/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class CreateAclsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<CreatableAclResult> results;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public CreateAclsResponseData(Readable readable, short version) {
        this.results = new ArrayList<CreatableAclResult>();
        this.read(readable, version);
    }

    public CreateAclsResponseData(Struct struct, short version) {
        this.results = new ArrayList<CreatableAclResult>();
        this.fromStruct(struct, version);
    }

    public CreateAclsResponseData() {
        this.throttleTimeMs = 0;
        this.results = new ArrayList<CreatableAclResult>();
    }

    public short apiKey() {
        return 30;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.results = null;
        } else {
            this.results.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.results.add(new CreatableAclResult(readable, version));
            }
        }
    }

    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeInt(this.results.size());
        for (CreatableAclResult element : this.results) {
            element.write(writable, version);
        }
    }

    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] nestedObjects = struct.getArray("results");
        this.results = new ArrayList<CreatableAclResult>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.results.add(new CreatableAclResult((Struct)nestedObject, version));
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] nestedObjects = new Struct[this.results.size()];
        int i = 0;
        for (CreatableAclResult element : this.results) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("results", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        for (CreatableAclResult element : this.results) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateAclsResponseData)) {
            return false;
        }
        CreateAclsResponseData other = (CreateAclsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.results == null ? other.results != null : !this.results.equals(other.results));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    public String toString() {
        return "CreateAclsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<CreatableAclResult> results() {
        return this.results;
    }

    public CreateAclsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public CreateAclsResponseData setResults(List<CreatableAclResult> v) {
        this.results = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", (Type)new ArrayOf((Type)CreatableAclResult.SCHEMA_0), "The results for each ACL creation.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class CreatableAclResult
    implements Message {
        private short errorCode;
        private String errorMessage;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public CreatableAclResult(Readable readable, short version) {
            this.read(readable, version);
        }

        public CreatableAclResult(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public CreatableAclResult() {
            this.errorCode = 0;
            this.errorMessage = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable readable, short version) {
            this.errorCode = readable.readShort();
            this.errorMessage = readable.readNullableString();
        }

        public void write(Writable writable, short version) {
            writable.writeShort(this.errorCode);
            writable.writeNullableString(this.errorMessage);
        }

        public void fromStruct(Struct struct, short version) {
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = struct.getString("error_message");
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("error_message", (Object)this.errorMessage);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += 2;
            if (this.errorMessage != null) {
                size += MessageUtil.serializedUtf8Length((CharSequence)this.errorMessage);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatableAclResult)) {
                return false;
            }
            CreatableAclResult other = (CreatableAclResult)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            return !(this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            return hashCode;
        }

        public String toString() {
            return "CreatableAclResult(errorCode=" + this.errorCode + ", errorMessage='" + this.errorMessage + "')";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public CreatableAclResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public CreatableAclResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The result error, or zero if there was no error."), new Field("error_message", (Type)Type.NULLABLE_STRING, "The result message, or null if there was no error.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

