/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class OffsetForLeaderEpochResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<OffsetForLeaderTopicResult> topics;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)OffsetForLeaderTopicResult.SCHEMA_0), "Each topic we fetched offsets for.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)OffsetForLeaderTopicResult.SCHEMA_1), "Each topic we fetched offsets for.")});
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;

    public OffsetForLeaderEpochResponseData(Readable readable, short version) {
        this.topics = new ArrayList<OffsetForLeaderTopicResult>();
        this.read(readable, version);
    }

    public OffsetForLeaderEpochResponseData(Struct struct, short version) {
        this.topics = new ArrayList<OffsetForLeaderTopicResult>();
        this.fromStruct(struct, version);
    }

    public OffsetForLeaderEpochResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new ArrayList<OffsetForLeaderTopicResult>();
    }

    public short apiKey() {
        return 23;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 3;
    }

    public void read(Readable readable, short version) {
        this.throttleTimeMs = version >= 2 ? readable.readInt() : 0;
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics = null;
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new OffsetForLeaderTopicResult(readable, version));
            }
        }
    }

    public void write(Writable writable, short version) {
        if (version >= 2) {
            writable.writeInt(this.throttleTimeMs);
        }
        writable.writeInt(this.topics.size());
        for (OffsetForLeaderTopicResult element : this.topics) {
            element.write(writable, version);
        }
    }

    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = version >= 2 ? struct.getInt("throttle_time_ms") : 0;
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<OffsetForLeaderTopicResult>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new OffsetForLeaderTopicResult((Struct)nestedObject, version));
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 2) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (OffsetForLeaderTopicResult element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        if (version >= 2) {
            size += 4;
        }
        size += 4;
        for (OffsetForLeaderTopicResult element : this.topics) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetForLeaderEpochResponseData)) {
            return false;
        }
        OffsetForLeaderEpochResponseData other = (OffsetForLeaderEpochResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "OffsetForLeaderEpochResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<OffsetForLeaderTopicResult> topics() {
        return this.topics;
    }

    public OffsetForLeaderEpochResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public OffsetForLeaderEpochResponseData setTopics(List<OffsetForLeaderTopicResult> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new ArrayOf((Type)OffsetForLeaderTopicResult.SCHEMA_1), "Each topic we fetched offsets for.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class OffsetForLeaderPartitionResult
    implements Message {
        private short errorCode;
        private int partitionIndex;
        private int leaderEpoch;
        private long endOffset;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The error code 0, or if there was no error."), new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("end_offset", (Type)Type.INT64, "The end offset of the epoch.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;

        public OffsetForLeaderPartitionResult(Readable readable, short version) {
            this.read(readable, version);
        }

        public OffsetForLeaderPartitionResult(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public OffsetForLeaderPartitionResult() {
            this.errorCode = 0;
            this.partitionIndex = 0;
            this.leaderEpoch = -1;
            this.endOffset = 0L;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public void read(Readable readable, short version) {
            this.errorCode = readable.readShort();
            this.partitionIndex = readable.readInt();
            this.leaderEpoch = version >= 1 ? readable.readInt() : -1;
            this.endOffset = readable.readLong();
        }

        public void write(Writable writable, short version) {
            writable.writeShort(this.errorCode);
            writable.writeInt(this.partitionIndex);
            if (version >= 1) {
                writable.writeInt(this.leaderEpoch);
            }
            writable.writeLong(this.endOffset);
        }

        public void fromStruct(Struct struct, short version) {
            this.errorCode = struct.getShort("error_code");
            this.partitionIndex = struct.getInt("partition_index");
            this.leaderEpoch = version >= 1 ? struct.getInt("leader_epoch") : -1;
            this.endOffset = struct.getLong("end_offset");
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("partition_index", (Object)this.partitionIndex);
            if (version >= 1) {
                struct.set("leader_epoch", (Object)this.leaderEpoch);
            }
            struct.set("end_offset", (Object)this.endOffset);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += 4;
            if (version >= 1) {
                size += 4;
            }
            return size += 8;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetForLeaderPartitionResult)) {
                return false;
            }
            OffsetForLeaderPartitionResult other = (OffsetForLeaderPartitionResult)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            return this.endOffset == other.endOffset;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + ((int)(this.endOffset >> 32) ^ (int)this.endOffset);
            return hashCode;
        }

        public String toString() {
            return "OffsetForLeaderPartitionResult(errorCode=" + this.errorCode + ", partitionIndex=" + this.partitionIndex + ", leaderEpoch=" + this.leaderEpoch + ", endOffset=" + this.endOffset + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public long endOffset() {
            return this.endOffset;
        }

        public OffsetForLeaderPartitionResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public OffsetForLeaderPartitionResult setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public OffsetForLeaderPartitionResult setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public OffsetForLeaderPartitionResult setEndOffset(long v) {
            this.endOffset = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The error code 0, or if there was no error."), new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("leader_epoch", (Type)Type.INT32, "The leader epoch of the partition."), new Field("end_offset", (Type)Type.INT64, "The end offset of the epoch.")}));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class OffsetForLeaderTopicResult
    implements Message {
        private String name;
        private List<OffsetForLeaderPartitionResult> partitions;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)OffsetForLeaderPartitionResult.SCHEMA_0), "Each partition in the topic we fetched offsets for.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;

        public OffsetForLeaderTopicResult(Readable readable, short version) {
            this.partitions = new ArrayList<OffsetForLeaderPartitionResult>();
            this.read(readable, version);
        }

        public OffsetForLeaderTopicResult(Struct struct, short version) {
            this.partitions = new ArrayList<OffsetForLeaderPartitionResult>();
            this.fromStruct(struct, version);
        }

        public OffsetForLeaderTopicResult() {
            this.name = "";
            this.partitions = new ArrayList<OffsetForLeaderPartitionResult>();
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions = null;
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new OffsetForLeaderPartitionResult(readable, version));
                }
            }
        }

        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (OffsetForLeaderPartitionResult element : this.partitions) {
                element.write(writable, version);
            }
        }

        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<OffsetForLeaderPartitionResult>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new OffsetForLeaderPartitionResult((Struct)nestedObject, version));
            }
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (OffsetForLeaderPartitionResult element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.name);
            size += 4;
            for (OffsetForLeaderPartitionResult element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetForLeaderTopicResult)) {
                return false;
            }
            OffsetForLeaderTopicResult other = (OffsetForLeaderTopicResult)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "OffsetForLeaderTopicResult(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<OffsetForLeaderPartitionResult> partitions() {
            return this.partitions;
        }

        public OffsetForLeaderTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public OffsetForLeaderTopicResult setPartitions(List<OffsetForLeaderPartitionResult> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)OffsetForLeaderPartitionResult.SCHEMA_1), "Each partition in the topic we fetched offsets for.")}));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

