/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.junit.Assert;
import org.junit.Test;

public class ControlRequestTest {
    @Test
    public void testLeaderAndIsrRequestNormalization() {
        Set<TopicPartition> tps = this.generateRandomTopicPartitions(10, 10);
        HashMap<TopicPartition, LeaderAndIsrRequest.PartitionState> partitionStates = new HashMap<TopicPartition, LeaderAndIsrRequest.PartitionState>();
        for (TopicPartition tp : tps) {
            partitionStates.put(tp, new LeaderAndIsrRequest.PartitionState(0, 0, 0, Collections.emptyList(), 0, Collections.emptyList(), false));
        }
        LeaderAndIsrRequest.Builder builder = new LeaderAndIsrRequest.Builder(2, 0, 0, 0L, partitionStates, Collections.emptySet());
        Assert.assertTrue((builder.build((short)2).size() < builder.build((short)1).size() ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateMetadataRequestNormalization() {
        Set<TopicPartition> tps = this.generateRandomTopicPartitions(10, 10);
        HashMap<TopicPartition, UpdateMetadataRequest.PartitionState> partitionStates = new HashMap<TopicPartition, UpdateMetadataRequest.PartitionState>();
        for (TopicPartition tp : tps) {
            partitionStates.put(tp, new UpdateMetadataRequest.PartitionState(0, 0, 0, Collections.emptyList(), 0, Collections.emptyList(), Collections.emptyList()));
        }
        UpdateMetadataRequest.Builder builder = new UpdateMetadataRequest.Builder(5, 0, 0, 0L, partitionStates, Collections.emptySet());
        Assert.assertTrue((builder.build((short)5).size() < builder.build((short)4).size() ? 1 : 0) != 0);
    }

    @Test
    public void testStopReplicaRequestNormalization() {
        Set<TopicPartition> tps = this.generateRandomTopicPartitions(10, 10);
        HashMap<TopicPartition, UpdateMetadataRequest.PartitionState> partitionStates = new HashMap<TopicPartition, UpdateMetadataRequest.PartitionState>();
        for (TopicPartition tp : tps) {
            partitionStates.put(tp, new UpdateMetadataRequest.PartitionState(0, 0, 0, Collections.emptyList(), 0, Collections.emptyList(), Collections.emptyList()));
        }
        StopReplicaRequest.Builder builder = new StopReplicaRequest.Builder(5, 0, 0, 0L, false, tps);
        Assert.assertTrue((builder.build((short)1).size() < builder.build((short)0).size() ? 1 : 0) != 0);
    }

    private Set<TopicPartition> generateRandomTopicPartitions(int numTopic, int numPartitionPerTopic) {
        HashSet<TopicPartition> tps = new HashSet<TopicPartition>();
        Random r = new Random();
        for (int i = 0; i < numTopic; ++i) {
            byte[] array = new byte[32];
            r.nextBytes(array);
            String topic = new String(array);
            for (int j = 0; j < numPartitionPerTopic; ++j) {
                tps.add(new TopicPartition(topic, j));
            }
        }
        return tps;
    }
}

