/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.junit.Assert;
import org.junit.Test;

public class SslPrincipalMapperTest {
    @Test
    public void testValidRules() {
        this.testValidRule(Arrays.asList("DEFAULT"));
        this.testValidRule(Arrays.asList("RULE:^CN=(.*?),OU=ServiceUsers.*$/$1/"));
        this.testValidRule(Arrays.asList("RULE:^CN=(.*?),OU=ServiceUsers.*$/$1/L", "DEFAULT"));
        this.testValidRule(Arrays.asList("RULE:^CN=(.*?),OU=(.*?),O=(.*?),L=(.*?),ST=(.*?),C=(.*?)$/$1@$2/"));
        this.testValidRule(Arrays.asList("RULE:^.*[Cc][Nn]=([a-zA-Z0-9.]*).*$/$1/L"));
        this.testValidRule(Arrays.asList("RULE:^cn=(.?),ou=(.?),dc=(.?),dc=(.?)$/$1@$2/U"));
    }

    @Test
    public void testValidSplitRules() {
        this.testValidRule(Arrays.asList("DEFAULT"));
        this.testValidRule(Arrays.asList("RULE:^CN=(.*?)", "OU=ServiceUsers.*$/$1/"));
        this.testValidRule(Arrays.asList("RULE:^CN=(.*?)", "OU=ServiceUsers.*$/$1/L", "DEFAULT"));
        this.testValidRule(Arrays.asList("RULE:^CN=(.*?)", "OU=(.*?),O=(.*?),L=(.*?)", "ST=(.*?)", "C=(.*?)$/$1@$2/"));
        this.testValidRule(Arrays.asList("RULE:^.*[Cc][Nn]=([a-zA-Z0-9.]*).*$/$1/L"));
        this.testValidRule(Arrays.asList("RULE:^cn=(.?)", "ou=(.?)", "dc=(.?)", "dc=(.?)$/$1@$2/U"));
    }

    private void testValidRule(List<String> rules) {
        SslPrincipalMapper.fromRules(rules);
    }

    @Test
    public void testInvalidRules() {
        this.testInvalidRule(Arrays.asList("default"));
        this.testInvalidRule(Arrays.asList("DEFAUL"));
        this.testInvalidRule(Arrays.asList("DEFAULT/L"));
        this.testInvalidRule(Arrays.asList("DEFAULT/U"));
        this.testInvalidRule(Arrays.asList("RULE:CN=(.*?),OU=ServiceUsers.*/$1"));
        this.testInvalidRule(Arrays.asList("rule:^CN=(.*?),OU=ServiceUsers.*$/$1/"));
        this.testInvalidRule(Arrays.asList("RULE:^CN=(.*?),OU=ServiceUsers.*$/$1/L/U"));
        this.testInvalidRule(Arrays.asList("RULE:^CN=(.*?),OU=ServiceUsers.*$/L"));
        this.testInvalidRule(Arrays.asList("RULE:^CN=(.*?),OU=ServiceUsers.*$/U"));
        this.testInvalidRule(Arrays.asList("RULE:^CN=(.*?),OU=ServiceUsers.*$/LU"));
    }

    @Test
    public void testInvalidSplitRules() {
        this.testInvalidRule(Arrays.asList("default"));
        this.testInvalidRule(Arrays.asList("DEFAUL"));
        this.testInvalidRule(Arrays.asList("DEFAULT/L"));
        this.testInvalidRule(Arrays.asList("DEFAULT/U"));
        this.testInvalidRule(Arrays.asList("RULE:CN=(.*?)", "OU=ServiceUsers.*/$1"));
        this.testInvalidRule(Arrays.asList("rule:^CN=(.*?)", "OU=ServiceUsers.*$/$1/"));
        this.testInvalidRule(Arrays.asList("RULE:^CN=(.*?)", "OU=ServiceUsers.*$/$1/L/U"));
        this.testInvalidRule(Arrays.asList("RULE:^CN=(.*?)", "OU=ServiceUsers.*$/L"));
        this.testInvalidRule(Arrays.asList("RULE:^CN=(.*?)", "OU=ServiceUsers.*$/U"));
        this.testInvalidRule(Arrays.asList("RULE:^CN=(.*?)", "OU=ServiceUsers.*$/LU"));
    }

    private void testInvalidRule(List<String> rules) {
        try {
            System.out.println(SslPrincipalMapper.fromRules(rules));
            Assert.fail((String)"should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSslPrincipalMapper() throws Exception {
        List<String> rules = Arrays.asList("RULE:^CN=(.*?),OU=ServiceUsers.*$/$1/L", "RULE:^CN=(.*?),OU=(.*?),O=(.*?),L=(.*?),ST=(.*?),C=(.*?)$/$1@$2/L", "RULE:^cn=(.*?),ou=(.*?),dc=(.*?),dc=(.*?)$/$1@$2/U", "RULE:^.*[Cc][Nn]=([a-zA-Z0-9.]*).*$/$1/U", "DEFAULT");
        SslPrincipalMapper mapper = SslPrincipalMapper.fromRules(rules);
        Assert.assertEquals((Object)"duke", (Object)mapper.getName("CN=Duke,OU=ServiceUsers,O=Org,C=US"));
        Assert.assertEquals((Object)"duke@sme", (Object)mapper.getName("CN=Duke,OU=SME,O=mycp,L=Fulton,ST=MD,C=US"));
        Assert.assertEquals((Object)"DUKE@SME", (Object)mapper.getName("cn=duke,ou=sme,dc=mycp,dc=com"));
        Assert.assertEquals((Object)"DUKE", (Object)mapper.getName("cN=duke,OU=JavaSoft,O=Sun Microsystems"));
        Assert.assertEquals((Object)"OU=JavaSoft,O=Sun Microsystems,C=US", (Object)mapper.getName("OU=JavaSoft,O=Sun Microsystems,C=US"));
    }
}

