/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WriteTxnMarkersRequestTest {
    private static long producerId = 10L;
    private static short producerEpoch = (short)2;
    private static int coordinatorEpoch = 1;
    private static TransactionResult result = TransactionResult.COMMIT;
    private static TopicPartition topicPartition = new TopicPartition("topic", 73);
    protected static int throttleTimeMs = 10;
    private static List<WriteTxnMarkersRequest.TxnMarkerEntry> markers;

    @Before
    public void setUp() {
        markers = Collections.singletonList(new WriteTxnMarkersRequest.TxnMarkerEntry(producerId, producerEpoch, coordinatorEpoch, result, Collections.singletonList(topicPartition)));
    }

    @Test
    public void testConstructor() {
        WriteTxnMarkersRequest.Builder builder = new WriteTxnMarkersRequest.Builder(markers);
        for (short version = 0; version <= ApiKeys.WRITE_TXN_MARKERS.latestVersion(); version = (short)(version + 1)) {
            WriteTxnMarkersRequest request = builder.build(version);
            Assert.assertEquals((long)1L, (long)request.markers().size());
            WriteTxnMarkersRequest.TxnMarkerEntry marker = (WriteTxnMarkersRequest.TxnMarkerEntry)request.markers().get(0);
            Assert.assertEquals((long)producerId, (long)marker.producerId());
            Assert.assertEquals((long)producerEpoch, (long)marker.producerEpoch());
            Assert.assertEquals((long)coordinatorEpoch, (long)marker.coordinatorEpoch());
            Assert.assertEquals((Object)result, (Object)marker.transactionResult());
            Assert.assertEquals(Collections.singletonList(topicPartition), (Object)marker.partitions());
        }
    }

    @Test
    public void testGetErrorResponse() {
        WriteTxnMarkersRequest.Builder builder = new WriteTxnMarkersRequest.Builder(markers);
        for (short version = 0; version <= ApiKeys.WRITE_TXN_MARKERS.latestVersion(); version = (short)(version + 1)) {
            WriteTxnMarkersRequest request = builder.build(version);
            WriteTxnMarkersResponse errorResponse = request.getErrorResponse(throttleTimeMs, (Throwable)Errors.UNKNOWN_PRODUCER_ID.exception());
            Assert.assertEquals(Collections.singletonMap(topicPartition, Errors.UNKNOWN_PRODUCER_ID), (Object)errorResponse.errors(producerId));
            Assert.assertEquals(Collections.singletonMap(Errors.UNKNOWN_PRODUCER_ID, 1), (Object)errorResponse.errorCounts());
            Assert.assertEquals((long)0L, (long)errorResponse.throttleTimeMs());
        }
    }
}

