/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public final class ByteBufferUnmapper {
    private static final MethodHandle UNMAP;
    private static final RuntimeException UNMAP_NOT_SUPPORTED_EXCEPTION;

    private ByteBufferUnmapper() {
    }

    public static void unmap(String resourceDescription, ByteBuffer buffer) throws IOException {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Unmapping only works with direct buffers");
        }
        if (UNMAP == null) {
            throw UNMAP_NOT_SUPPORTED_EXCEPTION;
        }
        try {
            UNMAP.invokeExact(buffer);
        }
        catch (Throwable throwable) {
            throw new IOException("Unable to unmap the mapped buffer: " + resourceDescription, throwable);
        }
    }

    private static MethodHandle lookupUnmapMethodHandle() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            MethodHandle unmapper = lookup.findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Object theUnsafe = f.get(null);
            return unmapper.bindTo(theUnsafe);
        }
        catch (ReflectiveOperationException | RuntimeException e1) {
            throw new UnsupportedOperationException("Unmapping is not supported on this platform, because internal Java APIs are not compatible with this Kafka version", e1);
        }
    }

    static {
        MethodHandle unmap = null;
        RuntimeException exception = null;
        try {
            unmap = ByteBufferUnmapper.lookupUnmapMethodHandle();
        }
        catch (RuntimeException e) {
            exception = e;
        }
        if (unmap != null) {
            UNMAP = unmap;
            UNMAP_NOT_SUPPORTED_EXCEPTION = null;
        } else {
            UNMAP = null;
            UNMAP_NOT_SUPPORTED_EXCEPTION = exception;
        }
    }
}

