/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.kafka.raft.internals;

import org.apache.kafka.raft.Isolation;

import java.util.function.Predicate;

public class LogOffset {
    public final long offset;
    public final Isolation isolation;

    public LogOffset(long offset, Isolation isolation) {
        this.offset = offset;
        this.isolation = isolation;
    }

    public static Predicate<LogOffset> await(long offset, Isolation isolation) {
        if (isolation == Isolation.COMMITTED) {
            return awaitCommitted(offset);
        } else {
            return awaitUncommitted(offset);
        }
    }

    public static Predicate<LogOffset> awaitCommitted(long offset) {
        return logOffset -> logOffset.isolation == Isolation.COMMITTED && logOffset.offset > offset;
    }

    public static Predicate<LogOffset> awaitUncommitted(long offset) {
        return logOffset -> logOffset.offset > offset;
    }

}
