/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class MetadataVersionTest {
    MetadataVersionTest() {
    }

    @Test
    public void testFeatureLevels() {
        for (int i = MetadataVersion.MINIMUM_VERSION.ordinal(); i < MetadataVersion.VERSIONS.length; ++i) {
            int expectedLevel = i + MetadataVersion.MINIMUM_VERSION.featureLevel();
            Assertions.assertEquals((int)expectedLevel, (int)MetadataVersion.VERSIONS[i].featureLevel());
        }
    }

    @Test
    public void testFromVersionString() {
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromVersionString((String)"3.3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromVersionString((String)"3.3-IV3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.fromVersionString((String)"3.4"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.fromVersionString((String)"3.4-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV2, (Object)MetadataVersion.fromVersionString((String)"3.5"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV0, (Object)MetadataVersion.fromVersionString((String)"3.5-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV1, (Object)MetadataVersion.fromVersionString((String)"3.5-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV2, (Object)MetadataVersion.fromVersionString((String)"3.5-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV2, (Object)MetadataVersion.fromVersionString((String)"3.6"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV0, (Object)MetadataVersion.fromVersionString((String)"3.6-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV1, (Object)MetadataVersion.fromVersionString((String)"3.6-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV2, (Object)MetadataVersion.fromVersionString((String)"3.6-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV4, (Object)MetadataVersion.fromVersionString((String)"3.7"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV0, (Object)MetadataVersion.fromVersionString((String)"3.7-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV1, (Object)MetadataVersion.fromVersionString((String)"3.7-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV2, (Object)MetadataVersion.fromVersionString((String)"3.7-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV3, (Object)MetadataVersion.fromVersionString((String)"3.7-IV3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV4, (Object)MetadataVersion.fromVersionString((String)"3.7-IV4"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_8_IV0, (Object)MetadataVersion.fromVersionString((String)"3.8"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_8_IV0, (Object)MetadataVersion.fromVersionString((String)"3.8-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_9_IV0, (Object)MetadataVersion.fromVersionString((String)"3.9"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_9_IV0, (Object)MetadataVersion.fromVersionString((String)"3.9-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV3, (Object)MetadataVersion.fromVersionString((String)"4.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV0, (Object)MetadataVersion.fromVersionString((String)"4.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV1, (Object)MetadataVersion.fromVersionString((String)"4.0-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV2, (Object)MetadataVersion.fromVersionString((String)"4.0-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV3, (Object)MetadataVersion.fromVersionString((String)"4.0-IV3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_1_IV1, (Object)MetadataVersion.fromVersionString((String)"4.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_1_IV0, (Object)MetadataVersion.fromVersionString((String)"4.1-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_1_IV1, (Object)MetadataVersion.fromVersionString((String)"4.1-IV1"));
    }

    @Test
    public void testShortVersion() {
        Assertions.assertEquals((Object)"3.3", (Object)MetadataVersion.IBP_3_3_IV3.shortVersion());
        Assertions.assertEquals((Object)"3.4", (Object)MetadataVersion.IBP_3_4_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.5", (Object)MetadataVersion.IBP_3_5_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.5", (Object)MetadataVersion.IBP_3_5_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.5", (Object)MetadataVersion.IBP_3_5_IV2.shortVersion());
        Assertions.assertEquals((Object)"3.6", (Object)MetadataVersion.IBP_3_6_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.6", (Object)MetadataVersion.IBP_3_6_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.6", (Object)MetadataVersion.IBP_3_6_IV2.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV2.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV3.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV4.shortVersion());
        Assertions.assertEquals((Object)"3.8", (Object)MetadataVersion.IBP_3_8_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.9", (Object)MetadataVersion.IBP_3_9_IV0.shortVersion());
        Assertions.assertEquals((Object)"4.0", (Object)MetadataVersion.IBP_4_0_IV0.shortVersion());
        Assertions.assertEquals((Object)"4.0", (Object)MetadataVersion.IBP_4_0_IV1.shortVersion());
        Assertions.assertEquals((Object)"4.0", (Object)MetadataVersion.IBP_4_0_IV2.shortVersion());
        Assertions.assertEquals((Object)"4.0", (Object)MetadataVersion.IBP_4_0_IV3.shortVersion());
        Assertions.assertEquals((Object)"4.1", (Object)MetadataVersion.IBP_4_1_IV0.shortVersion());
    }

    @Test
    public void testVersion() {
        Assertions.assertEquals((Object)"3.3-IV3", (Object)MetadataVersion.IBP_3_3_IV3.version());
        Assertions.assertEquals((Object)"3.4-IV0", (Object)MetadataVersion.IBP_3_4_IV0.version());
        Assertions.assertEquals((Object)"3.5-IV0", (Object)MetadataVersion.IBP_3_5_IV0.version());
        Assertions.assertEquals((Object)"3.5-IV1", (Object)MetadataVersion.IBP_3_5_IV1.version());
        Assertions.assertEquals((Object)"3.5-IV2", (Object)MetadataVersion.IBP_3_5_IV2.version());
        Assertions.assertEquals((Object)"3.6-IV0", (Object)MetadataVersion.IBP_3_6_IV0.version());
        Assertions.assertEquals((Object)"3.6-IV1", (Object)MetadataVersion.IBP_3_6_IV1.version());
        Assertions.assertEquals((Object)"3.6-IV2", (Object)MetadataVersion.IBP_3_6_IV2.version());
        Assertions.assertEquals((Object)"3.7-IV0", (Object)MetadataVersion.IBP_3_7_IV0.version());
        Assertions.assertEquals((Object)"3.7-IV1", (Object)MetadataVersion.IBP_3_7_IV1.version());
        Assertions.assertEquals((Object)"3.7-IV2", (Object)MetadataVersion.IBP_3_7_IV2.version());
        Assertions.assertEquals((Object)"3.7-IV3", (Object)MetadataVersion.IBP_3_7_IV3.version());
        Assertions.assertEquals((Object)"3.7-IV4", (Object)MetadataVersion.IBP_3_7_IV4.version());
        Assertions.assertEquals((Object)"3.8-IV0", (Object)MetadataVersion.IBP_3_8_IV0.version());
        Assertions.assertEquals((Object)"3.9-IV0", (Object)MetadataVersion.IBP_3_9_IV0.version());
        Assertions.assertEquals((Object)"4.0-IV0", (Object)MetadataVersion.IBP_4_0_IV0.version());
        Assertions.assertEquals((Object)"4.0-IV1", (Object)MetadataVersion.IBP_4_0_IV1.version());
        Assertions.assertEquals((Object)"4.0-IV2", (Object)MetadataVersion.IBP_4_0_IV2.version());
        Assertions.assertEquals((Object)"4.0-IV3", (Object)MetadataVersion.IBP_4_0_IV3.version());
        Assertions.assertEquals((Object)"4.1-IV0", (Object)MetadataVersion.IBP_4_1_IV0.version());
    }

    @Test
    public void testPrevious() {
        for (int i = 1; i < MetadataVersion.VERSIONS.length - 2; ++i) {
            MetadataVersion version = MetadataVersion.VERSIONS[i];
            Assertions.assertTrue((boolean)version.previous().isPresent(), (String)version.toString());
            Assertions.assertEquals((Object)MetadataVersion.VERSIONS[i - 1], version.previous().get());
        }
    }

    @Test
    public void testMetadataChanged() {
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_4_IV0, (MetadataVersion)MetadataVersion.IBP_3_3_IV3));
        Assertions.assertFalse((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_5_IV0, (MetadataVersion)MetadataVersion.IBP_3_4_IV0));
        Assertions.assertFalse((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_5_IV1, (MetadataVersion)MetadataVersion.IBP_3_5_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_6_IV0, (MetadataVersion)MetadataVersion.IBP_3_5_IV1));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_6_IV1, (MetadataVersion)MetadataVersion.IBP_3_6_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_3_IV3, (MetadataVersion)MetadataVersion.IBP_3_4_IV0));
        Assertions.assertFalse((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_4_IV0, (MetadataVersion)MetadataVersion.IBP_3_5_IV0));
        Assertions.assertFalse((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_5_IV0, (MetadataVersion)MetadataVersion.IBP_3_5_IV1));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_5_IV1, (MetadataVersion)MetadataVersion.IBP_3_6_IV0));
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsDelegationTokenSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_3_6_IV2), (Object)metadataVersion.isDelegationTokenSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testDirectoryAssignmentSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_3_7_IV2), (Object)metadataVersion.isDirectoryAssignmentSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsElrSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_4_0_IV1), (Object)metadataVersion.isElrSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testPartitionRecordVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isElrSupported() ? (short)2 : (metadataVersion.isDirectoryAssignmentSupported() ? (short)1 : 0);
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.partitionRecordVersion());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testPartitionChangeRecordVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isElrSupported() ? (short)2 : (metadataVersion.isDirectoryAssignmentSupported() ? (short)1 : 0);
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.partitionChangeRecordVersion());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testRegisterBrokerRecordVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_7_IV2) ? (short)3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? (short)2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_3_3_IV3) ? (short)1 : 0));
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.registerBrokerRecordVersion());
    }

    @Test
    public void assertLatestProductionIsLessThanLatest() {
        Assertions.assertTrue((MetadataVersion.LATEST_PRODUCTION.ordinal() < MetadataVersion.latestTesting().ordinal() ? 1 : 0) != 0, (String)("Expected LATEST_PRODUCTION " + String.valueOf(MetadataVersion.LATEST_PRODUCTION) + " to be less than the latest of " + String.valueOf(MetadataVersion.latestTesting())));
    }

    @Test
    public void testProductionMetadataDontUseUnstableApiVersion() {
        MetadataVersion mv = MetadataVersion.latestProduction();
        Assertions.assertTrue((mv.listOffsetRequestVersion() <= ApiKeys.LIST_OFFSETS.latestVersion(false) ? 1 : 0) != 0);
        Assertions.assertTrue((mv.fetchRequestVersion() <= ApiKeys.FETCH.latestVersion(false) ? 1 : 0) != 0);
    }

    @Test
    public void assertLatestProductionIsProduction() {
        Assertions.assertTrue((boolean)MetadataVersion.LATEST_PRODUCTION.isProduction());
    }

    @Test
    public void assertLatestIsNotProduction() {
        Assertions.assertFalse((boolean)MetadataVersion.latestTesting().isProduction());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testListOffsetsValueVersion(MetadataVersion metadataVersion) {
        int expectedVersion = 10;
        if (metadataVersion.isAtLeast(MetadataVersion.IBP_4_0_IV3)) {
            Assertions.assertEquals((short)10, (short)metadataVersion.listOffsetRequestVersion());
        } else {
            Assertions.assertTrue((metadataVersion.listOffsetRequestVersion() < 10 ? 1 : 0) != 0);
        }
    }
}

