/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.rocksdb.AbstractRocksIterator;
import org.rocksdb.RocksIterator;

class RocksDbIterator
extends AbstractIterator<KeyValue<Bytes, byte[]>>
implements KeyValueIterator<Bytes, byte[]> {
    private final String storeName;
    private final RocksIterator iter;
    private final Set<KeyValueIterator<Bytes, byte[]>> openIterators;
    private final Consumer<RocksIterator> advanceIterator;
    private volatile boolean open = true;
    private KeyValue<Bytes, byte[]> next;

    RocksDbIterator(String storeName, RocksIterator iter, Set<KeyValueIterator<Bytes, byte[]>> openIterators, boolean forward) {
        this.storeName = storeName;
        this.iter = iter;
        this.openIterators = openIterators;
        this.advanceIterator = forward ? AbstractRocksIterator::next : AbstractRocksIterator::prev;
    }

    @Override
    public synchronized boolean hasNext() {
        if (!this.open) {
            throw new InvalidStateStoreException(String.format("RocksDB iterator for store %s has closed", this.storeName));
        }
        return super.hasNext();
    }

    public KeyValue<Bytes, byte[]> makeNext() {
        if (!this.iter.isValid()) {
            return (KeyValue)this.allDone();
        }
        this.next = this.getKeyValue();
        this.advanceIterator.accept(this.iter);
        return this.next;
    }

    private KeyValue<Bytes, byte[]> getKeyValue() {
        return new KeyValue<Bytes, byte[]>(new Bytes(this.iter.key()), this.iter.value());
    }

    @Override
    public synchronized void close() {
        this.openIterators.remove(this);
        this.iter.close();
        this.open = false;
    }

    @Override
    public Bytes peekNextKey() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (Bytes)this.next.key;
    }
}

