/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.nio.ByteBuffer;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexSearchType$;
import kafka.log.TimeIndex$;
import kafka.log.TimeIndex$$anonfun$kafka$log$TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002V5nK&sG-\u001a=\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001\u0003B\u0005\u000b\u00191i\u0011AA\u0005\u0003\u0017\t\u0011Q\"\u00112tiJ\f7\r^%oI\u0016D\bCA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!\u0001\u0002'p]\u001eD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0006?\u001aLG.\u001a\t\u0003+ii\u0011A\u0006\u0006\u0003/a\t!![8\u000b\u0003e\tAA[1wC&\u00111D\u0006\u0002\u0005\r&dW\rC\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\r=\u0005Q!-Y:f\u001f\u001a47/\u001a;\n\u0005uQ\u0001\"\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0011%\u00031i\u0017\r_%oI\u0016D8+\u001b>f!\ti!%\u0003\u0002$\u001d\t\u0019\u0011J\u001c;\n\u0005\u0001R\u0001\"\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014+\u0003!9(/\u001b;bE2,\u0007CA\u0007)\u0013\tIcBA\u0004C_>dW-\u00198\n\u0005\u0019R\u0001\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\bF\u0003/_A\n$\u0007\u0005\u0002\n\u0001!)1c\u000ba\u0001)!)Qd\u000ba\u0001\u0019!9\u0001e\u000bI\u0001\u0002\u0004\t\u0003b\u0002\u0014,!\u0003\u0005\ra\n\u0005\bi\u0001\u0001\r\u0011\"\u00036\u0003)yF.Y:u\u000b:$(/_\u000b\u0002mA\u0011\u0011bN\u0005\u0003q\t\u0011q\u0002V5nKN$\u0018-\u001c9PM\u001a\u001cX\r\u001e\u0005\bu\u0001\u0001\r\u0011\"\u0003<\u00039yF.Y:u\u000b:$(/_0%KF$\"\u0001P \u0011\u00055i\u0014B\u0001 \u000f\u0005\u0011)f.\u001b;\t\u000f\u0001K\u0014\u0011!a\u0001m\u0005\u0019\u0001\u0010J\u0019\t\r\t\u0003\u0001\u0015)\u00037\u0003-yF.Y:u\u000b:$(/\u001f\u0011)\u0005\u0005#\u0005CA\u0007F\u0013\t1eB\u0001\u0005w_2\fG/\u001b7f\u0011\u0015A\u0005\u0001\"\u0011J\u0003%)g\u000e\u001e:z'&TX-F\u0001\"\u0011\u0015Y\u0005\u0001\"\u0011M\u0003\u0019I7OR;mYV\tq\u0005C\u0003O\u0001\u0011%q*A\u0005uS6,7\u000f^1naR\u0019A\u0002\u0015-\t\u000bEk\u0005\u0019\u0001*\u0002\r\t,hMZ3s!\t\u0019f+D\u0001U\u0015\t)\u0006$A\u0002oS>L!a\u0016+\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0003Z\u001b\u0002\u0007\u0011%A\u0001o\u0011\u0015Y\u0006\u0001\"\u0003]\u00039\u0011X\r\\1uSZ,wJ\u001a4tKR$2!I/_\u0011\u0015\t&\f1\u0001S\u0011\u0015I&\f1\u0001\"\u0011\u0015\u0001\u0007\u0001\"\u00016\u0003%a\u0017m\u001d;F]R\u0014\u0018\u0010C\u0003c\u0001\u0011%Q'\u0001\fmCN$XI\u001c;ss\u001a\u0013x.\\%oI\u0016Dh)\u001b7f\u0011\u0015!\u0007\u0001\"\u0001f\u0003\u0015)g\u000e\u001e:z)\t1d\rC\u0003ZG\u0002\u0007\u0011\u0005C\u0003i\u0001\u0011\u0005\u0013.\u0001\u0006qCJ\u001cX-\u00128uef$2A\u000e6l\u0011\u0015\tv\r1\u0001S\u0011\u0015Iv\r1\u0001\"\u0011\u0015i\u0007\u0001\"\u0001o\u0003-i\u0017-\u001f2f\u0003B\u0004XM\u001c3\u0015\tqz\u0007O\u001d\u0005\u0006\u001d2\u0004\r\u0001\u0004\u0005\u0006c2\u0004\r\u0001D\u0001\u0007_\u001a47/\u001a;\t\u000fMd\u0007\u0013!a\u0001O\u0005i1o[5q\rVdGn\u00115fG.DQ!\u001e\u0001\u0005\u0002Y\fa\u0001\\8pWV\u0004HC\u0001\u001cx\u0011\u0015AH\u000f1\u0001\r\u0003=!\u0018M]4fiRKW.Z:uC6\u0004\b\"\u0002>\u0001\t\u0003Z\u0018\u0001\u0003;sk:\u001c\u0017\r^3\u0015\u0003qBQ! \u0001\u0005By\f!\u0002\u001e:v]\u000e\fG/\u001a+p)\tat\u0010C\u0003ry\u0002\u0007A\u0002C\u0004\u0002\u0004\u0001!\t%!\u0002\u0002\rI,7/\u001b>f)\r9\u0013q\u0001\u0005\b\u0003\u0013\t\t\u00011\u0001\"\u0003\u001dqWm^*ju\u0016Dq!!\u0004\u0001\t\u0013\ty!A\tueVt7-\u0019;f)>,e\u000e\u001e:jKN$2\u0001PA\t\u0011\u001d\t\u0019\"a\u0003A\u0002\u0005\nq!\u001a8ue&,7\u000f\u0003\u0004\u0002\u0018\u0001!\te_\u0001\fg\u0006t\u0017\u000e^=DQ\u0016\u001c7\u000eC\u0005\u0002\u001c\u0001\t\n\u0011\"\u0001\u0002\u001e\u0005)R.Y=cK\u0006\u0003\b/\u001a8eI\u0011,g-Y;mi\u0012\u001aTCAA\u0010U\r9\u0013\u0011E\u0016\u0003\u0003G\u0001B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0006\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00022\u0005\u001d\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"a\u0011Q\u0007\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003JI\u0005\u00112/\u001e9fe\u0012j\u0017\r_%oI\u0016D8+\u001b>f\u00115\tI\u0004\u0001I\u0001\u0004\u0003\u0005I\u0011BA\u001e=\u0005\u00012/\u001e9fe\u0012\u0012\u0017m]3PM\u001a\u001cX\r^\u000b\u0002\u0019!q\u0011q\b\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002B\u0005\u0015\u0013\u0001D:va\u0016\u0014HE]3tSj,GcA\u0014\u0002D!9\u0011\u0011BA\u001f\u0001\u0004\t\u0013bAA\u0002\u0015\u001d9\u0011\u0011\n\u0002\t\u0002\u0005-\u0013!\u0003+j[\u0016Le\u000eZ3y!\rI\u0011Q\n\u0004\u0007\u0003\tA\t!a\u0014\u0014\r\u00055\u0013\u0011KA,!\ri\u00111K\u0005\u0004\u0003+r!AB!osJ+g\r\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\ti\u0006B\u0001\u0006kRLGn]\u0005\u0005\u0003C\nYFA\u0004M_\u001e<\u0017N\\4\t\u000f1\ni\u0005\"\u0001\u0002fQ\u0011\u00111\n\u0005\u000b\u0003S\niE1A\u0005B\u0005-\u0014A\u00037pO\u001e,'OT1nKV\u0011\u0011Q\u000e\t\u0005\u0003_\n)HD\u0002\u000e\u0003cJ1!a\u001d\u000f\u0003\u0019\u0001&/\u001a3fM&!\u0011qOA=\u0005\u0019\u0019FO]5oO*\u0019\u00111\u000f\b\t\u0013\u0005u\u0014Q\nQ\u0001\n\u00055\u0014a\u00037pO\u001e,'OT1nK\u0002B!\"!!\u0002NE\u0005I\u0011AAB\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0011\u0016\u0004C\u0005\u0005\u0002BCAE\u0003\u001b\n\n\u0011\"\u0001\u0002\u001e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\u0002")
public class TimeIndex
extends AbstractIndex<Object, Object> {
    private volatile TimestampOffset kafka$log$TimeIndex$$_lastEntry = this.kafka$log$TimeIndex$$lastEntryFromIndexFile();

    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.fatal(function0, function02);
    }

    public static void fatal(Function0<String> function0) {
        TimeIndex$.MODULE$.fatal(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.error(function0, function02);
    }

    public static void error(Function0<String> function0) {
        TimeIndex$.MODULE$.error(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.warn(function0, function02);
    }

    public static void warn(Function0<String> function0) {
        TimeIndex$.MODULE$.warn(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.info(function0, function02);
    }

    public static void info(Function0<String> function0) {
        TimeIndex$.MODULE$.info(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.debug(function0, function02);
    }

    public static void debug(Function0<String> function0) {
        TimeIndex$.MODULE$.debug(function0);
    }

    public static boolean isTraceEnabled() {
        return TimeIndex$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return TimeIndex$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.trace(function0, function02);
    }

    public static void trace(Function0<String> function0) {
        TimeIndex$.MODULE$.trace(function0);
    }

    public static String msgWithLogIdent(String string) {
        return TimeIndex$.MODULE$.msgWithLogIdent(string);
    }

    public static void logIdent_$eq(String string) {
        TimeIndex$.MODULE$.logIdent_$eq(string);
    }

    public static String logIdent() {
        return TimeIndex$.MODULE$.logIdent();
    }

    public static Logger logger() {
        return TimeIndex$.MODULE$.logger();
    }

    public static boolean $lessinit$greater$default$4() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static String loggerName() {
        return TimeIndex$.MODULE$.loggerName();
    }

    public /* synthetic */ int kafka$log$TimeIndex$$super$maxIndexSize() {
        return super.maxIndexSize();
    }

    public /* synthetic */ long kafka$log$TimeIndex$$super$baseOffset() {
        return super.baseOffset();
    }

    public /* synthetic */ boolean kafka$log$TimeIndex$$super$resize(int newSize) {
        return super.resize(newSize);
    }

    public TimestampOffset kafka$log$TimeIndex$$_lastEntry() {
        return this.kafka$log$TimeIndex$$_lastEntry;
    }

    public void kafka$log$TimeIndex$$_lastEntry_$eq(TimestampOffset x$1) {
        this.kafka$log$TimeIndex$$_lastEntry = x$1;
    }

    @Override
    public int entrySize() {
        return 12;
    }

    @Override
    public boolean isFull() {
        return this.entries() >= this.maxEntries() - 1;
    }

    private long timestamp(ByteBuffer buffer, int n) {
        return buffer.getLong(n * this.entrySize());
    }

    public int kafka$log$TimeIndex$$relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 8);
    }

    public TimestampOffset lastEntry() {
        return this.kafka$log$TimeIndex$$_lastEntry();
    }

    public TimestampOffset kafka$log$TimeIndex$$lastEntryFromIndexFile() {
        return (TimestampOffset)CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;

            public final TimestampOffset apply() {
                TimestampOffset timestampOffset;
                int n = this.$outer._entries();
                switch (n) {
                    default: {
                        timestampOffset = this.$outer.parseEntry(this.$outer.mmap(), n - 1);
                        break;
                    }
                    case 0: {
                        timestampOffset = new TimestampOffset(-1L, this.$outer.kafka$log$TimeIndex$$super$baseOffset());
                    }
                }
                return timestampOffset;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public TimestampOffset entry(int n) {
        return (TimestampOffset)this.maybeLock(this.lock(), new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final int n$1;

            public final TimestampOffset apply() {
                if (this.n$1 >= this.$outer._entries()) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempt to fetch the ", "th entry from  time index ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$1), this.$outer.file().getAbsolutePath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which has size ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer._entries())}))).toString());
                }
                return this.$outer.parseEntry(this.$outer.mmap(), this.n$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.n$1 = n$1;
            }
        });
    }

    @Override
    public TimestampOffset parseEntry(ByteBuffer buffer, int n) {
        return new TimestampOffset(this.timestamp(buffer, n), super.baseOffset() + (long)this.kafka$log$TimeIndex$$relativeOffset(buffer, n));
    }

    public void maybeAppend(long timestamp, long offset2, boolean skipFullCheck) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, timestamp, offset2, skipFullCheck){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            public final long timestamp$1;
            public final long offset$1;
            private final boolean skipFullCheck$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (!this.skipFullCheck$1) {
                    Predef$.MODULE$.require(!this.$outer.isFull(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$maybeAppend$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Attempt to append to a full time index (size = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$TimeIndex$$anonfun$$$outer()._entries())).append((Object)").").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                if (this.$outer._entries() != 0 && this.offset$1 < this.$outer.lastEntry().offset()) {
                    throw new InvalidOffsetException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempt to append an offset (", ") to slot ", " no larger than"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer._entries())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" the last offset appended (", ") to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.lastEntry().offset()), this.$outer.file().getAbsolutePath()}))).toString());
                }
                if (this.$outer._entries() != 0 && this.timestamp$1 < this.$outer.lastEntry().timestamp()) {
                    throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempt to append a timestamp (", ") to slot ", " no larger"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timestamp$1), BoxesRunTime.boxToInteger((int)this.$outer._entries())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" than the last timestamp appended (", ") to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.lastEntry().timestamp()), this.$outer.file().getAbsolutePath()}))).toString());
                }
                if (this.timestamp$1 > this.$outer.lastEntry().timestamp()) {
                    TimeIndex$.MODULE$.trace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$maybeAppend$1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding index entry ", " => ", " to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.timestamp$1), BoxesRunTime.boxToLong((long)this.$outer.offset$1), this.$outer.kafka$log$TimeIndex$$anonfun$$$outer().file().getAbsolutePath()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.mmap().putLong(this.timestamp$1);
                    this.$outer.mmap().putInt(this.$outer.relativeOffset(this.offset$1));
                    this.$outer._entries_$eq(this.$outer._entries() + 1);
                    this.$outer.kafka$log$TimeIndex$$_lastEntry_$eq(new TimestampOffset(this.timestamp$1, this.offset$1));
                    Predef$.MODULE$.require(this.$outer._entries() * this.$outer.entrySize() == this.$outer.mmap().position(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$maybeAppend$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append(this.$outer.kafka$log$TimeIndex$$anonfun$$$outer()._entries()).append((Object)" entries but file position in index is ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$TimeIndex$$anonfun$$$outer().mmap().position())).append((Object)".").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
            }

            public /* synthetic */ TimeIndex kafka$log$TimeIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$1 = timestamp$1;
                this.offset$1 = offset$1;
                this.skipFullCheck$1 = skipFullCheck$1;
            }
        });
    }

    public boolean maybeAppend$default$3() {
        return false;
    }

    public TimestampOffset lookup(long targetTimestamp) {
        return (TimestampOffset)this.maybeLock(this.lock(), new Serializable(this, targetTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final long targetTimestamp$1;

            public final TimestampOffset apply() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.largestLowerBoundSlotFor(idx, this.targetTimestamp$1, IndexSearchType$.MODULE$.KEY());
                return slot == -1 ? new TimestampOffset(-1L, this.$outer.kafka$log$TimeIndex$$super$baseOffset()) : this.$outer.parseEntry(idx, slot);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.targetTimestamp$1 = targetTimestamp$1;
            }
        });
    }

    @Override
    public void truncate() {
        this.kafka$log$TimeIndex$$truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final long offset$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.largestLowerBoundSlotFor(idx, this.offset$2, IndexSearchType$.MODULE$.VALUE());
                int newEntries = slot < 0 ? 0 : ((long)this.$outer.kafka$log$TimeIndex$$relativeOffset(idx, slot) == this.offset$2 - this.$outer.kafka$log$TimeIndex$$super$baseOffset() ? slot : slot + 1);
                this.$outer.kafka$log$TimeIndex$$truncateToEntries(newEntries);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$2 = offset$2;
            }
        });
    }

    @Override
    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final int newSize$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                boolean bl;
                if (this.$outer.kafka$log$TimeIndex$$super$resize(this.newSize$1)) {
                    this.$outer.kafka$log$TimeIndex$$_lastEntry_$eq(this.$outer.kafka$log$TimeIndex$$lastEntryFromIndexFile());
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        }));
    }

    public void kafka$log$TimeIndex$$truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, entries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            public final int entries$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer._entries_$eq(this.entries$1);
                this.$outer.mmap().position(this.$outer._entries() * this.$outer.entrySize());
                this.$outer.kafka$log$TimeIndex$$_lastEntry_$eq(this.$outer.kafka$log$TimeIndex$$lastEntryFromIndexFile());
                TimeIndex$.MODULE$.debug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$kafka$log$TimeIndex$$truncateToEntries$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Truncated index ", " to ", " entries; position is now ", " and last entry is now ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$log$TimeIndex$$anonfun$$$outer().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.$outer.entries$1), BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$TimeIndex$$anonfun$$$outer().mmap().position()), this.$outer.kafka$log$TimeIndex$$anonfun$$$outer().kafka$log$TimeIndex$$_lastEntry()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TimeIndex kafka$log$TimeIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.entries$1 = entries$1;
            }
        });
    }

    @Override
    public void sanityCheck() {
        long lastTimestamp = this.lastEntry().timestamp();
        long lastOffset = this.lastEntry().offset();
        if (this._entries() != 0 && lastTimestamp < this.timestamp(this.mmap(), 0)) {
            throw new CorruptIndexException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"non-zero size but the last timestamp is ", " which is less than the first timestamp "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastTimestamp)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timestamp(this.mmap(), 0))}))).toString());
        }
        if (this._entries() != 0 && lastOffset < super.baseOffset()) {
            throw new CorruptIndexException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"non-zero size but the last offset is ", " which is less than the first offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastOffset), BoxesRunTime.boxToLong((long)super.baseOffset())}))).toString());
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time index file ", " is corrupt, found ", " bytes "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToLong((long)this.length())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which is neither positive nor a multiple of ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.entrySize())}))).toString());
        }
    }

    public TimeIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
        TimeIndex$.MODULE$.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded index file ", " with maxEntries = ", ", maxIndexSize = ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.$outer.maxEntries()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$TimeIndex$$super$maxIndexSize())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" entries = ", ", lastOffset = ", ", file position = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer._entries()), this.$outer.kafka$log$TimeIndex$$_lastEntry(), BoxesRunTime.boxToInteger((int)this.$outer.mmap().position())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

