/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexSearchType$;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001\u0002\u0010 \u0001\u0011B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\nw\u0001\u0011\t\u0011)A\u0005SqB\u0011\"\u0010\u0001\u0003\u0002\u0003\u0006Ia\f \t\u0013}\u0002!\u0011!Q\u0001\n\u0001\u001b\u0005\"\u0002#\u0001\t\u0003)\u0005\"B&\u0001\t\u0003b\u0005BB'\u0001A\u0003&\u0011\u0006C\u0003O\u0001\u0011%q\nC\u0003T\u0001\u0011\u0005A\u000bC\u0003V\u0001\u0011\u0005a\u000bC\u0003Z\u0001\u0011\u0005!\fC\u0003c\u0001\u0011%1\rC\u0003o\u0001\u0011%q\u000eC\u0003s\u0001\u0011E3\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0003z\u0001\u0011\u0005!\u0010C\u0004\u0002\u0006\u0001!\t%a\u0002\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!9\u0011q\u0002\u0001\u0005\n\u0005E\u0001bBA\f\u0001\u0011\u0005\u0013q\u0001\u0005\r\u00033\u0001\u0001\u0013aA\u0001\u0002\u0013%AJ\u0010\u0005\r\u00037\u0001\u0001\u0013aA\u0001\u0002\u0013%A\u000bP\u0004\b\u0003;y\u0002\u0012AA\u0010\r\u0019qr\u0004#\u0001\u0002\"!1A\t\u0007C\u0001\u0003kA\u0011\"a\u000e\u0019\u0005\u0004%\t%!\u000f\t\u0011\u0005E\u0003\u0004)A\u0005\u0003wA\u0011\"a\u0015\u0019#\u0003%\t!!\u0016\t\u0013\u0005-\u0004$%A\u0005\u0002\u00055$aC(gMN,G/\u00138eKbT!\u0001I\u0011\u0002\u00071|wMC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0013\u0011\t\u0019:\u0013fL\u0007\u0002?%\u0011\u0001f\b\u0002\u000e\u0003\n\u001cHO]1di&sG-\u001a=\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\t1{gn\u001a\t\u0003UAJ!!M\u0016\u0003\u0007%sG/A\u0003`M&dW\r\u0005\u00025s5\tQG\u0003\u00027o\u0005\u0011\u0011n\u001c\u0006\u0002q\u0005!!.\u0019<b\u0013\tQTG\u0001\u0003GS2,\u0017A\u00032bg\u0016|eMZ:fi&\u00111hJ\u0001\r[\u0006D\u0018J\u001c3fqNK'0Z\u0005\u0003{\u001d\n\u0001b\u001e:ji\u0006\u0014G.\u001a\t\u0003U\u0005K!AQ\u0016\u0003\u000f\t{w\u000e\\3b]&\u0011qhJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0019;\u0005*\u0013&\u0011\u0005\u0019\u0002\u0001\"\u0002\u001a\u0006\u0001\u0004\u0019\u0004\"B\u001e\u0006\u0001\u0004I\u0003bB\u001f\u0006!\u0003\u0005\ra\f\u0005\b\u007f\u0015\u0001\n\u00111\u0001A\u0003%)g\u000e\u001e:z'&TX-F\u00010\u0003-yF.Y:u\u001f\u001a47/\u001a;\u0002\u00131\f7\u000f^#oiJLX#\u0001)\u0011\u0005\u0019\n\u0016B\u0001* \u00059yeMZ:fiB{7/\u001b;j_:\f!\u0002\\1ti>3gm]3u+\u0005I\u0013A\u00027p_.,\b\u000f\u0006\u0002Q/\")\u0001L\u0003a\u0001S\u0005aA/\u0019:hKR|eMZ:fi\u0006)b-\u001a;dQV\u0003\b/\u001a:C_VtGm\u00144gg\u0016$HcA._AB\u0019!\u0006\u0018)\n\u0005u[#AB(qi&|g\u000eC\u0003`\u0017\u0001\u0007\u0001+A\u0006gKR\u001c\u0007n\u00144gg\u0016$\b\"B1\f\u0001\u0004y\u0013!\u00034fi\u000eD7+\u001b>f\u00039\u0011X\r\\1uSZ,wJ\u001a4tKR$2a\f3m\u0011\u0015)G\u00021\u0001g\u0003\u0019\u0011WO\u001a4feB\u0011qM[\u0007\u0002Q*\u0011\u0011nN\u0001\u0004]&|\u0017BA6i\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006[2\u0001\raL\u0001\u0002]\u0006A\u0001\u000f[=tS\u000e\fG\u000eF\u00020aFDQ!Z\u0007A\u0002\u0019DQ!\\\u0007A\u0002=\n!\u0002]1sg\u0016,e\u000e\u001e:z)\r\u0001F/\u001e\u0005\u0006K:\u0001\rA\u001a\u0005\u0006[:\u0001\raL\u0001\u0006K:$(/\u001f\u000b\u0003!bDQ!\\\bA\u0002=\na!\u00199qK:$G\u0003B>\u007f\u0003\u0003\u0001\"A\u000b?\n\u0005u\\#\u0001B+oSRDQa \tA\u0002%\naa\u001c4gg\u0016$\bBBA\u0002!\u0001\u0007q&\u0001\u0005q_NLG/[8o\u0003!!(/\u001e8dCR,G#A>\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000eF\u0002|\u0003\u001bAQa \nA\u0002%\n\u0011\u0003\u001e:v]\u000e\fG/\u001a+p\u000b:$(/[3t)\rY\u00181\u0003\u0005\u0007\u0003+\u0019\u0002\u0019A\u0018\u0002\u000f\u0015tGO]5fg\u0006Y1/\u00198jif\u001c\u0005.Z2l\u0003I\u0019X\u000f]3sI5\f\u00070\u00138eKb\u001c\u0016N_3\u0002!M,\b/\u001a:%E\u0006\u001cXm\u00144gg\u0016$\u0018aC(gMN,G/\u00138eKb\u0004\"A\n\r\u0014\u000ba\t\u0019#!\u000b\u0011\u0007)\n)#C\u0002\u0002(-\u0012a!\u00118z%\u00164\u0007\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=\u0012%A\u0003vi&d7/\u0003\u0003\u00024\u00055\"a\u0002'pO\u001eLgn\u001a\u000b\u0003\u0003?\t!\u0002\\8hO\u0016\u0014h*Y7f+\t\tY\u0004\u0005\u0003\u0002>\u0005-c\u0002BA \u0003\u000f\u00022!!\u0011,\u001b\t\t\u0019EC\u0002\u0002F\r\na\u0001\u0010:p_Rt\u0014bAA%W\u00051\u0001K]3eK\u001aLA!!\u0014\u0002P\t11\u000b\u001e:j]\u001eT1!!\u0013,\u0003-awnZ4fe:\u000bW.\u001a\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t9FK\u00020\u00033Z#!a\u0017\u0011\t\u0005u\u0013qM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003KZ\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011NA0\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005=$f\u0001!\u0002Z\u0001")
public class OffsetIndex
extends AbstractIndex<Object, Object> {
    private long _lastOffset = this.lastEntry().offset();

    public static boolean $lessinit$greater$default$4() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static String loggerName() {
        return OffsetIndex$.MODULE$.loggerName();
    }

    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.fatal(function0, function02);
    }

    public static void fatal(Function0<String> function0) {
        OffsetIndex$.MODULE$.fatal(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.error(function0, function02);
    }

    public static void error(Function0<String> function0) {
        OffsetIndex$.MODULE$.error(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.warn(function0, function02);
    }

    public static void warn(Function0<String> function0) {
        OffsetIndex$.MODULE$.warn(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.info(function0, function02);
    }

    public static void info(Function0<String> function0) {
        OffsetIndex$.MODULE$.info(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.debug(function0, function02);
    }

    public static void debug(Function0<String> function0) {
        OffsetIndex$.MODULE$.debug(function0);
    }

    public static boolean isTraceEnabled() {
        return OffsetIndex$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return OffsetIndex$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.trace(function0, function02);
    }

    public static void trace(Function0<String> function0) {
        OffsetIndex$.MODULE$.trace(function0);
    }

    private /* synthetic */ int super$maxIndexSize() {
        return super.maxIndexSize();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 8;
    }

    private OffsetPosition lastEntry() {
        return (OffsetPosition)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            OffsetPosition offsetPosition;
            int n = this._entries();
            switch (n) {
                case 0: {
                    offsetPosition = new OffsetPosition(this.super$baseOffset(), 0);
                    break;
                }
                default: {
                    offsetPosition = this.parseEntry(this.mmap(), n - 1);
                    break;
                }
            }
            return offsetPosition;
        });
    }

    public long lastOffset() {
        return this._lastOffset;
    }

    public OffsetPosition lookup(long targetOffset) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetOffset, IndexSearchType$.MODULE$.KEY());
            return slot == -1 ? new OffsetPosition(this.super$baseOffset(), 0) : this.parseEntry(idx, slot);
        });
    }

    public Option<OffsetPosition> fetchUpperBoundOffset(OffsetPosition fetchOffset, int fetchSize) {
        return (Option)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.smallestUpperBoundSlotFor(idx, fetchOffset.position() + fetchSize, IndexSearchType$.MODULE$.VALUE());
            return slot == -1 ? None$.MODULE$ : new Some((Object)this.parseEntry(idx, slot));
        });
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize());
    }

    private int physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 4);
    }

    @Override
    public OffsetPosition parseEntry(ByteBuffer buffer, int n) {
        return new OffsetPosition(super.baseOffset() + (long)this.relativeOffset(buffer, n), this.physical(buffer, n));
    }

    public OffsetPosition entry(int n) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringBuilder(59).append("Attempt to fetch the ").append(n).append("th entry from index ").append(this.file().getAbsolutePath()).append(", ").append("which has size ").append(this._entries()).append(".").toString());
            }
            return this.parseEntry(this.mmap(), n);
        });
    }

    public void append(long offset, int position) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(!this.isFull(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Attempt to append to a full index (size = ").append(this._entries()).append(").").toString());
            if (this._entries() != 0 && offset <= $this._lastOffset) {
                throw new InvalidOffsetException(new StringBuilder(91).append("Attempt to append an offset (").append(offset).append(") to position ").append(this.entries()).append(" no larger than").append(" the last offset appended (").append($this._lastOffset).append(") to ").append(this.file().getAbsolutePath()).append(".").toString());
            }
            OffsetIndex$.MODULE$.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Adding index entry ").append(offset).append(" => ").append(position).append(" to ").append(this.file().getAbsolutePath()).toString());
            this.mmap().putInt(this.relativeOffset(offset));
            this.mmap().putInt(position);
            this._entries_$eq(this._entries() + 1);
            $this._lastOffset = offset;
            Predef$.MODULE$.require(this._entries() * this.entrySize() == this.mmap().position(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append(this.entries()).append(" entries but file position in index is ").append(this.mmap().position()).append(".").toString());
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, offset, IndexSearchType$.MODULE$.KEY());
            int newEntries = slot < 0 ? 0 : ((long)this.relativeOffset(idx, slot) == offset - this.super$baseOffset() ? slot : slot + 1);
            this.truncateToEntries(newEntries);
        });
    }

    private void truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this._entries_$eq(entries);
            this.mmap().position(this._entries() * this.entrySize());
            $this._lastOffset = this.lastEntry().offset();
            OffsetIndex$.MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Truncated index ").append(this.file().getAbsolutePath()).append(" to ").append(entries).append(" entries;").append(" position is now ").append(this.mmap().position()).append(" and last offset is now ").append($this._lastOffset).toString());
        });
    }

    @Override
    public void sanityCheck() {
        if (this._entries() != 0 && this._lastOffset < super.baseOffset()) {
            throw new CorruptIndexException(new StringBuilder(113).append("Corrupt index found, index file (").append(this.file().getAbsolutePath()).append(") has non-zero size ").append("but the last offset is ").append(this._lastOffset).append(" which is less than the base offset ").append(super.baseOffset()).append(".").toString());
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringBuilder(82).append("Index file ").append(this.file().getAbsolutePath()).append(" is corrupt, found ").append(this.length()).append(" bytes which is ").append("neither positive nor a multiple of ").append(this.entrySize()).append(".").toString());
        }
    }

    public OffsetIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
        OffsetIndex$.MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Loaded index file ").append(this.file().getAbsolutePath()).append(" with maxEntries = ").append(this.maxEntries()).append(", ").append("maxIndexSize = ").append(this.super$maxIndexSize()).append(", entries = ").append(this._entries()).append(", lastOffset = ").append($this._lastOffset).append(", file position = ").append(this.mmap().position()).toString());
    }
}

