/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.server.ConfigType$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001B\u0016-\u0001EBQA\u0011\u0001\u0005\u0002\rC\u0011\"\u0012\u0001A\u0002\u0003\u0007I\u0011\u0002$\t\u0013U\u0003\u0001\u0019!a\u0001\n\u00131\u0006\"C0\u0001\u0001\u0004\u0005\t\u0015)\u0003H\u0011%\u0001\u0007\u00011AA\u0002\u0013%\u0011\rC\u0005k\u0001\u0001\u0007\t\u0019!C\u0005W\"IQ\u000e\u0001a\u0001\u0002\u0003\u0006KA\u0019\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0011\u0019Q\b\u0001)A\u0005a\")1\u0010\u0001C\u0001_\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\b\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u00033\u0001A\u0011AA\u0003\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003\u000bAq!a\n\u0001\t\u0003\t)\u0001C\u0004\u0002,\u0001!\t!!\u0002\t\u000f\u0005=\u0002\u0001\"\u0001\u0002\u0006!9\u00111\u0007\u0001\u0005\u0002\u0005\u0015\u0001bBA\u001c\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003w\u0001A\u0011AA\u0003\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u000bAq!a\u0011\u0001\t\u0003\t)\u0001C\u0004\u0002H\u0001!\t!!\u0002\t\u000f\u0005-\u0003\u0001\"\u0001\u0002\u0006!9\u0011q\n\u0001\u0005\u0002\u0005\u0015\u0001bBA*\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003/\u0002A\u0011AA\u0003\u0011\u001d\tY\u0006\u0001C\u0001\u0003\u000bAq!a\u0018\u0001\t\u0003\t)\u0001C\u0004\u0002d\u0001!\t!!\u0002\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002\u0006!9\u00111\u000e\u0001\u0005\u0002\u0005\u0015\u0001bBA8\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003g\u0002A\u0011AA\u0003\u0011\u001d\t9\b\u0001C\u0001\u0003\u000bAq!a\u001f\u0001\t\u0003\t)\u0001C\u0004\u0002\u0000\u0001!\t!!\u0002\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006!9\u0011q\u0011\u0001\u0005\u0002\u0005\u0015\u0001bBAF\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001f\u0003A\u0011AA\u0003\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+\u0013A\u0004V8qS\u000e\u001cu.\\7b]\u0012<\u0016\u000e\u001e5[\u0017\u000ec\u0017.\u001a8u)\u0016\u001cHO\u0003\u0002.]\u0005)\u0011\rZ7j]*\tq&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\u0011\u0004H\u0010\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k9\n!A_6\n\u0005]\"$\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002:y5\t!H\u0003\u0002<]\u0005)Q\u000f^5mg&\u0011QH\u000f\u0002\b\u0019><w-\u001b8h!\ty\u0004)D\u0001-\u0013\t\tEFA\u0007SC\u000e\\\u0017i^1sKR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0003\"a\u0010\u0001\u0002\u0019Q|\u0007/[2TKJ4\u0018nY3\u0016\u0003\u001d\u0003\"\u0001\u0013*\u000f\u0005%\u0003fB\u0001&P\u001d\tYe*D\u0001M\u0015\ti\u0005'\u0001\u0004=e>|GOP\u0005\u0002_%\u0011QFL\u0005\u0003#2\nA\u0002V8qS\u000e\u001cu.\\7b]\u0012L!a\u0015+\u0003+i{wn[3fa\u0016\u0014Hk\u001c9jGN+'O^5dK*\u0011\u0011\u000bL\u0001\u0011i>\u0004\u0018nY*feZL7-Z0%KF$\"aV/\u0011\u0005a[V\"A-\u000b\u0003i\u000bQa]2bY\u0006L!\u0001X-\u0003\tUs\u0017\u000e\u001e\u0005\b=\u000e\t\t\u00111\u0001H\u0003\rAH%M\u0001\u000ei>\u0004\u0018nY*feZL7-\u001a\u0011\u0002\u001bQ,7\u000f\u001e+pa&\u001cg*Y7f+\u0005\u0011\u0007CA2h\u001d\t!W\r\u0005\u0002L3&\u0011a-W\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002g3\u0006\tB/Z:u)>\u0004\u0018n\u0019(b[\u0016|F%Z9\u0015\u0005]c\u0007b\u00020\u0007\u0003\u0003\u0005\rAY\u0001\u000fi\u0016\u001cH\u000fV8qS\u000et\u0015-\\3!\u0003%yF/Z:u\u001d\u0006lW-F\u0001q!\t\t\b0D\u0001s\u0015\t\u0019H/A\u0003sk2,7O\u0003\u0002vm\u0006)!.\u001e8ji*\tq/A\u0002pe\u001eL!!\u001f:\u0003\u0011Q+7\u000f\u001e(b[\u0016\f!b\u0018;fgRt\u0015-\\3!\u0003!!Xm\u001d;OC6,\u0007F\u0001\u0006~!\tqx0D\u0001u\u0013\r\t\t\u0001\u001e\u0002\u0005%VdW-A\u0003tKR,\b\u000fF\u0001XQ\rY\u0011\u0011\u0002\t\u0004}\u0006-\u0011bAA\u0007i\n1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0004\u0019\u0005M\u0001c\u0001@\u0002\u0016%\u0019\u0011q\u0003;\u0003\u000b\u00053G/\u001a:\u0002\u0015Q,7\u000f^\"sK\u0006$X\rK\u0002\u000e\u0003;\u00012A`A\u0010\u0013\r\t\t\u0003\u001e\u0002\u0005)\u0016\u001cH/A\u000buKN$8I]3bi\u0016<\u0016\u000e\u001e5D_:4\u0017nZ:)\u00079\ti\"A\u000buKN$8I]3bi\u0016LeMT8u\u000bbL7\u000f^:)\u0007=\ti\"A\u0010uKN$8I]3bi\u0016<\u0016\u000e\u001e5SKBd\u0017nY1BgNLwM\\7f]RD3\u0001EA\u000f\u0003\u0019\"Xm\u001d;De\u0016\fG/Z,ji\"LeN^1mS\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0015\u0004#\u0005u\u0011a\n;fgR\u001c%/Z1uK^KG\u000f\u001b(fO\u0006$\u0018N^3SKBd\u0017nY1uS>tg)Y2u_JD3AEA\u000f\u0003\u0011\"Xm\u001d;De\u0016\fG/Z,ji\"tUmZ1uSZ,\u0007+\u0019:uSRLwN\\\"pk:$\bfA\n\u0002\u001e\u0005YB/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019'fm\u0016d7i\u001c8gS\u001eD3\u0001FA\u000f\u00039!Xm\u001d;MSN$Hk\u001c9jGND3!FA\u000f\u0003u!Xm\u001d;MSN$Hk\u001c9jGN<\u0016\u000e\u001e5J]\u000edW\u000fZ3MSN$\bf\u0001\f\u0002\u001e\u0005\tC/Z:u\u0019&\u001cH\u000fV8qS\u000e\u001cx+\u001b;i\u000bb\u001cG.\u001e3f\u0013:$XM\u001d8bY\"\u001aq#!\b\u0002/Q,7\u000f^!mi\u0016\u0014\b+\u0019:uSRLwN\\\"pk:$\bf\u0001\r\u0002\u001e\u0005\u0019B/Z:u\u00032$XM]!tg&<g.\\3oi\"\u001a\u0011$!\b\u0002EQ,7\u000f^!mi\u0016\u0014x+\u001b;i\u0013:4\u0018\r\\5e!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\rQ\u0012QD\u0001\u0012i\u0016\u001cH/\u00117uKJLe-\u0012=jgR\u001c\bfA\u000e\u0002\u001e\u0005\u0001B/Z:u\u00032$XM]\"p]\u001aLwm\u001d\u0015\u00049\u0005u\u0011a\f;fgR\u001cuN\u001c4jOB\u0013Xm]3sm\u0006$\u0018n\u001c8BGJ|7o\u001d)beRLG/[8o\u00032$XM]1uS>t\u0007fA\u000f\u0002\u001e\u0005\tB/Z:u)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8)\u0007y\ti\"\u0001\nuKN$H)\u001a7fi\u0016Le-\u0012=jgR\u001c\bfA\u0010\u0002\u001e\u00059B/Z:u\t\u0016dW\r^3J]R,'O\\1m)>\u0004\u0018n\u0019\u0015\u0004A\u0005u\u0011\u0001\b;fgR$Um]2sS\n,\u0017J\u001a+pa&\u001cgj\u001c;Fq&\u001cHo\u001d\u0015\u0004C\u0005u\u0011!\t;fgR\u001c%/Z1uK\u0006cG/\u001a:U_BL7mV5uQJ\u000b7m[!xCJ,\u0007f\u0001\u0012\u0002\u001e\u0005aA/Z:u\t\u0016\u001c8M]5cK\"\u001a1%!\b\u0002GQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3SKB|'\u000f^(wKJ\u0014\u0018\u000e\u001a3f]\u000e{gNZ5hg\"\u001aA%!\b\u0002UQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3B]\u0012d\u0015n\u001d;U_BL7m]'be.,GMR8s\t\u0016dW\r^5p]\"\u001aQ%!\b\u0002]Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3B]\u0012d\u0015n\u001d;U_BL7m],ji\"|W\u000f^%oi\u0016\u0014h.\u00197U_BL7m\u001d\u0015\u0004M\u0005u\u0011!\f;fgR$v\u000e]5d\u001fB,'/\u0019;j_:\u001cx+\u001b;i%\u0016<W\r_*z[\n|G.\u00138U_BL7MT1nK\"\u001aq%!\b\u0002IQ,7\u000f^!mi\u0016\u0014\u0018J\u001c;fe:\fG\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]RD3\u0001KA\u000f\u0003\r#Xm\u001d;De\u0016\fG/Z,ji\",fn\u001d9fG&4\u0017.\u001a3SKBd\u0017nY1uS>tg)Y2u_J\fe\u000e\u001a)beRLG/[8og^KG\u000f\u001b.l\u00072LWM\u001c;)\u0007%\ni\"\u0001\bbgN,'\u000f^#ySR\u001cu\u000eZ3\u0015\u000b]\u000b9*!)\t\u000f\u0005e%\u00061\u0001\u0002\u001c\u0006AQ\r\u001f9fGR,G\rE\u0002Y\u0003;K1!a(Z\u0005\rIe\u000e\u001e\u0005\b\u0003GS\u0003\u0019AAS\u0003\u0019iW\r\u001e5pIB!\u0001,a*X\u0013\r\tI+\u0017\u0002\n\rVt7\r^5p]B\u0002")
public class TopicCommandWithZKClientTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private TopicCommand.ZookeeperTopicService topicService;
    private String testTopicName;
    private final TestName _testName = new TestName();

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    private TopicCommand.ZookeeperTopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.ZookeeperTopicService x$1) {
        this.topicService = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    /*
     * WARNING - void declaration
     */
    @Before
    public void setup() {
        void mkString_end;
        this.topicService_$eq(new TopicCommand.ZookeeperTopicService(this.zkClient()));
        LazyList lazyList = Random$.MODULE$.alphanumeric().take(10);
        if (lazyList == null) {
            throw null;
        }
        LazyList mkString_this = lazyList;
        String mkString_mkString_sep = "";
        String string = "";
        String mkString_start = "";
        Object var3_4 = null;
        string = null;
        Object var2_2 = null;
        Object var1_1 = null;
        this.testTopicName_$eq(new StringBuilder(1).append(this.testName().getMethodName()).append("-").append(IterableOnceOps.mkString$((IterableOnceOps)mkString_this, (String)mkString_start, (String)mkString_mkString_sep, (String)mkString_end)).toString());
    }

    @After
    public void teardown() {
        if (this.topicService() != null) {
            this.topicService().close();
        }
    }

    @Test
    public void testCreate() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()}));
        KafkaZkClient qual$1 = this.zkClient();
        boolean x$1 = qual$1.getAllTopicsInCluster$default$1();
        Assert.assertTrue((boolean)qual$1.getAllTopicsInCluster(x$1).contains((Object)this.testTopicName()));
    }

    @Test
    public void testCreateWithConfigs() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", configResource.name(), "--config", "delete.retention.ms=1000"}));
        Properties configs = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertEquals((Object)1000, (Object)Integer.valueOf(configs.getProperty("delete.retention.ms")));
    }

    @Test
    public void testCreateIfNotExists() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitions).toString(), "--replication-factor", "1", "--topic", this.testTopicName()});
        this.topicService().createTopic(createOpts);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        TopicCommand.TopicCommandOptions createNotExistsOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitions).toString(), "--replication-factor", "1", "--topic", this.testTopicName(), "--if-not-exists"});
        this.topicService().createTopic(createNotExistsOpts);
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()});
        this.topicService().createTopic(createOpts);
        Seq replicas0 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 0));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)replicas0);
        Seq replicas1 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 1));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)replicas1);
        Seq replicas2 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 2));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)replicas2);
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", ((Object)32768).toString(), "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"});
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        TopicCommand.TopicCommandOptions createOpts2 = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.format.version=boom"});
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(createOpts2), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
    }

    @Test
    public void testListTopics() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var2_2 = null;
        Object var3_3 = null;
        Assert.assertTrue((boolean)grabConsoleOutput_out.toString().contains(this.testTopicName()));
    }

    @Test
    public void testListTopicsWithIncludeList() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topic1, 2, 2, x$4, x$5);
        AdminZkClient qual$2 = this.adminZkClient();
        Properties x$9 = qual$2.createTopic$default$4();
        RackAwareMode x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(topic2, 2, 2, x$9, x$10);
        AdminZkClient qual$3 = this.adminZkClient();
        Properties x$14 = qual$3.createTopic$default$4();
        RackAwareMode x$15 = qual$3.createTopic$default$5();
        qual$3.createTopic(topic3, 2, 2, x$14, x$15);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--topic", "kafka.*"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var15_14 = null;
        Object var16_15 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertTrue((boolean)output.contains(topic2));
        Assert.assertFalse((boolean)output.contains(topic3));
    }

    @Test
    public void testListTopicsWithExcludeInternal() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, 2, 2, x$4, x$5);
        AdminZkClient qual$2 = this.adminZkClient();
        Properties x$9 = qual$2.createTopic$default$4();
        RackAwareMode x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic("__consumer_offsets", 2, 2, x$9, x$10);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var10_9 = null;
        Object var11_10 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterPartitionCount() {
        void apply_elems;
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, 2, 2, x$4, x$5);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "3"}));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        SeqOps seqOps = (SeqOps)this.zkClient().getPartitionsForTopics((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).apply((Object)this.testTopicName());
        if (seqOps == null) {
            throw null;
        }
        Assert.assertEquals((long)3L, (long)seqOps.length());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterAssignment() {
        void apply_elems;
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, 2, 2, x$4, x$5);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"}));
        Seq replicas0 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 2));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        SeqOps seqOps = (SeqOps)this.zkClient().getPartitionsForTopics((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).apply((Object)this.testTopicName());
        if (seqOps == null) {
            throw null;
        }
        Assert.assertEquals((long)3L, (long)seqOps.length());
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)replicas0);
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
    }

    @Test
    public void testAlterIfExists() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1"});
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().alterTopic(alterOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        TopicCommand.TopicCommandOptions alterExistsOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"});
        this.topicService().alterTopic(alterExistsOpts);
    }

    @Test
    public void testAlterConfigs() {
        String string;
        String string2;
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--config", "cleanup.policy=compact"}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string3 = string2 = grabConsoleOutput_out.toString();
        Object var4_2 = null;
        Object var5_3 = null;
        string2 = null;
        String output = string3;
        Assert.assertTrue((String)"The output should contain the modified config", (boolean)output.contains("Configs: cleanup.policy=compact"));
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--config", "cleanup.policy=delete"}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string4 = string = grabConsoleOutput_out2.toString();
        Object var8_7 = null;
        Object var9_8 = null;
        string = null;
        String output2 = string4;
        Assert.assertTrue((String)"The output should contain the modified config", (boolean)output2.contains("Configs: cleanup.policy=delete"));
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitionsOriginal).toString(), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()});
        this.topicService().createTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitionsModified).toString(), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        int numPartitionsOriginal = 1;
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitionsOriginal).toString(), "--replication-factor", "1", "--topic", this.testTopicName()});
        this.topicService().createTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        this.topicService().deleteTopic(deleteOpts);
        Assert.assertTrue((String)"Delete path for topic should exist after deletion.", (boolean)this.zkClient().pathExists(deletePath));
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitionsOriginal).toString(), "--replication-factor", "1", "--topic", "__consumer_offsets"});
        this.topicService().createTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", "__consumer_offsets"});
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().deleteTopic(deleteOffsetTopicOpts), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        Assert.assertFalse((String)"Delete path for topic shouldn't exist after deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
    }

    @Test
    public void testDeleteIfExists() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().deleteTopic(deleteOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
        TopicCommand.TopicCommandOptions deleteExistsOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"});
        this.topicService().deleteTopic(deleteExistsOpts);
    }

    @Test
    public void testDeleteInternalTopic() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"});
        this.topicService().createTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", "__consumer_offsets"});
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().deleteTopic(deleteOffsetTopicOpts), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
    }

    @Test
    public void testDescribeIfTopicNotExists() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions describeOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(describeOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        TopicCommand.TopicCommandOptions describeOptsAllTopics = new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        this.topicService().describeTopic(describeOptsAllTopics);
        TopicCommand.TopicCommandOptions describeOptsWithExists = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"});
        this.topicService().describeTopic(describeOptsWithExists);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateAlterTopicWithRackAware() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[6];
        String string = "rack1";
        Integer $minus$greater$extension_$this = 0;
        Object var8_2 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y6);
        String string2 = "rack2";
        Integer $minus$greater$extension_$this2 = 1;
        Object var10_4 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y5);
        String string3 = "rack2";
        Integer $minus$greater$extension_$this3 = 2;
        Object var12_6 = null;
        string3 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y4);
        String string4 = "rack1";
        Integer $minus$greater$extension_$this4 = 3;
        Object var14_8 = null;
        string4 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y3);
        String string5 = "rack3";
        Integer $minus$greater$extension_$this5 = 4;
        Object var16_10 = null;
        string5 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y2);
        String string6 = "rack3";
        Integer $minus$greater$extension_$this6 = 5;
        Object var18_12 = null;
        string6 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3);
        TestUtils$.MODULE$.createBrokersInZk(this.toBrokerMetadata((Map<Object, String>)rackInfo, this.toBrokerMetadata$default$2()), this.zkClient());
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitions).toString(), "--replication-factor", ((Object)replicationFactor).toString(), "--topic", this.testTopicName()});
        this.topicService().createTopic(createOpts);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Map assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            Integer n;
            Integer n2;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            Seq replicas = (Seq)x0$1._2();
            Integer n3 = n2 = Integer.valueOf(tp.partition());
            n2 = null;
            Integer n4 = n = n3;
            n = null;
            Integer $minus$greater$extension_$this = n4;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            Object var4_5 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        });
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)alteredNumPartitions).toString(), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2;
            Integer n;
            Integer n2;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Seq replicas = (Seq)x0$2._2();
            Integer n3 = n2 = Integer.valueOf(tp.partition());
            n2 = null;
            Integer n4 = n = n3;
            n = null;
            Integer $minus$greater$extension_$this = n4;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            Object var4_5 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        });
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testDescribe() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, 2, 2, x$4, x$5);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var7_6 = null;
        Object var8_7 = null;
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assert.assertEquals((long)3L, (long)rows.length);
        rows[0].startsWith("Topic:testTopic\tPartitionCount:2");
    }

    @Test
    public void testDescribeReportOverriddenConfigs() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        String config = "file.delete.delay.ms=1000";
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", configResource.name(), "--config", config}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var4_4 = null;
        Object var5_5 = null;
        Assert.assertTrue((boolean)grabConsoleOutput_out.toString().contains(config));
    }

    @Test
    public void testDescribeAndListTopicsMarkedForDeletion() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        String markedForDeletionDescribe = "MarkedForDeletion";
        String markedForDeletionList = "marked for deletion";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()});
        this.topicService().createTopic(createOpts);
        TestUtils$.MODULE$.deleteBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.describeTopicsWithConfig$1();
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var8_5 = null;
        Object var9_6 = null;
        String outputWithConfig = grabConsoleOutput_out.toString();
        Assert.assertTrue((outputWithConfig.contains(this.testTopicName()) && outputWithConfig.contains(markedForDeletionDescribe) ? 1 : 0) != 0);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.describeTopicsNoConfig$1();
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var11_9 = null;
        Object var12_10 = null;
        String outputNoConfig = grabConsoleOutput_out2.toString();
        Assert.assertTrue((outputNoConfig.contains(this.testTopicName()) && outputNoConfig.contains(markedForDeletionDescribe) ? 1 : 0) != 0);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f3 = (JFunction0.mcV.sp & Serializable)() -> this.listTopics$1();
        ByteArrayOutputStream grabConsoleOutput_out3 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out3, (Function0)grabConsoleOutput_f3);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var14_13 = null;
        Object var15_14 = null;
        String output = grabConsoleOutput_out3.toString();
        Assert.assertTrue((output.contains(this.testTopicName()) && output.contains(markedForDeletionList) ? 1 : 0) != 0);
    }

    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--describe", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_2 = null;
        Object var4_3 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--list", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var6_6 = null;
        Object var7_7 = null;
        output = grabConsoleOutput_out2.toString();
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testTopicOperationsWithRegexSymbolInTopicName() {
        String topic1 = "test.topic";
        String topic2 = "test-topic";
        String escapedTopic = "\"test\\.topic\"";
        String unescapedTopic = "test.topic";
        int numPartitionsOriginal = 1;
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitionsOriginal).toString(), "--replication-factor", "1", "--topic", topic1});
        this.topicService().createTopic(createOpts);
        TopicCommand.TopicCommandOptions createOpts2 = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitionsOriginal).toString(), "--replication-factor", "1", "--topic", topic2});
        this.topicService().createTopic(createOpts2);
        TopicCommand.TopicCommandOptions escapedCommandOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", escapedTopic});
        TopicCommand.TopicCommandOptions unescapedCommandOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", unescapedTopic});
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(escapedCommandOpts);
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var11_11 = null;
        Object var12_12 = null;
        Assert.assertFalse((boolean)grabConsoleOutput_out.toString().contains(topic2));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(unescapedCommandOpts);
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var14_14 = null;
        Object var15_15 = null;
        Assert.assertTrue((boolean)grabConsoleOutput_out2.toString().contains(topic2));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f3 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().deleteTopic(escapedCommandOpts);
        ByteArrayOutputStream grabConsoleOutput_out3 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out3, (Function0)grabConsoleOutput_f3);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var17_17 = null;
        Object var18_18 = null;
        Assert.assertFalse((boolean)grabConsoleOutput_out3.toString().contains(topic2));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f4 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().deleteTopic(unescapedCommandOpts);
        ByteArrayOutputStream grabConsoleOutput_out4 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out4, (Function0)grabConsoleOutput_f4);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var20_20 = null;
        Object var21_21 = null;
        Assert.assertTrue((boolean)grabConsoleOutput_out4.toString().contains(topic2));
    }

    @Test
    public void testAlterInternalTopicPartitionCount() {
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic("__consumer_offsets", 1, 1, x$4, x$5);
        AdminZkClient qual$2 = this.adminZkClient();
        Properties x$9 = qual$2.createTopic$default$4();
        RackAwareMode x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic("__transaction_state", 1, 1, x$9, x$10);
        this.expectAlterInternalTopicPartitionCountFailed$1("__consumer_offsets");
        this.expectAlterInternalTopicPartitionCountFailed$1("__transaction_state");
    }

    @Test
    public void testCreateWithUnspecifiedReplicationFactorAndPartitionsWithZkClient() {
        this.assertExitCode(1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> new TopicCommand.TopicCommandOptions(new String[]{"--create", "--zookeeper", "zk", "--topic", this.testTopicName()}).checkArgs());
    }

    public void assertExitCode(int expected, Function0<BoxedUnit> method) {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(exitCode, exitMessage) -> TopicCommandWithZKClientTest.mockExitProcedure$1(BoxesRunTime.unboxToInt((Object)exitCode), exitMessage, expected);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var4_3 = null;
        try {
            Assertions$.MODULE$.intercept(method, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    private final void describeTopicsWithConfig$1() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--describe"}));
    }

    private final void describeTopicsNoConfig$1() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--describe", "--unavailable-partitions"}));
    }

    private final void listTopics$1() {
        this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--list"}));
    }

    private final void expectAlterInternalTopicPartitionCountFailed$1(String topic) {
        try {
            this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", topic, "--partitions", "2"}));
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    private static final Nothing$ mockExitProcedure$1(int exitCode, Option exitMessage, int expected$1) {
        Assert.assertEquals((long)expected$1, (long)exitCode);
        throw new RuntimeException();
    }
}

