/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t%g\u0001B\u0013'\u0001-BQa\r\u0001\u0005\u0002QBqA\u000e\u0001C\u0002\u0013\u0005s\u0007\u0003\u0004?\u0001\u0001\u0006I\u0001\u000f\u0005\u0006\u007f\u0001!\t\u0006\u0011\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003P\u0011\u0019A\u0006\u0001)A\u0005!\"9\u0011\f\u0001b\u0001\n\u0013Q\u0006BB2\u0001A\u0003%1\fC\u0004e\u0001\t\u0007I\u0011B3\t\rA\u0004\u0001\u0015!\u0003g\u0011\u0015\t\b\u0001\"\u0015s\u0011\u001dY\bA1A\u0005RqDq!!\u0004\u0001A\u0003%Q\u0010\u0003\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0015}\u0011\u001d\t\t\u0002\u0001Q\u0001\nuDq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u0002,\u0001!\t%!\u0006\t\u000f\u0005U\u0002\u0001\"\u0001\u0002\u0016!9\u0011q\b\u0001\u0005\n\u0005\u0005\u0003bBA;\u0001\u0011%\u0011q\u000f\u0005\b\u0003w\u0002A\u0011BA?\u0011\u001d\ty\t\u0001C\u0005\u0003#Cq!a0\u0001\t\u0013\t\t\rC\u0004\u0002R\u0002!I!a5\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\"9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\bbBAv\u0001\u0011%\u0011Q\u001e\u0005\n\u0005s\u0001\u0011\u0013!C\u0005\u0005wAqA!\u0016\u0001\t\u0013\u00119\u0006C\u0004\u0003r\u0001!IAa\u001d\t\u0013\t\u001d\u0005!%A\u0005\n\tu\u0002b\u0002BE\u0001\u0011%!1\u0012\u0005\b\u0005\u001f\u0003A\u0011\u0002BI\u0011\u001d\u0011Y\u000b\u0001C\u0005\u0005[C\u0011Ba/\u0001#\u0003%IA!0\t\u000f\t\u0005\u0007\u0001\"\u0003\u0003D\nYQ*\u001a;sS\u000e\u001cH+Z:u\u0015\t9\u0003&A\u0002ba&T\u0011!K\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001A\u0006\r\t\u0003[9j\u0011AJ\u0005\u0003_\u0019\u0012a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o\u001d\t\u0003[EJ!A\r\u0014\u0003\u0013M\u000b7\u000f\\*fiV\u0004\u0018A\u0002\u001fj]&$h\bF\u00016!\ti\u0003!A\u0006ce>\\WM]\"pk:$X#\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u0007%sG/\u0001\u0007ce>\\WM]\"pk:$\b%\u0001\u0007mSN$XM\\3s\u001d\u0006lW-F\u0001B!\t\u0011E*D\u0001D\u0015\t!U)A\u0004oKR<xN]6\u000b\u0005\u0019;\u0015AB2p[6|gN\u0003\u0002*\u0011*\u0011\u0011JS\u0001\u0007CB\f7\r[3\u000b\u0003-\u000b1a\u001c:h\u0013\ti5I\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6,\u0012\u0001\u0015\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000bA\u0001\\1oO*\tQ+\u0001\u0003kCZ\f\u0017BA,S\u0005\u0019\u0019FO]5oO\u0006I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0003m\u00032\u0001X1Q\u001b\u0005i&B\u00010`\u0003%IW.\\;uC\ndWM\u0003\u0002au\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\tl&\u0001\u0002'jgR\f!d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ng\u0002\n\u0001d[1gW\u0006\u001cVM\u001d<fe*\u000b\u0017m]#oiJLh*Y7f+\u00051\u0007CA4o\u001d\tAG\u000e\u0005\u0002ju5\t!N\u0003\u0002lU\u00051AH]8pizJ!!\u001c\u001e\u0002\rA\u0013X\rZ3g\u0013\t9vN\u0003\u0002nu\u0005I2.\u00194lCN+'O^3s\u0015\u0006\f7/\u00128ueft\u0015-\\3!\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.F\u0001t!\t!\u00180D\u0001v\u0015\t1x/\u0001\u0003bkRD'B\u0001=F\u0003!\u0019XmY;sSRL\u0018B\u0001>v\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0001\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm]\u000b\u0002{B!\u0011H`A\u0001\u0013\ty(H\u0001\u0003T_6,\u0007\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001dA+\u0001\u0003vi&d\u0017\u0002BA\u0006\u0003\u000b\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003U\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0002\nAc\u00197jK:$8+Y:m!J|\u0007/\u001a:uS\u0016\u001c\u0018!F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003/\u00012!OA\r\u0013\r\tYB\u000f\u0002\u0005+:LG\u000fK\u0002\u0011\u0003?\u0001B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003KQ\u0015!\u00026v]&$\u0018\u0002BA\u0015\u0003G\u0011aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0007E\ty\u0003\u0005\u0003\u0002\"\u0005E\u0012\u0002BA\u001a\u0003G\u0011Q!\u00114uKJ\f1\u0002^3ti6+GO]5dg\"\u001a!#!\u000f\u0011\t\u0005\u0005\u00121H\u0005\u0005\u0003{\t\u0019C\u0001\u0003UKN$\u0018aC:f]\u0012\u0014VmY8sIN$\"\"a\u0006\u0002D\u0005\u0005\u0014QMA5\u0011\u001d\t)e\u0005a\u0001\u0003\u000f\n\u0001\u0002\u001d:pIV\u001cWM\u001d\t\t\u0003\u0013\n\t&!\u0016\u0002V5\u0011\u00111\n\u0006\u0005\u0003\u000b\niEC\u0002\u0002P\u001d\u000bqa\u00197jK:$8/\u0003\u0003\u0002T\u0005-#!D&bM.\f\u0007K]8ek\u000e,'\u000fE\u0003:\u0003/\nY&C\u0002\u0002Zi\u0012Q!\u0011:sCf\u00042!OA/\u0013\r\tyF\u000f\u0002\u0005\u0005f$X\r\u0003\u0004\u0002dM\u0001\r\u0001O\u0001\u000b]Vl'+Z2pe\u0012\u001c\bBBA4'\u0001\u0007\u0001(\u0001\u0006sK\u000e|'\u000fZ*ju\u0016Dq!a\u001b\u0014\u0001\u0004\ti'\u0001\u0002uaB!\u0011qNA9\u001b\u0005)\u0015bAA:\u000b\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017!H4f]\u0016\u0014\u0018\r^3BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3\u0015\t\u0005]\u0011\u0011\u0010\u0005\b\u0003W\"\u0002\u0019AA7\u0003%2XM]5gs.\u000bgm[1SCR,W*\u001a;sS\u000e\u001c\b*\u0019<f\u0007VlW\u000f\\1uSZ,7i\\;oiR1\u0011qCA@\u0003\u0003Cq!!\u0012\u0016\u0001\u0004\t9\u0005C\u0004\u0002\u0004V\u0001\r!!\"\u0002\u0011\r|gn];nKJ\u0004\u0002\"a\"\u0002\f\u0006U\u0013QK\u0007\u0003\u0003\u0013SA!a!\u0002N%!\u0011QRAE\u00055Y\u0015MZ6b\u0007>t7/^7fe\u0006Qb/\u001a:jMf\u001cE.[3oiZ+'o]5p]6+GO]5dgR1\u0011qCAJ\u0003wCq!!&\u0017\u0001\u0004\t9*A\u0004nKR\u0014\u0018nY:1\t\u0005e\u0015\u0011\u0016\t\t\u0003\u0007\tY*a(\u0002&&!\u0011QTA\u0003\u0005\ri\u0015\r\u001d\t\u0005\u0003_\n\t+C\u0002\u0002$\u0016\u0013!\"T3ue&\u001cg*Y7f!\u0011\t9+!+\r\u0001\u0011a\u00111VAJ\u0003\u0003\u0005\tQ!\u0001\u0002.\n\u0019q\fJ\u0019\u0012\t\u0005=\u0016Q\u0017\t\u0004s\u0005E\u0016bAAZu\t9aj\u001c;iS:<\u0007\u0003BA8\u0003oK1!!/F\u0005\u0019iU\r\u001e:jG\"1\u0011Q\u0018\fA\u0002\u0019\fa!\u001a8uSRL\u0018!\t<fe&4\u0017P\u0011:pW\u0016\u0014\u0018)\u001e;iK:$\u0018nY1uS>tW*\u001a;sS\u000e\u001cH\u0003BA\f\u0003\u0007Dq!!2\u0018\u0001\u0004\t9-\u0001\u0004tKJ4XM\u001d\t\u0005\u0003\u0013\fi-\u0004\u0002\u0002L*\u0019\u0011Q\u0019\u0015\n\t\u0005=\u00171\u001a\u0002\f\u0017\u000647.Y*feZ,'/\u0001\u0013wKJLg-\u001f\"s_.,'/T3tg\u0006<WmQ8om\u0016\u00148/[8o\u001b\u0016$(/[2t)!\t9\"!6\u0002X\u0006e\u0007bBAc1\u0001\u0007\u0011q\u0019\u0005\u0007\u0003OB\u0002\u0019\u0001\u001d\t\u000f\u0005-\u0004\u00041\u0001\u0002n\u0005)b/\u001a:jMf\u0014%o\\6fej[W*\u001a;sS\u000e\u001cHCBA\f\u0003?\f\t\u000fC\u0004\u0002Ff\u0001\r!a2\t\r\u0005\r\u0018\u00041\u0001g\u0003\u0015!x\u000e]5d\u0003a1XM]5gs\n\u0013xn[3s\u000bJ\u0014xN]'fiJL7m\u001d\u000b\u0005\u0003/\tI\u000fC\u0004\u0002Fj\u0001\r!a2\u0002#Y,'/\u001b4z\u0017\u000647.Y'fiJL7-\u0006\u0003\u0002p\u0006UHCCAy\u0005;\u0011\tC!\f\u00030Q!\u00111\u001fB\u0001!\u0011\t9+!>\u0005\u000f\u0005]8D1\u0001\u0002z\n\tA+\u0005\u0003\u00020\u0006m\bcA\u001d\u0002~&\u0019\u0011q \u001e\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003\u0004m\u0001\rA!\u0002\u0002\rY,'/\u001b4z!\u001dI$q\u0001B\u0006\u0003gL1A!\u0003;\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0004\u0003\u000e\t]\u0011Q\u0017\b\u0005\u0005\u001f\u0011\u0019BD\u0002j\u0005#I\u0011aO\u0005\u0004\u0005+Q\u0014a\u00029bG.\fw-Z\u0005\u0005\u00053\u0011YB\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u0011)B\u000f\u0005\u0007\u0005?Y\u0002\u0019\u00014\u0002\t9\fW.\u001a\u0005\b\u0003+[\u0002\u0019\u0001B\u0012a\u0011\u0011)C!\u000b\u0011\u0011\u0005\r\u00111TAP\u0005O\u0001B!a*\u0003*\u0011a!1\u0006B\u0011\u0003\u0003\u0005\tQ!\u0001\u0002.\n\u0019q\f\n\u001a\t\r\u0005u6\u00041\u0001g\u0011%\u0011\td\u0007I\u0001\u0002\u0004\u0011\u0019$A\u0003he>,\b\u000f\u0005\u0003:\u0005k1\u0017b\u0001B\u001cu\t1q\n\u001d;j_:\f1D^3sS\u001aL8*\u00194lC6+GO]5dI\u0011,g-Y;mi\u0012\"T\u0003\u0002B\u001f\u0005'*\"Aa\u0010+\t\tM\"\u0011I\u0016\u0003\u0005\u0007\u0002BA!\u0012\u0003P5\u0011!q\t\u0006\u0005\u0005\u0013\u0012Y%A\u0005v]\u000eDWmY6fI*\u0019!Q\n\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003R\t\u001d#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00129\u0011q\u001f\u000fC\u0002\u0005e\u0018aE7bq.\u000bgm[1NKR\u0014\u0018n\u0019,bYV,GC\u0003B-\u0005?\u0012\tG!\u001c\u0003pA\u0019\u0011Ha\u0017\n\u0007\tu#H\u0001\u0004E_V\u0014G.\u001a\u0005\u0007\u0005?i\u0002\u0019\u00014\t\u000f\u0005UU\u00041\u0001\u0003dA\"!Q\rB5!!\t\u0019!a'\u0002 \n\u001d\u0004\u0003BAT\u0005S\"ABa\u001b\u0003b\u0005\u0005\t\u0011!B\u0001\u0003[\u00131a\u0018\u00134\u0011\u0019\ti,\ba\u0001M\"9!\u0011G\u000fA\u0002\tM\u0012!\u0007<fe&4\u0017pS1gW\u0006lU\r\u001e:jGJ+7m\u001c:eK\u0012$\"\"a\u0006\u0003v\t]$1\u0011BC\u0011\u0019\u0011yB\ba\u0001M\"9\u0011Q\u0013\u0010A\u0002\te\u0004\u0007\u0002B>\u0005\u007f\u0002\u0002\"a\u0001\u0002\u001c\u0006}%Q\u0010\t\u0005\u0003O\u0013y\b\u0002\u0007\u0003\u0002\n]\u0014\u0011!A\u0001\u0006\u0003\tiKA\u0002`IQBa!!0\u001f\u0001\u00041\u0007\"\u0003B\u0019=A\u0005\t\u0019\u0001B\u001a\u0003\r2XM]5gs.\u000bgm[1NKR\u0014\u0018n\u0019*fG>\u0014H-\u001a3%I\u00164\u0017-\u001e7uIQ\n\u0011#_1n[\u0016\u0014X*\u001a;sS\u000e4\u0016\r\\;f)\u0011\tYP!$\t\r\t}\u0001\u00051\u0001g\u0003=I\u0018-\\7fe\"K7\u000f^8he\u0006lG\u0003\u0002BJ\u0005S\u0003BA!&\u0003&6\u0011!q\u0013\u0006\u0005\u00053\u0013Y*\u0001\u0003d_J,'\u0002BAK\u0005;SAAa(\u0003\"\u00061\u00110Y7nKJT!Aa)\u0002\u0007\r|W.\u0003\u0003\u0003(\n]%!\u0003%jgR|wM]1n\u0011\u0019\u0011y\"\ta\u0001M\u0006Qb/\u001a:jMfL\u0016-\\7fe6+GO]5d%\u0016\u001cwN\u001d3fIR1!\u0011\fBX\u0005cCaAa\b#\u0001\u00041\u0007\"\u0003B\u0002EA\u0005\t\u0019\u0001BZ!\u001dI$q\u0001B-\u0005k\u00032!\u000fB\\\u0013\r\u0011IL\u000f\u0002\b\u0005>|G.Z1o\u0003\u00112XM]5gsf\u000bW.\\3s\u001b\u0016$(/[2SK\u000e|'\u000fZ3eI\u0011,g-Y;mi\u0012\u0012TC\u0001B`U\u0011\u0011\u0019L!\u0011\u0002-Y,'/\u001b4z\u001d>\u0014V-];fgRlU\r\u001e:jGN$B!a\u0006\u0003F\"1!q\u0019\u0013A\u0002\u0019\fA\"\u001a:s_JlUm]:bO\u0016\u0004")
public class MetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @Before
    public void setUp() {
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.kafkaServerJaasEntryName()));
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @Test
    public void testMetrics() {
        String topic = "topicWithOldMessageFormat";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic, 1, 1, props);
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 100000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, recordSize, tp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, 15000L);
        this.verifyKafkaRateMetricsHaveCumulativeCount(producer, consumer);
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(producer.metrics(), "Producer");
        KafkaServer server = (KafkaServer)this.servers().head();
        this.verifyBrokerMessageConversionMetrics(server, recordSize, tp);
        this.verifyBrokerErrorMetrics((KafkaServer)this.servers().head());
        this.verifyBrokerZkMetrics(server, topic);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
    }

    /*
     * WARNING - void declaration
     */
    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        Future future;
        byte[] bytes = new byte[recordSize];
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, numRecords, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Future future2;
            Future future3 = future2 = producer.send(new ProducerRecord(tp.topic(), Integer.valueOf(tp.partition()), Long.valueOf(BoxesRunTime.unboxToInt((Object)object)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)object)).toString().getBytes(), (Object)bytes));
            future2 = null;
            future = future3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            future = null;
        }
        IndexedSeq cfr_ignored_0 = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        future = null;
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        ByteArraySerializer byteArraySerializer;
        ByteArraySerializer byteArraySerializer2;
        String string;
        Properties saslProps = new Properties();
        saslProps.put("sasl.mechanism", this.kafkaClientSaslMechanism());
        saslProps.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty((String)this.kafkaClientSaslMechanism(), (String)"badUser", (String)"badPass"));
        String x$1 = this.brokerList();
        SecurityProtocol x$5 = this.securityProtocol();
        Option<File> x$6 = this.trustStoreFile();
        Some x$7 = new Some((Object)saslProps);
        long l = 0x100000L;
        int n = Integer.MAX_VALUE;
        int n2 = 30000;
        int n3 = 0;
        int n4 = 16384;
        String string2 = string = "none";
        string = null;
        String x$13 = string2;
        ByteArraySerializer byteArraySerializer3 = byteArraySerializer2 = new ByteArraySerializer();
        byteArraySerializer2 = null;
        ByteArraySerializer x$14 = byteArraySerializer3;
        ByteArraySerializer byteArraySerializer4 = byteArraySerializer = new ByteArraySerializer();
        byteArraySerializer = null;
        ByteArraySerializer x$15 = byteArraySerializer4;
        boolean bl = false;
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, 0, 1000L, l, n, n2, n3, n4, x$13, 1000, x$5, x$6, (Option<Properties>)x$7, x$14, x$15, bl);){
            try {
                producer.send(new ProducerRecord(tp.topic(), Integer.valueOf(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    private void verifyKafkaRateMetricsHaveCumulativeCount(KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
        void apply_elems;
        Set consumerMetricNames = AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, consumer.metrics().keySet()).asScala().toSet();
        ((IterableOnceOps)consumerMetricNames.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(x$1)))).foreach((Function1 & Serializable)x$2 -> {
            MetricsTest.verify$1(x$2, consumerMetricNames);
            return BoxedUnit.UNIT;
        });
        Set producerMetricNames = AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, producer.metrics().keySet()).asScala().toSet();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set producerExclusions = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        ((IterableOnceOps)((IterableOps)producerMetricNames.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(x$3)))).filterNot((Function1 & Serializable)metricName -> BoxesRunTime.boxToBoolean((boolean)producerExclusions.contains((Object)metricName.name())))).foreach((Function1 & Serializable)x$4 -> {
            MetricsTest.verify$1(x$4, producerMetricNames);
            return BoxedUnit.UNIT;
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        .colon.colon foreach_these = new .colon.colon((Object)"commit-id", (List)new .colon.colon((Object)"version", (List)Nil$.MODULE$));
        while (!foreach_these.isEmpty()) {
            String string = (String)foreach_these.head();
            MetricsTest.$anonfun$verifyClientVersionMetrics$1(this, metrics, entity, string);
            foreach_these = (List)foreach_these.tail();
        }
    }

    private void verifyBrokerAuthenticationMetrics(KafkaServer server) {
        Map metrics = server.metrics().metrics();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetricsTest.$anonfun$verifyBrokerAuthenticationMetrics$1(this, metrics)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("failed-authentication-total not updated", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageConversionMetrics(KafkaServer server, int recordSize, TopicPartition tp) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(new StringBuilder(34).append(requestMetricsPrefix).append(",name=RequestBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(new StringBuilder(42).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        Assert.assertTrue((String)new StringBuilder(57).append("Unexpected temporary memory size requestBytes ").append(requestBytes).append(" tempBytes ").append(tempBytes).toString(), (tempBytes >= (double)recordSize ? 1 : 0) != 0);
        this.verifyYammerMetricRecorded("kafka.server:type=BrokerTopicMetrics,name=ProduceMessageConversionsPerSec", this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name = new StringBuilder(46).append(requestMetricsPrefix).append(",name=MessageConversionsTimeMs,request=Produce").toString();
        double verifyYammerMetricRecorded_metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name));
        Assert.assertTrue((String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name).append(" value ").append(verifyYammerMetricRecorded_metricValue).toString(), (boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$1(verifyYammerMetricRecorded_metricValue));
        Object var9_7 = null;
        this.verifyYammerMetricRecorded(new StringBuilder(32).append(requestMetricsPrefix).append(",name=RequestBytes,request=Fetch").toString(), this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name2 = new StringBuilder(40).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Fetch").toString();
        double verifyYammerMetricRecorded_metricValue2 = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name2));
        Assert.assertTrue((String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name2).append(" value ").append(verifyYammerMetricRecorded_metricValue2).toString(), (boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$2(verifyYammerMetricRecorded_metricValue2));
        Object var12_9 = null;
        this.verifyYammerMetricRecorded(new StringBuilder(35).append(requestMetricsPrefix).append(",name=RequestBytes,request=Metadata").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerZkMetrics(KafkaServer server, String topic) {
        Histogram histogram = this.yammerHistogram("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs");
        long initialCount = histogram.count();
        ((KafkaServer)this.servers().head()).zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        long newCount = histogram.count();
        Assert.assertTrue((String)"ZooKeeper latency not recorded", (newCount > initialCount ? 1 : 0) != 0);
        double min = histogram.min();
        Assert.assertTrue((String)new StringBuilder(36).append("Min latency should not be negative: ").append(min).toString(), (min >= 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Unexpected ZK state", (Object)"CONNECTED", (Object)this.yammerMetricValue("SessionState"));
    }

    private void verifyBrokerErrorMetrics(KafkaServer server) {
        int startErrorMetricCount = MetricsTest.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(new StringBuilder(28).append(errorMetricPrefix).append(",request=Metadata,error=NONE").toString(), this.verifyYammerMetricRecorded$default$2());
        try {
            this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(47).append(errorMetricPrefix).append(",request=Metadata,error=INVALID_TOPIC_EXCEPTION").toString(), this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = MetricsTest.errorMetricCount$1();
        Assert.assertEquals((long)(startErrorMetricCount + 1), (long)currentErrorMetricCount);
        Assert.assertTrue((String)new StringBuilder(23).append("Too many error metrics ").append(currentErrorMetricCount).toString(), (currentErrorMetricCount < 10 ? 1 : 0) != 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 1, 100, new TopicPartition("non-existent", 0));
        this.verifyYammerMetricRecorded(new StringBuilder(44).append(errorMetricPrefix).append(",request=Metadata,error=LEADER_NOT_AVAILABLE").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private <T> T verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assert.assertTrue((String)new StringBuilder(17).append("Metric not found ").append(name).toString(), (boolean)matchingMetrics.nonEmpty());
        return (T)verify.apply((Object)matchingMetrics.values());
    }

    private <T> Option<String> verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    private double maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assert.assertTrue((String)new StringBuilder(17).append("Metric not found ").append(name).toString(), (boolean)verifyKafkaMetric_matchingMetrics.nonEmpty());
        return MetricsTest.$anonfun$maxKafkaMetricValue$1(verifyKafkaMetric_matchingMetrics.values());
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.maxKafkaMetricValue(name, metrics, entity, group);
        Assert.assertTrue((String)new StringBuilder(42).append(entity).append(" metric not recorded correctly for ").append(name).append(" value ").append(value).toString(), (value > 0.0 ? 1 : 0) != 0);
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    private Object yammerMetricValue(String name) {
        Object object;
        scala.collection.mutable.Map allMetrics = AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Option option = allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerMetricValue$1(name, x0$1)));
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$7 -> x$7.getMBeanName())).toString(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        }
        Object var6_3 = null;
        Tuple2 tuple2 = (Tuple2)getOrElse_this.get();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (metric instanceof Meter) {
            Double d;
            Double d2 = d = Double.valueOf(((Meter)metric).count());
            d = null;
            object = d2;
        } else if (metric instanceof Histogram) {
            Double d;
            Double d3 = d = Double.valueOf(((Histogram)metric).max());
            d = null;
            object = d3;
        } else if (metric instanceof Gauge) {
            object = ((Gauge)metric).value();
        } else {
            throw Assertions$.MODULE$.fail(new StringBuilder(34).append("Unexpected broker metric of class ").append(metric.getClass()).toString(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        }
        return object;
    }

    private Histogram yammerHistogram(String name) {
        scala.collection.mutable.Map allMetrics = AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Option option = allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerHistogram$1(name, x0$1)));
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$8 -> x$8.getMBeanName())).toString(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        }
        Object var6_3 = null;
        Tuple2 tuple2 = (Tuple2)getOrElse_this.get();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (!(metric instanceof Histogram)) {
            throw Assertions$.MODULE$.fail(new StringBuilder(34).append("Unexpected broker metric of class ").append(metric.getClass()).toString(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        }
        Histogram histogram = (Histogram)metric;
        return histogram;
    }

    /*
     * WARNING - void declaration
     */
    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify) {
        void var3_3;
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(name));
        Assert.assertTrue((String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(name).append(" value ").append(metricValue).toString(), (boolean)verify.apply$mcZD$sp(metricValue));
        return (double)var3_3;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return (JFunction1.mcZD.sp & Serializable)d -> d > 0.0;
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyNoRequestMetrics$1(x0$1)));
        Assert.assertTrue((String)new StringBuilder(2).append(errorMessage).append(": ").append(metrics.keys()).toString(), (boolean)metrics.isEmpty());
    }

    private static final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    private static final void verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = MetricsTest.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = MetricsTest.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assert.assertTrue((String)new StringBuilder(48).append("No cumulative count/time metric for rate metric ").append(rateMetricName).toString(), (totalExists || totalTimeExists ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(MetricName x$1) {
        return x$1.name().endsWith("-rate");
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(MetricName x$3) {
        return x$3.name().endsWith("-rate");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$2(String entity$1, String name$1, Iterable matchingMetrics) {
        Assert.assertEquals((long)1L, (long)matchingMetrics.size());
        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
        Object value = metric.metricValue();
        Assert.assertNotNull((String)new StringBuilder(21).append(entity$1).append(" metric not recorded ").append(name$1).toString(), (Object)value);
        Assert.assertNotNull((String)new StringBuilder(37).append(entity$1).append(" metric ").append(name$1).append(" should be a non-empty String").toString(), (Object)(value instanceof String && !((String)value).isEmpty() ? 1 : 0));
        Assert.assertTrue((String)"Client-id not specified", (boolean)metric.metricName().tags().containsKey("client-id"));
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$1(MetricsTest $this, Map metrics$1, String entity$1, String name) {
        None$ none$;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ verifyKafkaMetric_group = none$2;
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)metrics$1).asScala().filter(arg_0 -> MetricsTest.$anonfun$verifyKafkaMetric$1$adapted(name, (Option)verifyKafkaMetric_group, arg_0));
        Assert.assertTrue((String)new StringBuilder(17).append("Metric not found ").append(name).toString(), (boolean)verifyKafkaMetric_matchingMetrics.nonEmpty());
        Iterable iterable = verifyKafkaMetric_matchingMetrics.values();
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name, iterable);
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerAuthenticationMetrics$1(MetricsTest $this, Map metrics$2) {
        return $this.maxKafkaMetricValue("failed-authentication-total", metrics$2, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$verifyBrokerAuthenticationMetrics$2() {
        return "failed-authentication-total not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$1(double value) {
        return value > 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$2(double value) {
        return value == 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerErrorMetrics$1(com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getName();
        String string2 = "ErrorsPerSec";
        return string != null && string.equals(string2);
    }

    private static final int errorMetricCount$1() {
        return ((IterableOnceOps)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyBrokerErrorMetrics$1(x$5)))).size();
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$2(MetricName metricName$1, String x$6) {
        String string = x$6;
        String string2 = metricName$1.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$1(String name$2, Option group$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metricName = (MetricName)x0$1._1();
        String string = metricName.name();
        if (string == null) {
            if (name$2 != null) {
                return false;
            }
        } else if (!string.equals(name$2)) return false;
        if (group$1 == null) {
            throw null;
        }
        if (group$1.isEmpty()) return true;
        String string2 = (String)group$1.get();
        if (!MetricsTest.$anonfun$verifyKafkaMetric$2(metricName, string2)) return false;
        return true;
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$2(double max, org.apache.kafka.common.Metric metric) {
        return Math.max(max, BoxesRunTime.unboxToDouble((Object)metric.metricValue()));
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$1(Iterable matchingMetrics) {
        return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)0.0, (Function2 & Serializable)(max, metric) -> BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$2(BoxesRunTime.unboxToDouble((Object)max), metric))));
    }

    public static final /* synthetic */ boolean $anonfun$yammerMetricValue$1(String name$3, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$3);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$yammerHistogram$1(String name$4, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$4);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$verifyNoRequestMetrics$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith("kafka.network:type=RequestMetrics");
        return bl;
    }

    public MetricsTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
        this.kafkaServerJaasEntryName = new StringBuilder(1).append(this.listenerName().value().toLowerCase(Locale.ROOT)).append(".").append(JaasTestUtils$.MODULE$.KafkaServerContextName()).toString();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableDoc(), "false");
        this.producerConfig().setProperty("linger.ms", "10");
        this.producerConfig().setProperty("compression.type", "gzip");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        Statics.releaseFence();
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1$adapted(KafkaProducer producer$1, TopicPartition tp$1, byte[] bytes$1, Object i) {
        return producer$1.send(new ProducerRecord(tp$1.topic(), Integer.valueOf(tp$1.partition()), Long.valueOf(BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)bytes$1));
    }

    public static final /* synthetic */ Object $anonfun$verifyClientVersionMetrics$1$adapted(MetricsTest $this, Map metrics$1, String entity$1, String name) {
        MetricsTest.$anonfun$verifyClientVersionMetrics$1($this, metrics$1, entity$1, name);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$maxKafkaMetricValue$1$adapted(Iterable matchingMetrics) {
        return BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$1(matchingMetrics));
    }

    public static final /* synthetic */ Object $anonfun$verifyClientVersionMetrics$2$adapted(String entity$1, String name$1, Iterable matchingMetrics) {
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name$1, matchingMetrics);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$verifyKafkaMetric$2$adapted(MetricName metricName$1, String x$6) {
        return BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$2(metricName$1, x$6));
    }
}

