/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.DescribeCredentialsTest;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import scala.$less$colon$less$;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005]4AAD\b\u0001)!)\u0011\u0004\u0001C\u00015!)A\u0004\u0001C!;!9a\u0006\u0001b\u0001\n\u0013y\u0003B\u0002\u001e\u0001A\u0003%\u0001\u0007C\u0003<\u0001\u0011\u0005q\u0006C\u0003B\u0001\u0011\u0005!\tC\u0003H\u0001\u0011\u0005!\tC\u0003J\u0001\u0011\u0005!\tC\u0003L\u0001\u0011\u0005!\tC\u0003N\u0001\u0011\u0005!\tC\u0003P\u0001\u0011\u0005!\tC\u0003R\u0001\u0011%!\u000bC\u0004l\u0001E\u0005I\u0011\u00027\u0003O\u0011+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003!E\taa]3sm\u0016\u0014(\"\u0001\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0006\t\u0003-]i\u0011aD\u0005\u00031=\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"A\u0006\u0001\u0002/\t\u0014xn[3s!J|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001cHC\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0011)f.\u001b;\t\u000b\u0015\u0012\u0001\u0019\u0001\u0014\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005!Q\u000f^5m\u0015\u0005Y\u0013\u0001\u00026bm\u0006L!!\f\u0015\u0003\u0015A\u0013x\u000e]3si&,7/A\u0005`i\u0016\u001cHOT1nKV\t\u0001\u0007\u0005\u00022q5\t!G\u0003\u00024i\u0005)!/\u001e7fg*\u0011QGN\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002o\u0005\u0019qN]4\n\u0005e\u0012$\u0001\u0003+fgRt\u0015-\\3\u0002\u0015}#Xm\u001d;OC6,\u0007%\u0001\u0005uKN$h*Y7fQ\t)Q\b\u0005\u0002?\u007f5\tA'\u0003\u0002Ai\t!!+\u001e7f\u0003M!Xm\u001d;EKN\u001c'/\u001b2f\u001d>$\b.\u001b8h)\u0005q\u0002F\u0001\u0004E!\tqT)\u0003\u0002Gi\t!A+Z:u\u0003Q!Xm\u001d;EKN\u001c'/\u001b2f/&$\bNT;mY\"\u0012q\u0001R\u0001\u001ai\u0016\u001cH\u000fR3tGJL'-\u001a(pi\u000e{g\u000e\u001e:pY2,'\u000f\u000b\u0002\t\t\u0006IB/Z:u\t\u0016\u001c8M]5cK:{G/Q;uQ>\u0014\u0018N_3eQ\tIA)A\ruKN$H)Z:de&\u0014WmU1nKV\u001bXM\u001d+xS\u000e,\u0007F\u0001\u0006E\u0003=!Xm\u001d;V].twn\u001e8Vg\u0016\u0014\bFA\u0006E\u0003\u001d\u001aXM\u001c3EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;\u0015\u0007Ms6\r\u0005\u0002U96\tQK\u0003\u0002W/\u0006A!/Z9vKN$8O\u0003\u0002Y3\u000611m\\7n_:T!A\u0005.\u000b\u0005m3\u0014AB1qC\u000eDW-\u0003\u0002^+\n!C)Z:de&\u0014W-V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z:q_:\u001cX\rC\u0003`\u0019\u0001\u0007\u0001-A\u0004sKF,Xm\u001d;\u0011\u0005Q\u000b\u0017B\u00012V\u0005\r\"Um]2sS\n,Wk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014V-];fgRDq\u0001\u001a\u0007\u0011\u0002\u0003\u0007Q-\u0001\u0007t_\u000e\\W\r^*feZ,'\u000f\u0005\u0002gS6\tqM\u0003\u0002i#\u00059a.\u001a;x_J\\\u0017B\u00016h\u00051\u0019vnY6fiN+'O^3s\u0003E\u001aXM\u001c3EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII*\u0012!\u001c\u0016\u0003K:\\\u0013a\u001c\t\u0003aVl\u0011!\u001d\u0006\u0003eN\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005Q\u0004\u0013AC1o]>$\u0018\r^5p]&\u0011a/\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class DescribeUserScramCredentialsRequestTest
extends BaseRequestTest {
    private final TestName _testName = new TestName();

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        properties.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), DescribeCredentialsTest.TestAuthorizer.class.getName());
        properties.put(KafkaConfig$.MODULE$.PrincipalBuilderClassProp(), this.testName().getMethodName().endsWith("NotAuthorized") ? DescribeCredentialsTest.TestPrincipalBuilderReturningUnauthorized.class.getName() : DescribeCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    @Test
    public void testDescribeNothing() {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.controllerSocketServer());
        short error = response.data().errorCode();
        Assert.assertEquals((String)"Expected no error when describing everything and there are no credentials", (long)Errors.NONE.code(), (long)error);
        Assert.assertEquals((String)"Expected no credentials when describing everything and there are no credentials", (long)0L, (long)response.data().results().size());
    }

    @Test
    public void testDescribeWithNull() {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(null)).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.controllerSocketServer());
        short error = response.data().errorCode();
        Assert.assertEquals((String)"Expected no error when describing everything and there are no credentials", (long)Errors.NONE.code(), (long)error);
        Assert.assertEquals((String)"Expected no credentials when describing everything and there are no credentials", (long)0L, (long)response.data().results().size());
    }

    @Test
    public void testDescribeNotController() {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build();
        short error = this.sendDescribeUserScramCredentialsRequest(request, this.notControllerSocketServer()).data().errorCode();
        Assert.assertEquals((String)"Did not expect controller error when routed to non-controller", (long)Errors.NONE.code(), (long)error);
    }

    @Test
    public void testDescribeNotAuthorized() {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build();
        short error = this.sendDescribeUserScramCredentialsRequest(request, this.controllerSocketServer()).data().errorCode();
        Assert.assertEquals((String)"Expected not authorized error", (long)Errors.CLUSTER_AUTHORIZATION_FAILED.code(), (long)error);
    }

    @Test
    public void testDescribeSameUserTwice() {
        String user = "user1";
        DescribeUserScramCredentialsRequestData.UserName userName = new DescribeUserScramCredentialsRequestData.UserName().setName(user);
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)userName, (List)new .colon.colon((Object)userName, (List)Nil$.MODULE$))).asJava())).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.controllerSocketServer());
        Assert.assertEquals((String)"Expected no top-level error", (long)Errors.NONE.code(), (long)response.data().errorCode());
        Assert.assertEquals((long)1L, (long)response.data().results().size());
        DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result = (DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult)response.data().results().get(0);
        Assert.assertEquals((String)new StringBuilder(38).append("Expected duplicate resource error for ").append(user).toString(), (long)Errors.DUPLICATE_RESOURCE.code(), (long)result.errorCode());
        Assert.assertEquals((Object)new StringBuilder(79).append("Cannot describe SCRAM credentials for the same user twice in a single request: ").append(user).toString(), (Object)result.errorMessage());
    }

    @Test
    public void testUnknownUser() {
        String unknownUser = "unknownUser";
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new DescribeUserScramCredentialsRequestData.UserName().setName(unknownUser), (List)Nil$.MODULE$)).asJava())).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.controllerSocketServer());
        Assert.assertEquals((String)"Expected no top-level error", (long)Errors.NONE.code(), (long)response.data().errorCode());
        Assert.assertEquals((long)1L, (long)response.data().results().size());
        DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result = (DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult)response.data().results().get(0);
        Assert.assertEquals((String)new StringBuilder(38).append("Expected duplicate resource error for ").append(unknownUser).toString(), (long)Errors.RESOURCE_NOT_FOUND.code(), (long)result.errorCode());
        Assert.assertEquals((Object)new StringBuilder(59).append("Attempt to describe a user credential that does not exist: ").append(unknownUser).toString(), (Object)result.errorMessage());
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.controllerSocketServer();
    }
}

