/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin$Replication$;
import kafka.log.CompletedTxn;
import kafka.log.LazyIndex;
import kafka.log.LogConfig;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.RollParams;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.server.FetchDataInfo;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011Ea\u0001\u0002.\\\u0001\u0001D\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\t!\u001c\u0005\tw\u0002\u0011\t\u0011)A\u0005]\"AA\u0010\u0001BC\u0002\u0013\u0005Q\u0010C\u0005\u0002\f\u0001\u0011\t\u0011)A\u0005}\"Q\u0011Q\u0002\u0001\u0003\u0006\u0004%\t!a\u0004\t\u0015\u0005e\u0001A!A!\u0002\u0013\t\t\u0002\u0003\u0006\u0002\u001c\u0001\u0011)\u0019!C\u0001\u0003;A!\"!\n\u0001\u0005\u0003\u0005\u000b\u0011BA\u0010\u0011)\t9\u0003\u0001BC\u0002\u0013\u0005\u0011\u0011\u0006\u0005\u000b\u0003c\u0001!\u0011!Q\u0001\n\u0005-\u0002BCA\u001a\u0001\t\u0015\r\u0011\"\u0001\u00026!Q\u0011Q\b\u0001\u0003\u0002\u0003\u0006I!a\u000e\t\u0015\u0005}\u0002A!b\u0001\n\u0003\tI\u0003\u0003\u0006\u0002B\u0001\u0011\t\u0011)A\u0005\u0003WA!\"a\u0011\u0001\u0005\u000b\u0007I\u0011AA#\u0011)\t\t\u0006\u0001B\u0001B\u0003%\u0011q\t\u0005\t\u0003'\u0002A\u0011A.\u0002V!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003c\u0002A\u0011AA:\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fCq!a%\u0001\t\u0003\t)\nC\u0005\u0002\u001c\u0002\u0001\r\u0011\"\u0003\u0002*!I\u0011Q\u0014\u0001A\u0002\u0013%\u0011q\u0014\u0005\t\u0003K\u0003\u0001\u0015)\u0003\u0002,!I\u0011q\u0015\u0001A\u0002\u0013%\u0011Q\u0007\u0005\n\u0003S\u0003\u0001\u0019!C\u0005\u0003WC\u0001\"a,\u0001A\u0003&\u0011q\u0007\u0005\n\u0003c\u0003\u0001\u0019!C\u0005\u0003gC\u0011\"a/\u0001\u0001\u0004%I!!0\t\u0011\u0005\u0005\u0007\u0001)Q\u0005\u0003kC\u0011\"a3\u0001\u0001\u0004%I!a-\t\u0013\u00055\u0007\u00011A\u0005\n\u0005=\u0007\u0002CAj\u0001\u0001\u0006K!!.\t\u000f\u0005]\u0007\u0001\"\u0001\u0002Z\"9\u0011q\u001c\u0001\u0005\u0002\u0005%\u0002\"CAq\u0001\u0001\u0007I\u0011BAZ\u0011%\t\u0019\u000f\u0001a\u0001\n\u0013\t)\u000f\u0003\u0005\u0002j\u0002\u0001\u000b\u0015BA[\u0011\u001d\ti\u000f\u0001C\u0001\u0003_Dq!!>\u0001\t\u0003\tI\u0003C\u0004\u0002\u0012\u0002!\t!!\u000e\t\u000f\u0005]\b\u0001\"\u0001\u0002z\"9\u0011Q \u0001\u0005\u0002\u0005}\bb\u0002B\u0010\u0001\u0011%!\u0011\u0005\u0005\b\u0005K\u0001A\u0011\u0002B\u0014\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005wAqAa\u0011\u0001\t\u0003\u0011)\u0005C\u0004\u0003X\u0001!IA!\u0017\t\u0011\t=\u0004\u0001\"\u0001\\\u0005cB!B!+\u0001#\u0003%\ta\u0017BV\u0011\u001d\u0011\t\r\u0001C\u0001\u0005\u0007D\u0011Ba9\u0001#\u0003%\tA!:\t\u0013\t%\b!%A\u0005\u0002\t-\bb\u0002Bx\u0001\u0011\u0005!\u0011\u001f\u0005\b\u0007\u0003\u0001A\u0011AB\u0002\u0011%\u0019Y\u0002AI\u0001\n\u0003\u0019i\u0002C\u0004\u0004\"\u0001!Iaa\t\t\u000f\r\u0015\u0002\u0001\"\u0001\u0004(!91\u0011\u0006\u0001\u0005\u0002\r-\u0002bBB\u001e\u0001\u0011\u00053Q\b\u0005\b\u0007\u001f\u0002A\u0011AB)\u0011\u001d\u00199\u0006\u0001C\u0001\u0003SAqaa\u0017\u0001\t\u0003\u0019\u0019\u0003C\u0004\u0004`\u0001!\ta!\u0019\t\u000f\r]\u0004\u0001\"\u0001\u0004z!911\u0011\u0001\u0005\u0002\r\r\u0002bBBC\u0001\u0011%11\u0005\u0005\b\u0007\u000f\u0003A\u0011ABE\u0011\u001d\u0019\u0019\n\u0001C\u0001\u0007+Cqaa&\u0001\t\u0003\u0019I\nC\u0005\u0004*\u0002\t\n\u0011\"\u0001\u0003f\"911\u0016\u0001\u0005\u0002\r\r\u0002bBBW\u0001\u0011\u000511\u0005\u0005\b\u0007_\u0003A\u0011AB\u0012\u0011\u001d\u0019\t\f\u0001C\u0001\u0003SAqaa-\u0001\t\u0003\t\u0019\fC\u0004\u0003\b\u0001!\t!!\u000b\t\u000f\rU\u0006\u0001\"\u0001\u00048\u001e91qZ.\t\u0002\rEgA\u0002.\\\u0011\u0003\u0019\u0019\u000eC\u0004\u0002TE#\ta!6\t\u000f\r]\u0017\u000b\"\u0001\u0004Z\"I11`)\u0012\u0002\u0013\u0005!1\u001e\u0005\n\u0007{\f\u0016\u0013!C\u0001\u0005WC\u0011ba@R#\u0003%\tAa;\t\u0013\u0011\u0005\u0011+%A\u0005\u0002\u0011\r\u0001bBBX#\u0012\u0005Aq\u0001\u0005\n\t\u001f\t\u0016\u0013!C\u0001\t\u0007\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\taV,A\u0002m_\u001eT\u0011AX\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0011m\u001a\t\u0003E\u0016l\u0011a\u0019\u0006\u0002I\u0006)1oY1mC&\u0011am\u0019\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!\\W\"A5\u000b\u0005)l\u0016!B;uS2\u001c\u0018B\u00017j\u0005\u001daunZ4j]\u001e,\u0012A\u001c\t\u0003_fl\u0011\u0001\u001d\u0006\u0003cJ\faA]3d_J$'BA:u\u0003\u0019\u0019w.\\7p]*\u0011a,\u001e\u0006\u0003m^\fa!\u00199bG\",'\"\u0001=\u0002\u0007=\u0014x-\u0003\u0002{a\nYa)\u001b7f%\u0016\u001cwN\u001d3t\u0003\u0011awn\u001a\u0011\u0002\u001f1\f'0_(gMN,G/\u00138eKb,\u0012A \t\u0006\u007f\u0006\u0005\u0011QA\u0007\u00027&\u0019\u00111A.\u0003\u00131\u000b'0_%oI\u0016D\bcA@\u0002\b%\u0019\u0011\u0011B.\u0003\u0017=3gm]3u\u0013:$W\r_\u0001\u0011Y\u0006T\u0018p\u00144gg\u0016$\u0018J\u001c3fq\u0002\nQ\u0002\\1{sRKW.Z%oI\u0016DXCAA\t!\u0015y\u0018\u0011AA\n!\ry\u0018QC\u0005\u0004\u0003/Y&!\u0003+j[\u0016Le\u000eZ3y\u00039a\u0017M_=US6,\u0017J\u001c3fq\u0002\n\u0001\u0002\u001e=o\u0013:$W\r_\u000b\u0003\u0003?\u00012a`A\u0011\u0013\r\t\u0019c\u0017\u0002\u0011)J\fgn]1di&|g.\u00138eKb\f\u0011\u0002\u001e=o\u0013:$W\r\u001f\u0011\u0002\u0015\t\f7/Z(gMN,G/\u0006\u0002\u0002,A\u0019!-!\f\n\u0007\u0005=2M\u0001\u0003M_:<\u0017a\u00032bg\u0016|eMZ:fi\u0002\n!#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fgV\u0011\u0011q\u0007\t\u0004E\u0006e\u0012bAA\u001eG\n\u0019\u0011J\u001c;\u0002'%tG-\u001a=J]R,'O^1m\u0005f$Xm\u001d\u0011\u0002\u0019I|G\u000e\u001c&jiR,'/T:\u0002\u001bI|G\u000e\u001c&jiR,'/T:!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003\u001bj!!a\u0013\u000b\u0005)\u0014\u0018\u0002BA(\u0003\u0017\u0012A\u0001V5nK\u0006)A/[7fA\u00051A(\u001b8jiz\"\"#a\u0016\u0002Z\u0005m\u0013QLA0\u0003C\n\u0019'!\u001a\u0002hA\u0011q\u0010\u0001\u0005\u00069F\u0001\rA\u001c\u0005\u0006yF\u0001\rA \u0005\b\u0003\u001b\t\u0002\u0019AA\t\u0011\u001d\tY\"\u0005a\u0001\u0003?Aq!a\n\u0012\u0001\u0004\tY\u0003C\u0004\u00024E\u0001\r!a\u000e\t\u000f\u0005}\u0012\u00031\u0001\u0002,!9\u00111I\tA\u0002\u0005\u001d\u0013aC8gMN,G/\u00138eKb,\"!!\u0002\u0002\u0013QLW.Z%oI\u0016DXCAA\n\u0003)\u0019\bn\\;mIJ{G\u000e\u001c\u000b\u0005\u0003k\nY\bE\u0002c\u0003oJ1!!\u001fd\u0005\u001d\u0011un\u001c7fC:Dq!! \u0015\u0001\u0004\ty(\u0001\u0006s_2d\u0007+\u0019:b[N\u00042a`AA\u0013\r\t\u0019i\u0017\u0002\u000b%>dG\u000eU1sC6\u001c\u0018!\u0004:fg&TX-\u00138eKb,7\u000f\u0006\u0003\u0002\n\u0006=\u0005c\u00012\u0002\f&\u0019\u0011QR2\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003#+\u0002\u0019AA\u001c\u0003\u0011\u0019\u0018N_3\u0002\u0017M\fg.\u001b;z\u0007\",7m\u001b\u000b\u0005\u0003\u0013\u000b9\nC\u0004\u0002\u001aZ\u0001\r!!\u001e\u00023QLW.Z%oI\u0016Dh)\u001b7f\u001d\u0016<H._\"sK\u0006$X\rZ\u0001\bGJ,\u0017\r^3e\u0003-\u0019'/Z1uK\u0012|F%Z9\u0015\t\u0005%\u0015\u0011\u0015\u0005\n\u0003GC\u0012\u0011!a\u0001\u0003W\t1\u0001\u001f\u00132\u0003!\u0019'/Z1uK\u0012\u0004\u0013\u0001\u00072zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^%oI\u0016DXI\u001c;ss\u0006a\"-\u001f;fgNKgnY3MCN$\u0018J\u001c3fq\u0016sGO]=`I\u0015\fH\u0003BAE\u0003[C\u0011\"a)\u001c\u0003\u0003\u0005\r!a\u000e\u00023\tLH/Z:TS:\u001cW\rT1ti&sG-\u001a=F]R\u0014\u0018\u0010I\u0001\u0016e>dG.\u001b8h\u0005\u0006\u001cX\r\u001a+j[\u0016\u001cH/Y7q+\t\t)\fE\u0003c\u0003o\u000bY#C\u0002\u0002:\u000e\u0014aa\u00149uS>t\u0017!\u0007:pY2Lgn\u001a\"bg\u0016$G+[7fgR\fW\u000e]0%KF$B!!#\u0002@\"I\u00111\u0015\u0010\u0002\u0002\u0003\u0007\u0011QW\u0001\u0017e>dG.\u001b8h\u0005\u0006\u001cX\r\u001a+j[\u0016\u001cH/Y7qA!\u001aq$!2\u0011\u0007\t\f9-C\u0002\u0002J\u000e\u0014\u0001B^8mCRLG.Z\u0001\u0013?6\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'/\u0001\f`[\u0006DH+[7fgR\fW\u000e]*p\r\u0006\u0014x\fJ3r)\u0011\tI)!5\t\u0013\u0005\r\u0016%!AA\u0002\u0005U\u0016aE0nCb$\u0016.\\3ti\u0006l\u0007oU8GCJ\u0004\u0003f\u0001\u0012\u0002F\u0006)R.\u0019=US6,7\u000f^1naN{g)\u0019:`I\u0015\fH\u0003BAE\u00037Dq!!8$\u0001\u0004\tY#A\u0005uS6,7\u000f^1na\u0006\tR.\u0019=US6,7\u000f^1naN{g)\u0019:\u00025}{gMZ:fi>3W*\u0019=US6,7\u000f^1naN{g)\u0019:\u0002=}{gMZ:fi>3W*\u0019=US6,7\u000f^1naN{g)\u0019:`I\u0015\fH\u0003BAE\u0003OD\u0011\"a)'\u0003\u0003\u0005\r!!.\u00027}{gMZ:fi>3W*\u0019=US6,7\u000f^1naN{g)\u0019:!Q\r9\u0013QY\u0001\u001e_\u001a47/\u001a;PM6\u000b\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'o\u0018\u0013fcR!\u0011\u0011RAy\u0011\u001d\t\u0019\u0010\u000ba\u0001\u0003W\taa\u001c4gg\u0016$\u0018!G8gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007oU8GCJ\f!dY1o\u0007>tg/\u001a:u)>\u0014V\r\\1uSZ,wJ\u001a4tKR$B!!\u001e\u0002|\"9\u00111_\u0016A\u0002\u0005-\u0012AB1qa\u0016tG\r\u0006\u0006\u0002\n\n\u0005!Q\u0001B\u0005\u0005\u001bAqAa\u0001-\u0001\u0004\tY#A\u0007mCJ<Wm\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0005\u000fa\u0003\u0019AA\u0016\u0003Aa\u0017M]4fgR$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0003\f1\u0002\r!a\u000b\u00027MD\u0017\r\u001c7po>3gm]3u\u001f\u001al\u0015\r\u001f+j[\u0016\u001cH/Y7q\u0011\u001d\u0011y\u0001\fa\u0001\u0005#\tqA]3d_J$7\u000fE\u0002p\u0005'I1A!\u0006q\u00055iU-\\8ssJ+7m\u001c:eg\"\u001aAF!\u0007\u0011\u0007!\u0014Y\"C\u0002\u0003\u001e%\u0014QB\\8oi\"\u0014X-\u00193tC\u001a,\u0017aE3ogV\u0014Xm\u00144gg\u0016$\u0018J\u001c*b]\u001e,G\u0003BAE\u0005GAq!a=.\u0001\u0004\tY#A\nbaB,g\u000eZ\"ik:\\gI]8n\r&dW\r\u0006\u0005\u00028\t%\"1\u0006B\u0018\u0011\u0019\u0011yA\fa\u0001]\"9!Q\u0006\u0018A\u0002\u0005]\u0012\u0001\u00039pg&$\u0018n\u001c8\t\u000f\tEb\u00061\u0001\u00034\u0005q!-\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\bcA8\u00036%\u0019!q\u00079\u0003\u001d\t+hMZ3s'V\u0004\b\u000f\\5fe\u0006q\u0011\r\u001d9f]\u00124%o\\7GS2,GCBA\u001c\u0005{\u0011y\u0004\u0003\u0004\u0003\u0010=\u0002\rA\u001c\u0005\b\u0005\u0003z\u0003\u0019AA\u001c\u0003\u0015\u0019H/\u0019:u\u00039)\b\u000fZ1uKRCh.\u00138eKb$b!!#\u0003H\tE\u0003b\u0002B%a\u0001\u0007!1J\u0001\rG>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\t\u0004\u007f\n5\u0013b\u0001B(7\na1i\\7qY\u0016$X\r\u001a+y]\"9!1\u000b\u0019A\u0002\u0005-\u0012\u0001\u00057bgR\u001cF/\u00192mK>3gm]3uQ\r\u0001$\u0011D\u0001\u0014kB$\u0017\r^3Qe>$WoY3s'R\fG/\u001a\u000b\u0007\u0003\u0013\u0013YF!\u001a\t\u000f\tu\u0013\u00071\u0001\u0003`\u0005!\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u00042a B1\u0013\r\u0011\u0019g\u0017\u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\t\u000f\t\u001d\u0014\u00071\u0001\u0003j\u0005)!-\u0019;dQB\u0019qNa\u001b\n\u0007\t5\u0004OA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0017a\u0004;sC:\u001cH.\u0019;f\u001f\u001a47/\u001a;\u0015\r\tM$1\u0014BO!\u0011\u0011)H!&\u000f\t\t]$\u0011\u0013\b\u0005\u0005s\u0012yI\u0004\u0003\u0003|\t5e\u0002\u0002B?\u0005\u0017sAAa \u0003\n:!!\u0011\u0011BD\u001b\t\u0011\u0019IC\u0002\u0003\u0006~\u000ba\u0001\u0010:p_Rt\u0014\"\u0001=\n\u0005Y<\u0018B\u00010v\u0013\t\u0019H/\u0003\u0002re&\u0019!1\u00139\u0002\u0017\u0019KG.\u001a*fG>\u0014Hm]\u0005\u0005\u0005/\u0013IJA\tM_\u001e|eMZ:fiB{7/\u001b;j_:T1Aa%q\u0011\u001d\t\u0019P\ra\u0001\u0003WA\u0011Ba(3!\u0003\u0005\r!a\u000e\u0002)M$\u0018M\u001d;j]\u001e4\u0015\u000e\\3Q_NLG/[8oQ\r\u0011$1\u0015\t\u0004Q\n\u0015\u0016b\u0001BTS\nQA\u000f\u001b:fC\u0012\u001c\u0018MZ3\u00023Q\u0014\u0018M\\:mCR,wJ\u001a4tKR$C-\u001a4bk2$HEM\u000b\u0003\u0005[SC!a\u000e\u00030.\u0012!\u0011\u0017\t\u0005\u0005g\u0013i,\u0004\u0002\u00036*!!q\u0017B]\u0003%)hn\u00195fG.,GMC\u0002\u0003<\u000e\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yL!.\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0003sK\u0006$GC\u0003Bc\u0005#\u0014)N!7\u0003^B!!q\u0019Bg\u001b\t\u0011IMC\u0002\u0003Lv\u000baa]3sm\u0016\u0014\u0018\u0002\u0002Bh\u0005\u0013\u0014QBR3uG\"$\u0015\r^1J]\u001a|\u0007b\u0002Bji\u0001\u0007\u00111F\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0004\u0003XR\u0002\r!a\u000e\u0002\u000f5\f\u0007pU5{K\"I!1\u001c\u001b\u0011\u0002\u0003\u0007\u00111F\u0001\f[\u0006D\bk\\:ji&|g\u000eC\u0005\u0003`R\u0002\n\u00111\u0001\u0002v\u0005iQ.\u001b8P]\u0016lUm]:bO\u0016D3\u0001\u000eBR\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uIM*\"Aa:+\t\u0005-\"qV\u0001\u000fe\u0016\fG\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011iO\u000b\u0003\u0002v\t=\u0016!\u00064fi\u000eDW\u000b\u001d9fe\n{WO\u001c3PM\u001a\u001cX\r\u001e\u000b\u0007\u0003k\u0013\u0019P!@\t\u000f\tUx\u00071\u0001\u0003x\u0006\u00192\u000f^1si>3gm]3u!>\u001c\u0018\u000e^5p]B\u0019qP!?\n\u0007\tm8L\u0001\bPM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\t\u000f\t}x\u00071\u0001\u00028\u0005Ia-\u001a;dQNK'0Z\u0001\be\u0016\u001cwN^3s)\u0019\t9d!\u0002\u0004\b!9!Q\f\u001dA\u0002\t}\u0003\"CB\u0005qA\u0005\t\u0019AB\u0006\u0003AaW-\u00193fe\u0016\u0003xn\u00195DC\u000eDW\rE\u0003c\u0003o\u001bi\u0001\u0005\u0003\u0004\u0010\rUQBAB\t\u0015\u0011\u0019\u0019B!3\u0002\u000b\u0015\u0004xn\u00195\n\t\r]1\u0011\u0003\u0002\u0015\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR5mK\u000e\u000b7\r[3)\u0007a\u0012I\"A\tsK\u000e|g/\u001a:%I\u00164\u0017-\u001e7uII*\"aa\b+\t\r-!qV\u0001\u0015Y>\fG\rT1sO\u0016\u001cH\u000fV5nKN$\u0018-\u001c9\u0015\u0005\u0005%\u0015a\u00035bg>3XM\u001d4m_^,\"!!\u001e\u0002%\r|G\u000e\\3di\u0006\u0013wN\u001d;fIRChn\u001d\u000b\u0007\u0007[\u0019\u0019da\u000e\u0011\u0007}\u001cy#C\u0002\u00042m\u0013A\u0003\u0016=o\u0013:$W\r_*fCJ\u001c\u0007NU3tk2$\bbBB\u001by\u0001\u0007\u00111F\u0001\fM\u0016$8\r[(gMN,G\u000fC\u0004\u0004:q\u0002\r!a\u000b\u0002!U\u0004\b/\u001a:C_VtGm\u00144gg\u0016$\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\r}\u0002\u0003BB!\u0007\u0013rAaa\u0011\u0004FA\u0019!\u0011Q2\n\u0007\r\u001d3-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0007\u0017\u001aiE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0007\u000f\u001a\u0017A\u0003;sk:\u001c\u0017\r^3U_R!\u0011qGB*\u0011\u001d\t\u0019P\u0010a\u0001\u0003WA3A\u0010B\r\u00039\u0011X-\u00193OKb$xJ\u001a4tKRD3a\u0010BR\u0003\u00151G.^:iQ\r\u0001%1U\u0001\u0010kB$\u0017\r^3QCJ,g\u000e\u001e#jeR!\u0011\u0011RB2\u0011\u001d\u0019)'\u0011a\u0001\u0007O\n1\u0001Z5s!\u0011\u0019Iga\u001d\u000e\u0005\r-$\u0002BB7\u0007_\n!![8\u000b\u0005\rE\u0014\u0001\u00026bm\u0006LAa!\u001e\u0004l\t!a)\u001b7f\u0003I\u0019\u0007.\u00198hK\u001aKG.Z*vM\u001aL\u00070Z:\u0015\r\u0005%51PB@\u0011\u001d\u0019iH\u0011a\u0001\u0007\u007f\t\u0011b\u001c7e'V4g-\u001b=\t\u000f\r\u0005%\t1\u0001\u0004@\u0005Ia.Z<Tk\u001a4\u0017\u000e_\u0001\u0018_:\u0014UmY8nK&s\u0017m\u0019;jm\u0016\u001cVmZ7f]R\fq\u0003\\8bI\u001aK'o\u001d;CCR\u001c\u0007\u000eV5nKN$\u0018-\u001c9\u0002#QLW.Z,bSR,GMR8s%>dG\u000e\u0006\u0004\u0002,\r-5q\u0012\u0005\b\u0007\u001b+\u0005\u0019AA\u0016\u0003\rqwn\u001e\u0005\b\u0007#+\u0005\u0019AA\u0016\u0003AiWm]:bO\u0016$\u0016.\\3ti\u0006l\u0007/\u0001\fhKR4\u0015N]:u\u0005\u0006$8\r\u001b+j[\u0016\u001cH/Y7q)\t\tY#A\u000bgS:$wJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9\u0015\r\rm51UBS!\u0015\u0011\u0017qWBO!\u0011\u0011)ha(\n\t\r\u0005&\u0011\u0014\u0002\u0013)&lWm\u001d;b[B\fe\u000eZ(gMN,G\u000fC\u0004\u0002^\u001e\u0003\r!a\u000b\t\u0013\r\u001dv\t%AA\u0002\u0005-\u0012AD:uCJ$\u0018N\\4PM\u001a\u001cX\r^\u0001 M&tGm\u00144gg\u0016$()\u001f+j[\u0016\u001cH/Y7qI\u0011,g-Y;mi\u0012\u0012\u0014!B2m_N,\u0017!D2m_N,\u0007*\u00198eY\u0016\u00148/\u0001\beK2,G/Z%g\u000bbL7\u000f^:\u0002\u00191\f7\u000f^'pI&4\u0017.\u001a3\u0002-1\f'oZ3tiJ+7m\u001c:e)&lWm\u001d;b[B\f\u0001\u0003\\1ti6{G-\u001b4jK\u0012|F%Z9\u0015\t\re6\u0011\u001a\t\u0005\u0007w\u001b)-\u0004\u0002\u0004>*!1qXBa\u0003\u00111\u0017\u000e\\3\u000b\t\r\r7qN\u0001\u0004]&|\u0017\u0002BBd\u0007{\u0013A\u0001U1uQ\"911Z(A\u0002\u0005-\u0012AA7tQ\r\u0001!\u0011D\u0001\u000b\u0019><7+Z4nK:$\bCA@R'\t\t\u0016\r\u0006\u0002\u0004R\u0006!q\u000e]3o)I\t9fa7\u0004^\u000e}7\u0011^Bv\u0007_\u001c\u0019pa>\t\u000f\r\u00154\u000b1\u0001\u0004h!9\u0011qE*A\u0002\u0005-\u0002bBBq'\u0002\u000711]\u0001\u0007G>tg-[4\u0011\u0007}\u001c)/C\u0002\u0004hn\u0013\u0011\u0002T8h\u0007>tg-[4\t\u000f\u0005\r3\u000b1\u0001\u0002H!I1Q^*\u0011\u0002\u0003\u0007\u0011QO\u0001\u0012M&dW-\u00117sK\u0006$\u00170\u0012=jgR\u001c\b\"CBy'B\u0005\t\u0019AA\u001c\u00031Ig.\u001b;GS2,7+\u001b>f\u0011%\u0019)p\u0015I\u0001\u0002\u0004\t)(A\u0006qe\u0016\fG\u000e\\8dCR,\u0007\"CB}'B\u0005\t\u0019AB \u0003)1\u0017\u000e\\3Tk\u001a4\u0017\u000e_\u0001\u000f_B,g\u000e\n3fM\u0006,H\u000e\u001e\u00136\u00039y\u0007/\u001a8%I\u00164\u0017-\u001e7uIY\nab\u001c9f]\u0012\"WMZ1vYR$s'\u0001\bpa\u0016tG\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\u0011\u0015!\u0006BB \u0005_#\u0002\"!#\u0005\n\u0011-AQ\u0002\u0005\b\u0007KB\u0006\u0019AB4\u0011\u001d\t9\u0003\u0017a\u0001\u0003WA\u0011b!?Y!\u0003\u0005\raa\u0010\u00021\u0011,G.\u001a;f\u0013\u001a,\u00050[:ug\u0012\"WMZ1vYR$3\u0007")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final LazyIndex<OffsetIndex> lazyOffsetIndex;
    private final LazyIndex<TimeIndex> lazyTimeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private volatile Option<Object> rollingBasedTimestamp;
    private volatile Option<Object> _maxTimestampSoFar;
    private volatile Option<Object> _offsetOfMaxTimestampSoFar;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return "";
    }

    public static String open$default$8() {
        return "";
    }

    public static boolean open$default$7() {
        return false;
    }

    public static int open$default$6() {
        return 0;
    }

    public static boolean open$default$5() {
        return false;
    }

    public static LogSegment open(File file, long l, LogConfig logConfig, Time time, boolean bl, int n, boolean bl2, String string) {
        return LogSegment$.MODULE$.open(file, l, logConfig, time, bl, n, bl2, string);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FileRecords log() {
        return this.log;
    }

    public LazyIndex<OffsetIndex> lazyOffsetIndex() {
        return this.lazyOffsetIndex;
    }

    public LazyIndex<TimeIndex> lazyTimeIndex() {
        return this.lazyTimeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public OffsetIndex offsetIndex() {
        return this.lazyOffsetIndex().get();
    }

    public TimeIndex timeIndex() {
        return this.lazyTimeIndex().get();
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs;
        boolean bl = reachedRollMs = this.timeWaitedForRoll(rollParams.now(), rollParams.maxTimestampInMessages()) > rollParams.maxSegmentMs() - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes() - rollParams.messagesSize() || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages());
    }

    public void resizeIndexes(int size) {
        this.offsetIndex().resize(size);
        this.timeIndex().resize(size);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        if (this.lazyOffsetIndex().file().exists()) {
            if (timeIndexFileNewlyCreated) {
                this.timeIndex().resize(0);
            }
            this.txnIndex().sanityCheck();
            return;
        }
        throw new NoSuchFileException(new StringBuilder(33).append("Offset index file ").append(this.lazyOffsetIndex().file().getAbsolutePath()).append(" does not exist").toString());
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private Option<Object> _maxTimestampSoFar() {
        return this._maxTimestampSoFar;
    }

    private void _maxTimestampSoFar_$eq(Option<Object> x$1) {
        this._maxTimestampSoFar = x$1;
    }

    public void maxTimestampSoFar_$eq(long timestamp) {
        this._maxTimestampSoFar_$eq((Option<Object>)new Some((Object)timestamp));
    }

    public long maxTimestampSoFar() {
        if (this._maxTimestampSoFar().isEmpty()) {
            this._maxTimestampSoFar_$eq((Option<Object>)new Some((Object)this.timeIndex().lastEntry().timestamp()));
        }
        return BoxesRunTime.unboxToLong((Object)this._maxTimestampSoFar().get());
    }

    private Option<Object> _offsetOfMaxTimestampSoFar() {
        return this._offsetOfMaxTimestampSoFar;
    }

    private void _offsetOfMaxTimestampSoFar_$eq(Option<Object> x$1) {
        this._offsetOfMaxTimestampSoFar = x$1;
    }

    public void offsetOfMaxTimestampSoFar_$eq(long offset) {
        this._offsetOfMaxTimestampSoFar_$eq((Option<Object>)new Some((Object)offset));
    }

    public long offsetOfMaxTimestampSoFar() {
        if (this._offsetOfMaxTimestampSoFar().isEmpty()) {
            this._offsetOfMaxTimestampSoFar_$eq((Option<Object>)new Some((Object)this.timeIndex().lastEntry().offset()));
        }
        return BoxesRunTime.unboxToLong((Object)this._offsetOfMaxTimestampSoFar().get());
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return this.offsetIndex().canAppendOffset(offset);
    }

    public void append(long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        if (records.sizeInBytes() > 0) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(45).append("Inserting ").append(records.sizeInBytes()).append(" bytes at end offset ").append(largestOffset).append(" at position ").append(this.log().sizeInBytes()).append(" ").toString()).append(new StringBuilder(42).append("with largest timestamp ").append(largestTimestamp).append(" at shallow offset ").append(shallowOffsetOfMaxTimestamp).toString()).toString());
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)largestTimestamp));
            }
            this.ensureOffsetInRange(largestOffset);
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Appended ").append(appendedBytes).append(" to ").append(this.log().file()).append(" at end offset ").append(largestOffset).toString());
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampSoFar_$eq(largestTimestamp);
                this.offsetOfMaxTimestampSoFar_$eq(shallowOffsetOfMaxTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.offsetIndex().append(largestOffset, physicalPosition);
                TimeIndex qual$1 = this.timeIndex();
                long x$1 = this.maxTimestampSoFar();
                long x$2 = this.offsetOfMaxTimestampSoFar();
                boolean x$3 = qual$1.maybeAppend$default$3();
                qual$1.maybeAppend(x$1, x$2, x$3);
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    private void ensureOffsetInRange(long offset) {
        if (!this.canConvertToRelativeOffset(offset)) {
            throw new LogSegmentOffsetOverflowException(this, offset);
        }
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        ObjectRef objectRef;
        LongRef longRef;
        LongRef longRef2;
        LongRef longRef3;
        IntRef intRef;
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef bytesToAppend = intRef2;
        long create_e2 = Long.MIN_VALUE;
        LongRef longRef4 = longRef3 = new LongRef(create_e2);
        longRef3 = null;
        LongRef maxTimestamp = longRef4;
        long create_e3 = Long.MIN_VALUE;
        LongRef longRef5 = longRef2 = new LongRef(create_e3);
        longRef2 = null;
        LongRef offsetOfMaxTimestamp = longRef5;
        long create_e4 = Long.MIN_VALUE;
        LongRef longRef6 = longRef = new LongRef(create_e4);
        longRef = null;
        LongRef maxOffset = longRef6;
        ByteBuffer create_e5 = bufferSupplier.get(0x100000);
        ObjectRef objectRef2 = objectRef = new ObjectRef((Object)create_e5);
        Object var20_16 = null;
        objectRef = null;
        ObjectRef readBuffer = objectRef2;
        AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)records.batchesFrom(position)).asScala().iterator().takeWhile((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)this.canAppend$1(batch, bytesToAppend, readBuffer))).foreach((Function1 & Serializable)batch -> {
            LogSegment.$anonfun$appendChunkFromFile$2(maxTimestamp, offsetOfMaxTimestamp, maxOffset, bytesToAppend, batch);
            return BoxedUnit.UNIT;
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, MemoryRecords.readableRecords((ByteBuffer)((ByteBuffer)readBuffer.elem)));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start; position < start + records.sizeInBytes(); position += bytesAppended) {
            bytesAppended = this.appendChunkFromFile(records, position, (BufferSupplier)bufferSupplier);
            if (bytesAppended != 0) continue;
            return position - start;
        }
        return position - start;
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset) {
        if (completedTxn.isAborted()) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Writing aborted transaction ").append(completedTxn).append(" to transaction index, last stable offset is ").append(lastStableOffset).toString());
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset));
        }
    }

    private void updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, AppendOrigin$Replication$.MODULE$);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch, (Option<LogOffsetMetadata>)None$.MODULE$);
            producerStateManager.update(appendInfo);
            if (maybeCompletedTxn == null) {
                throw null;
            }
            if (!maybeCompletedTxn.isEmpty()) {
                CompletedTxn completedTxn = (CompletedTxn)maybeCompletedTxn.get();
                LogSegment.$anonfun$updateProducerState$1(this, producerStateManager, completedTxn);
            }
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, Math.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int adjustedMaxSize;
        int n;
        if (maxSize < 0) {
            throw new IllegalArgumentException(new StringBuilder(44).append("Invalid max size ").append(maxSize).append(" for log read from segment ").append(this.log()).toString());
        }
        FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
        if (startOffsetAndSize == null) {
            return null;
        }
        int startPosition = startOffsetAndSize.position;
        LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
        if (minOneMessage) {
            int max_y = startOffsetAndSize.size;
            n = Math.max(maxSize, max_y);
        } else {
            n = adjustedMaxSize = maxSize;
        }
        if (adjustedMaxSize == 0) {
            return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, false, (Option<List<FetchResponse.AbortedTransaction>>)None$.MODULE$);
        }
        int n2 = Math.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
        return new FetchDataInfo(offsetMetadata, (Records)this.log().slice(startPosition, n2), adjustedMaxSize < startOffsetAndSize.size, (Option<List<FetchResponse.AbortedTransaction>>)None$.MODULE$);
    }

    public long read$default$3() {
        return this.size();
    }

    public boolean read$default$4() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        Option<OffsetPosition> option = this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize);
        if (option == null) {
            throw null;
        }
        Option<OffsetPosition> map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((OffsetPosition)map_this.get()).offset());
        return object;
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        IntRef intRef;
        IntRef intRef2;
        this.offsetIndex().reset();
        this.timeIndex().reset();
        this.txnIndex().reset();
        int create_e = 0;
        IntRef intRef3 = intRef2 = new IntRef(create_e);
        intRef2 = null;
        IntRef validBytes = intRef3;
        int create_e2 = 0;
        IntRef intRef4 = intRef = new IntRef(create_e2);
        intRef = null;
        IntRef lastIndexEntry = intRef4;
        this.maxTimestampSoFar_$eq(-1L);
        try {
            AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)this.log().batches()).asScala().foreach((Function1 & Serializable)batch -> {
                LogSegment.$anonfun$recover$1(this, validBytes, lastIndexEntry, leaderEpochCache, producerStateManager, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof CorruptRecordException ? true : throwable instanceof InvalidRecordException;
            if (bl) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension("Found invalid messages in log segment %s at byte offset %d: %s. %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), validBytes$1.elem, throwable.getMessage(), throwable.getCause()})));
            }
            throw throwable;
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Truncated ").append(truncated).append(" invalid bytes at the end of segment ").append(this.log().file().getAbsoluteFile()).append(" during recovery").toString());
        }
        this.log().truncateTo(validBytes.elem);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
        this.offsetOfMaxTimestampSoFar_$eq(lastTimeIndexEntry.offset());
        OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
        FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
        if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp()) {
            this.maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp);
            this.offsetOfMaxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.offset);
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder(74).append("LogSegment(baseOffset=").append(this.baseOffset()).append(", size=").append(this.size()).append(", lastModifiedTime=").append(this.lastModified()).append(", largestRecordTimestamp=").append(this.largestRecordTimestamp()).append(")").toString();
    }

    public int truncateTo(long offset) {
        int bytesTruncated;
        FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        this.offsetIndex().truncateTo(offset);
        this.timeIndex().truncateTo(offset);
        this.txnIndex().truncateTo(offset);
        this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time().milliseconds());
            this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        if (this.maxTimestampSoFar() >= 0L) {
            this.loadLargestTimestamp();
        }
        return bytesTruncated;
    }

    public long readNextOffset() {
        Object object;
        FetchDataInfo fetchData = this.read(this.offsetIndex().lastOffset(), this.log().sizeInBytes(), this.read$default$3(), this.read$default$4());
        if (fetchData == null) {
            return this.baseOffset();
        }
        Option option = AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)fetchData.records().batches()).asScala().lastOption();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((RecordBatch)map_this.get()).nextOffset());
        None$ none$ = object2;
        Object var2_2 = null;
        object2 = null;
        None$ getOrElse_this = none$;
        if (getOrElse_this.isEmpty()) {
            Long l;
            Long l2 = l = Long.valueOf(this.baseOffset());
            l = null;
            object = l2;
        } else {
            object = getOrElse_this.get();
        }
        Object object3 = object;
        Object var4_4 = null;
        object = null;
        return BoxesRunTime.unboxToLong((Object)object3);
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time((JFunction0.mcV.sp & Serializable)() -> {
            this.log().flush();
            this.offsetIndex().flush();
            this.timeIndex().flush();
            this.txnIndex().flush();
        });
    }

    public void updateParentDir(File dir) {
        this.log().updateParentDir(dir);
        this.lazyOffsetIndex().updateParentDir(dir);
        this.lazyTimeIndex().updateParentDir(dir);
        this.txnIndex().updateParentDir(dir);
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        this.lazyOffsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyOffsetIndex().file().getPath(), oldSuffix, newSuffix)));
        this.lazyTimeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyTimeIndex().file().getPath(), oldSuffix, newSuffix)));
        this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    private void loadFirstBatchTimestamp() {
        Iterator iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp()));
            return;
        }
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public long getFirstBatchTimestamp() {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L ? t : Long.MAX_VALUE;
        return l;
    }

    public Option<FileRecords.TimestampAndOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup(Math.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset));
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        block6: {
            block5: {
                Option<Object> option = this._maxTimestampSoFar();
                if (option == null) {
                    throw null;
                }
                if (option.isDefined()) break block5;
                Option<Object> option2 = this._offsetOfMaxTimestampSoFar();
                if (option2 == null) {
                    throw null;
                }
                if (!option2.isDefined()) break block6;
            }
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true), this, Level.WARN);
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.lazyOffsetIndex().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.lazyTimeIndex().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.log().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.txnIndex().close(), this, Level.WARN);
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.lazyOffsetIndex().closeHandler(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.lazyTimeIndex().closeHandler(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.log().closeHandlers(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.txnIndex().close(), this, Level.WARN);
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.log().file();
            String delete$1_fileType = "log";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$4(this)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.lazyOffsetIndex().file();
            String delete$1_fileType = "offset index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$6(this)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.lazyTimeIndex().file();
            String delete$1_fileType = "time index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$8(this)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> {
            boolean bl = false;
            File delete$1_file = this.txnIndex().file();
            String delete$1_fileType = "transaction index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$10(this)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)Nil$.MODULE$)))));
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public Option<Object> largestRecordTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return new Some((Object)this.maxTimestampSoFar());
        }
        return None$.MODULE$;
    }

    public long largestTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return this.maxTimestampSoFar();
        }
        return this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.lazyOffsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.lazyTimeIndex().file().toPath(), fileTime);
    }

    private final boolean canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public static final /* synthetic */ void $anonfun$appendChunkFromFile$2(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, LongRef maxOffset$1, IntRef bytesToAppend$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.lastOffset();
        }
        maxOffset$1.elem = batch.lastOffset();
        bytesToAppend$1.elem += batch.sizeInBytes();
    }

    public static final /* synthetic */ void $anonfun$updateProducerState$1(LogSegment $this, ProducerStateManager producerStateManager$1, CompletedTxn completedTxn) {
        long lastStableOffset = producerStateManager$1.lastStableOffset(completedTxn);
        $this.updateTxnIndex(completedTxn, lastStableOffset);
        producerStateManager$1.completeTxn(completedTxn);
    }

    public static final /* synthetic */ boolean $anonfun$recover$3(FileLogInputStream.FileChannelRecordBatch batch$1, int x$2) {
        return batch$1.partitionLeaderEpoch() > x$2;
    }

    public static final /* synthetic */ void $anonfun$recover$2(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        if (batch$1.partitionLeaderEpoch() >= 0) {
            int n;
            Option<Object> option = cache.latestEpoch();
            if (option == null) {
                throw null;
            }
            Option<Object> forall_this = option;
            boolean bl = forall_this.isEmpty() || LogSegment.$anonfun$recover$3(batch$1, n = BoxesRunTime.unboxToInt((Object)forall_this.get()));
            Object var2_2 = null;
            if (bl) {
                cache.assign(batch$1.partitionLeaderEpoch(), batch$1.baseOffset());
            }
        }
    }

    public static final /* synthetic */ void $anonfun$recover$1(LogSegment $this, IntRef validBytes$1, IntRef lastIndexEntry$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$2, FileLogInputStream.FileChannelRecordBatch batch) {
        batch.ensureValid();
        $this.ensureOffsetInRange(batch.lastOffset());
        if (batch.maxTimestamp() > $this.maxTimestampSoFar()) {
            $this.maxTimestampSoFar_$eq(batch.maxTimestamp());
            $this.offsetOfMaxTimestampSoFar_$eq(batch.lastOffset());
        }
        if (validBytes$1.elem - lastIndexEntry$1.elem > $this.indexIntervalBytes()) {
            $this.offsetIndex().append(batch.lastOffset(), validBytes$1.elem);
            TimeIndex qual$1 = $this.timeIndex();
            long x$1 = $this.maxTimestampSoFar();
            long x$2 = $this.offsetOfMaxTimestampSoFar();
            boolean x$3 = qual$1.maybeAppend$default$3();
            qual$1.maybeAppend(x$1, x$2, x$3);
            lastIndexEntry$1.elem = validBytes$1.elem;
        }
        validBytes$1.elem += batch.sizeInBytes();
        if (batch.magic() >= 2) {
            if (leaderEpochCache$1 == null) {
                throw null;
            }
            if (!leaderEpochCache$1.isEmpty()) {
                LeaderEpochFileCache leaderEpochFileCache = (LeaderEpochFileCache)leaderEpochCache$1.get();
                LogSegment.$anonfun$recover$2(batch, leaderEpochFileCache);
            }
            $this.updateProducerState(producerStateManager$2, (RecordBatch)batch);
        }
    }

    public static final /* synthetic */ long $anonfun$readNextOffset$2(LogSegment $this) {
        return $this.baseOffset();
    }

    private final void delete$1(Function0 delete, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete.apply$mcZ$sp()) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
            } else if (logIfMissing) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
            }
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(19).append("Delete of ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" failed.").toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$4(LogSegment $this) {
        return $this.log().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$6(LogSegment $this) {
        return $this.lazyOffsetIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$8(LogSegment $this) {
        return $this.lazyTimeIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$10(LogSegment $this) {
        return $this.txnIndex().deleteIfExists();
    }

    public LogSegment(FileRecords log, LazyIndex<OffsetIndex> lazyOffsetIndex, LazyIndex<TimeIndex> lazyTimeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.lazyOffsetIndex = lazyOffsetIndex;
        this.lazyTimeIndex = lazyTimeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this._maxTimestampSoFar = None$.MODULE$;
        this._offsetOfMaxTimestampSoFar = None$.MODULE$;
    }

    public static final /* synthetic */ Object $anonfun$updateProducerState$1$adapted(LogSegment $this, ProducerStateManager producerStateManager$1, CompletedTxn completedTxn) {
        LogSegment.$anonfun$updateProducerState$1($this, producerStateManager$1, completedTxn);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$fetchUpperBoundOffset$1$adapted(OffsetPosition x$1) {
        return BoxesRunTime.boxToLong((long)x$1.offset());
    }

    public static final /* synthetic */ Object $anonfun$readNextOffset$1$adapted(RecordBatch x$3) {
        return BoxesRunTime.boxToLong((long)x$3.nextOffset());
    }

    public static final /* synthetic */ Object $anonfun$recover$2$adapted(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        LogSegment.$anonfun$recover$2(batch$1, cache);
        return BoxedUnit.UNIT;
    }
}

