/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.cluster.AbstractPartitionTest;
import kafka.cluster.CommittedIsr;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.IsrState;
import kafka.cluster.OngoingReassignmentState;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.PendingShrinkIsr;
import kafka.cluster.Replica;
import kafka.cluster.SimpleAssignmentState;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.ClientRecordDeletion$;
import kafka.log.LoadLogParams;
import kafka.log.LoadedLogOffsets;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogLoader$;
import kafka.log.LogManager;
import kafka.log.LogReadInfo;
import kafka.log.LogSegments;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.ProducerStateManager;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.ZkIsrManager;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InconsistentTopicIdException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.OffsetNotAvailableException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t}f\u0001B A\u0001\u0015CQA\u0013\u0001\u0005\u0002-CQ!\u0014\u0001\u0005\u00029CQA\u0019\u0001\u0005\u00029CQ\u0001\u001a\u0001\u0005\u00029CQA\u001a\u0001\u0005\u00029CQ\u0001\u001b\u0001\u0005\u00029CQA\u001b\u0001\u0005\u00029CQ\u0001\u001c\u0001\u0005\u00029CQA\u001c\u0001\u0005\u00029CQ\u0001\u001d\u0001\u0005\u00029CQA\u001d\u0001\u0005\u00029CQ\u0001\u001e\u0001\u0005\u00029CQA\u001e\u0001\u0005\u00029CQ\u0001\u001f\u0001\u0005\u00029CQA\u001f\u0001\u0005\u00029CQ\u0001 \u0001\u0005\u00029CQA \u0001\u0005\u00029Ca!!\u0001\u0001\t\u0003q\u0005BBA\u0003\u0001\u0011\u0005a\n\u0003\u0004\u0002\n\u0001!\tA\u0014\u0005\u0007\u0003\u001b\u0001A\u0011\u0001(\t\r\u0005E\u0001\u0001\"\u0001O\u0011\u001d\t)\u0002\u0001C\u0001\u0003/A\u0011\"!\u001a\u0001#\u0003%\t!a\u001a\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!1\u0011Q\u0011\u0001\u0005\u00029Ca!!#\u0001\t\u0003q\u0005BBAG\u0001\u0011\u0005a\n\u0003\u0004\u0002\u0012\u0002!\tA\u0014\u0005\u0007\u0003+\u0003A\u0011\u0001(\t\r\u0005e\u0005\u0001\"\u0001O\u0011\u0019\ti\n\u0001C\u0001\u001d\"1\u0011\u0011\u0015\u0001\u0005\u00029Ca!!*\u0001\t\u0003q\u0005BBAU\u0001\u0011\u0005a\n\u0003\u0004\u0002.\u0002!\tA\u0014\u0005\u0007\u0003c\u0003A\u0011\u0001(\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\"1\u0011\u0011\u001c\u0001\u0005\u00029Ca!!8\u0001\t\u0003q\u0005BBAq\u0001\u0011\u0005a\n\u0003\u0004\u0002f\u0002!\tA\u0014\u0005\u0007\u0003S\u0004A\u0011\u0001(\t\u000f\u00055\b\u0001\"\u0001\u0002p\"1!\u0011\u0001\u0001\u0005\u00029CaA!\u0002\u0001\t\u0003q\u0005B\u0002B\u0005\u0001\u0011\u0005a\n\u0003\u0004\u0003\u000e\u0001!\tA\u0014\u0005\u0007\u0005#\u0001A\u0011\u0001(\t\r\tU\u0001\u0001\"\u0001O\u0011\u001d\u0011I\u0002\u0001C\u0005\u000571aAa\r\u0001\t\tU\u0002B\u0003B\u0010i\t\u0005\t\u0015!\u0003\u0003\"!a!q\u0007\u001b\u0003\u0002\u0003\u0006IA!\u000f\u0003@!Q!\u0011\t\u001b\u0003\u0002\u0003\u0006IAa\u0011\t\u0015\t%CG!A!\u0002\u0013\u0011Y\u0005\u0003\u0007\u0003bQ\u0012\t\u0011)A\u0005\u0005G\u0012I\u0007\u0003\u0007\u0003lQ\u0012\t\u0011)A\u0005\u0005[\u0012I\b\u0003\u0006\u0003~Q\u0012\t\u0011)A\u0005\u0005\u007fB!Ba\"5\u0005\u0003\u0005\u000b\u0011\u0002BE\u0011\u0019QE\u0007\"\u0001\u0003\u001e\"9!1\u0017\u001b\u0005B\tU&!\u0004)beRLG/[8o)\u0016\u001cHO\u0003\u0002B\u0005\u000691\r\\;ti\u0016\u0014(\"A\"\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0012\t\u0003\u000f\"k\u0011\u0001Q\u0005\u0003\u0013\u0002\u0013Q#\u00112tiJ\f7\r\u001e)beRLG/[8o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002\u0019B\u0011q\tA\u0001 i\u0016\u001cH\u000fT1ti\u001a+Go\u00195fI>3gm]3u-\u0006d\u0017\u000eZ1uS>tG#A(\u0011\u0005A\u001bV\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005Y\u0003\"a\u00161\u000e\u0003aS!!\u0017.\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\\9\u00069!.\u001e9ji\u0016\u0014(BA/_\u0003\u0015QWO\\5u\u0015\u0005y\u0016aA8sO&\u0011\u0011\r\u0017\u0002\u0005)\u0016\u001cH/A\u0010uKN$X*Y6f\u0019\u0016\fG-\u001a:Va\u0012\fG/Z:Fa>\u001c\u0007nQ1dQ\u0016D#a\u0001,\u0002QQ,7\u000f^'bs\n,'+\u001a9mC\u000e,7)\u001e:sK:$x+\u001b;i\rV$XO]3SKBd\u0017nY1)\u0005\u00111\u0016!\f;fgRl\u0015m[3G_2dwn^3s/&$\bnV5uQ\u001a{G\u000e\\8xKJ\f\u0005\u000f]3oIJ+7m\u001c:eg\"\u0012QAV\u0001=i\u0016\u001cH/T1zE\u0016\u0014V\r\u001d7bG\u0016\u001cUO\u001d:f]R<\u0016\u000e\u001e5GkR,(/\u001a*fa2L7-\u0019#jM\u001a,'/\u001a8u\u0005\u0006\u001cXm\u00144gg\u0016$8\u000f\u000b\u0002\u0007-\u0006yC/Z:u\r\u0016$8\r[(gMN,Go\u00158baNDw\u000e^#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_JdU-\u00193fe\"\u0012qAV\u00012i\u0016\u001cHOR3uG\"|eMZ:fiNs\u0017\r]:i_R,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:G_2dwn^3sQ\tAa+A\u0016uKN$xJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"4\u0016\r\\5eCRLwN\u001c$pe2+\u0017\rZ3sQ\tIa+A\u0017uKN$xJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"4\u0016\r\\5eCRLwN\u001c$pe\u001a{G\u000e\\8xKJD#A\u0003,\u0002MQ,7\u000f\u001e*fC\u0012\u0014VmY8sI\u0016\u0003xn\u00195WC2LG-\u0019;j_:4uN\u001d'fC\u0012,'\u000f\u000b\u0002\f-\u0006AC/Z:u%\u0016\fGMU3d_J$W\t]8dQZ\u000bG.\u001b3bi&|gNR8s\r>dGn\\<fe\"\u0012ABV\u00014i\u0016\u001cHOR3uG\"|eMZ:fi\u001a{'\u000fV5nKN$\u0018-\u001c9Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014H*Z1eKJD#!\u0004,\u0002kQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR4uN\u001d+j[\u0016\u001cH/Y7q\u000bB|7\r\u001b,bY&$\u0017\r^5p]\u001a{'OR8mY><XM\u001d\u0015\u0003\u001dY\u000b\u0001\u0006^3ti\u001a+Go\u00195MCR,7\u000f^(gMN,G/\u00138dYV$Wm\u001d'fC\u0012,'/\u00129pG\"D#a\u0004,\u0002KQ,7\u000f^'p]>$xN\\5d\u001f\u001a47/\u001a;t\u0003\u001a$XM\u001d'fC\u0012,'o\u00115b]\u001e,\u0007F\u0001\tW\u00039\"Xm\u001d;BaB,g\u000e\u001a*fG>\u0014Hm]!t\r>dGn\\<fe\n+Gn\\<M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;)\u0005E1\u0016!\b;fgRd\u0015n\u001d;PM\u001a\u001cX\r^%t_2\fG/[8o\u0019\u00164X\r\\:)\u0005I1\u0016A\u0004;fgR<U\r\u001e*fa2L7-\u0019\u0015\u0003'Y\u000bq\u0007^3ti\u0006\u0003\b/\u001a8e%\u0016\u001cwN\u001d3t)>4u\u000e\u001c7po\u0016\u0014x+\u001b;i\u001d>\u0014V\r\u001d7jG\u0006$\u0006N]8xg\u0016C8-\u001a9uS>t\u0007F\u0001\u000bW\u0003\u0011\"Xm\u001d;NC.,gi\u001c7m_^,'oV5uQ:{G*Z1eKJLEm\u00115b]\u001e,\u0007FA\u000bW\u0003\u001d#Xm\u001d;G_2dwn^3s\t>,7OT8u\u0015>Lg.S*S+:$\u0018\u000e\\\"bk\u001eDG/\u00169U_>3gm]3u/&$\b.\u001b8DkJ\u0014XM\u001c;MK\u0006$WM]#q_\u000eD\u0007F\u0001\fW\u00035\u0019'/Z1uKJ+7m\u001c:egRA\u0011\u0011DA\u0018\u0003#\nY\u0006\u0005\u0003\u0002\u001c\u0005-RBAA\u000f\u0015\u0011\ty\"!\t\u0002\rI,7m\u001c:e\u0015\u0011\t\u0019#!\n\u0002\r\r|W.\\8o\u0015\r\u0019\u0015q\u0005\u0006\u0004\u0003Sq\u0016AB1qC\u000eDW-\u0003\u0003\u0002.\u0005u!!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u00022]\u0001\r!a\r\u0002\u000fI,7m\u001c:egB1\u0011QGA#\u0003\u0017rA!a\u000e\u0002B9!\u0011\u0011HA \u001b\t\tYDC\u0002\u0002>\u0011\u000ba\u0001\u0010:p_Rt\u0014\"\u0001*\n\u0007\u0005\r\u0013+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0013\u0011\n\u0002\t\u0013R,'/\u00192mK*\u0019\u00111I)\u0011\t\u0005m\u0011QJ\u0005\u0005\u0003\u001f\niB\u0001\u0007TS6\u0004H.\u001a*fG>\u0014H\rC\u0004\u0002T]\u0001\r!!\u0016\u0002\u0015\t\f7/Z(gMN,G\u000fE\u0002Q\u0003/J1!!\u0017R\u0005\u0011auN\\4\t\u0013\u0005us\u0003%AA\u0002\u0005}\u0013\u0001\u00069beRLG/[8o\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000eE\u0002Q\u0003CJ1!a\u0019R\u0005\rIe\u000e^\u0001\u0018GJ,\u0017\r^3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM*\"!!\u001b+\t\u0005}\u00131N\u0016\u0003\u0003[\u0002B!a\u001c\u0002z5\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\n)(A\u0005v]\u000eDWmY6fI*\u0019\u0011qO)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002|\u0005E$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Q2M]3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8bYJ+7m\u001c:egR1\u0011\u0011DAA\u0003\u0007Cq!!\r\u001a\u0001\u0004\t\u0019\u0004C\u0004\u0002Te\u0001\r!!\u0016\u0002\u0019Q,7\u000f^!u\u001b&t\u0017j\u001d:)\u0005i1\u0016\u0001\b;fgR,\u0006\u000fZ1uK\u001a{G\u000e\\8xKJ4U\r^2i'R\fG/\u001a\u0015\u00037Y\u000b\u0001\u0003^3ti&\u001b(/\u0012=qC:\u001c\u0018n\u001c8)\u0005q1\u0016a\b;fgRL5O\u001d(pi\u0016C\b/\u00198eK\u0012Le-\u00169eCR,g)Y5mg\"\u0012QDV\u0001\u0013i\u0016\u001cH/T1zE\u0016\u001c\u0006N]5oW&\u001b(\u000f\u000b\u0002\u001f-\u0006aB/Z:u\u00032$XM]%te2+\u0017\rZ3s\u0003:$\u0017j\u001d:SC\u000e,\u0007FA\u0010W\u0003=\"Xm\u001d;TQ>,H\u000e\u001a(piNC'/\u001b8l\u0013N\u0014\u0018J\u001a)sKZLw.^:GKR\u001c\u0007.S:DCV<\u0007\u000e^+qQ\t\u0001c+\u0001\u0019uKN$8\u000b[8vY\u0012tu\u000e^*ie&t7.S:s\u0013\u001a4u\u000e\u001c7po\u0016\u00148)Y;hQR,\u0006\u000fV8M_\u001e,e\u000e\u001a\u0015\u0003CY\u000bQ\u0004^3ti&\u001b(OT8u'\"\u0014XO\\6JMV\u0003H-\u0019;f\r\u0006LGn\u001d\u0015\u0003EY\u000b\u0001\u0004^3ti\u0006cG/\u001a:JgJ,fn\u001b8po:$v\u000e]5dQ\t\u0019c+\u0001\u000euKN$\u0018\t\u001c;fe&\u001b(/\u00138wC2LGMV3sg&|g\u000e\u000b\u0002%-\u0006YB/Z:u\u00032$XM]%teVsW\r\u001f9fGR,G-\u0012:s_JD#!\n,\u0002+!\fg\u000e\u001a7f\u00032$XM]%te\u001a\u000b\u0017\u000e\\;sKR)q*!/\u0002J\"9\u00111\u0018\u0014A\u0002\u0005u\u0016!B3se>\u0014\b\u0003BA`\u0003\u000bl!!!1\u000b\t\u0005\r\u0017\u0011E\u0001\taJ|Go\\2pY&!\u0011qYAa\u0005\u0019)%O]8sg\"9\u00111\u001a\u0014A\u0002\u00055\u0017\u0001C2bY2\u0014\u0017mY6\u0011\u0015A\u000by-a\u0018\u0002`\u0005Mw*C\u0002\u0002RF\u0013\u0011BR;oGRLwN\\\u001a\u0011\u0007\u001d\u000b).C\u0002\u0002X\u0002\u0013\u0011\u0002U1si&$\u0018n\u001c8\u00025Q,7\u000f^*j]\u001edW-\u00138GY&<\u0007\u000e^!mi\u0016\u0014\u0018j\u001d:)\u0005\u001d2\u0016!\b;fgRT6.S:s\u001b\u0006t\u0017mZ3s\u0003NLhnY\"bY2\u0014\u0017mY6)\u0005!2\u0016A\u000b;fgR,6/Z\"iK\u000e\\\u0007o\\5oiR{\u0017J\\5uS\u0006d\u0017N_3IS\u001eDw+\u0019;fe6\f'o\u001b\u0015\u0003SY\u000bA\u0006^3tiR{\u0007/[2JI\u0006sG\rU1si&$\u0018n\u001c8NKR\fG-\u0019;b\r&dWMR8s\u0019\u0016\fG-\u001a:)\u0005)2\u0016A\f;fgR$v\u000e]5d\u0013\u0012\fe\u000e\u001a)beRLG/[8o\u001b\u0016$\u0018\rZ1uC\u001aKG.\u001a$pe\u001a{G\u000e\\8xKJD#a\u000b,\u0002\u0019\rDWmY6U_BL7-\u00133\u0015\u000b=\u000b\t0!@\t\u000f\u0005MH\u00061\u0001\u0002v\u0006yQ\r\u001f9fGR,G\rV8qS\u000eLE\r\u0005\u0003\u0002x\u0006eXBAA\u0011\u0013\u0011\tY0!\t\u0003\tU+\u0018\u000e\u001a\u0005\b\u0003\u007fd\u0003\u0019AAj\u0003%\u0001\u0018M\u001d;ji&|g.A\fuKN$\u0018\t\u001a3B]\u0012\u0014V-\\8wK6+GO]5dg\"\u0012QFV\u0001.i\u0016\u001cH/\u00168eKJ\u0014V\r\u001d7jG\u0006$X\r\u001a)beRLG/[8og\u000e{'O]3diN+W.\u00198uS\u000e\u001c\bF\u0001\u0018W\u0003i!Xm\u001d;Va\u0012\fG/Z!tg&<g.\\3oi\u0006sG-S:sQ\tyc+A\u000buKN$Hj\\4D_:4\u0017n\u001a(pi\u0012K'\u000f^=)\u0005A2\u0016\u0001\t;fgRdunZ\"p]\u001aLw\rR5sif\f5\u000fV8qS\u000e,\u0006\u000fZ1uK\u0012D#!\r,\u0002CQ,7\u000f\u001e'pO\u000e{gNZ5h\t&\u0014H/_!t\u0005J|7.\u001a:Va\u0012\fG/\u001a3)\u0005I2\u0016aC:fK\u0012dun\u001a#bi\u0006$ra\u0014B\u000f\u0005W\u0011y\u0003C\u0004\u0003 M\u0002\rA!\t\u0002\u00071|w\r\u0005\u0003\u0003$\t\u001dRB\u0001B\u0013\u0015\r\u0011yBQ\u0005\u0005\u0005S\u0011)CA\u0002M_\u001eDqA!\f4\u0001\u0004\ty&\u0001\u0006ok6\u0014VmY8sINDqA!\r4\u0001\u0004\ty&A\u0006mK\u0006$WM]#q_\u000eD'aB*m_^dunZ\n\u0004i\t\u0005\u0012\u0001C:fO6,g\u000e^:\u0011\t\t\r\"1H\u0005\u0005\u0005{\u0011)CA\u0006M_\u001e\u001cVmZ7f]R\u001c\u0018\u0002\u0002B\u001c\u0005O\tqa\u001c4gg\u0016$8\u000f\u0005\u0003\u0003$\t\u0015\u0013\u0002\u0002B$\u0005K\u0011\u0001\u0003T8bI\u0016$Gj\\4PM\u001a\u001cX\r^:\u0002!1,\u0017\rZ3s\u000bB|7\r[\"bG\",\u0007#\u0002)\u0003N\tE\u0013b\u0001B(#\n1q\n\u001d;j_:\u0004BAa\u0015\u0003^5\u0011!Q\u000b\u0006\u0005\u0005/\u0012I&A\u0003fa>\u001c\u0007NC\u0002\u0003\\\t\u000baa]3sm\u0016\u0014\u0018\u0002\u0002B0\u0005+\u0012A\u0003T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",\u0017\u0001\u00069s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'\u000f\u0005\u0003\u0003$\t\u0015\u0014\u0002\u0002B4\u0005K\u0011A\u0003\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014\u0018\u0002\u0002B1\u0005O\t\u0001\"\\8dWRKW.\u001a\t\u0005\u0005_\u0012)(\u0004\u0002\u0003r)\u0019!1\u000f\"\u0002\u000bU$\u0018\u000e\\:\n\t\t]$\u0011\u000f\u0002\t\u001b>\u001c7\u000eV5nK&!!1\u0010B\u0014\u0003\u0011!\u0018.\\3\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m!\u0011\u0011\tIa!\u000e\u0005\te\u0013\u0002\u0002BC\u00053\u0012A\u0003T8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0017aD1qa\u0016tGmU3nCBDwN]3\u0011\t\t-%\u0011T\u0007\u0003\u0005\u001bSAAa$\u0003\u0012\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\tM%QS\u0001\u0005kRLGN\u0003\u0002\u0003\u0018\u0006!!.\u0019<b\u0013\u0011\u0011YJ!$\u0003\u0013M+W.\u00199i_J,GC\u0005BP\u0005G\u0013)Ka*\u0003*\n-&Q\u0016BX\u0005c\u00032A!)5\u001b\u0005\u0001\u0001b\u0002B\u0010{\u0001\u0007!\u0011\u0005\u0005\b\u0005oi\u0004\u0019\u0001B\u001d\u0011\u001d\u0011\t%\u0010a\u0001\u0005\u0007BqA!\u0013>\u0001\u0004\u0011Y\u0005C\u0004\u0003bu\u0002\rAa\u0019\t\u000f\t-T\b1\u0001\u0003n!9!QP\u001fA\u0002\t}\u0004b\u0002BD{\u0001\u0007!\u0011R\u0001\u0011CB\u0004XM\u001c3Bg\u001a{G\u000e\\8xKJ$BAa.\u0003>B!!1\u0005B]\u0013\u0011\u0011YL!\n\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u001d\t\tD\u0010a\u0001\u00033\u0001")
public class PartitionTest
extends AbstractPartitionTest {
    @Test
    public void testLastFetchedOffsetValidation() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        PartitionTest.append$1(0, 2, log);
        PartitionTest.append$1(3, 3, log);
        PartitionTest.append$1(3, 3, log);
        PartitionTest.append$1(4, 5, log);
        PartitionTest.append$1(7, 1, log);
        PartitionTest.append$1(9, 3, log);
        Assertions.assertEquals((long)17L, (long)log.logEndOffset());
        int leaderEpoch = 10;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(0, 2L), PartitionTest.read$1(2, 5L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(0, 2L), PartitionTest.read$1(0, 4L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(4, 13L), PartitionTest.read$1(6, 6L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(4, 13L), PartitionTest.read$1(5, 9L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(10, 17L), PartitionTest.read$1(10, 18L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(0, 2L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(7, 14L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(9, 17L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(10, 17L, partition, leaderEpoch));
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(11, 5L, partition, leaderEpoch));
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(5L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(2, 5L), PartitionTest.read$1(2, 8L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(0, 5L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(3, 5L, partition, leaderEpoch));
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(0, 0L, partition, leaderEpoch));
        log.maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(5, 6L, partition, leaderEpoch));
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(3, 6L, partition, leaderEpoch));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMakeLeaderUpdatesEpochCache() {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compressionType2;
        int leaderEpoch = 8;
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$12, x$3, x$4, (Option)x$2);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())};
        boolean bl = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        compressionType = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())};
        int n = 5;
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = 0L;
        compressionType2 = null;
        simpleRecordArray2 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderLogIfLocal().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.logEndOffset())));
        OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assertions.assertEquals((long)4L, (long)epochEndOffset.endOffset());
        Assertions.assertEquals((int)leaderEpoch, (int)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        Thread thread1 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                Partition qual$1 = this.$outer.partition();
                boolean x$1 = qual$1.removeFutureLocalReplica$default$1();
                qual$1.removeFutureLocalReplica(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        Thread thread2 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                this.$outer.partition().maybeReplaceCurrentWithFutureReplica();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().futureLog());
    }

    @Test
    public void testMakeFollowerWithWithFollowerAppendRecords() {
        Semaphore appendSemaphore = new Semaphore(0);
        MockTime mockTime = new MockTime();
        this.partition_$eq(new Partition(this, mockTime, appendSemaphore){
            private final /* synthetic */ PartitionTest $outer;
            private final MockTime mockTime$1;
            private final Semaphore appendSemaphore$1;

            public Log createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints, Option<Uuid> topicId) {
                Log log = super.createLog(isNew, isFutureReplica, offsetCheckpoints, (Option)None$.MODULE$);
                LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
                LogSegments segments = new LogSegments(log.topicPartition());
                Option leaderEpochCache = Log$.MODULE$.maybeCreateLeaderEpochCache(log.dir(), log.topicPartition(), logDirFailureChannel, log.config().recordVersion(), "");
                int maxProducerIdExpirationMs = 3600000;
                ProducerStateManager producerStateManager = new ProducerStateManager(log.topicPartition(), log.dir(), maxProducerIdExpirationMs, Time.SYSTEM);
                LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(log.dir(), log.topicPartition(), log.config(), (Scheduler)this.mockTime$1.scheduler(), (Time)this.mockTime$1, logDirFailureChannel, true, segments, 0L, 0L, maxProducerIdExpirationMs, leaderEpochCache, producerStateManager));
                return new SlowLog(this.$outer, log, segments, offsets, (Option<LeaderEpochFileCache>)leaderEpochCache, producerStateManager, this.mockTime$1, logDirFailureChannel, this.appendSemaphore$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mockTime$1 = mockTime$1;
                this.appendSemaphore$1 = appendSemaphore$1;
                super($outer.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), $outer.brokerId(), (Time)$outer.time(), (IsrChangeListener)$outer.isrChangeListener(), $outer.delayedOperations(), $outer.metadataCache(), $outer.logManager(), (AlterIsrManager)$outer.alterIsrManager());
            }
        });
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Thread appendThread = new Thread(this){
            private final /* synthetic */ PartitionTest $outer;

            public void run() {
                MemoryRecords records = this.$outer.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}))), 0L, this.$outer.createRecords$default$3());
                this.$outer.partition().appendRecordsToFollowerOrFutureReplica(records, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        appendThread.start();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!appendSemaphore.hasQueuedThreads()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"follower log append is not called.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(2).setLeaderEpoch(1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setIsNew(false);
        Assertions.assertTrue((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints(), (Option)None$.MODULE$));
        appendSemaphore.release();
        appendThread.join();
        Assertions.assertEquals((long)2L, (long)this.partition().localLogOrException().logEndOffset());
        Assertions.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)this.partition().leaderReplicaIdOpt().get()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeReplaceCurrentWithFutureReplicaDifferentBaseOffsets() {
        void builder_partitionLeaderEpoch;
        void builder_isTransactional;
        void builder_baseSequence;
        void builder_producerEpoch;
        void builder_logAppendTime;
        void builder_baseOffset;
        void builder_timestampType;
        void builder_compressionType;
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compressionType2;
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        Log currentLog = (Log)this.partition().log().get();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k1".getBytes(), "v2".getBytes()), new SimpleRecord("k1".getBytes(), "v3".getBytes()), new SimpleRecord("k2".getBytes(), "v4".getBytes()), new SimpleRecord("k2".getBytes(), "v5".getBytes()), new SimpleRecord("k2".getBytes(), "v6".getBytes())};
        boolean bl = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        compressionType = null;
        simpleRecordArray = null;
        currentLog.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4(), currentLog.appendAsLeader$default$5());
        currentLog.roll(currentLog.roll$default$1());
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v7".getBytes()), new SimpleRecord("k4".getBytes(), "v8".getBytes())};
        boolean bl2 = false;
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = 0L;
        compressionType2 = null;
        simpleRecordArray2 = null;
        currentLog.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4(), currentLog.appendAsLeader$default$5());
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        boolean bl3 = false;
        long l = -1L;
        long l2 = 0L;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType compressionType3 = CompressionType.NONE;
        byte builder_magic = 2;
        boolean bl4 = false;
        int n = -1;
        int n2 = -1;
        long builder_producerId = -1L;
        compressionType3 = null;
        timestampType = null;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)builder_magic, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)builder_baseOffset, (long)builder_logAppendTime, (long)builder_producerId, (short)builder_producerEpoch, (int)builder_baseSequence, (boolean)builder_isTransactional, (boolean)false, (int)builder_partitionLeaderEpoch);
        builder.appendWithOffset(2L, new SimpleRecord("k1".getBytes(), "v3".getBytes()));
        builder.appendWithOffset(5L, new SimpleRecord("k2".getBytes(), "v6".getBytes()));
        builder.appendWithOffset(6L, new SimpleRecord("k3".getBytes(), "v7".getBytes()));
        builder.appendWithOffset(7L, new SimpleRecord("k4".getBytes(), "v8".getBytes()));
        this.partition().futureLocalLogOrException().appendAsFollower(builder.build());
        Assertions.assertTrue((boolean)this.partition().maybeReplaceCurrentWithFutureReplica());
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertSnapshotError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.empty(), partition);
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false);
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testReadRecordEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testReadRecordEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false);
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false);
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchLatestOffsetIncludesLeaderEpoch() {
        int leaderEpoch = 5;
        Option timestampAndOffsetOpt = this.setupPartitionWithMocks(leaderEpoch, true).fetchOffsetForTimestamp(-1L, (Option)None$.MODULE$, Optional.empty(), true);
        Assertions.assertTrue((boolean)timestampAndOffsetOpt.isDefined());
        FileRecords.TimestampAndOffset timestampAndOffset = (FileRecords.TimestampAndOffset)timestampAndOffsetOpt.get();
        Assertions.assertEquals((int)leaderEpoch, (Integer)((Integer)timestampAndOffset.leaderEpoch.get()));
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testMonotonicOffsetsAfterLeaderChange() {
        block51: {
            block53: {
                block52: {
                    block50: {
                        block47: {
                            block49: {
                                block48: {
                                    block46: {
                                        controllerEpoch = 3;
                                        leader = this.brokerId();
                                        follower1 = this.brokerId() + 1;
                                        follower2 = this.brokerId() + 2;
                                        replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader, follower1, follower2}));
                                        isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
                                        leaderEpoch = 8;
                                        batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes())}))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                        batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v1".getBytes()), new SimpleRecord(20L, "k4".getBytes(), "v2".getBytes()), new SimpleRecord(21L, "k5".getBytes(), "v3".getBytes())}))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                        leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)())).asJava()).setIsNew(true);
                                        Assertions.assertTrue((boolean)this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected first makeLeader() to return 'leader changed'");
                                        Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch(), (String)"Current leader epoch");
                                        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().isrState().isr(), (String)"ISR");
                                        requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
                                        this.partition().appendRecordsToLeader(batch1, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal);
                                        this.partition().appendRecordsToLeader(batch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal);
                                        Assertions.assertEquals((long)this.partition().localLogOrException().logStartOffset(), (long)this.partition().localLogOrException().highWatermark(), (String)"Expected leader's HW not move");
                                        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.alterIsrManager().completeIsrUpdate(2);
                                        Assertions.assertEquals((long)2L, (long)this.partition().localLogOrException().highWatermark());
                                        var12_12 = false;
                                        var13_13 = null;
                                        var14_14 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                                        if (!(var14_14 instanceof Right)) ** GOTO lbl-1000
                                        var12_12 = true;
                                        var13_13 = (Right)var14_14;
                                        var15_15 = (Option)var13_13.value();
                                        if (var15_15 instanceof Some) {
                                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var15_15).value();
                                            Assertions.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                                        } else if (var12_12 && None$.MODULE$.equals(var17_17 = (Option)var13_13.value())) {
                                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                                        } else if (var14_14 instanceof Left) {
                                            (BoxedUnit)Assertions.fail((String)"Should not have seen an error");
                                        } else {
                                            throw new MatchError((Object)var14_14);
                                        }
                                        var18_18 = false;
                                        var19_19 = null;
                                        var20_20 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                        if (!(var20_20 instanceof Right)) ** GOTO lbl-1000
                                        var18_18 = true;
                                        var19_19 = (Right)var20_20;
                                        var21_21 = (Option)var19_19.value();
                                        if (var21_21 instanceof Some) {
                                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var21_21).value();
                                            Assertions.assertEquals((long)2L, (long)offsetAndTimestamp.offset);
                                        } else if (var18_18 && None$.MODULE$.equals(var23_23 = (Option)var19_19.value())) {
                                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                                        } else if (var20_20 instanceof Left) {
                                            (BoxedUnit)Assertions.fail((String)"Should not have seen an error");
                                        } else {
                                            throw new MatchError((Object)var20_20);
                                        }
                                        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(30L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
                                        followerState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(4).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$2$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)())).asJava()).setIsNew(false);
                                        Assertions.assertTrue((boolean)this.partition().makeFollower(followerState, this.offsetCheckpoints(), (Option)None$.MODULE$));
                                        newLeaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(5).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$3$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)())).asJava()).setIsNew(false);
                                        Assertions.assertTrue((boolean)this.partition().makeLeader(newLeaderState, this.offsetCheckpoints(), (Option)None$.MODULE$));
                                        var26_26 = false;
                                        var27_27 = null;
                                        var28_28 = false;
                                        var29_29 = null;
                                        var30_30 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                        if (!(var30_30 instanceof Right)) break block46;
                                        var26_26 = true;
                                        var27_27 = (Right)var30_30;
                                        if (!((Option)var27_27.value() instanceof Some)) break block46;
                                        (BoxedUnit)Assertions.fail((String)"Should have failed with OffsetNotAvailable");
                                        break block47;
                                    }
                                    if (!var26_26 || !None$.MODULE$.equals(var31_31 = (Option)var27_27.value())) break block48;
                                    (BoxedUnit)Assertions.fail((String)"Should have seen an error");
                                    break block47;
                                }
                                if (!(var30_30 instanceof Left)) break block49;
                                var28_28 = true;
                                var29_29 = (Left)var30_30;
                                if ((ApiException)var29_29.value() instanceof OffsetNotAvailableException) break block47;
                            }
                            if (var28_28 && (e = (ApiException)var29_29.value()) != null) {
                                (BoxedUnit)Assertions.fail((String)new StringBuilder(42).append("Expected OffsetNotAvailableException, got ").append(e).toString());
                            } else {
                                throw new MatchError((Object)var30_30);
                            }
                        }
                        var33_33 = false;
                        var34_34 = null;
                        var35_35 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                        if (!(var35_35 instanceof Right)) ** GOTO lbl-1000
                        var33_33 = true;
                        var34_34 = (Right)var35_35;
                        var36_36 = (Option)var34_34.value();
                        if (var36_36 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var36_36).value();
                            Assertions.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                        } else if (var33_33 && None$.MODULE$.equals(var38_38 = (Option)var34_34.value())) {
                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                        } else if (var35_35 instanceof Left && (e = (ApiException)((Left)var35_35).value()) != null) {
                            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var35_35);
                        }
                        var40_40 = false;
                        var41_41 = null;
                        var42_42 = this.fetchOffsetsForTimestamp$1(-2L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var42_42 instanceof Right)) ** GOTO lbl-1000
                        var40_40 = true;
                        var41_41 = (Right)var42_42;
                        var43_43 = (Option)var41_41.value();
                        if (var43_43 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var43_43).value();
                            Assertions.assertEquals((long)0L, (long)offsetAndTimestamp.offset);
                        } else if (var40_40 && None$.MODULE$.equals(var45_45 = (Option)var41_41.value())) {
                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                        } else if (var42_42 instanceof Left && (e = (ApiException)((Left)var42_42).value()) != null) {
                            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var42_42);
                        }
                        var47_47 = false;
                        var48_48 = null;
                        var49_49 = this.fetchOffsetsForTimestamp$1(11L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var49_49 instanceof Right)) ** GOTO lbl-1000
                        var47_47 = true;
                        var48_48 = (Right)var49_49;
                        var50_50 = (Option)var48_48.value();
                        if (var50_50 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var50_50).value();
                            Assertions.assertEquals((long)1L, (long)offsetAndTimestamp.offset);
                            Assertions.assertEquals((long)11L, (long)offsetAndTimestamp.timestamp);
                        } else if (var47_47 && None$.MODULE$.equals(var52_52 = (Option)var48_48.value())) {
                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                        } else if (var49_49 instanceof Left && (e = (ApiException)((Left)var49_49).value()) != null) {
                            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var49_49);
                        }
                        var54_54 = false;
                        var55_55 = null;
                        var56_56 = false;
                        var57_57 = null;
                        var58_58 = this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var58_58 instanceof Right)) break block50;
                        var54_54 = true;
                        var55_55 = (Right)var58_58;
                        if (!((Option)var55_55.value() instanceof Some)) break block50;
                        (BoxedUnit)Assertions.fail((String)"Should have failed");
                        break block51;
                    }
                    if (!var54_54 || !None$.MODULE$.equals(var59_59 = (Option)var55_55.value())) break block52;
                    (BoxedUnit)Assertions.fail((String)"Should have failed");
                    break block51;
                }
                if (!(var58_58 instanceof Left)) break block53;
                var56_56 = true;
                var57_57 = (Left)var58_58;
                if ((ApiException)var57_57.value() instanceof OffsetNotAvailableException) break block51;
            }
            if (var56_56 && (e = (ApiException)var57_57.value()) != null) {
                (BoxedUnit)Assertions.fail((String)new StringBuilder(50).append("Should have seen OffsetNotAvailableException, saw ").append(e).toString());
            } else {
                throw new MatchError((Object)var58_58);
            }
        }
        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.alterIsrManager().completeIsrUpdate(6);
        var61_61 = false;
        var62_62 = null;
        var63_63 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
        if (!(var63_63 instanceof Right)) ** GOTO lbl-1000
        var61_61 = true;
        var62_62 = (Right)var63_63;
        var64_64 = (Option)var62_62.value();
        if (var64_64 instanceof Some) {
            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var64_64).value();
            Assertions.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
        } else if (var61_61 && None$.MODULE$.equals(var66_66 = (Option)var62_62.value())) {
            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
        } else if (var63_63 instanceof Left && (e = (ApiException)((Left)var63_63).value()) != null) {
            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
        } else {
            throw new MatchError((Object)var63_63);
        }
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Log log = this.partition().localLogOrException();
        long initialLogStartOffset = 5L;
        this.partition().truncateFullyAndStartAt(initialLogStartOffset, false);
        Assertions.assertEquals((long)initialLogStartOffset, (long)log.logEndOffset(), (String)new StringBuilder(50).append("Log end offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString());
        Assertions.assertEquals((long)initialLogStartOffset, (long)log.logStartOffset(), (String)new StringBuilder(52).append("Log start offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString());
        Assertions.assertThrows(UnexpectedAppendOffsetException.class, () -> this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())}))), 3L, this.createRecords$default$3()), false));
        Assertions.assertEquals((long)initialLogStartOffset, (long)log.logEndOffset(), (String)"Log end offset should not change after failure to append");
        long newLogStartOffset = 4L;
        MemoryRecords records = this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())}))), newLogStartOffset, this.createRecords$default$3());
        this.partition().appendRecordsToFollowerOrFutureReplica(records, false);
        Assertions.assertEquals((long)7L, (long)log.logEndOffset(), (String)new StringBuilder(59).append("Log end offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString());
        Assertions.assertEquals((long)newLogStartOffset, (long)log.logStartOffset(), (String)new StringBuilder(61).append("Log start offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString());
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())}))), 7L, this.createRecords$default$3()), false);
        Assertions.assertEquals((long)8L, (long)log.logEndOffset(), (String)"Log end offset after append of 1 record at offset 7:");
        Assertions.assertEquals((long)newLogStartOffset, (long)log.logStartOffset(), (String)"Log start offset not expected to change:");
        MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}))), 3L, this.createRecords$default$3());
        Assertions.assertThrows(UnexpectedAppendOffsetException.class, () -> this.partition().appendRecordsToFollowerOrFutureReplica(records2, false));
        Assertions.assertEquals((long)8L, (long)log.logEndOffset(), (String)"Log end offset should not change after failure to append");
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())}))), 8L, this.createRecords$default$3()), false);
        Assertions.assertEquals((long)9L, (long)log.logEndOffset(), (String)"Log end offset after append of 1 record at offset 8:");
        Assertions.assertEquals((long)newLogStartOffset, (long)log.logStartOffset(), (String)"Log start offset not expected to change:");
    }

    @Test
    public void testListOffsetIsolationLevels() {
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        MemoryRecords records = this.createTransactionalRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())}))), 0L);
        this.partition().appendRecordsToLeader(records, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, RequestLocal$.MODULE$.withThreadConfinedCaching());
        Assertions.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
        ((Log)this.partition().log().get()).updateHighWatermark(1L);
        Assertions.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$).offset);
        Assertions.assertEquals((long)1L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)None$.MODULE$).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
    }

    @Test
    public void testGetReplica() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().log());
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> this.partition().localLogOrException());
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())}))), 0L, this.createRecords$default$3()), false));
    }

    @Test
    public void testMakeFollowerWithNoLeaderIdChange() {
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setIsNew(false);
        this.partition().makeFollower(partitionState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setIsNew(false);
        Assertions.assertTrue((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints(), (Option)None$.MODULE$));
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava());
        Assertions.assertFalse((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints(), (Option)None$.MODULE$));
    }

    @Test
    public void testFollowerDoesNotJoinISRUntilCaughtUpToOffsetWithinCurrentLeaderEpoch() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        int leaderEpoch = 8;
        MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v1".getBytes()), new SimpleRecord("k4".getBytes(), "v2".getBytes()), new SimpleRecord("k5".getBytes(), "v3".getBytes())}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        MemoryRecords batch3 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k6".getBytes(), "v1".getBytes()), new SimpleRecord("k7".getBytes(), "v2".getBytes())}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        Assertions.assertTrue((boolean)this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected first makeLeader() to return 'leader changed'");
        Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch(), (String)"Current leader epoch");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().isrState().isr(), (String)"ISR");
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        long lastOffsetOfFirstBatch = this.partition().appendRecordsToLeader(batch1, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal).lastOffset();
        this.partition().appendRecordsToLeader(batch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal);
        Assertions.assertEquals((long)this.partition().localLogOrException().logStartOffset(), (long)((Log)this.partition().log().get()).highWatermark(), (String)"Expected leader's HW not move");
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(0L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(lastOffsetOfFirstBatch, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Assertions.assertEquals((long)lastOffsetOfFirstBatch, (long)((Log)this.partition().log().get()).highWatermark(), (String)"Expected leader's HW");
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState followerState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeFollower(followerState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState newLeaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        Assertions.assertTrue((boolean)this.partition().makeLeader(newLeaderState, this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected makeLeader() to return 'leader changed' after makeFollower()");
        long currentLeaderEpochStartOffset = this.partition().localLogOrException().logEndOffset();
        this.partition().appendRecordsToLeader(batch3, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal);
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(0L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(lastOffsetOfFirstBatch, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().isrState().isr(), (String)"ISR");
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(currentLeaderEpochStartOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().isrState().isr(), (String)"ISR");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().isrState().maximalIsr(), (String)"ISR");
        Assertions.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr().toSet(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader, follower1, follower2})), (String)"AlterIsr");
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords createRecords(Iterable<SimpleRecord> records, long baseOffset, int partitionLeaderEpoch) {
        MemoryRecordsBuilder memoryRecordsBuilder;
        void builder_isTransactional;
        void builder_baseSequence;
        void builder_producerEpoch;
        void builder_logAppendTime;
        void builder_timestampType;
        void builder_compressionType;
        MemoryRecordsBuilder memoryRecordsBuilder2;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)CollectionConverters$.MODULE$.IterableHasAsJava(records).asJava()));
        long l = this.time().milliseconds();
        TimestampType timestampType = TimestampType.LOG_APPEND_TIME;
        CompressionType compressionType = CompressionType.NONE;
        byte builder_magic = 2;
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        long builder_producerId = -1L;
        MemoryRecordsBuilder memoryRecordsBuilder3 = memoryRecordsBuilder2 = MemoryRecords.builder((ByteBuffer)buf, (byte)builder_magic, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)baseOffset, (long)builder_logAppendTime, (long)builder_producerId, (short)builder_producerEpoch, (int)builder_baseSequence, (boolean)builder_isTransactional, (boolean)false, (int)partitionLeaderEpoch);
        memoryRecordsBuilder2 = null;
        MemoryRecordsBuilder memoryRecordsBuilder4 = memoryRecordsBuilder = memoryRecordsBuilder3;
        compressionType = null;
        timestampType = null;
        memoryRecordsBuilder = null;
        MemoryRecordsBuilder builder = memoryRecordsBuilder4;
        records.foreach((Function1 & Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords createTransactionalRecords(Iterable<SimpleRecord> records, long baseOffset) {
        MemoryRecordsBuilder memoryRecordsBuilder;
        void builder_partitionLeaderEpoch;
        void builder_logAppendTime;
        void builder_timestampType;
        MemoryRecordsBuilder memoryRecordsBuilder2;
        long producerId = 1L;
        short producerEpoch = (short)0;
        int baseSequence = 0;
        boolean isTransactional = true;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)CollectionConverters$.MODULE$.IterableHasAsJava(records).asJava()));
        CompressionType builder_compressionType = CompressionType.NONE;
        int n = -1;
        long l = -1L;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        byte builder_magic = 2;
        MemoryRecordsBuilder memoryRecordsBuilder3 = memoryRecordsBuilder2 = MemoryRecords.builder((ByteBuffer)buf, (byte)builder_magic, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)baseOffset, (long)builder_logAppendTime, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional, (boolean)false, (int)builder_partitionLeaderEpoch);
        timestampType = null;
        memoryRecordsBuilder2 = null;
        MemoryRecordsBuilder memoryRecordsBuilder4 = memoryRecordsBuilder = memoryRecordsBuilder3;
        Object var11_8 = null;
        memoryRecordsBuilder = null;
        MemoryRecordsBuilder builder = memoryRecordsBuilder4;
        records.foreach((Function1 & Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    @Test
    public void testAtMinIsr() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader)}))).asJava();
        int leaderEpoch = 8;
        Assertions.assertFalse((boolean)this.partition().isAtMinIsr());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().isAtMinIsr());
    }

    @Test
    public void testUpdateFollowerFetchState() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 6, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        long initializeTimeMs = this.time().milliseconds();
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(500L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(500L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(6L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((long)this.time().milliseconds(), (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)6L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
    }

    @Test
    public void testIsrExpansion() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> PartitionTest.$anonfun$testIsrExpansion$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().isrState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr(), (Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().maximalIsr());
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.alterIsrManager().completeIsrUpdate(2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((int)this.isrChangeListener().expands().get(), (int)1);
        Assertions.assertEquals((int)this.isrChangeListener().shrinks().get(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().failures().get(), (int)0);
    }

    @Test
    public void testIsrNotExpandedIfUpdateFails() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().isrState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.alterIsrManager().failIsrUpdate(Errors.INVALID_UPDATE_VERSION);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().expands().get(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().shrinks().get(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().failures().get(), (int)1);
    }

    @Test
    public void testMaybeShrinkIsr() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> PartitionTest.$anonfun$testMaybeShrinkIsr$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr(), (Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().maximalIsr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testAlterIsrLeaderAndIsrRace() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> PartitionTest.$anonfun$testAlterIsrLeaderAndIsrRace$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assertions.assertTrue((boolean)this.partition().isrState().isInflight());
        Assertions.assertFalse((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(2).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> PartitionTest.$anonfun$testAlterIsrLeaderAndIsrRace$2(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setIsNew(false), this.offsetCheckpoints(), (Option)None$.MODULE$));
        Assertions.assertFalse((boolean)this.partition().isrState().isInflight(), (String)"ISR should be committed and not inflight");
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assertions.assertFalse((boolean)this.partition().isrState().isInflight(), (String)"ISR should still be committed and not inflight");
        this.alterIsrManager().completeIsrUpdate(10);
        this.partition().maybeShrinkIsr();
        Assertions.assertTrue((boolean)this.partition().isrState().isInflight(), (String)"ISR should be pending a shrink");
    }

    @Test
    public void testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> PartitionTest.$anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(5000L);
        long firstFetchTimeMs = this.time().milliseconds();
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(5L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, firstFetchTimeMs, 10L);
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)5L, (long)this.partition().localLogOrException().highWatermark());
        Assertions.assertEquals((long)5L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(5001L);
        this.seedLogData(log, 5, leaderEpoch);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 15L);
        Assertions.assertEquals((long)firstFetchTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    @Test
    public void testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> PartitionTest.$anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(30001L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    @Test
    public void testIsrNotShrunkIfUpdateFails() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(30001L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.alterIsrManager().failIsrUpdate(Errors.INVALID_UPDATE_VERSION);
        Assertions.assertEquals(this.partition().isrState().getClass(), PendingShrinkIsr.class);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testAlterIsrUnknownTopic() {
        this.handleAlterIsrFailure(Errors.UNKNOWN_TOPIC_OR_PARTITION, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrUnknownTopic$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterIsrInvalidVersion() {
        this.handleAlterIsrFailure(Errors.INVALID_UPDATE_VERSION, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrInvalidVersion$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterIsrUnexpectedError() {
        this.handleAlterIsrFailure(Errors.UNKNOWN_SERVER_ERROR, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrUnexpectedError$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    public void handleAlterIsrFailure(Errors error, Function3<Object, Object, Partition, BoxedUnit> callback) {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().isrState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.alterIsrManager().failIsrUpdate(error);
        callback.apply((Object)BoxesRunTime.boxToInteger((int)this.brokerId()), (Object)BoxesRunTime.boxToInteger((int)remoteBrokerId), (Object)this.partition());
    }

    @Test
    public void testSingleInFlightAlterIsr() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int follower3 = this.brokerId() + 3;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2), Predef$.MODULE$.int2Integer(follower3)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteAll();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.partition().expandIsr(follower3);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3})), (Object)this.partition().isrState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        this.partition().shrinkIsr((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{follower3})));
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
    }

    @Test
    public void testZkIsrManagerAsyncCallback() {
        KafkaScheduler scheduler = new KafkaScheduler(1, "zk-isr-test", true);
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$2 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        MockTime apply_time = this.time();
        Object var28_3 = null;
        ZkIsrManager zkIsrManager = new ZkIsrManager((Scheduler)scheduler, (Time)apply_time, kafkaZkClient);
        zkIsrManager.start();
        Partition partition = new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), (ApiVersion)KAFKA_2_6_IV0$.MODULE$, this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterIsrManager)zkIsrManager);
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$22 = None$.MODULE$;
        boolean x$32 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$32, x$4, (Option)x$22);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int follower3 = this.brokerId() + 3;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2), Predef$.MODULE$.int2Integer(follower3)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteAll();
        partition.createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2})), (Object)partition.isrState().isr());
        Assertions.assertEquals((long)0L, (long)partition.localLogOrException().highWatermark());
        partition.expandIsr(follower3);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionTest.$anonfun$testZkIsrManagerAsyncCallback$2(partition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected ISR state to be committed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        IsrState isrState = partition.isrState();
        if (isrState instanceof CommittedIsr) {
            CommittedIsr committedIsr = (CommittedIsr)isrState;
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3})), (Object)committedIsr.isr());
        } else {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Expected a committed ISR following Zk expansion");
        }
        ((KafkaZkClient)Mockito.doAnswer(x$3 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)2), (Option)ArgumentMatchers.any());
        partition.expandIsr(follower3);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PartitionTest.$anonfun$testZkIsrManagerAsyncCallback$5(partition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Expected ISR state to be committed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), l2));
        }
        scheduler.shutdown();
    }

    @Test
    public void testUseCheckpointToInitializeHighWatermark() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 6, 5);
        Mockito.when((Object)this.offsetCheckpoints().fetch(this.logDir1().getAbsolutePath(), this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)4L)));
        int controllerEpoch = 3;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertEquals((long)4L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testTopicIdAndPartitionMetadataFileForLeader() {
        int controllerEpoch = 3;
        int leaderEpoch = 5;
        Uuid topicId = Uuid.randomUuid();
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)new Some((Object)topicId));
        this.checkTopicId(topicId, this.partition());
        Partition partition2 = new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterIsrManager)this.alterIsrManager());
        Assertions.assertTrue((boolean)partition2.topicId().isDefined());
        Assertions.assertEquals((Object)topicId, (Object)partition2.topicId().get());
        Assertions.assertFalse((boolean)partition2.log().isDefined());
        Assertions.assertThrows(InconsistentTopicIdException.class, () -> partition2.makeLeader(leaderState, this.offsetCheckpoints(), (Option)new Some((Object)Uuid.randomUuid())));
        partition2.makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        this.checkTopicId(topicId, partition2);
    }

    @Test
    public void testTopicIdAndPartitionMetadataFileForFollower() {
        int controllerEpoch = 3;
        int leaderEpoch = 5;
        Uuid topicId = Uuid.randomUuid();
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeFollower(leaderState, this.offsetCheckpoints(), (Option)new Some((Object)topicId));
        this.checkTopicId(topicId, this.partition());
        Partition partition2 = new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterIsrManager)this.alterIsrManager());
        Assertions.assertTrue((boolean)partition2.topicId().isDefined());
        Assertions.assertEquals((Object)topicId, (Object)partition2.topicId().get());
        Assertions.assertFalse((boolean)partition2.log().isDefined());
        Assertions.assertThrows(InconsistentTopicIdException.class, () -> partition2.makeFollower(leaderState, this.offsetCheckpoints(), (Option)new Some((Object)Uuid.randomUuid())));
        partition2.makeFollower(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        this.checkTopicId(topicId, partition2);
    }

    public void checkTopicId(Uuid expectedTopicId, Partition partition) {
        Assertions.assertTrue((boolean)partition.topicId().isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)partition.topicId().get());
        Assertions.assertTrue((boolean)partition.log().isDefined());
        Log log = (Log)partition.log().get();
        Assertions.assertEquals((Object)expectedTopicId, (Object)log.topicId().get());
        Assertions.assertTrue((boolean)log.partitionMetadataFile().exists());
        Assertions.assertEquals((Object)expectedTopicId, (Object)log.partitionMetadataFile().read().topicId());
    }

    @Test
    public void testAddAndRemoveMetrics() {
        Assertions.assertTrue((boolean)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"UnderReplicated", "UnderMinIsr", "InSyncReplicasCount", "ReplicasCount", "LastStableOffsetLag", "AtMinIsr"}))).forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$3(x$5))));
        Partition$.MODULE$.removeMetrics(this.topicPartition());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().keySet().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$4(x$6))));
    }

    @Test
    public void testUnderReplicatedPartitionsCorrectSemantics() {
        int controllerEpoch = 3;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1), Predef$.MODULE$.int2Integer(this.brokerId() + 2)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().isUnderReplicated());
        leaderState = leaderState.setIsr(replicas);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertFalse((boolean)this.partition().isUnderReplicated());
    }

    @Test
    public void testUpdateAssignmentAndIsr() {
        TopicPartition topicPartition = new TopicPartition("test", 1);
        Partition partition = new Partition(topicPartition, 1000L, ApiVersion$.MODULE$.latestVersion(), 0, (Time)new SystemTime(), (IsrChangeListener)Mockito.mock(IsrChangeListener.class), (DelayedOperations)Mockito.mock(DelayedOperations.class), (MetadataCache)Mockito.mock(MetadataCache.class), (LogManager)Mockito.mock(LogManager.class), (AlterIsrManager)Mockito.mock(AlterIsrManager.class));
        scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        scala.collection.immutable.Seq adding = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5}));
        scala.collection.immutable.Seq removing = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        partition.updateAssignmentAndIsr((Seq)replicas, isr, (Seq)adding, (Seq)removing);
        Assertions.assertTrue((boolean)(partition.assignmentState() instanceof OngoingReassignmentState), (String)"The assignmentState is not OngoingReassignmentState");
        Assertions.assertEquals((Object)replicas, (Object)partition.assignmentState().replicas());
        Assertions.assertEquals((Object)isr, (Object)partition.isrState().isr());
        Assertions.assertEquals((Object)adding, (Object)((OngoingReassignmentState)partition.assignmentState()).addingReplicas());
        Assertions.assertEquals((Object)removing, (Object)((OngoingReassignmentState)partition.assignmentState()).removingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)partition.remoteReplicas().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.brokerId())));
        scala.collection.immutable.Seq replicas2 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 4, 5}));
        scala.collection.immutable.Set isr2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 4, 5}));
        partition.updateAssignmentAndIsr((Seq)replicas2, isr2, (Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty());
        Assertions.assertTrue((boolean)(partition.assignmentState() instanceof SimpleAssignmentState), (String)"The assignmentState is not SimpleAssignmentState");
        Assertions.assertEquals((Object)replicas2, (Object)partition.assignmentState().replicas());
        Assertions.assertEquals((Object)isr2, (Object)partition.isrState().isr());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), (Object)partition.remoteReplicas().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.brokerId())));
    }

    @Test
    public void testLogConfigNotDirty() {
        String string;
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)this.configRepository());
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        String string2 = string = "MD5";
        string = null;
        String x$9 = string2;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), spyConfigRepository, new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$9), this.time(), ApiVersion$.MODULE$.latestVersion()));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(this.topicPartition().topic());
    }

    @Test
    public void testLogConfigDirtyAsTopicUpdated() {
        String string;
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)this.configRepository());
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        String string2 = string = "MD5";
        string = null;
        String x$92 = string2;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), spyConfigRepository, new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$92), this.time(), ApiVersion$.MODULE$.latestVersion()));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer(x$9 -> {
            PartitionTest.$anonfun$testLogConfigDirtyAsTopicUpdated$1(this, x$9);
            return BoxedUnit.UNIT;
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)2))).topicConfig(this.topicPartition().topic());
    }

    @Test
    public void testLogConfigDirtyAsBrokerUpdated() {
        String string;
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)this.configRepository());
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        String string2 = string = "MD5";
        string = null;
        String x$9 = string2;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), spyConfigRepository, new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$9), this.time(), ApiVersion$.MODULE$.latestVersion()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer(x$10 -> {
            PartitionTest.$anonfun$testLogConfigDirtyAsBrokerUpdated$1(this, x$10);
            return BoxedUnit.UNIT;
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)2))).topicConfig(this.topicPartition().topic());
    }

    private void seedLogData(Log log, int numRecords, int leaderEpoch) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable)i -> PartitionTest.$anonfun$seedLogData$1(leaderEpoch, log, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ SimpleRecord $anonfun$testLastFetchedOffsetValidation$1(int i) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
    }

    /*
     * WARNING - void declaration
     */
    private static final void append$1(int leaderEpoch, int count, Log log$1) {
        void withRecords_records;
        void withRecords_compressionType;
        MemoryRecords memoryRecords;
        IndexedSeq recordArray = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable)i -> PartitionTest.$anonfun$testLastFetchedOffsetValidation$1(BoxesRunTime.unboxToInt((Object)i)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])recordArray.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)leaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        compressionType = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords2;
        log$1.appendAsLeader(records, leaderEpoch, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5());
    }

    private static final FetchResponseData.EpochEndOffset epochEndOffset$1(int epoch, long endOffset) {
        return new FetchResponseData.EpochEndOffset().setEpoch(epoch).setEndOffset(endOffset);
    }

    private static final LogReadInfo read$1(int lastFetchedEpoch, long fetchOffset, Partition partition$1, int leaderEpoch$1) {
        return partition$1.readRecords(Optional.of(Predef$.MODULE$.int2Integer(lastFetchedEpoch)), fetchOffset, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch$1)), Integer.MAX_VALUE, (FetchIsolation)FetchLogEnd$.MODULE$, true, true);
    }

    private static final void assertDivergence$1(FetchResponseData.EpochEndOffset divergingEpoch, LogReadInfo readInfo) {
        Assertions.assertEquals((Object)new Some((Object)divergingEpoch), (Object)readInfo.divergingEpoch());
        Assertions.assertEquals((int)0, (int)readInfo.fetchedData().records().sizeInBytes());
    }

    private static final void assertNoDivergence$1(LogReadInfo readInfo) {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)readInfo.divergingEpoch());
    }

    public static final /* synthetic */ boolean $anonfun$testMakeFollowerWithWithFollowerAppendRecords$1(Semaphore appendSemaphore$1) {
        return appendSemaphore$1.hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testMakeFollowerWithWithFollowerAppendRecords$2() {
        return "follower log append is not called.";
    }

    private static final void assertSnapshotError$1(Errors expectedError, Optional currentLeaderEpoch, Partition partition$2) {
        try {
            partition$2.fetchOffsetSnapshot(currentLeaderEpoch, true);
            Assertions.assertEquals((Object)Errors.NONE, (Object)expectedError);
            return;
        }
        catch (ApiException error) {
            Assertions.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)error));
            return;
        }
    }

    private static final void assertSnapshotError$2(Errors expectedError, Optional currentLeaderEpoch, boolean fetchOnlyLeader, Partition partition$3) {
        try {
            partition$3.fetchOffsetSnapshot(currentLeaderEpoch, fetchOnlyLeader);
            Assertions.assertEquals((Object)Errors.NONE, (Object)expectedError);
            return;
        }
        catch (ApiException error) {
            Assertions.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)error));
            return;
        }
    }

    private static final void assertLastOffsetForLeaderError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$4) {
        OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = partition$4.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, true);
        Assertions.assertEquals((short)error.code(), (short)endOffset.errorCode());
    }

    private static final void assertLastOffsetForLeaderError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$5) {
        OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = partition$5.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, fetchOnlyLeader);
        Assertions.assertEquals((short)error.code(), (short)endOffset.errorCode());
    }

    private static final void assertReadRecordsError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$6) {
        try {
            partition$6.readRecords(Optional.empty(), 0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertReadRecordsError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$7) {
        try {
            partition$7.readRecords(Optional.empty(), 0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, fetchOnlyLeader, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$8) {
        try {
            partition$8.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, true);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$9) {
        try {
            partition$9.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, fetchOnlyLeader);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private final void updateFollowerFetchState$1(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset());
    }

    private final Either fetchOffsetsForTimestamp$1(long timestamp, Option isolation) {
        try {
            return package$.MODULE$.Right().apply((Object)this.partition().fetchOffsetForTimestamp(timestamp, isolation, Optional.of(Predef$.MODULE$.int2Integer(this.partition().getLeaderEpoch())), true));
        }
        catch (ApiException e) {
            return package$.MODULE$.Left().apply((Object)e);
        }
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$3(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private final FileRecords.TimestampAndOffset fetchLatestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-1L, isolationLevel, Optional.empty(), true);
        Assertions.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final FileRecords.TimestampAndOffset fetchEarliestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-2L, isolationLevel, Optional.empty(), true);
        Assertions.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final void updateFollowerFetchState$2(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset());
    }

    public static final /* synthetic */ Integer $anonfun$testIsrExpansion$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testMaybeShrinkIsr$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testAlterIsrLeaderAndIsrRace$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testAlterIsrLeaderAndIsrRace$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ void $anonfun$testAlterIsrUnknownTopic$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        Assertions.assertEquals((Object)partition.isrState().isr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})));
        Assertions.assertEquals((Object)partition.isrState().maximalIsr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId})));
        Assertions.assertEquals((int)$this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    public static final /* synthetic */ void $anonfun$testAlterIsrInvalidVersion$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        Assertions.assertEquals((Object)partition.isrState().isr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})));
        Assertions.assertEquals((Object)partition.isrState().maximalIsr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId})));
        Assertions.assertEquals((int)$this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    public static final /* synthetic */ void $anonfun$testAlterIsrUnexpectedError$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        Assertions.assertEquals((Object)partition.isrState().isr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})));
        Assertions.assertEquals((Object)partition.isrState().maximalIsr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId})));
        Assertions.assertEquals((int)$this.alterIsrManager().isrUpdates().size(), (int)1);
    }

    public static final /* synthetic */ boolean $anonfun$testZkIsrManagerAsyncCallback$2(Partition partition$10) {
        return !partition$10.isrState().isInflight();
    }

    public static final /* synthetic */ String $anonfun$testZkIsrManagerAsyncCallback$3() {
        return "Expected ISR state to be committed";
    }

    public static final /* synthetic */ boolean $anonfun$testZkIsrManagerAsyncCallback$5(Partition partition$10) {
        return !partition$10.isrState().isInflight();
    }

    public static final /* synthetic */ String $anonfun$testZkIsrManagerAsyncCallback$6() {
        return "Expected ISR state to be committed";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$1(String metric$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metricName = (MetricName)x0$1._1();
        String string = metricName.getName();
        if (string == null) {
            if (metric$1 != null) {
                return false;
            }
        } else if (!string.equals(metric$1)) return false;
        String string2 = metricName.getType();
        String string3 = "Partition";
        if (string2 == null) return false;
        if (!string2.equals(string3)) return false;
        return true;
    }

    private static final Option getMetric$1(String metric) {
        return ((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$1(metric, x0$1)))).headOption().map((Function1 & Serializable)x$4 -> (Metric)x$4._2());
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$3(String x$5) {
        return PartitionTest.getMetric$1(x$5).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$4(MetricName x$6) {
        String string = x$6.getType();
        String string2 = "Partition";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testLogConfigDirtyAsTopicUpdated$1(PartitionTest $this, InvocationOnMock x$9) {
        $this.logManager().initializingLog($this.topicPartition());
        $this.logManager().topicConfigUpdated($this.topicPartition().topic());
    }

    public static final /* synthetic */ void $anonfun$testLogConfigDirtyAsBrokerUpdated$1(PartitionTest $this, InvocationOnMock x$10) {
        $this.logManager().initializingLog($this.topicPartition());
        $this.logManager().brokerConfigUpdated();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ LogAppendInfo $anonfun$seedLogData$1(int leaderEpoch$2, Log log$2, int i) {
        void withRecords_records;
        void withRecords_compressionType;
        MemoryRecords memoryRecords;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(new StringBuilder(1).append("k").append(i).toString().getBytes(), new StringBuilder(1).append("v").append(i).toString().getBytes())};
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)leaderEpoch$2, (boolean)false, (SimpleRecord[])withRecords_records);
        compressionType = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords2;
        return log$2.appendAsLeader(records, leaderEpoch$2, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4(), log$2.appendAsLeader$default$5());
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$1(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$2$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$2(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$3$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$3(BoxesRunTime.unboxToInt((Object)x));
    }

    private class SlowLog
    extends Log {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionTest $outer;

        public LogAppendInfo appendAsFollower(MemoryRecords records) {
            this.appendSemaphore.acquire();
            return super.appendAsFollower(records);
        }

        public /* synthetic */ PartitionTest kafka$cluster$PartitionTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionTest $outer, Log log, LogSegments segments, LoadedLogOffsets offsets, Option<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, MockTime mockTime, LogDirFailureChannel logDirFailureChannel, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(log.dir(), log.config(), segments, offsets.logStartOffset(), offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)mockTime.scheduler(), new BrokerTopicStats(), (Time)mockTime, log.producerIdExpirationCheckIntervalMs(), log.topicPartition(), leaderEpochCache, producerStateManager, logDirFailureChannel, (Option)None$.MODULE$, true);
        }
    }
}

