/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.LastRecord;
import kafka.log.LocalLog$;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.log.TransactionIndex;
import kafka.log.UnifiedLog;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u001de!\u0002\u0012$\u0001\r:\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\t\u0011i\u0002!\u0011!Q\u0001\n]B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005{!A!\t\u0001B\u0001B\u0003%q\u0007\u0003\u0005D\u0001\t\u0005\t\u0015!\u00038\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\u0006I\u0002!\t!\u001a\u0005\u0006_\u0002!\t\u0006\u001d\u0005\bs\u0002\u0001\r\u0011\"\u0003{\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)\u0001C\u0004\u0002\f\u0001\u0001\u000b\u0015B>\t\u0011\u00055\u0001\u00011A\u0005\niD\u0011\"a\u0004\u0001\u0001\u0004%I!!\u0005\t\u000f\u0005U\u0001\u0001)Q\u0005w\"I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011\u0004\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u001c!A\u00111\u0005\u0001\u0005\u0002\r\n)\u0003\u0003\u0005\u0002D\u0001!\taIA#\u0011!\ti\u0005\u0001C\u0001G\u0005=\u0003\u0002CAD\u0001\u0011\u00051%!#\t\u000f\u0005u\u0007\u0001\"\u0003\u0002`\"9\u00111\u001f\u0001\u0005\n\u0005U\bb\u0002B\u0002\u0001\u0011%!Q\u0001\u0005\b\u00057\u0001A\u0011\u0001B\u000f\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005GA\u0001B!\n\u0001\t\u0003\u0019#q\u0005\u0005\b\u0005\u001f\u0002A\u0011\u0002B)\u0011!\u0011Y\u0006\u0001C\u0001G\tu\u0003b\u0002B7\u0001\u0011%!q\u000e\u0002\b\u00072,\u0017M\\3s\u0015\t!S%A\u0002m_\u001eT\u0011AJ\u0001\u0006W\u000647.Y\n\u0004\u0001!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020e5\t\u0001G\u0003\u00022K\u0005)Q\u000f^5mg&\u00111\u0007\r\u0002\b\u0019><w-\u001b8h\u0003\tIGm\u0001\u0001\u0016\u0003]\u0002\"!\u000b\u001d\n\u0005eR#aA%oi\u0006\u0019\u0011\u000e\u001a\u0011\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u001f\u0011\u0005yzT\"A\u0012\n\u0005\u0001\u001b#!C(gMN,G/T1q\u0003)ygMZ:fi6\u000b\u0007\u000fI\u0001\rS>\u0014UO\u001a4feNK'0Z\u0001\u0010[\u0006D\u0018j\u001c\"vM\u001a,'oU5{K\u0006\u0019B-\u001e9Ck\u001a4WM\u001d'pC\u00124\u0015m\u0019;peB\u0011\u0011FR\u0005\u0003\u000f*\u0012a\u0001R8vE2,\u0017!\u0003;ie>$H\u000f\\3s!\ty#*\u0003\u0002La\tIA\u000b\u001b:piRdWM]\u0001\u0005i&lW\r\u0005\u0002O/6\tqJ\u0003\u00022!*\u0011\u0011KU\u0001\u0007G>lWn\u001c8\u000b\u0005\u0019\u001a&B\u0001+V\u0003\u0019\t\u0007/Y2iK*\ta+A\u0002pe\u001eL!\u0001W(\u0003\tQKW.Z\u0001\nG\",7m\u001b#p]\u0016\u0004B!K.^C&\u0011AL\u000b\u0002\n\rVt7\r^5p]F\u0002\"AX0\u000e\u0003AK!\u0001\u0019)\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0011FY\u0005\u0003G*\u0012A!\u00168ji\u00061A(\u001b8jiz\"\u0012BZ4iS*\\G.\u001c8\u0011\u0005y\u0002\u0001\"\u0002\u001b\f\u0001\u00049\u0004\"B\u001e\f\u0001\u0004i\u0004\"\u0002\"\f\u0001\u00049\u0004\"B\"\f\u0001\u00049\u0004\"\u0002#\f\u0001\u0004)\u0005\"\u0002%\f\u0001\u0004I\u0005\"\u0002'\f\u0001\u0004i\u0005\"B-\f\u0001\u0004Q\u0016A\u00037pO\u001e,'OT1nKV\t\u0011\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u0006!A.\u00198h\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_:\u0003\rM#(/\u001b8h\u0003)\u0011X-\u00193Ck\u001a4WM]\u000b\u0002wB\u0011Ap`\u0007\u0002{*\u0011a0^\u0001\u0004]&|\u0017bAA\u0001{\nQ!)\u001f;f\u0005V4g-\u001a:\u0002\u001dI,\u0017\r\u001a\"vM\u001a,'o\u0018\u0013fcR\u0019\u0011-a\u0002\t\u0011\u0005%a\"!AA\u0002m\f1\u0001\u001f\u00132\u0003-\u0011X-\u00193Ck\u001a4WM\u001d\u0011\u0002\u0017]\u0014\u0018\u000e^3Ck\u001a4WM]\u0001\u0010oJLG/\u001a\"vM\u001a,'o\u0018\u0013fcR\u0019\u0011-a\u0005\t\u0011\u0005%\u0011#!AA\u0002m\fAb\u001e:ji\u0016\u0014UO\u001a4fe\u0002\n1\u0004Z3d_6\u0004(/Z:tS>t')\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014XCAA\u000e!\rq\u0015QD\u0005\u0004\u0003?y%A\u0004\"vM\u001a,'oU;qa2LWM]\u0001\u001dI\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8Ck\u001a4WM]*vaBd\u0017.\u001a:!\u0003\u0015\u0019G.Z1o)\u0011\t9#!\u000f\u0011\u000f%\nI#!\f\u00024%\u0019\u00111\u0006\u0016\u0003\rQ+\b\u000f\\33!\rI\u0013qF\u0005\u0004\u0003cQ#\u0001\u0002'p]\u001e\u00042APA\u001b\u0013\r\t9d\t\u0002\r\u00072,\u0017M\\3s'R\fGo\u001d\u0005\b\u0003w)\u0002\u0019AA\u001f\u0003%\u0019G.Z1oC\ndW\rE\u0002?\u0003\u007fI1!!\u0011$\u0005)aun\u001a+p\u00072,\u0017M\\\u0001\bI>\u001cE.Z1o)\u0019\t9#a\u0012\u0002J!9\u00111\b\fA\u0002\u0005u\u0002bBA&-\u0001\u0007\u0011QF\u0001\fGV\u0014(/\u001a8u)&lW-A\u0007dY\u0016\fgnU3h[\u0016tGo\u001d\u000b\u0010C\u0006E\u0013\u0011LA8\u0003g\n)(!\u001f\u0002\u0004\"1Ae\u0006a\u0001\u0003'\u00022APA+\u0013\r\t9f\t\u0002\u000b+:Lg-[3e\u0019><\u0007bBA./\u0001\u0007\u0011QL\u0001\tg\u0016<W.\u001a8ugB1\u0011qLA3\u0003Sj!!!\u0019\u000b\u0007\u0005\r$&\u0001\u0006d_2dWm\u0019;j_:LA!a\u001a\u0002b\t\u00191+Z9\u0011\u0007y\nY'C\u0002\u0002n\r\u0012!\u0002T8h'\u0016<W.\u001a8u\u0011\u0019\t\th\u0006a\u0001{\u0005\u0019Q.\u00199\t\u000f\u0005-s\u00031\u0001\u0002.!9\u0011qO\fA\u0002\u0005M\u0012!B:uCR\u001c\bbBA>/\u0001\u0007\u0011QP\u0001\u0014iJ\fgn]1di&|g.T3uC\u0012\fG/\u0019\t\u0004}\u0005}\u0014bAAAG\tQ2\t\\3b]\u0016$GK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\"9\u0011QQ\fA\u0002\u00055\u0012!\u00067fO\u0006\u001c\u0017\u0010R3mKR,\u0007j\u001c:ju>tWj]\u0001\nG2,\u0017M\\%oi>$r#YAF\u0003\u001f\u000by*a)\u0002&\u0006=\u00161WA\\\u0003s\u000bI.a7\t\r\u00055\u0005\u00041\u0001^\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!%\u0019\u0001\u0004\t\u0019*A\u0007t_V\u00148-\u001a*fG>\u0014Hm\u001d\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\u0014)\u0002\rI,7m\u001c:e\u0013\u0011\ti*a&\u0003\u0017\u0019KG.\u001a*fG>\u0014Hm\u001d\u0005\b\u0003CC\u0002\u0019AA5\u0003\u0011!Wm\u001d;\t\r\u0005E\u0004\u00041\u0001>\u0011\u001d\t9\u000b\u0007a\u0001\u0003S\u000b\u0001E]3uC&tG*Z4bGf$U\r\\3uKN\fe\u000e\u001a+y]6\u000b'o[3sgB\u0019\u0011&a+\n\u0007\u00055&FA\u0004C_>dW-\u00198\t\u000f\u0005E\u0006\u00041\u0001\u0002.\u0005\tB-\u001a7fi\u0016\u0014V\r^3oi&|g.T:\t\r\u0005U\u0006\u00041\u00018\u0003Ei\u0017\r\u001f'pO6+7o]1hKNK'0\u001a\u0005\b\u0003wB\u0002\u0019AA?\u0011\u001d\tY\f\u0007a\u0001\u0003{\u000bA\u0004\\1tiJ+7m\u001c:eg>3\u0017i\u0019;jm\u0016\u0004&o\u001c3vG\u0016\u00148\u000f\u0005\u0005\u0002@\u00065\u0017QFAj\u001d\u0011\t\t-!3\u0011\u0007\u0005\r'&\u0004\u0002\u0002F*\u0019\u0011qY\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\tYMK\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0017\u0011\u001b\u0002\u0004\u001b\u0006\u0004(bAAfUA\u0019a(!6\n\u0007\u0005]7E\u0001\u0006MCN$(+Z2pe\u0012Dq!a\u001e\u0019\u0001\u0004\t\u0019\u0004C\u0004\u0002La\u0001\r!!\f\u0002#\u001d\u0014xn\u001e\"vM\u001a,'o](s\r\u0006LG\u000eF\u0005b\u0003C\f\u0019/a:\u0002j\"9\u0011\u0011S\rA\u0002\u0005M\u0005BBAs3\u0001\u0007q'\u0001\u0005q_NLG/[8o\u0011\u0019\t),\u0007a\u0001o!9\u00111^\rA\u0002\u00055\u0018!D7f[>\u0014\u0018PU3d_J$7\u000f\u0005\u0003\u0002\u0016\u0006=\u0018\u0002BAy\u0003/\u0013Q\"T3n_JL(+Z2pe\u0012\u001c\u0018AE:i_VdG\rR5tG\u0006\u0014HMQ1uG\"$b!!+\u0002x\n\u0005\u0001bBA}5\u0001\u0007\u00111`\u0001\u0006E\u0006$8\r\u001b\t\u0005\u0003+\u000bi0\u0003\u0003\u0002\u0000\u0006]%a\u0003*fG>\u0014HMQ1uG\"Dq!a\u001f\u001b\u0001\u0004\ti(\u0001\ntQ>,H\u000e\u001a*fi\u0006LgNU3d_J$GCDAU\u0005\u000f\u0011IA!\u0004\u0003\u0010\t]!\u0011\u0004\u0005\u0007\u0003cZ\u0002\u0019A\u001f\t\u000f\t-1\u00041\u0001\u0002*\u0006i\"/\u001a;bS:$U\r\\3uKN4uN\u001d'fO\u0006\u001c\u0017PU3d_J$7\u000fC\u0004\u0002zn\u0001\r!a?\t\u000f\u0005e5\u00041\u0001\u0003\u0012A!\u0011Q\u0013B\n\u0013\u0011\u0011)\"a&\u0003\rI+7m\u001c:e\u0011\u001d\t9h\u0007a\u0001\u0003gAq!a\u0013\u001c\u0001\u0004\ti#A\u0006he><()\u001e4gKJ\u001cHcA1\u0003 !1\u0011Q\u0017\u000fA\u0002]\naB]3ti>\u0014XMQ;gM\u0016\u00148\u000fF\u0001b\u0003M9'o\\;q'\u0016<W.\u001a8ug\nK8+\u001b>f))\u0011ICa\u000f\u0003D\t\u001d#1\n\t\u0007\u0005W\u0011)$!\u0018\u000f\t\t5\"\u0011\u0007\b\u0005\u0003\u0007\u0014y#C\u0001,\u0013\r\u0011\u0019DK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00119D!\u000f\u0003\t1K7\u000f\u001e\u0006\u0004\u0005gQ\u0003bBA.=\u0001\u0007!Q\b\t\u0007\u0003?\u0012y$!\u001b\n\t\t\u0005\u0013\u0011\r\u0002\t\u0013R,'/\u00192mK\"1!Q\t\u0010A\u0002]\nq!\\1y'&TX\r\u0003\u0004\u0003Jy\u0001\raN\u0001\r[\u0006D\u0018J\u001c3fqNK'0\u001a\u0005\b\u0005\u001br\u0002\u0019AA\u0017\u0003Y1\u0017N]:u+:\u001cG.Z1oC\ndWm\u00144gg\u0016$\u0018!\u00077bgR|eMZ:fi\u001a{'OR5sgR\u001cVmZ7f]R$b!!\f\u0003T\te\u0003b\u0002B+?\u0001\u0007!qK\u0001\u0005g\u0016<7\u000f\u0005\u0004\u0003,\tU\u0012\u0011\u000e\u0005\b\u0005\u001bz\u0002\u0019AA\u0017\u00039\u0011W/\u001b7e\u001f\u001a47/\u001a;NCB$2\"\u0019B0\u0005C\u0012)G!\u001b\u0003l!1A\u0005\ta\u0001\u0003'BqAa\u0019!\u0001\u0004\ti#A\u0003ti\u0006\u0014H\u000fC\u0004\u0003h\u0001\u0002\r!!\f\u0002\u0007\u0015tG\r\u0003\u0004\u0002r\u0001\u0002\r!\u0010\u0005\b\u0003o\u0002\u0003\u0019AA\u001a\u0003a\u0011W/\u001b7e\u001f\u001a47/\u001a;NCB4uN]*fO6,g\u000e\u001e\u000b\u0013\u0003S\u0013\tHa\u001d\u0003x\te$Q\u0010BA\u0005\u0007\u0013)\t\u0003\u0004\u0002\u000e\u0006\u0002\r!\u0018\u0005\b\u0005k\n\u0003\u0019AA5\u0003\u001d\u0019XmZ7f]RDa!!\u001d\"\u0001\u0004i\u0004b\u0002B>C\u0001\u0007\u0011QF\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0004\u0003\u0000\u0005\u0002\r!!\f\u0002-9,\u0007\u0010^*fO6,g\u000e^*uCJ$xJ\u001a4tKRDa!!.\"\u0001\u00049\u0004bBA>C\u0001\u0007\u0011Q\u0010\u0005\b\u0003o\n\u0003\u0019AA\u001a\u0001")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        return this.doClean(cleanable, this.time.milliseconds());
    }

    public Tuple2<Object, CleanerStats> doClean(LogToClean cleanable, long currentTime) {
        long l;
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Beginning cleaning of log %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        Option option = cleanable.log().logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            l = ((LogSegment)((Some)option).value()).lastModified() - Predef$.MODULE$.Long2long(cleanable.log().config().deleteRetentionMs());
        } else {
            throw new MatchError((Object)option);
        }
        UnifiedLog log = cleanable.log();
        CleanerStats stats = new CleanerStats(Time.SYSTEM);
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Building offset map for %s..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)log.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.lastModified())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to upper bound deletion horizon %s)..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(l)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        this.groupSegmentsBySize(log.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize()), cleanable.firstUncleanableOffset()).foreach((Function1 & Serializable)group -> {
            this.cleanSegments(log, (Seq<LogSegment>)group, this.offsetMap(), currentTime, stats, transactionMetadata, l);
            return BoxedUnit.UNIT;
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    /*
     * WARNING - void declaration
     */
    public void cleanSegments(UnifiedLog log, Seq<LogSegment> segments, OffsetMap map, long currentTime, CleanerStats stats, CleanedTransactionMetadata transactionMetadata, long legacyDeleteHorizonMs) {
        void createNewCleanedSegment_baseOffset;
        void createNewCleanedSegment_logConfig;
        LogSegment logSegment;
        long l = ((LogSegment)segments.head()).baseOffset();
        LogConfig logConfig = log.config();
        File createNewCleanedSegment_dir = log.dir();
        LogSegment logSegment2 = logSegment = LocalLog$.MODULE$.createNewCleanedSegment(createNewCleanedSegment_dir, (LogConfig)createNewCleanedSegment_logConfig, (long)createNewCleanedSegment_baseOffset);
        Object var27_10 = null;
        logConfig = null;
        logSegment = null;
        LogSegment cleaned = logSegment2;
        transactionMetadata.cleanedIndex_$eq((Option<TransactionIndex>)new Some((Object)cleaned.txnIndex()));
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            Map<Object, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> map.latestOffset() + 1L));
                List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(startOffset, upperBoundOffset);
                transactionMetadata.addAbortedTransactions(abortedTransactions);
                boolean retainLegacyDeletesAndTxnMarkers = currentSegment.lastModified() > legacyDeleteHorizonMs;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(24).append("Cleaning ").append(currentSegment).append(" in log ").append(log.name()).append(" into ").append(cleaned.baseOffset()).append(" ").toString()).append(new StringBuilder(52).append("with an upper bound deletion horizon ").append(legacyDeleteHorizonMs).append(" computed from ").toString()).append(new StringBuilder(35).append("the segment last modified time of ").append(currentSegment.lastModified()).append(",").toString()).append(new StringBuilder(9).append((Object)(retainLegacyDeletesAndTxnMarkers ? "retaining" : "discarding")).append(" deletes.").toString()).toString());
                try {
                    this.cleanInto(log.topicPartition(), currentSegment.log(), cleaned, map, retainLegacyDeletesAndTxnMarkers, Predef$.MODULE$.Long2long(log.config().deleteRetentionMs()), Predef$.MODULE$.Integer2int(log.config().maxMessageSize()), transactionMetadata, lastOffsetOfActiveProducers, stats, currentTime);
                }
                catch (LogSegmentOffsetOverflowException e) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Caught segment overflow error during cleaning: ").append(e.getMessage()).toString());
                    log.splitOverflowedSegment(currentSegment);
                    throw new LogCleaningAbortedException();
                }
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Swapping in cleaned segment ").append(cleaned).append(" for segment(s) ").append(segments).append(" in log ").append(log).toString());
            log.replaceSegments((Seq<LogSegment>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{cleaned}))), segments);
            return;
        }
        catch (LogCleaningAbortedException e) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception deleteException) {
                    e.addSuppressed(deleteException);
                }
            }
            catch (Throwable throwable) {
                throw e;
            }
            throw e;
        }
    }

    public void cleanInto(TopicPartition topicPartition, FileRecords sourceRecords, LogSegment dest, OffsetMap map, boolean retainLegacyDeletesAndTxnMarkers, long deleteRetentionMs, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, LastRecord> lastRecordsOfActiveProducers, CleanerStats stats, long currentTime) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, currentTime, deleteRetentionMs, transactionMetadata, lastRecordsOfActiveProducers, map, retainLegacyDeletesAndTxnMarkers, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final Map lastRecordsOfActiveProducers$1;
            private final OffsetMap map$2;
            private final boolean retainLegacyDeletesAndTxnMarkers$2;
            private final CleanerStats stats$3;

            private boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            private void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                boolean canDiscardBatch = this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$2);
                if (batch.isControlBatch()) {
                    this.discardBatchRecords_$eq(canDiscardBatch && batch.deleteHorizonMs().isPresent() && batch.deleteHorizonMs().getAsLong() <= this.currentTime);
                } else {
                    this.discardBatchRecords_$eq(canDiscardBatch);
                }
                MemoryRecords.RecordFilter.BatchRetention batchRetention = batch.hasProducerId() && this.isBatchLastRecordOfProducer$1(batch) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY);
                return new MemoryRecords.RecordFilter.BatchRetentionResult(batchRetention, canDiscardBatch && batch.isControlBatch());
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record) {
                if (this.discardBatchRecords()) {
                    return false;
                }
                return this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$2, this.retainLegacyDeletesAndTxnMarkers$2, batch, record, this.stats$3, this.currentTime);
            }

            public static final /* synthetic */ boolean $anonfun$checkBatchRetention$1(RecordBatch batch$1, LastRecord lastRecord) {
                boolean bl;
                Option<Object> option = lastRecord.lastDataOffset();
                if (option instanceof Some) {
                    long offset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    bl = batch$1.lastOffset() == offset;
                } else if (None$.MODULE$.equals(option)) {
                    bl = batch$1.isControlBatch() && batch$1.producerEpoch() == lastRecord.producerEpoch();
                } else {
                    throw new MatchError(option);
                }
                return bl;
            }

            private final boolean isBatchLastRecordOfProducer$1(RecordBatch batch$1) {
                return this.lastRecordsOfActiveProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch$1.producerId())).exists((Function1 & Serializable)lastRecord -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$checkBatchRetention$1(batch$1, lastRecord)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.lastRecordsOfActiveProducers$1 = lastRecordsOfActiveProducers$1;
                this.map$2 = map$2;
                this.retainLegacyDeletesAndTxnMarkers$2 = retainLegacyDeletesAndTxnMarkers$2;
                this.stats$3 = stats$3;
                super(currentTime$2, deleteRetentionMs$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$checkBatchRetention$1$adapted(org.apache.kafka.common.record.RecordBatch kafka.log.LastRecord )}, serializedLambda);
            }
        };
        int position = 0;
        while (position < sourceRecords.sizeInBytes()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            sourceRecords.readInto(this.readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result.messagesRead(), result.bytesRead());
            stats.recopyMessages(result.messagesRetained(), result.bytesRetained());
            position += result.bytesRead();
            ByteBuffer outputBuffer = result.outputBuffer();
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(result.maxOffset(), result.maxTimestamp(), result.shallowOffsetOfMaxTimestamp(), retained);
                this.throttler.maybeThrottle(outputBuffer.limit());
            }
            if (this.readBuffer().limit() <= 0 || result.bytesRead() != 0) continue;
            this.growBuffersOrFail(sourceRecords, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
    }

    private void growBuffersOrFail(FileRecords sourceRecords, int position, int maxLogMessageSize, MemoryRecords memoryRecords) {
        int n;
        if (this.readBuffer().capacity() >= maxLogMessageSize) {
            Integer nextBatchSize = memoryRecords.firstBatchSize();
            String logDesc = new StringBuilder(25).append("log segment ").append(sourceRecords.file()).append(" at position ").append(position).toString();
            if (nextBatchSize == null) {
                throw new IllegalStateException(new StringBuilder(40).append("Could not determine next batch size for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= 0) {
                throw new IllegalStateException(new StringBuilder(24).append("Invalid batch size ").append(nextBatchSize).append(" for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= this.readBuffer().capacity()) {
                throw new IllegalStateException(new StringBuilder(50).append("Batch size ").append(nextBatchSize).append(" < buffer size ").append(this.readBuffer().capacity()).append(", but not processed for ").append(logDesc).toString());
            }
            long bytesLeft = sourceRecords.channel().size() - (long)position;
            if ((long)Predef$.MODULE$.Integer2int(nextBatchSize) > bytesLeft) {
                throw new CorruptRecordException(new StringBuilder(69).append("Log segment may be corrupt, batch size ").append(nextBatchSize).append(" > ").append(bytesLeft).append(" bytes left in segment for ").append(logDesc).toString());
            }
            n = nextBatchSize;
        } else {
            n = maxLogMessageSize;
        }
        int maxSize = n;
        this.growBuffers(maxSize);
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata) {
        if (batch.isControlBatch()) {
            return transactionMetadata.onControlBatchRead(batch);
        }
        return transactionMetadata.onBatchRead(batch);
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletesForLegacyRecords, RecordBatch batch, Record record, CleanerStats stats, long currentTime) {
        if (record.offset() > map.latestOffset()) {
            return true;
        }
        if (record.hasKey()) {
            boolean isRetainedValue;
            ByteBuffer key = record.key();
            long foundOffset = map.get(key);
            boolean latestOffsetForKey = record.offset() >= foundOffset;
            boolean legacyRecord = batch.magic() < 2;
            boolean bl = isRetainedValue = record.hasValue() || Cleaner.shouldRetainDeletes$1(legacyRecord, batch, currentTime, retainDeletesForLegacyRecords);
            return latestOffsetForKey && isRetainedValue;
        }
        stats.invalidMessage();
        return false;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = scala.math.package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = scala.math.package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Growing cleaner I/O buffers from ").append(this.readBuffer().capacity()).append(" bytes to ").append(newSize).append(" bytes.").toString());
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.readBuffer().capacity() > this.ioBufferSize) {
            this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        List grouped = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            List group = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && (((LogSegment)segs.head()).size() == 0 || this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE)) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        if (segs.size() > 1) {
            return ((LogSegment)segs.apply(1)).baseOffset() - 1L;
        }
        return firstUncleanableOffset - 1L;
    }

    public void buildOffsetMap(UnifiedLog log, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = log.logSegments(start, end).toBuffer();
        ListBuffer nextSegmentStartOffsets = new ListBuffer();
        if (dirty.nonEmpty()) {
            ((IterableOnceOps)dirty.tail()).foreach((Function1 & Serializable)nextSegment -> (ListBuffer)nextSegmentStartOffsets.append((Object)BoxesRunTime.boxToLong((long)nextSegment.baseOffset())));
            nextSegmentStartOffsets.append((Object)BoxesRunTime.boxToLong((long)end));
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d)."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(start, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        BooleanRef full = BooleanRef.create((boolean)false);
        ((IterableOps)dirty.zip((IterableOnce)nextSegmentStartOffsets)).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).withFilter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$4(full, x$15))).foreach((Function1 & Serializable)x$16 -> {
            Cleaner.$anonfun$buildOffsetMap$5(this, log, full, map, start, transactionMetadata, stats, dirty, x$16);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset map for log %s complete."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{log.name()})));
    }

    private boolean buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map, long startOffset, long nextSegmentStartOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        Object object = new Object();
        try {
            int position = segment.offsetIndex().lookup(startOffset).position();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < segment.log().sizeInBytes()) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                try {
                    segment.log().readInto(this.readBuffer(), position);
                }
                catch (Exception e) {
                    throw new KafkaException(new StringBuilder(24).append(new StringBuilder(43).append("Failed to read from segment ").append(segment).append(" of partition ").append(topicPartition).append(" ").toString()).append("while loading offset map").toString(), (Throwable)e);
                }
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                this.throttler.maybeThrottle(records.sizeInBytes());
                int startPosition = position;
                CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$1(this, transactionMetadata, stats, startOffset, map, maxDesiredMapSize, object, batch);
                    return BoxedUnit.UNIT;
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(segment.log(), position, maxLogMessageSize, records);
            }
            map.updateLatestOffset(nextSegmentStartOffset - 1L);
            this.restoreBuffers();
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private static final boolean shouldRetainDeletes$1(boolean legacyRecord$1, RecordBatch batch$2, long currentTime$3, boolean retainDeletesForLegacyRecords$1) {
        if (!legacyRecord$1) {
            return !batch$2.deleteHorizonMs().isPresent() || currentTime$3 < batch$2.deleteHorizonMs().getAsLong();
        }
        return retainDeletesForLegacyRecords$1;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$4(BooleanRef full$1, Tuple2 x$15) {
        if (x$15 == null) {
            throw new MatchError(null);
        }
        boolean bl = !full$1.elem;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$5(Cleaner $this, UnifiedLog log$3, BooleanRef full$1, OffsetMap map$3, long start$1, CleanedTransactionMetadata transactionMetadata$3, CleanerStats stats$4, Buffer dirty$1, Tuple2 x$16) {
        if (x$16 != null) {
            LogSegment segment = (LogSegment)x$16._1();
            long nextSegmentStartOffset = x$16._2$mcJ$sp();
            $this.checkDone.apply((Object)log$3.topicPartition());
            full$1.elem = $this.buildOffsetMapForSegment(log$3.topicPartition(), segment, map$3, start$1, nextSegmentStartOffset, Predef$.MODULE$.Integer2int(log$3.config().maxMessageSize()), transactionMetadata$3, stats$4);
            if (full$1.elem) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirty$1.indexOf((Object)segment)), BoxesRunTime.boxToLong((long)segment.baseOffset())})));
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$2(long startOffset$1, OffsetMap map$4, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, CleanerStats stats$5, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$1) {
            if (map$4.size() < maxDesiredMapSize$1) {
                map$4.put(record.key(), record.offset());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
        }
        stats$5.indexMessagesRead(1);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(Cleaner $this, CleanedTransactionMetadata transactionMetadata$4, CleanerStats stats$5, long startOffset$1, OffsetMap map$4, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, MutableRecordBatch batch) {
        if (batch.isControlBatch()) {
            transactionMetadata$4.onControlBatchRead((RecordBatch)batch);
            stats$5.indexMessagesRead(1);
        } else if (transactionMetadata$4.onBatchRead((RecordBatch)batch)) {
            stats$5.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
        } else {
            try (CloseableIterator recordsIterator = batch.streamingIterator($this.decompressionBufferSupplier());){
                CollectionConverters$.MODULE$.IteratorHasAsScala((java.util.Iterator)recordsIterator).asScala().foreach((Function1 & Serializable)record -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$2(startOffset$1, map$4, maxDesiredMapSize$1, nonLocalReturnKey1$1, stats$5, record);
                    return BoxedUnit.UNIT;
                });
            }
        }
        if (batch.lastOffset() >= startOffset$1) {
            map$4.updateLatestOffset(batch.lastOffset());
        }
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.checkDone = checkDone;
        this.logIdent_$eq(new StringBuilder(10).append("Cleaner ").append(id).append(": ").toString());
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0 & Serializable)() -> "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads");
    }
}

