/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.util.stream.IntStream;
import kafka.coordinator.transaction.ProducerIdManagerTest$MockProducerIdManager$;
import kafka.coordinator.transaction.RPCProducerIdManager;
import kafka.coordinator.transaction.ZkProducerIdManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.CoordinatorLoadInProgressException;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005}e\u0001\u0002\u0011\"\u0001!BQa\f\u0001\u0005\u0002ABqa\r\u0001A\u0002\u0013\u0005A\u0007C\u0004<\u0001\u0001\u0007I\u0011\u0001\u001f\t\r\t\u0003\u0001\u0015)\u00036\u0011\u001d\u0019\u0005A1A\u0005\u0002\u0011Caa\u0013\u0001!\u0002\u0013)e\u0001\u0002'\u0001\u00015C\u0001\"U\u0004\u0003\u0006\u0004%\tA\u0015\u0005\t-\u001e\u0011\t\u0011)A\u0005'\"Aqk\u0002BA\u0002\u0013\u0005\u0001\f\u0003\u0005]\u000f\t\u0005\r\u0011\"\u0001^\u0011!yvA!A!B\u0013I\u0006\u0002\u00031\b\u0005\u000b\u0007I\u0011\u0001*\t\u0011\u0005<!\u0011!Q\u0001\nMC\u0001BY\u0004\u0003\u0002\u0004%\ta\u0019\u0005\tc\u001e\u0011\t\u0019!C\u0001e\"AAo\u0002B\u0001B\u0003&A\r\u0003\u0005v\u000f\t\u0005\t\u0015!\u0003w\u0011\u0015ys\u0001\"\u0001z\u0011!\t\u0019a\u0002C!C\u0005\u0015q!CA\u0004\u0001\u0005\u0005\t\u0012AA\u0005\r!a\u0005!!A\t\u0002\u0005-\u0001BB\u0018\u0017\t\u0003\ti\u0001C\u0005\u0002\u0010Y\t\n\u0011\"\u0001\u0002\u0012!I\u0011q\u0005\f\u0012\u0002\u0013\u0005\u0011\u0011\u0006\u0005\b\u0003[\u0001A\u0011AA\u0003\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000bAq!!\u0013\u0001\t\u0003\t)\u0001C\u0004\u0002N\u0001!\t!a\u0014\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u00111\u0014\u0001\u0005\u0002\u0005\u0015!!\u0006)s_\u0012,8-\u001a:JI6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003E\r\n1\u0002\u001e:b]N\f7\r^5p]*\u0011A%J\u0001\fG>|'\u000fZ5oCR|'OC\u0001'\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0007\u0005\u00023\u00015\t\u0011%\u0001\nce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014X#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0005a*\u0013AB:feZ,'/\u0003\u0002;o\t\u0001#I]8lKJ$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003Y\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:`I\u0015\fHCA\u001fA!\tQc(\u0003\u0002@W\t!QK\\5u\u0011\u001d\t5!!AA\u0002U\n1\u0001\u001f\u00132\u0003M\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:!\u0003!Q8n\u00117jK:$X#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!+\u0013A\u0001>l\u0013\tQuIA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\nu.\u001cE.[3oi\u0002\u0012Q#T8dWB\u0013x\u000eZ;dKJLE-T1oC\u001e,'o\u0005\u0002\b\u001dB\u0011!gT\u0005\u0003!\u0006\u0012AC\u0015)D!J|G-^2fe&#W*\u00198bO\u0016\u0014\u0018\u0001\u00032s_.,'/\u00133\u0016\u0003M\u0003\"A\u000b+\n\u0005U[#aA%oi\u0006I!M]8lKJLE\rI\u0001\bS\u0012\u001cF/\u0019:u+\u0005I\u0006C\u0001\u0016[\u0013\tY6F\u0001\u0003M_:<\u0017aC5e'R\f'\u000f^0%KF$\"!\u00100\t\u000f\u0005[\u0011\u0011!a\u00013\u0006A\u0011\u000eZ*uCJ$\b%A\u0003jI2+g.\u0001\u0004jI2+g\u000eI\u0001\u0006KJ\u0014xN]\u000b\u0002IB\u0011Qm\\\u0007\u0002M*\u0011q\r[\u0001\taJ|Go\\2pY*\u0011\u0011N[\u0001\u0007G>lWn\u001c8\u000b\u0005\u0019Z'B\u00017n\u0003\u0019\t\u0007/Y2iK*\ta.A\u0002pe\u001eL!\u0001\u001d4\u0003\r\u0015\u0013(o\u001c:t\u0003%)'O]8s?\u0012*\u0017\u000f\u0006\u0002>g\"9\u0011\tEA\u0001\u0002\u0004!\u0017AB3se>\u0014\b%A\u0004uS6,w.\u001e;\u0011\u0005):\u0018B\u0001=,\u0005\u001d\u0011un\u001c7fC:$rA\u001f?~}~\f\t\u0001\u0005\u0002|\u000f5\t\u0001\u0001C\u0003R'\u0001\u00071\u000bC\u0003X'\u0001\u0007\u0011\fC\u0003a'\u0001\u00071\u000bC\u0004c'A\u0005\t\u0019\u00013\t\u000fU\u001c\u0002\u0013!a\u0001m\u0006Y1/\u001a8e%\u0016\fX/Z:u)\u0005i\u0014!F'pG.\u0004&o\u001c3vG\u0016\u0014\u0018\nZ'b]\u0006<WM\u001d\t\u0003wZ\u0019\"AF\u0015\u0015\u0005\u0005%\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u0014)\u001aA-!\u0006,\u0005\u0005]\u0001\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\t,\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\tYBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAA\u0016U\r1\u0018QC\u0001\u0014i\u0016\u001cHoR3u!J|G-^2fe&#'l\u001b\u0015\u00045\u0005E\u0002\u0003BA\u001a\u0003\u0003j!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0004CBL'\u0002BA\u001e\u0003{\tqA[;qSR,'OC\u0002\u0002@5\fQA[;oSRLA!a\u0011\u00026\t!A+Z:u\u0003Q\"Xm\u001d;S!\u000e\u0003&o\u001c3vG\u0016\u0014\u0018\nZ'b]\u0006<WM\u001d+ie><8oQ8oGV\u0014(/\u001a8u)J\fgn]1di&|gn\u001d\u0015\u00047\u0005E\u0012a\u0007;fgR,\u0005pY3fIB\u0013x\u000eZ;dKJLE\rT5nSRT6\u000eK\u0002\u001d\u0003c\t\u0011\u0003^3ti\u000e{g\u000e^5hk>,8/\u00133t)\ri\u0014\u0011\u000b\u0005\u0007\u0003'j\u0002\u0019A*\u0002\u0015%$'\t\\8dW2+g\u000eK\u0004\u001e\u0003/\n9'!\u001b\u0011\t\u0005e\u00131M\u0007\u0003\u00037RA!!\u0018\u0002`\u0005A\u0001O]8wS\u0012,'O\u0003\u0003\u0002b\u0005e\u0012A\u00029be\u0006l7/\u0003\u0003\u0002f\u0005m#a\u0003,bYV,7k\\;sG\u0016\fA!\u001b8ug22\u00111NA7\u0003_j\u0012!A\u000f\u0002\u0005u\t!\u0002K\u0002\u001e\u0003g\u0002B!!\u001e\u0002x5\u0011\u0011qL\u0005\u0005\u0003s\nyFA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fq\u0003^3tiVs'/Z2pm\u0016\u0014\u0018M\u00197f\u000bJ\u0014xN]:\u0015\u0007u\ny\bC\u0003c=\u0001\u0007A\rK\u0006\u001f\u0003\u0007\u000bI)a#\u0002\u000e\u0006=\u0005\u0003BA-\u0003\u000bKA!a\"\u0002\\\tQQI\\;n'>,(oY3\u0002\u000bY\fG.^3$\u0003\u0011\fQA\\1nKNdC!!%\u0002\u0016\u0006\u0012\u00111S\u0001\u0015+:[ejT,O?N+%KV#S?\u0016\u0013&k\u0014*\"\u0005\u0005]\u0015aD%O-\u0006c\u0015\nR0S\u000bF+Vi\u0015+)\u0007y\t\u0019(A\tuKN$\u0018J\u001c<bY&$'+\u00198hKND3aHA\u0019\u0001")
public class ProducerIdManagerTest {
    private volatile ProducerIdManagerTest$MockProducerIdManager$ MockProducerIdManager$module;
    private BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);

    public ProducerIdManagerTest$MockProducerIdManager$ MockProducerIdManager() {
        if (this.MockProducerIdManager$module == null) {
            this.MockProducerIdManager$lzycompute$1();
        }
        return this.MockProducerIdManager$module;
    }

    public BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(BrokerToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    @Test
    public void testGetProducerIdZk() {
        ObjectRef zkVersion = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef data = ObjectRef.create(null);
        Mockito.when((Object)this.zkClient().getDataAndVersion(ArgumentMatchers.anyString())).thenAnswer(x$1 -> (Tuple2)((Option)zkVersion$1.elem).map((Function1 & Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)((byte[])data.elem))), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$2)))).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0))));
        ArgumentCaptor capturedVersion = ArgumentCaptor.forClass(Integer.TYPE);
        ArgumentCaptor capturedData = ArgumentCaptor.forClass(byte[].class);
        Mockito.when((Object)this.zkClient().conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])capturedData.capture(), BoxesRunTime.unboxToInt((Object)capturedVersion.capture()), (Option)ArgumentMatchers.any())).thenAnswer(x$3 -> {
            int newZkVersion = BoxesRunTime.unboxToInt((Object)capturedVersion.getValue()) + 1;
            zkVersion$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)newZkVersion));
            data$1.elem = (byte[])capturedData.getValue();
            return new Tuple2.mcZI.sp(true, newZkVersion);
        });
        ZkProducerIdManager manager1 = new ZkProducerIdManager(0, this.zkClient());
        ZkProducerIdManager manager2 = new ZkProducerIdManager(1, this.zkClient());
        long pid1 = manager1.generateProducerId();
        long pid2 = manager2.generateProducerId();
        Assertions.assertEquals((long)0L, (long)pid1);
        Assertions.assertEquals((long)1000L, (long)pid2);
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)1000L)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)i -> Assertions.assertEquals((long)(pid1 + i), (long)manager1.generateProducerId()));
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)1000L)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)i -> Assertions.assertEquals((long)(pid2 + i), (long)manager2.generateProducerId()));
        Assertions.assertEquals((long)(pid2 + 1000L), (long)manager1.generateProducerId());
        Assertions.assertEquals((long)(pid2 + 2000L), (long)manager2.generateProducerId());
    }

    @Test
    public void testRPCProducerIdManagerThrowsConcurrentTransactions() {
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Errors x$5 = Errors.NONE;
        MockProducerIdManager manager1 = new MockProducerIdManager(this, 0, 0L, 0, x$5, true);
        Assertions.assertThrows(CoordinatorLoadInProgressException.class, () -> manager1.generateProducerId());
    }

    @Test
    public void testExceedProducerIdLimitZk() {
        Mockito.when((Object)this.zkClient().getDataAndVersion(ArgumentMatchers.anyString())).thenAnswer(x$4 -> {
            byte[] json = ProducerIdBlockZNode$.MODULE$.generateProducerIdBlockJson(new ProducerIdsBlock(0, 9223372036854774807L, 1000));
            return new Tuple2((Object)new Some((Object)json), (Object)BoxesRunTime.boxToInteger((int)0));
        });
        Assertions.assertThrows(KafkaException.class, () -> new ZkProducerIdManager(0, this.zkClient()));
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 10})
    public void testContiguousIds(int idBlockLen) {
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, 0L, idBlockLen, Errors.NONE, false);
        IntStream.range(0, idBlockLen * 3).forEach(i -> Assertions.assertEquals((long)i, (long)manager.generateProducerId()));
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"UNKNOWN_SERVER_ERROR", "INVALID_REQUEST"})
    public void testUnrecoverableErrors(Errors error) {
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, 0L, 1, Errors.NONE, false);
        Assertions.assertEquals((long)0L, (long)manager.generateProducerId());
        manager.error_$eq(error);
        Assertions.assertThrows(Throwable.class, () -> manager.generateProducerId());
        manager.error_$eq(Errors.NONE);
        Assertions.assertEquals((long)1L, (long)manager.generateProducerId());
    }

    @Test
    public void testInvalidRanges() {
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        ObjectRef manager = ObjectRef.create((Object)((Object)new MockProducerIdManager(this, 0, -1L, 10, Errors.NONE, false)));
        Assertions.assertThrows(KafkaException.class, () -> ((MockProducerIdManager)((Object)((Object)manager$3.elem))).generateProducerId());
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        manager.elem = new MockProducerIdManager(this, 0, 0L, -1, Errors.NONE, false);
        Assertions.assertThrows(KafkaException.class, () -> ((MockProducerIdManager)((Object)((Object)manager$3.elem))).generateProducerId());
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        manager.elem = new MockProducerIdManager(this, 0, 0x7FFFFFFFFFFFFFFEL, 10, Errors.NONE, false);
        Assertions.assertThrows(KafkaException.class, () -> ((MockProducerIdManager)((Object)((Object)manager$3.elem))).generateProducerId());
    }

    private final void MockProducerIdManager$lzycompute$1() {
        synchronized (this) {
            if (this.MockProducerIdManager$module == null) {
                this.MockProducerIdManager$module = new ProducerIdManagerTest$MockProducerIdManager$(this);
            }
            return;
        }
    }

    public class MockProducerIdManager
    extends RPCProducerIdManager {
        private final int brokerId;
        private long idStart;
        private final int idLen;
        private Errors error;
        private final boolean timeout;
        public final /* synthetic */ ProducerIdManagerTest $outer;

        public int brokerId() {
            return this.brokerId;
        }

        public long idStart() {
            return this.idStart;
        }

        public void idStart_$eq(long x$1) {
            this.idStart = x$1;
        }

        public int idLen() {
            return this.idLen;
        }

        public Errors error() {
            return this.error;
        }

        public void error_$eq(Errors x$1) {
            this.error = x$1;
        }

        public void sendRequest() {
            if (this.timeout) {
                return;
            }
            Errors errors = this.error();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                this.handleAllocateProducerIdsResponse(new AllocateProducerIdsResponse(new AllocateProducerIdsResponseData().setProducerIdStart(this.idStart()).setProducerIdLen(this.idLen())));
                this.idStart_$eq(this.idStart() + (long)this.idLen());
                return;
            }
            this.handleAllocateProducerIdsResponse(new AllocateProducerIdsResponse(new AllocateProducerIdsResponseData().setErrorCode(this.error().code())));
        }

        public /* synthetic */ ProducerIdManagerTest kafka$coordinator$transaction$ProducerIdManagerTest$MockProducerIdManager$$$outer() {
            return this.$outer;
        }

        public MockProducerIdManager(ProducerIdManagerTest $outer, int brokerId, long idStart, int idLen, Errors error, boolean timeout) {
            this.brokerId = brokerId;
            this.idStart = idStart;
            this.idLen = idLen;
            this.error = error;
            this.timeout = timeout;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(brokerId, (Function0)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final long apply() {
                    return 1L;
                }

                public long apply$mcJ$sp() {
                    return 1L;
                }
            }, $outer.brokerToController(), 100);
        }
    }
}

