/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.admin.AdminOperationException;
import kafka.server.DynamicConfig;
import kafka.server.QuorumTestHarness;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.config.ConfigException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000513A!\u0004\b\u0001'!)\u0001\u0004\u0001C\u00013!91\u0004\u0001b\u0001\n\u001ba\u0002B\u0002\u0016\u0001A\u00035Q\u0004C\u0004,\u0001\t\u0007IQ\u0002\u000f\t\r1\u0002\u0001\u0015!\u0004\u001e\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u0015\u0001\u0005\u0001\"\u0001/\u0011\u0015\u0011\u0005\u0001\"\u0001/\u0011\u0015!\u0005\u0001\"\u0001/\u0011\u00151\u0005\u0001\"\u0001/\u0011\u0015A\u0005\u0001\"\u0001/\u0011\u0015Q\u0005\u0001\"\u0001/\u0005E!\u0015P\\1nS\u000e\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003\u001fA\taa]3sm\u0016\u0014(\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+Yi\u0011AD\u0005\u0003/9\u0011\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u0016\u0001\u0005\tbn\u001c8Fq&\u001cH/\u001a8u\u0007>tg-[4\u0016\u0003u\u0001\"AH\u0014\u000f\u0005})\u0003C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0013\u0003\u0019a$o\\8u})\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\u00051\u0001K]3eK\u001aL!\u0001K\u0015\u0003\rM#(/\u001b8h\u0015\t13%\u0001\no_:,\u00050[:uK:$8i\u001c8gS\u001e\u0004\u0013!C:p[\u00164\u0016\r\\;f\u0003)\u0019x.\\3WC2,X\rI\u0001,g\"|W\u000f\u001c3GC&dw\u000b[3o\u0007\"\fgnZ5oO\u000ec\u0017.\u001a8u\u0013\u0012,fn\u001b8po:\u001cuN\u001c4jOR\tq\u0006\u0005\u00021c5\t1%\u0003\u00023G\t!QK\\5uQ\t1A\u0007\u0005\u00026}5\taG\u0003\u00028q\u0005\u0019\u0011\r]5\u000b\u0005eR\u0014a\u00026va&$XM\u001d\u0006\u0003wq\nQA[;oSRT\u0011!P\u0001\u0004_J<\u0017BA 7\u0005\u0011!Vm\u001d;\u0002OMDw.\u001e7e\r\u0006LGn\u00165f]\u000eC\u0017M\\4j]\u001e,6/\u001a:V].twn\u001e8D_:4\u0017n\u001a\u0015\u0003\u000fQ\n\u0001f\u001d5pk2$g)Y5m\u0019\u0016\fG-\u001a:D_:4\u0017nZ:XSRD\u0017J\u001c<bY&$g+\u00197vKND#\u0001\u0003\u001b\u0002UMDw.\u001e7e\r\u0006LGNR8mY><XM]\"p]\u001aLwm],ji\"LeN^1mS\u00124\u0016\r\\;fg\"\u0012\u0011\u0002N\u0001%g\"|W\u000f\u001c3GC&d\u0017\n]\"p]\u001aLwm],ji\"LeN^1mS\u00124\u0016\r\\;fg\"\u0012!\u0002N\u0001)g\"|W\u000f\u001c3GC&d\u0017\n]\"p]\u001aLwm],ji\"LeN^1mS\u0012L\u0005O\u001e\u001bF]RLG/\u001f\u0015\u0003\u0017Q\nad\u001d5pk2$g)Y5m\u0013B\u001cuN\u001c4jON<\u0016\u000e\u001e5CC\u0012Dun\u001d;)\u00051!\u0004")
public class DynamicConfigTest
extends QuorumTestHarness {
    private final String nonExistentConfig;
    private final String someValue;

    private final String nonExistentConfig() {
        return this.nonExistentConfig;
    }

    private final String someValue() {
        return this.someValue;
    }

    @Test
    public void shouldFailWhenChangingClientIdUnknownConfig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.adminZkClient().changeClientIdConfig("ClientId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue())));
    }

    @Test
    public void shouldFailWhenChangingUserUnknownConfig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.adminZkClient().changeUserOrUserClientIdConfig("UserId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue())));
    }

    @Test
    public void shouldFailLeaderConfigsWithInvalidValues() {
        Assertions.assertThrows(ConfigException.class, () -> this.adminZkClient().changeBrokerConfig((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "-100")));
    }

    @Test
    public void shouldFailFollowerConfigsWithInvalidValues() {
        Assertions.assertThrows(ConfigException.class, () -> this.adminZkClient().changeBrokerConfig((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "-100")));
    }

    @Test
    public void shouldFailIpConfigsWithInvalidValues() {
        Assertions.assertThrows(ConfigException.class, () -> this.adminZkClient().changeIpConfig("1.2.3.4", CoreUtils$.MODULE$.propsWith("connection_creation_rate", "-1")));
    }

    @Test
    public void shouldFailIpConfigsWithInvalidIpv4Entity() {
        Assertions.assertThrows(AdminOperationException.class, () -> this.adminZkClient().changeIpConfig("1,1.1.1", CoreUtils$.MODULE$.propsWith("connection_creation_rate", "2")));
    }

    @Test
    public void shouldFailIpConfigsWithBadHost() {
        Assertions.assertThrows(AdminOperationException.class, () -> this.adminZkClient().changeIpConfig("RFC2606.invalid", CoreUtils$.MODULE$.propsWith("connection_creation_rate", "2")));
    }

    public DynamicConfigTest() {
        this.nonExistentConfig = "some.config.that.does.not.exist";
        this.someValue = "some interesting value";
    }
}

