/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import kafka.server.metadata.BrokerMetadataSnapshotter;
import kafka.server.metadata.SnapshotWriterBuilder;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.util.SnapshotReason;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.MockRawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}e\u0001B\u000e\u001d\u0001\rBQA\u000b\u0001\u0005\u0002-BQA\f\u0001\u0005\u0002=2A\u0001\u0011\u0001\u0001\u0003\")!f\u0001C\u0001\u000b\"9\u0001j\u0001a\u0001\n\u0003I\u0005b\u0002/\u0004\u0001\u0004%\t!\u0018\u0005\u0007A\u000e\u0001\u000b\u0015\u0002&\t\u000b\u0005\u001cA\u0011\t2\t\r}\u001cA\u0011AA\u0001\r\u0019\tY\u0002\u0001\u0001\u0002\u001e!1!F\u0003C\u0001\u0003\u007fA\u0011\"a\u0011\u000b\u0005\u0004%\t!!\u0012\t\u0011\u00055#\u0002)A\u0005\u0003\u000fBa!a\u0014\u000b\t\u0003z\u0003BBA)\u0001\u0011\u0005qF\u0002\u0004\u0002V\u0001\u0001\u0011q\u000b\u0005\u0007UA!\t!!\u0017\t\u0013\u0005u\u0003C1A\u0005\u0002\u0005}\u0003\u0002CA8!\u0001\u0006I!!\u0019\t\u000f\u0005E\u0004\u0003\"\u0011\u0002t!9\u0011\u0011\u0011\t\u0005B\u0005\r\u0005bBAC!\u0011\u0005\u0013q\u0011\u0005\b\u0003\u0013\u0003B\u0011IAF\u0011\u001d\t\u0019\n\u0005C!\u0003+Ca!a'\u0011\t\u0003z\u0003BBAO!\u0011\u0005sFA\u000fCe>\\WM]'fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8ui\u0016\u0014H+Z:u\u0015\tib$\u0001\u0005nKR\fG-\u0019;b\u0015\ty\u0002%\u0001\u0004tKJ4XM\u001d\u0006\u0002C\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001%!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\f\t\u0003[\u0001i\u0011\u0001H\u0001\u0013i\u0016\u001cHo\u0011:fCR,\u0017I\u001c3DY>\u001cX\rF\u00011!\t)\u0013'\u0003\u00023M\t!QK\\5uQ\t\u0011A\u0007\u0005\u00026}5\taG\u0003\u00028q\u0005\u0019\u0011\r]5\u000b\u0005eR\u0014a\u00026va&$XM\u001d\u0006\u0003wq\nQA[;oSRT\u0011!P\u0001\u0004_J<\u0017BA 7\u0005\u0011!Vm\u001d;\u000335{7m[*oCB\u001c\bn\u001c;Xe&$XM\u001d\"vS2$WM]\n\u0004\u0007\u0011\u0012\u0005CA\u0017D\u0013\t!EDA\u000bT]\u0006\u00048\u000f[8u/JLG/\u001a:Ck&dG-\u001a:\u0015\u0003\u0019\u0003\"aR\u0002\u000e\u0003\u0001\tQ![7bO\u0016,\u0012A\u0013\t\u0004\u0017J#V\"\u0001'\u000b\u00055s\u0015AC2p]\u000e,(O]3oi*\u0011q\nU\u0001\u0005kRLGNC\u0001R\u0003\u0011Q\u0017M^1\n\u0005Mc%!E\"p[BdW\r^1cY\u00164U\u000f^;sKB\u0011QKW\u0007\u0002-*\u0011\u0001j\u0016\u0006\u0003CaS!!\u0017\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tYfKA\u0007NKR\fG-\u0019;b\u00136\fw-Z\u0001\nS6\fw-Z0%KF$\"\u0001\r0\t\u000f}3\u0011\u0011!a\u0001\u0015\u0006\u0019\u0001\u0010J\u0019\u0002\r%l\u0017mZ3!\u0003\u0015\u0011W/\u001b7e)\u0011\u00197\u000f_?\u0011\u0007\u0015\"g-\u0003\u0002fM\t1q\n\u001d;j_:\u00042a\u001a6m\u001b\u0005A'BA5X\u0003!\u0019h.\u00199tQ>$\u0018BA6i\u00059\u0019f.\u00199tQ>$xK]5uKJ\u0004\"!\\9\u000e\u00039T!a\u001c9\u0002\r\r|W.\\8o\u0015\tyr+\u0003\u0002s]\n!\u0012\t]5NKN\u001c\u0018mZ3B]\u00124VM]:j_:DQ\u0001\u001e\u0005A\u0002U\fqbY8n[&$H/\u001a3PM\u001a\u001cX\r\u001e\t\u0003KYL!a\u001e\u0014\u0003\t1{gn\u001a\u0005\u0006s\"\u0001\rA_\u0001\u000fG>lW.\u001b;uK\u0012,\u0005o\\2i!\t)30\u0003\u0002}M\t\u0019\u0011J\u001c;\t\u000byD\u0001\u0019A;\u0002)1\f7\u000f^\"p]R\f\u0017N\\3e\u0019><G+[7f\u0003U\u0019wN\\:v[\u0016\u001cf.\u00199tQ>$()\u001e4gKJ$\u0002\"a\u0001\u0002\u0016\u0005]\u0011\u0011\u0004\u000b\u0004a\u0005\u0015\u0001bBA\u0004\u0013\u0001\u0007\u0011\u0011B\u0001\u0007EV4g-\u001a:\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004Q\u0003\rq\u0017n\\\u0005\u0005\u0003'\tiA\u0001\u0006CsR,')\u001e4gKJDQ\u0001^\u0005A\u0002UDQ!_\u0005A\u0002iDQA`\u0005A\u0002U\u0014QB\u00117pG.LgnZ#wK:$8#\u0002\u0006\u0002 \u0005-\u0002\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015\u0002+\u0001\u0003mC:<\u0017\u0002BA\u0015\u0003G\u0011aa\u00142kK\u000e$\b\u0003BA\u0017\u0003sqA!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003g9\u0016!B9vKV,\u0017\u0002BA\u001c\u0003c\t!\"\u0012<f]R\fV/Z;f\u0013\u0011\tY$!\u0010\u0003\u000b\u00153XM\u001c;\u000b\t\u0005]\u0012\u0011\u0007\u000b\u0003\u0003\u0003\u0002\"a\u0012\u0006\u0002\u000b1\fGo\u00195\u0016\u0005\u0005\u001d\u0003cA&\u0002J%\u0019\u00111\n'\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\u00061A.\u0019;dQ\u0002\n1A];o\u0003I!Xm\u001d;De\u0016\fG/Z*oCB\u001c\bn\u001c;)\u0005=!$AE'pG.\u001cf.\u00199tQ>$xK]5uKJ\u001cB\u0001EA\u0010MR\u0011\u00111\f\t\u0003\u000fB\tqAY1uG\",7/\u0006\u0002\u0002bA1\u00111MA3\u0003Sj\u0011AT\u0005\u0004\u0003Or%!C!se\u0006LH*[:u!\u0015\t\u0019'a\u001bm\u0013\r\tiG\u0014\u0002\u0005\u0019&\u001cH/\u0001\u0005cCR\u001c\u0007.Z:!\u0003)\u0019h.\u00199tQ>$\u0018\n\u001a\u000b\u0003\u0003k\u0002B!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0004\u0003w:\u0016\u0001\u0002:bMRLA!a \u0002z\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0017A\u00067bgR\u001cuN\u001c;bS:,G\rT8h\u001f\u001a47/\u001a;\u0015\u0003U\fQ\u0003\\1ti\u000e{g\u000e^1j]\u0016$Gj\\4Fa>\u001c\u0007\u000eF\u0001{\u0003!I7O\u0012:pu\u0016tGCAAG!\r)\u0013qR\u0005\u0004\u0003#3#a\u0002\"p_2,\u0017M\\\u0001\u0007CB\u0004XM\u001c3\u0015\u0007A\n9\nC\u0004\u0002\u001ab\u0001\r!!\u001b\u0002\u000b\t\fGo\u00195\u0002\r\u0019\u0014X-\u001a>f\u0003\u0015\u0019Gn\\:f\u0001")
public class BrokerMetadataSnapshotterTest {
    @Test
    public void testCreateAndClose() {
        new BrokerMetadataSnapshotter(0, Time.SYSTEM, (Option)None$.MODULE$, (x$1, x$2, x$3) -> {
            throw new RuntimeException("unimplemented");
        }).close();
    }

    @Test
    public void testCreateSnapshot() {
        MockSnapshotWriterBuilder writerBuilder = new MockSnapshotWriterBuilder();
        try (BrokerMetadataSnapshotter snapshotter = new BrokerMetadataSnapshotter(0, Time.SYSTEM, (Option)None$.MODULE$, (SnapshotWriterBuilder)writerBuilder);){
            BlockingEvent blockingEvent = new BlockingEvent();
            Set reasons = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SnapshotReason[]{SnapshotReason.UNKNOWN}));
            KafkaEventQueue kafkaEventQueue = snapshotter.eventQueue();
            if (kafkaEventQueue == null) {
                throw null;
            }
            kafkaEventQueue.enqueue(EventQueue.EventInsertionType.APPEND, null, (Function)EventQueue.NoDeadlineFunction.INSTANCE, (EventQueue.Event)blockingEvent);
            Assertions.assertTrue((boolean)snapshotter.maybeStartSnapshot(2000L, MetadataImageTest.IMAGE1, reasons));
            Assertions.assertFalse((boolean)snapshotter.maybeStartSnapshot(4000L, MetadataImageTest.IMAGE2, reasons));
            blockingEvent.latch().countDown();
            Assertions.assertEquals((Object)MetadataImageTest.IMAGE1, (Object)writerBuilder.image().get());
        }
    }

    public class BlockingEvent
    implements EventQueue.Event {
        private final CountDownLatch latch;

        public void handleException(Throwable x$1) {
            super.handleException(x$1);
        }

        public CountDownLatch latch() {
            return this.latch;
        }

        public void run() {
            this.latch().await();
        }

        public /* synthetic */ BrokerMetadataSnapshotterTest kafka$server$metadata$BrokerMetadataSnapshotterTest$BlockingEvent$$$outer() {
            return BrokerMetadataSnapshotterTest.this;
        }

        public BlockingEvent() {
            if (BrokerMetadataSnapshotterTest.this == null) {
                throw null;
            }
            this.latch = new CountDownLatch(1);
        }
    }

    public class MockSnapshotWriter
    implements SnapshotWriter<ApiMessageAndVersion> {
        private final ArrayList<List<ApiMessageAndVersion>> batches;

        public ArrayList<List<ApiMessageAndVersion>> batches() {
            return this.batches;
        }

        public OffsetAndEpoch snapshotId() {
            return new OffsetAndEpoch(0L, 0);
        }

        public long lastContainedLogOffset() {
            return 0L;
        }

        public int lastContainedLogEpoch() {
            return 0;
        }

        public boolean isFrozen() {
            return false;
        }

        public void append(List<ApiMessageAndVersion> batch) {
            this.batches().add(batch);
        }

        public void freeze() {
        }

        public void close() {
        }

        public /* synthetic */ BrokerMetadataSnapshotterTest kafka$server$metadata$BrokerMetadataSnapshotterTest$MockSnapshotWriter$$$outer() {
            return BrokerMetadataSnapshotterTest.this;
        }

        public MockSnapshotWriter() {
            if (BrokerMetadataSnapshotterTest.this == null) {
                throw null;
            }
            this.batches = new ArrayList();
        }
    }

    public class MockSnapshotWriterBuilder
    implements SnapshotWriterBuilder {
        private CompletableFuture<MetadataImage> image;

        public CompletableFuture<MetadataImage> image() {
            return this.image;
        }

        public void image_$eq(CompletableFuture<MetadataImage> x$1) {
            this.image = x$1;
        }

        public Option<SnapshotWriter<ApiMessageAndVersion>> build(long committedOffset, int committedEpoch, long lastContainedLogTime) {
            OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(committedOffset, committedEpoch);
            return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(RecordsSnapshotWriter.createWithHeader(() -> Optional.of(new MockRawSnapshotWriter(offsetAndEpoch, buffer -> this.consumeSnapshotBuffer(committedOffset, committedEpoch, lastContainedLogTime, (ByteBuffer)buffer))), (int)1024, (MemoryPool)MemoryPool.NONE, (Time)Time.SYSTEM, (long)lastContainedLogTime, (CompressionType)CompressionType.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE)));
        }

        public void consumeSnapshotBuffer(long committedOffset, int committedEpoch, long lastContainedLogTime, ByteBuffer buffer) {
            MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
            AbstractIterator batchIterator = MemoryRecords.readableRecords((ByteBuffer)buffer).batchIterator();
            while (batchIterator.hasNext()) {
                MutableRecordBatch batch = (MutableRecordBatch)batchIterator.next();
                if (batch.isControlBatch()) continue;
                batch.forEach(record -> {
                    ByteBuffer recordBuffer = record.value().duplicate();
                    ApiMessageAndVersion messageAndVersion = MetadataRecordSerde.INSTANCE.read((Readable)new ByteBufferAccessor(recordBuffer), recordBuffer.remaining());
                    delta.replay(messageAndVersion.message());
                });
            }
            this.image().complete(delta.apply(new MetadataProvenance(committedOffset, committedEpoch, lastContainedLogTime)));
        }

        public /* synthetic */ BrokerMetadataSnapshotterTest kafka$server$metadata$BrokerMetadataSnapshotterTest$MockSnapshotWriterBuilder$$$outer() {
            return BrokerMetadataSnapshotterTest.this;
        }

        public MockSnapshotWriterBuilder() {
            if (BrokerMetadataSnapshotterTest.this == null) {
                throw null;
            }
            this.image = new CompletableFuture();
        }
    }
}

