/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import kafka.api.AbstractConsumerTest;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.internals.PrototypeAsyncConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005A2AAB\u0004\u0001\u0019!)\u0011\u0003\u0001C\u0001%!9A\u0003\u0001b\u0001\n\u0003)\u0002B\u0002\u000f\u0001A\u0003%a\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0003/\u0001\u0011\u0005aDA\u000bCCN,\u0017i]=oG\u000e{gn];nKJ$Vm\u001d;\u000b\u0005!I\u0011aA1qS*\t!\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0001C\u0001\b\u0010\u001b\u00059\u0011B\u0001\t\b\u0005Q\t%m\u001d;sC\u000e$8i\u001c8tk6,'\u000fV3ti\u00061A(\u001b8jiz\"\u0012a\u0005\t\u0003\u001d\u0001\t1\u0004Z3gCVdGO\u00117pG.LgnZ!Q\u0013RKW.Z8vi6\u001bX#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0007%sG/\u0001\u000feK\u001a\fW\u000f\u001c;CY>\u001c7.\u001b8h\u0003BKE+[7f_V$Xj\u001d\u0011\u0002\u001fQ,7\u000f^\"p[6LG/Q:z]\u000e$\u0012a\b\t\u0003/\u0001J!!\t\r\u0003\tUs\u0017\u000e\u001e\u0015\u0003\t\r\u0002\"\u0001\n\u0017\u000e\u0003\u0015R!\u0001\u0003\u0014\u000b\u0005\u001dB\u0013a\u00026va&$XM\u001d\u0006\u0003S)\nQA[;oSRT\u0011aK\u0001\u0004_J<\u0017BA\u0017&\u0005\u0011!Vm\u001d;\u0002\u001dQ,7\u000f^\"p[6LGoU=oG\"\u0012Qa\t")
public class BaseAsyncConsumerTest
extends AbstractConsumerTest {
    private final int defaultBlockingAPITimeoutMs;

    public int defaultBlockingAPITimeoutMs() {
        return this.defaultBlockingAPITimeoutMs;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCommitAsync() {
        PrototypeAsyncConsumer consumer = this.createAsyncConsumer(this.createAsyncConsumer$default$1(), this.createAsyncConsumer$default$2(), this.createAsyncConsumer$default$3(), this.createAsyncConsumer$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int numRecords = 10000;
        long startingTimestamp = System.currentTimeMillis();
        AbstractConsumerTest.CountConsumerCommitCallback cb = new AbstractConsumerTest.CountConsumerCommitCallback();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.commitAsync((OffsetCommitCallback)cb);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = this.defaultBlockingAPITimeoutMs();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseAsyncConsumerTest.$anonfun$testCommitAsync$1(cb)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"wait until commit is completed successfully");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Map committedOffset = consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava(), Duration.ofMillis(this.defaultBlockingAPITimeoutMs()));
        Assertions.assertNotNull((Object)committedOffset);
        Assertions.assertNull(committedOffset.get(this.tp()));
        Assertions.assertTrue((boolean)consumer.assignment().contains(this.tp()));
    }

    @Test
    public void testCommitSync() {
        PrototypeAsyncConsumer consumer = this.createAsyncConsumer(this.createAsyncConsumer$default$1(), this.createAsyncConsumer$default$2(), this.createAsyncConsumer$default$3(), this.createAsyncConsumer$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int numRecords = 10000;
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.commitSync();
        Map committedOffset = consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava(), Duration.ofMillis(this.defaultBlockingAPITimeoutMs()));
        Assertions.assertNotNull((Object)committedOffset);
        Assertions.assertNull(committedOffset.get(this.tp()));
        Assertions.assertTrue((boolean)consumer.assignment().contains(this.tp()));
    }

    public static final /* synthetic */ boolean $anonfun$testCommitAsync$1(AbstractConsumerTest.CountConsumerCommitCallback cb$1) {
        return cb$1.successCount() == 1;
    }

    public static final /* synthetic */ String $anonfun$testCommitAsync$2() {
        return "wait until commit is completed successfully";
    }

    public BaseAsyncConsumerTest() {
        this.defaultBlockingAPITimeoutMs = 1000;
    }
}

