/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.time.Duration;
import java.util.Arrays;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.ZkVersion$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005=3Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C!-!)Q\u0004\u0001C!=!)\u0001\u0006\u0001C\u0001S!)!\b\u0001C\u0005w!)q\b\u0001C\u0005\u0001\nIb)\u001a;dQJ+\u0017/^3tiR+7\u000f\u001e#po:<'/\u00193f\u0015\tI!\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0017\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\t\u0013\t\t\u0002BA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\tA\u0003\u0005\u0002\u0010\u0001\u0005Y!M]8lKJ\u001cu.\u001e8u+\u00059\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"aA%oi\u0006yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001 !\r\u00013%J\u0007\u0002C)\u0011!%G\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0013\"\u0005\r\u0019V-\u001d\t\u0003\u001f\u0019J!a\n\u0005\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u00018i\u0016\u001cH\u000fV8qS\u000eLE-S:SK6|g/\u001a3Ge>lg)\u001a;dQ\u0016\u0014x\u000b[3o\u0007>tGO]8mY\u0016\u0014Hi\\<oOJ\fG-Z:\u0015\u0003)\u0002\"\u0001G\u0016\n\u00051J\"\u0001B+oSRD#\u0001\u0002\u0018\u0011\u0005=BT\"\u0001\u0019\u000b\u0005E\u0012\u0014aA1qS*\u00111\u0007N\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)d'A\u0003kk:LGOC\u00018\u0003\ry'oZ\u0005\u0003sA\u0012A\u0001V3ti\u0006\u0011RM\\:ve\u0016\u001cuN\u001c;s_2dWM]%o)\tQC\bC\u0003>\u000b\u0001\u0007a(A\u0005ce>\\WM]%egB\u0019\u0001eI\f\u0002\u0019\r\u0014X-\u0019;f\u0007>tg-[4\u0015\u0007\u0015\n5\tC\u0003C\r\u0001\u0007q#\u0001\u0004o_\u0012,\u0017\n\u001a\u0005\u0006\t\u001a\u0001\r!R\u0001\u0013S:$XM\u001d\"s_.,'OV3sg&|g\u000e\u0005\u0002G\u001b6\tqI\u0003\u0002I\u0013\u000611m\\7n_:T!!\u0003&\u000b\u0005-Y%B\u0001'7\u0003\u0019\t\u0007/Y2iK&\u0011aj\u0012\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0002")
public class FetchRequestTestDowngrade
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 2;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return new .colon.colon((Object)this.createConfig(0, MetadataVersion.IBP_3_1_IV0), (List)new .colon.colon((Object)this.createConfig(1, MetadataVersion.IBP_2_7_IV0), (List)Nil$.MODULE$));
    }

    @Test
    public void testTopicIdIsRemovedFromFetcherWhenControllerDowngrades() {
        TopicPartition tp = new TopicPartition("topic", 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.ensureControllerIn((Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        Assertions.assertEquals((int)0, (int)this.controllerSocketServer().config().brokerId());
        scala.collection.immutable.Map<Object, Object> partitionLeaders = this.createTopicWithAssignment(tp.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), tp.topic(), 1);
        this.ensureControllerIn((Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))));
        Assertions.assertEquals((int)1, (int)this.controllerSocketServer().config().brokerId());
        Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)0))));
        ProducerRecord record1 = new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        producer.send(record1);
        consumer.assign(Arrays.asList(tp));
        int count = consumer.poll(Duration.ofMillis(5000L)).count();
        Assertions.assertEquals((int)1, (int)count);
    }

    private void ensureControllerIn(Seq<Object> brokerIds) {
        while (!brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)this.controllerSocketServer().config().brokerId()))) {
            this.zkClient().deleteController(ZkVersion$.MODULE$.MatchAnyVersion());
            TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        }
    }

    private KafkaConfig createConfig(int nodeId, MetadataVersion interBrokerVersion) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), interBrokerVersion.version());
        return KafkaConfig$.MODULE$.fromProps(props);
    }
}

