/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.BrokerEndPoint;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.LocalLeaderEndPoint;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.server.checkpoints.LazyOffsetCheckpoints;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tub\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004H\u0001\u0001\u0006Ia\u000f\u0005\b\u0011\u0002\u0011\r\u0011\"\u0001J\u0011\u0019\u0001\u0006\u0001)A\u0005\u0015\"9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006BB.\u0001A\u0003%1\u000bC\u0004]\u0001\t\u0007I\u0011A/\t\r\u0005\u0004\u0001\u0015!\u0003_\u0011\u001d\u0011\u0007A1A\u0005\u0002\rDaA\u001b\u0001!\u0002\u0013!\u0007\"C6\u0001\u0001\u0004\u0005\r\u0011\"\u0001m\u0011%\u0001\b\u00011AA\u0002\u0013\u0005\u0011\u000fC\u0005x\u0001\u0001\u0007\t\u0011)Q\u0005[\"I\u0001\u0010\u0001a\u0001\u0002\u0004%\t!\u001f\u0005\n{\u0002\u0001\r\u00111A\u0005\u0002yD!\"!\u0001\u0001\u0001\u0004\u0005\t\u0015)\u0003{\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bAq!!\b\u0001\t\u0003\t)\u0001C\u0004\u0002(\u0001!\t!!\u0002\t\u000f\u0005-\u0002\u0001\"\u0001\u0002\u0006!9\u0011q\u0006\u0001\u0005\u0002\u0005\u0015aABA\u001a\u0001\u0011\t)\u0004\u0003\u00046/\u0011\u0005\u0011\u0011\b\u0005\n\u0003+:\u0002\u0019!C\u0005\u0003/B\u0011\"a\u0018\u0018\u0001\u0004%I!!\u0019\t\u0011\u0005\u0015t\u0003)Q\u0005\u00033B\u0011\"a\u001a\u0018\u0001\u0004%I!!\u001b\t\u0013\u0005Mt\u00031A\u0005\n\u0005U\u0004\u0002CA=/\u0001\u0006K!a\u001b\t\u000f\u0005mt\u0003\"\u0001\u0002~!9\u0011QQ\f\u0005\u0002\u0005\u001d\u0005bBAF/\u0011\u0005\u0011Q\u0012\u0005\b\u0003#\u0003A\u0011BAJ\u0011\u001d\tY\u000b\u0001C\u0005\u0003[C\u0011B!\u0005\u0001#\u0003%IAa\u0005\t\u0013\t%\u0002!%A\u0005\n\t-\u0002b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\b\u0003C\u0004A\u0011\u0002B\u001e\u0005]aunY1m\u0019\u0016\fG-\u001a:F]\u0012\u0004v.\u001b8u)\u0016\u001cHO\u0003\u0002+W\u000511/\u001a:wKJT\u0011\u0001L\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0006\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0002\"\u0001\u000f\u0001\u000e\u0003%\nA\u0001^5nKV\t1\b\u0005\u0002=\u000b6\tQH\u0003\u0002?\u007f\u0005!Q\u000f^5m\u0015\tQ\u0003I\u0003\u0002-\u0003*\u0011!iQ\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\u000b1a\u001c:h\u0013\t1UH\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001d!x\u000e]5d\u0013\u0012,\u0012A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b\u0002\u000baaY8n[>t\u0017BA(M\u0005\u0011)V/\u001b3\u0002\u0011Q|\u0007/[2JI\u0002\nQ\u0001^8qS\u000e,\u0012a\u0015\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000bA\u0001\\1oO*\t\u0001,\u0001\u0003kCZ\f\u0017B\u0001.V\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001_!\tYu,\u0003\u0002a\u0019\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u0019M|WO]2f\u0005J|7.\u001a:\u0016\u0003\u0011\u0004\"!\u001a5\u000e\u0003\u0019T!aZ\u0016\u0002\u000f\rdWo\u001d;fe&\u0011\u0011N\u001a\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u00035\u0019x.\u001e:dK\n\u0013xn[3sA\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#A7\u0011\u0005ar\u0017BA8*\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f!C]3qY&\u001c\u0017-T1oC\u001e,'o\u0018\u0013fcR\u0011!/\u001e\t\u0003aML!\u0001^\u0019\u0003\tUs\u0017\u000e\u001e\u0005\bm6\t\t\u00111\u0001n\u0003\rAH%M\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005AQM\u001c3Q_&tG/F\u0001{!\tA40\u0003\u0002}S\tqA*Z1eKJ,e\u000e\u001a)pS:$\u0018\u0001D3oIB{\u0017N\u001c;`I\u0015\fHC\u0001:\u0000\u0011\u001d1\b#!AA\u0002i\f\u0011\"\u001a8e!>Lg\u000e\u001e\u0011\u0002\u000bM,G/\u00169\u0015\u0003ID3AEA\u0005!\u0011\tY!!\u0007\u000e\u0005\u00055!\u0002BA\b\u0003#\t1!\u00199j\u0015\u0011\t\u0019\"!\u0006\u0002\u000f),\b/\u001b;fe*\u0019\u0011qC\"\u0002\u000b),h.\u001b;\n\t\u0005m\u0011Q\u0002\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!\u0006;fgR4U\r^2i\u0019\u0006$Xm\u001d;PM\u001a\u001cX\r\u001e\u0015\u0004'\u0005\u0005\u0002\u0003BA\u0006\u0003GIA!!\n\u0002\u000e\t!A+Z:u\u0003]!Xm\u001d;GKR\u001c\u0007.R1sY&,7\u000f^(gMN,G\u000fK\u0002\u0015\u0003C\tA\u0004^3ti\u001a+Go\u00195FCJd\u0017.Z:u\u0019>\u001c\u0017\r\\(gMN,G\u000fK\u0002\u0016\u0003C\t\u0001\u0004^3ti\u001a+Go\u00195Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;tQ\r1\u0012\u0011\u0005\u0002\u000f\u0007\u0006dGNY1dWJ+7/\u001e7u+\u0011\t9$a\u0011\u0014\u0005]yCCAA\u001e!\u0015\tidFA \u001b\u0005\u0001\u0001\u0003BA!\u0003\u0007b\u0001\u0001B\u0004\u0002F]\u0011\r!a\u0012\u0003\u0003Q\u000bB!!\u0013\u0002PA\u0019\u0001'a\u0013\n\u0007\u00055\u0013GA\u0004O_RD\u0017N\\4\u0011\u0007A\n\t&C\u0002\u0002TE\u00121!\u00118z\u0003\u00151\u0018\r\\;f+\t\tI\u0006E\u00031\u00037\ny$C\u0002\u0002^E\u0012aa\u00149uS>t\u0017!\u0003<bYV,w\fJ3r)\r\u0011\u00181\r\u0005\tmj\t\t\u00111\u0001\u0002Z\u00051a/\u00197vK\u0002\n1AZ;o+\t\tY\u0007E\u00031\u00037\ni\u0007\u0005\u00041\u0003_\nyD]\u0005\u0004\u0003c\n$!\u0003$v]\u000e$\u0018n\u001c82\u0003\u001d1WO\\0%KF$2A]A<\u0011!1X$!AA\u0002\u0005-\u0014\u0001\u00024v]\u0002\n\u0001\u0002[1t\r&\u0014X\rZ\u000b\u0003\u0003\u007f\u00022\u0001MAA\u0013\r\t\u0019)\r\u0002\b\u0005>|G.Z1o\u0003\u00111\u0017N]3\u0015\u0007I\fI\tC\u0004\u0002V\u0001\u0002\r!a\u0010\u0002\r=tg)\u001b:f)\u0011\tY$a$\t\u000f\u0005\u001d\u0014\u00051\u0001\u0002n\u0005A\"-^5mI2+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;\u0015\t\u0005U\u0015\u0011\u0015\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111\u0014'\u0002\u0011I,\u0017/^3tiNLA!a(\u0002\u001a\n\u0019B*Z1eKJ\fe\u000eZ%teJ+\u0017/^3ti\"9\u00111\u0015\u0012A\u0002\u0005\u0015\u0016a\u00037fC\u0012,'/\u00129pG\"\u00042\u0001MAT\u0013\r\tI+\r\u0002\u0004\u0013:$\u0018!D1qa\u0016tGMU3d_J$7\u000f\u0006\u0007\u00020\u0006e\u00171\\Ap\u0003_\u00149\u0001E\u0003\u0002>]\t\t\f\u0005\u0003\u00024\u0006Mg\u0002BA[\u0003\u001ftA!a.\u0002N:!\u0011\u0011XAf\u001d\u0011\tY,!3\u000f\t\u0005u\u0016q\u0019\b\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*\u0019\u00111Y\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0015B\u0001\"D\u0013\ta\u0013)\u0003\u0002N\u0001&\u0019\u00111\u0014'\n\t\u0005E\u0017\u0011T\u0001\u0010!J|G-^2f%\u0016\u001c\bo\u001c8tK&!\u0011Q[Al\u0005E\u0001\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u0006\u0005\u0003#\fI\nC\u0003lG\u0001\u0007Q\u000e\u0003\u0004\u0002^\u000e\u0002\rAX\u0001\na\u0006\u0014H/\u001b;j_:Dq!!9$\u0001\u0004\t\u0019/A\u0004sK\u000e|'\u000fZ:\u0011\t\u0005\u0015\u00181^\u0007\u0003\u0003OT1!!;M\u0003\u0019\u0011XmY8sI&!\u0011Q^At\u00055iU-\\8ssJ+7m\u001c:eg\"I\u0011\u0011_\u0012\u0011\u0002\u0003\u0007\u00111_\u0001\u0007_JLw-\u001b8\u0011\t\u0005U(1A\u0007\u0003\u0003oTA!!?\u0002|\u0006\u0019An\\4\u000b\t\u0005u\u0018q`\u0001\nS:$XM\u001d8bYNT1A!\u0001A\u0003\u001d\u0019Ho\u001c:bO\u0016LAA!\u0002\u0002x\na\u0011\t\u001d9f]\u0012|%/[4j]\"I!\u0011B\u0012\u0011\u0002\u0003\u0007!1B\u0001\re\u0016\fX/\u001b:fI\u0006\u001b7n\u001d\t\u0004a\t5\u0011b\u0001B\bc\t)1\u000b[8si\u00069\u0012\r\u001d9f]\u0012\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005+QC!a=\u0003\u0018-\u0012!\u0011\u0004\t\u0005\u00057\u0011)#\u0004\u0002\u0003\u001e)!!q\u0004B\u0011\u0003%)hn\u00195fG.,GMC\u0002\u0003$E\n!\"\u00198o_R\fG/[8o\u0013\u0011\u00119C!\b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\fbaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!Q\u0006\u0016\u0005\u0005\u0017\u00119\"\u0001\u0003o_\u0012,G\u0003\u0002B\u001a\u0005s\u00012a\u0013B\u001b\u0013\r\u00119\u0004\u0014\u0002\u0005\u001d>$W\rC\u0003yM\u0001\u0007A-\u0006\u0002\u0002d\u0002")
public class LocalLeaderEndPointTest {
    private final MockTime time = new MockTime();
    private final Uuid topicId = Uuid.randomUuid();
    private final String topic;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), 5);
    private final BrokerEndPoint sourceBroker = new BrokerEndPoint(0, "localhost", 9092);
    private ReplicaManager replicaManager;
    private LeaderEndPoint endPoint;

    public MockTime time() {
        return this.time;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public String topic() {
        return this.topic;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerEndPoint sourceBroker() {
        return this.sourceBroker;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LeaderEndPoint endPoint() {
        return this.endPoint;
    }

    public void endPoint_$eq(LeaderEndPoint x$1) {
        this.endPoint = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void setUp() {
        void zkMetadataCache_zkMigrationEnabled;
        void zkMetadataCache_kraftControllerNodes;
        void zkMetadataCache_brokerFeatures;
        void zkMetadataCache_metadataVersion;
        int x$1 = this.sourceBroker().id();
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$32 = this.sourceBroker().port();
        boolean x$42 = true;
        boolean x$52 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var50_11 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var51_14 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var52_17 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$42, x$52, x$32, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable)x$3 -> new File((String)x$3))), TestUtils$.MODULE$.createLogManager$default$2(), new MockConfigRepository(), new CleanerConfig(false), new MockTime(), MetadataVersion.latest(), 4, false, (Option<UnifiedLog>)None$.MODULE$);
        AlterPartitionManager alterPartitionManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        Metrics metrics = new Metrics();
        QuotaFactory.QuotaManagers quotaManager = QuotaFactory$.MODULE$.instantiate(config, metrics, (Time)this.time(), "");
        MockTime x$24 = this.time();
        MockScheduler x$25 = new MockScheduler((Time)this.time());
        boolean bl = false;
        Seq seq = (Seq)Seq$.MODULE$.empty();
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        MetadataVersion metadataVersion = config.interBrokerProtocolVersion();
        int zkMetadataCache_brokerId = config.brokerId();
        metadataVersion = null;
        brokerFeatures = null;
        seq = null;
        ZkMetadataCache x$28 = new ZkMetadataCache(zkMetadataCache_brokerId, (MetadataVersion)zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures, (Seq)zkMetadataCache_kraftControllerNodes, (boolean)zkMetadataCache_zkMigrationEnabled);
        LogDirFailureChannel x$29 = new LogDirFailureChannel(config.logDirs().size());
        None$ x$31 = None$.MODULE$;
        BrokerTopicStats x$322 = ReplicaManager$.MODULE$.$lessinit$greater$default$11();
        AtomicBoolean x$33 = new AtomicBoolean(false);
        None$ x$34 = None$.MODULE$;
        None$ x$35 = None$.MODULE$;
        None$ x$36 = None$.MODULE$;
        None$ x$37 = None$.MODULE$;
        None$ x$38 = None$.MODULE$;
        None$ x$39 = None$.MODULE$;
        None$ x$40 = None$.MODULE$;
        Function0 x$41 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        None$ x$422 = None$.MODULE$;
        this.replicaManager_$eq(new ReplicaManager(config, metrics, (Time)x$24, (Scheduler)x$25, mockLogMgr, (Option)x$31, quotaManager, (MetadataCache)x$28, x$29, alterPartitionManager, x$322, x$33, (Option)x$34, (Option)x$35, (Option)x$36, (Option)x$37, (Option)x$38, (Option)x$39, (Option)x$40, x$41, (Option)x$422));
        this.replicaManager().createPartition(this.topicPartition()).createLogIfNotExists(false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(this.replicaManager().highWatermarkCheckpoints()), (Option)None$.MODULE$);
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(0);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$4, x$5) -> {
            LocalLeaderEndPointTest.$anonfun$setUp$2(x$4, x$5);
            return BoxedUnit.UNIT;
        });
        this.replicaManager().getPartitionOrException(this.topicPartition()).localLogOrException();
        this.endPoint_$eq((LeaderEndPoint)new LocalLeaderEndPoint(this.sourceBroker(), config, this.replicaManager(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$));
    }

    @Test
    public void testFetchLatestOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 0), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$6, x$7) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$2(x$6, x$7);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$3(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(6L, 4), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEarliestOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$8, x$9) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$2(x$8, x$9);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$3(response);
            return BoxedUnit.UNIT;
        });
        this.replicaManager().deleteRecords(1000L, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)3L))})), (Function1 & Serializable)x$10 -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$4(x$10);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 4), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEarliestLocalOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestLocalOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$11, x$12) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestLocalOffset$2(x$11, x$12);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestLocalOffset$3(response);
            return BoxedUnit.UNIT;
        });
        LogManager qual$1 = this.replicaManager().logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        qual$1.getLog(x$1, x$2).foreach((Function1 & Serializable)log -> {
            log._localLogStartOffset_$eq(3L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 7));
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 4), (Object)this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEpochEndOffsets() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$1(response);
            return BoxedUnit.UNIT;
        });
        Map result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(0))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(3L))}))), (Object)result);
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$13, x$14) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$2(x$13, x$14);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$3(response);
            return BoxedUnit.UNIT;
        });
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(4))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(4).setEndOffset(6L))}))), (Object)result);
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(3))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(3L))}))), (Object)result);
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(5))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(-1).setEndOffset(-1L))}))), (Object)result);
    }

    private LeaderAndIsrRequest buildLeaderAndIsrRequest(int leaderEpoch) {
        java.util.List brokerList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.sourceBroker().id()), (List)Nil$.MODULE$)).asJava();
        java.util.Map<String, Uuid> topicIds = Collections.singletonMap(this.topic(), this.topicId());
        return (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, 0L, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(this.topicPartition().partition()).setControllerEpoch(0).setLeader(this.sourceBroker().id()).setLeaderEpoch(leaderEpoch).setIsr(brokerList).setPartitionEpoch(0).setReplicas(brokerList).setIsNew(false), (List)Nil$.MODULE$)).asJava(), topicIds, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{this.node(this.sourceBroker())}))).asJava()).build();
    }

    private CallbackResult<ProduceResponse.PartitionResponse> appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records, AppendOrigin origin, short requiredAcks) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, requiredAcks, false, origin, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records)})), (Function1 & Serializable)responses -> {
            LocalLeaderEndPointTest.appendCallback$1(responses, partition, result);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8(), replicaManager.appendRecords$default$9(), replicaManager.appendRecords$default$10(), replicaManager.appendRecords$default$11(), replicaManager.appendRecords$default$12());
        return result;
    }

    private AppendOrigin appendRecords$default$4() {
        return AppendOrigin.CLIENT;
    }

    private short appendRecords$default$5() {
        return -1;
    }

    private Node node(BrokerEndPoint endPoint) {
        return new Node(endPoint.id(), endPoint.host(), endPoint.port());
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords records() {
        void withRecords_timestampType;
        SimpleRecord[] withRecords_records = new SimpleRecord[]{new SimpleRecord("first message".getBytes()), new SimpleRecord("second message".getBytes()), new SimpleRecord("third message".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        return MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    public static final /* synthetic */ void $anonfun$setUp$2(Iterable x$4, Iterable x$5) {
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$2(Iterable x$6, Iterable x$7) {
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$2(Iterable x$8, Iterable x$9) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$4(Map x$10) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestLocalOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestLocalOffset$2(Iterable x$11, Iterable x$12) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestLocalOffset$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$2(Iterable x$13, Iterable x$14) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    private static final void appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assertions.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    public LocalLeaderEndPointTest() {
        this.topic = "test";
    }

    private class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public boolean hasFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1 & Serializable)f -> {
                f.apply(value);
                return BoxedUnit.UNIT;
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
            if (this.hasFired()) {
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ LocalLeaderEndPointTest kafka$server$LocalLeaderEndPointTest$CallbackResult$$$outer() {
            return LocalLeaderEndPointTest.this;
        }

        public CallbackResult() {
            if (LocalLeaderEndPointTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

