/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommand$;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.server.ConfigEntityName$;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005!4Aa\u0002\u0005\u0001\u001b!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0001?!)a\n\u0001C\u0001\u001f\")A\u000b\u0001C\u0005+\")1\f\u0001C\u00019\")\u0011\r\u0001C\u0005E\na2i\u001c8gS\u001e\u001cu.\\7b]\u0012Le\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\u0005\u000b\u0003\u0015\tG-\\5o\u0015\u0005Y\u0011!B6bM.\f7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"BA\t\u000b\u0003\u0019\u0019XM\u001d<fe&\u00111\u0003\u0005\u0002\u0012#V|'/^7UKN$\b*\u0019:oKN\u001c\bCA\u000b\u0019\u001b\u00051\"BA\f\u000b\u0003\u0015)H/\u001b7t\u0013\tIbCA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005A\u0011!O:i_VdG-\u0012=ji^KG\u000f\u001b(p]j+'o\\*uCR,8o\u00148Va\u0012\fG/\u001b8h+:\fG\u000e\\8xK\u0012\u001cuN\u001c4jOZK\u0017MW6\u0015\u0005\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#\u0001B+oSRDQa\n\u0002A\u0002!\na!];peVl\u0007CA\u00151\u001d\tQc\u0006\u0005\u0002,E5\tAF\u0003\u0002.\u0019\u00051AH]8pizJ!a\f\u0012\u0002\rA\u0013X\rZ3g\u0013\t\t$G\u0001\u0004TiJLgn\u001a\u0006\u0003_\tBCA\u0001\u001bA\u0003B\u0011QGP\u0007\u0002m)\u0011q\u0007O\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005eR\u0014a\u00026va&$XM\u001d\u0006\u0003wq\nQA[;oSRT\u0011!P\u0001\u0004_J<\u0017BA 7\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-I\u0001C\u0003\tZH-[:qY\u0006Lh*Y7f{:Z\u0018M]4v[\u0016tGo],ji\"t\u0015-\\3t{\"\"!\u0001\u0012&L!\t)\u0005*D\u0001G\u0015\t9e'\u0001\u0005qe>4\u0018\u000eZ3s\u0013\tIeIA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0002\u0019\u0006\nQ*\u0001\u0002{W\u0006!4\u000f[8vY\u0012,\u00050\u001b;XSRDgj\u001c8[KJ|7\u000b^1ukN|eNW6D_6l\u0017M\u001c3BYR,'/V:feF+x\u000e^1\u0015\u0005\u0001\u0002\u0006\"B\u0014\u0004\u0001\u0004A\u0003\u0006B\u00025\u0001\u0006CCa\u0001#K'2\nA*A\fbgN,'\u000f\u001e(p]j+'o\\*uCR,8/\u0012=jiR\u0011\u0001E\u0016\u0005\u0006/\u0012\u0001\r\u0001W\u0001\u0005CJ<7\u000fE\u0002\"3\"J!A\u0017\u0012\u0003\u000b\u0005\u0013(/Y=\u0002WQ,7\u000f\u001e#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<W\u000b\u001d3bi\u0016,6/\u001b8h5>|7*Z3qKJ$\"\u0001I/\t\u000b\u001d*\u0001\u0019\u0001\u0015)\t\u0015!\u0004)\u0011\u0015\u0005\u000b\u0011S\u0005\rL\u0001M\u0003I\u0011XmZ5ti\u0016\u0014(I]8lKJLeNW6\u0015\u0005\u0001\u001a\u0007\"\u00023\u0007\u0001\u0004)\u0017AA5e!\t\tc-\u0003\u0002hE\t\u0019\u0011J\u001c;")
public class ConfigCommandIntegrationTest
extends QuorumTestHarness {
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void shouldExitWithNonZeroStatusOnUpdatingUnallowedConfigViaZk(String quorum) {
        this.assertNonZeroStatusExit(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "security.inter.broker.protocol=PLAINTEXT"});
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void shouldExitWithNonZeroStatusOnZkCommandAlterUserQuota(String quorum) {
        this.assertNonZeroStatusExit(new String[]{"--zookeeper", this.zkConnect(), "--entity-type", "users", "--entity-name", "admin", "--alter", "--add-config", "consumer_byte_rate=20000"});
    }

    private void assertNonZeroStatusExit(String[] args) {
        ObjectRef exitStatus = ObjectRef.create((Object)None$.MODULE$);
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, x$1) -> ConfigCommandIntegrationTest.$anonfun$assertNonZeroStatusExit$1(exitStatus, BoxesRunTime.unboxToInt((Object)status), x$1);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var4_3 = null;
        try {
            try {
                ConfigCommand$.MODULE$.main(args);
            }
            catch (RuntimeException runtimeException) {}
        }
        finally {
            Exit.resetExitProcedure();
        }
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((Option)exitStatus.elem));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testDynamicBrokerConfigUpdateUsingZooKeeper(String quorum) {
        String brokerId = "1";
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient(), (Option)None$.MODULE$);
        String[] alterOpts = new String[]{"--zookeeper", this.zkConnect(), "--entity-type", "brokers", "--alter"};
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"110000")})), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"120000")})), (Option)None$.MODULE$, alterOpts, adminZkClient);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"130000")})), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"140000")})), (Option)None$.MODULE$, alterOpts, adminZkClient);
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"})), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"})), (Option)None$.MODULE$, alterOpts, adminZkClient);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location"), (Object)"/tmp/test.jks")})), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Assertions.assertThrows(ConfigException.class, () -> this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/tmp/test.jks")})), (Option)new Some((Object)brokerId), ConfigCommandIntegrationTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient));
        Assertions.assertThrows(ConfigException.class, () -> this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location"), (Object)"/tmp/test.jks")})), (Option)None$.MODULE$, ConfigCommandIntegrationTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient));
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.ssl.keystore.location"})), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.password"), (Object)"secret")})), (Option)new Some((Object)brokerId), ConfigCommandIntegrationTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient));
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.password"), (Object)"secret"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.threads"), (Object)"2")}));
        scala.collection.immutable.Map encoderConfigs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp()), (Object)"encoder-secret")}));
        this.alterConfigWithZk$1(configs, (Option)new Some((Object)brokerId), encoderConfigs, alterOpts, adminZkClient);
        Properties brokerConfigs = this.zkClient().getEntityConfigs("brokers", brokerId);
        Assertions.assertFalse((boolean)brokerConfigs.contains(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()), (String)"Encoder secret stored in ZooKeeper");
        Assertions.assertEquals((Object)"2", (Object)brokerConfigs.getProperty("log.cleaner.threads"));
        String encodedPassword = brokerConfigs.getProperty("listener.name.external.ssl.keystore.password");
        PasswordEncoder passwordEncoder = ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs);
        Assertions.assertEquals((Object)"secret", (Object)passwordEncoder.decode(encodedPassword).value());
        Assertions.assertEquals((int)configs.size(), (int)brokerConfigs.size());
        scala.collection.immutable.Map configs2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.ssl.keystore.password"), (Object)"secret2")}));
        scala.collection.immutable.Map encoderConfigs2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp()), (Object)"encoder-secret"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp()), (Object)"DES/CBC/PKCS5Padding"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderIterationsProp()), (Object)"1024"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyFactoryAlgorithmProp()), (Object)"PBKDF2WithHmacSHA1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp()), (Object)"64")}));
        this.alterConfigWithZk$1(configs2, (Option)new Some((Object)brokerId), encoderConfigs2, alterOpts, adminZkClient);
        String encodedPassword2 = this.zkClient().getEntityConfigs("brokers", brokerId).getProperty("listener.name.internal.ssl.keystore.password");
        Assertions.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs).decode(encodedPassword2).value());
        Assertions.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs2).decode(encodedPassword2).value());
        Assertions.assertThrows(ConfigException.class, () -> this.alterConfigWithZk$1(configs, (Option)None$.MODULE$, encoderConfigs, alterOpts, adminZkClient));
        this.registerBrokerInZk(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(brokerId)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"210000")})), (Option)new Some((Object)brokerId), ConfigCommandIntegrationTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"220000")})), (Option)None$.MODULE$, ConfigCommandIntegrationTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient));
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"230000")})), (Option)new Some((Object)"2"), alterOpts, adminZkClient);
    }

    private void registerBrokerInZk(int id) {
        this.zkClient().createTopLevelPaths();
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        EndPoint endpoint = new EndPoint("localhost", 9092, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
        BrokerInfo brokerInfo = BrokerInfo$.MODULE$.apply(Broker$.MODULE$.apply(id, (Seq)new .colon.colon((Object)endpoint, (List)Nil$.MODULE$), (Option)None$.MODULE$), MetadataVersion.latestTesting(), 9192);
        this.zkClient().registerBroker(brokerInfo);
    }

    public static final /* synthetic */ Nothing$ $anonfun$assertNonZeroStatusExit$1(ObjectRef exitStatus$1, int status, Option x$1) {
        exitStatus$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)status));
        throw new RuntimeException();
    }

    public static final /* synthetic */ String[] $anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$2() {
        return new String[]{"--entity-default"};
    }

    /*
     * Exception decompiling
     */
    private static final String[] entityOpt$1(Option brokerId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void alterConfigWithZk$1(scala.collection.immutable.Map configs, Option brokerId, scala.collection.immutable.Map encoderConfigs, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        String configStr = ((IterableOnceOps)configs.$plus$plus((IterableOnce)encoderConfigs).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return new StringBuilder(1).append(k).append("=").append(v).toString();
            }
            throw new MatchError(null);
        })).mkString(",");
        ConfigCommand.ConfigCommandOptions addOpts = new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])alterOpts$1), (Object)ConfigCommandIntegrationTest.entityOpt$1(brokerId), ClassTag$.MODULE$.apply(String.class))), (Object)new String[]{"--add-config", configStr}, ClassTag$.MODULE$.apply(String.class)));
        ConfigCommand$.MODULE$.alterConfigWithZk(this.zkClient(), addOpts, adminZkClient$1);
    }

    private static final scala.collection.immutable.Map alterConfigWithZk$default$3$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private final void verifyConfig$1(scala.collection.immutable.Map configs, Option brokerId) {
        Properties entityConfigs = this.zkClient().getEntityConfigs("brokers", (String)brokerId.getOrElse((Function0 & Serializable)() -> ConfigEntityName$.MODULE$.Default()));
        Assertions.assertEquals((Object)configs, (Object)CollectionConverters$.MODULE$.PropertiesHasAsScala(entityConfigs).asScala());
    }

    private final void alterAndVerifyConfig$1(scala.collection.immutable.Map configs, Option brokerId, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        this.alterConfigWithZk$1(configs, brokerId, ConfigCommandIntegrationTest.alterConfigWithZk$default$3$1(), alterOpts$1, adminZkClient$1);
        this.verifyConfig$1(configs, brokerId);
    }

    private final void deleteAndVerifyConfig$1(Set configNames, Option brokerId, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        ConfigCommand.ConfigCommandOptions deleteOpts = new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])alterOpts$1), (Object)ConfigCommandIntegrationTest.entityOpt$1(brokerId), ClassTag$.MODULE$.apply(String.class))), (Object)new String[]{"--delete-config", configNames.mkString(",")}, ClassTag$.MODULE$.apply(String.class)));
        ConfigCommand$.MODULE$.alterConfigWithZk(this.zkClient(), deleteOpts, adminZkClient$1);
        this.verifyConfig$1(Predef$.MODULE$.Map().empty(), brokerId);
    }
}

