/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.AbstractPartitionTest;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005Q2A\u0001B\u0003\u0001\u0015!)q\u0002\u0001C\u0001!!)!\u0003\u0001C)'!)\u0011\u0005\u0001C\u0001E\t!\u0003+\u0019:uSRLwN\\,ji\"dUmZ1ds6+7o]1hK\u001a{'/\\1u)\u0016\u001cHO\u0003\u0002\u0007\u000f\u000591\r\\;ti\u0016\u0014(\"\u0001\u0005\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0003\t\u0003\u00195i\u0011!B\u0005\u0003\u001d\u0015\u0011Q#\u00112tiJ\f7\r\u001e)beRLG/[8o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011A\u0002A\u0001\u001bS:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\\\u000b\u0002)A\u0011QcH\u0007\u0002-)\u0011q\u0003G\u0001\u0007G>lWn\u001c8\u000b\u0005eQ\u0012AB:feZ,'O\u0003\u0002\t7)\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0013\t\u0001cCA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003I\"Xm\u001d;NC.,G*Z1eKJ$u.Z:O_R,\u0006\u000fZ1uK\u0016\u0003xn\u00195DC\u000eDWMR8s\u001f2$gi\u001c:nCR\u001cH#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0007)\u0002\"a\u000b\u001a\u000e\u00031R!!\f\u0018\u0002\u0007\u0005\u0004\u0018N\u0003\u00020a\u00059!.\u001e9ji\u0016\u0014(BA\u0019\u001e\u0003\u0015QWO\\5u\u0013\t\u0019DF\u0001\u0003UKN$\b")
public class PartitionWithLegacyMessageFormatTest
extends AbstractPartitionTest {
    @Override
    public MetadataVersion interBrokerProtocolVersion() {
        return MetadataVersion.IBP_2_8_IV1;
    }

    @Test
    public void testMakeLeaderDoesNotUpdateEpochCacheForOldFormats() {
        int leaderEpoch = 8;
        this.configRepository().setTopicConfig(this.topicPartition().topic(), "message.format.version", MetadataVersion.IBP_0_10_2_IV0.shortVersion());
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        UnifiedLog log = qual$1.getOrCreateLog(x$12, x$3, x$4, (Option)x$2, x$5);
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), RecordVersion.V1.value, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)Nil$.MODULE$)), RecordVersion.V1.value, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        Assertions.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderLogIfLocal().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.logEndOffset())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.latestEpoch());
        OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assertions.assertEquals((long)-1L, (long)epochEndOffset.endOffset());
        Assertions.assertEquals((int)-1, (int)epochEndOffset.leaderEpoch());
    }
}

