/*
 * Decompiled with CFR 0.152.
 */
package kafka.docker;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kafka.docker.KafkaDockerWrapper$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005%4A!\u0006\f\u00017!)!\u0005\u0001C\u0001G!)a\u0005\u0001C\u0001O!)\u0001\b\u0001C\u0001O!)!\b\u0001C\u0001O!)A\b\u0001C\u0001O!)a\b\u0001C\u0001O!)\u0001\t\u0001C\u0001O!)!\t\u0001C\u0001O!)A\t\u0001C\u0001O!)a\t\u0001C\u0001O!)\u0001\n\u0001C\u0001O!)!\n\u0001C\u0001O!)A\n\u0001C\u0001O!)a\n\u0001C\u0001O!)\u0001\u000b\u0001C\u0001O!)!\u000b\u0001C\u0001O!)A\u000b\u0001C\u0001O!)a\u000b\u0001C\u0001O!)\u0001\f\u0001C\u0001O!)!\f\u0001C\u00057\n12*\u00194lC\u0012{7m[3s/J\f\u0007\u000f]3s)\u0016\u001cHO\u0003\u0002\u00181\u00051Am\\2lKJT\u0011!G\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0004\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0002\"!\n\u0001\u000e\u0003Y\t1\u0004^3ti\u001e+GoU3sm\u0016\u00148i\u001c8gS\u001e\u001chI]8n\u000b:4H#\u0001\u0015\u0011\u0005uI\u0013B\u0001\u0016\u001f\u0005\u0011)f.\u001b;)\u0005\ta\u0003CA\u00177\u001b\u0005q#BA\u00181\u0003\r\t\u0007/\u001b\u0006\u0003cI\nqA[;qSR,'O\u0003\u00024i\u0005)!.\u001e8ji*\tQ'A\u0002pe\u001eL!a\u000e\u0018\u0003\tQ+7\u000f^\u0001\u0019i\u0016\u001cH\u000f\u0015:fa\u0006\u0014XmU3sm\u0016\u00148i\u001c8gS\u001e\u001c\bFA\u0002-\u0003)\"Xm\u001d;Qe\u0016\u0004\u0018M]3TKJ4XM]\"p]\u001aLwm],ji\"|W\u000f^'pk:$X\r\u001a$jY\u0016D#\u0001\u0002\u0017\u0002WQ,7\u000f\u001e)sKB\f'/Z*feZ,'oQ8oM&<7oV5uQ>,H/\u00128w-\u0006\u0014\u0018.\u00192mKND#!\u0002\u0017\u0002QQ,7\u000f\u001e)sKB\f'/Z*feZ,'oQ8oM&<7oV5uQ>,H/V:fe&s\u0007/\u001e;)\u0005\u0019a\u0013\u0001\f;fgR\u0004&/\u001a9be\u0016\u001cVM\u001d<fe\u000e{gNZ5hg^KG\u000f[#naRLXj\\;oi\u0016$g)\u001b7fQ\t9A&\u0001\u000euKN$x)\u001a;M_\u001e$$nQ8oM&<7O\u0012:p[\u0016sg\u000f\u000b\u0002\tY\u0005aC/Z:u\u000f\u0016$Hj\\45U\u000e{gNZ5hg\u001a\u0013x.\\#om&sg/\u00197jI\u0016sgOV1sS\u0006\u0014G.\u001a\u0015\u0003\u00131\na\u0006^3ti\u001e+G\u000fT8hi)\u001cuN\u001c4jON4%o\\7F]Z<\u0016\u000e\u001e5F[B$\u00180\u00128w-\u0006\u0014\u0018.\u00192mK\"\u0012!\u0002L\u0001\u0018i\u0016\u001cH\u000f\u0015:fa\u0006\u0014X\rT8hi)\u001cuN\u001c4jOND#a\u0003\u0017\u0002SQ,7\u000f\u001e)sKB\f'/\u001a'pORR7i\u001c8gS\u001e\u001cx+\u001b;i_V$Xj\\;oi\u0016$g)\u001b7fQ\taA&\u0001\u0016uKN$\bK]3qCJ,Gj\\45U\u000e{gNZ5hg^KG\u000f[8vi\u0016sgOV1sS\u0006\u0014G.Z:)\u00055a\u0013a\b;fgR<U\r\u001e+p_2\u001cHj\\45U\u000e{gNZ5hg\u001a\u0013x.\\#om\"\u0012a\u0002L\u00012i\u0016\u001cHoR3u)>|Gn\u001d'pORR7i\u001c8gS\u001e\u001chI]8n\u000b:4\u0018J\u001c<bY&$WI\u001c<WCJL\u0017M\u00197fQ\tyA&A\u001auKN$x)\u001a;U_>d7\u000fT8hi)\u001cuN\u001c4jON4%o\\7F]Z<\u0016\u000e\u001e5F[B$\u00180\u00128w-\u0006\u0014\u0018.\u00192mK\"\u0012\u0001\u0003L\u0001\u001di\u0016\u001cH\u000f\u0015:fa\u0006\u0014X\rV8pYNdun\u001a\u001bk\u0007>tg-[4tQ\t\tB&\u0001\u0018uKN$\bK]3qCJ,Gk\\8mg2{w\r\u000e6D_:4\u0017nZ:XSRDw.\u001e;N_VtG/\u001a3GS2,\u0007F\u0001\n-\u00039\"Xm\u001d;Qe\u0016\u0004\u0018M]3U_>d7\u000fT8hi)\u001cuN\u001c4jON<\u0016\u000e\u001e5pkR,eN\u001e,be&\f'\r\\3)\u0005Ma\u0013AC2sK\u0006$X\rR5sgR\tA\fE\u0003\u001e;~{v,\u0003\u0002_=\t1A+\u001e9mKN\u0002\"\u0001Y4\u000e\u0003\u0005T!AY2\u0002\t\u0019LG.\u001a\u0006\u0003I\u0016\f1A\\5p\u0015\u00051\u0017\u0001\u00026bm\u0006L!\u0001[1\u0003\tA\u000bG\u000f\u001b")
public class KafkaDockerWrapperTest {
    @Test
    public void testGetServerConfigsFromEnv() {
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_TOOLS_LOG4J_LOGLEVEL"), (Object)"TRACE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_VALID_PROPERTY"), (Object)"Value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_VALID___PROPERTY__ALL_CASES"), (Object)"All Cases Value")}));
        .colon.colon expected = new .colon.colon((Object)"valid.property=Value", (List)new .colon.colon((Object)"valid-property_all.cases=All Cases Value", (List)Nil$.MODULE$));
        List actual = KafkaDockerWrapper$.MODULE$.getServerConfigsFromEnv(envVars);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareServerConfigs() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_ENV_CONFIG"), (Object)"env value")}));
        Files.write(var2_2.resolve("server.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var3_3.resolve("server.properties"), "mounted.config=mounted value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var4_4.resolve("server.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareServerConfigs((Path)var2_2, (Path)var3_3, (Path)var4_4, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(18).append(var4_4.toString()).append("/server.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"mounted.config=mounted value\nenv.config=env value", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareServerConfigsWithoutMountedFile() {
        String string;
        void var3_3;
        void var4_4;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_ENV_CONFIG"), (Object)"env value")}));
        Files.write(var2_2.resolve("server.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var4_4.resolve("server.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareServerConfigs((Path)var2_2, (Path)var3_3, (Path)var4_4, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(18).append(var4_4.toString()).append("/server.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"\nenv.config=env value", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareServerConfigsWithoutEnvVariables() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        Map envVars = Predef$.MODULE$.Map().empty();
        Files.write(var2_2.resolve("server.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var3_3.resolve("server.properties"), "mounted.config=mounted value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var4_4.resolve("server.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareServerConfigs((Path)var2_2, (Path)var3_3, (Path)var4_4, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(18).append(var4_4.toString()).append("/server.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"mounted.config=mounted value", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareServerConfigsWithoutUserInput() {
        String string;
        void var3_3;
        void var4_4;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        Map envVars = Predef$.MODULE$.Map().empty();
        Files.write(var2_2.resolve("server.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var4_4.resolve("server.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareServerConfigs((Path)var2_2, (Path)var3_3, (Path)var4_4, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(18).append(var4_4.toString()).append("/server.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"default.config=default value", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareServerConfigsWithEmptyMountedFile() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        Map envVars = Predef$.MODULE$.Map().empty();
        Files.write(var2_2.resolve("server.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var3_3.resolve("server.properties"), " \n \n ".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var4_4.resolve("server.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareServerConfigs((Path)var2_2, (Path)var3_3, (Path)var4_4, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(18).append(var4_4.toString()).append("/server.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"default.config=default value", (Object)actual);
    }

    @Test
    public void testGetLog4jConfigsFromEnv() {
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_LOGGERS"), (Object)"kafka=INFO,kafka.network.RequestChannel$=WARN,kafka.producer.async.DefaultEventHandler=DEBUG,"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_ROOT_LOGLEVEL"), (Object)"ERROR"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value")}));
        String expected = "\nlog4j.rootLogger=ERROR, stdout\nlog4j.logger.kafka=INFO\nlog4j.logger.kafka.network.RequestChannel$=WARN\nlog4j.logger.kafka.producer.async.DefaultEventHandler=DEBUG";
        String actual = KafkaDockerWrapper$.MODULE$.getLog4jConfigsFromEnv(envVars);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetLog4jConfigsFromEnvInvalidEnvVariable() {
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value")}));
        String expected = "";
        String actual = KafkaDockerWrapper$.MODULE$.getLog4jConfigsFromEnv(envVars);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetLog4jConfigsFromEnvWithEmptyEnvVariable() {
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_LOGGERS"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_ROOT_LOGLEVEL"), (Object)"")}));
        String expected = "";
        String actual = KafkaDockerWrapper$.MODULE$.getLog4jConfigsFromEnv(envVars);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareLog4jConfigs() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_LOGGERS"), (Object)"kafka=INFO,kafka.network.RequestChannel$=WARN,kafka.producer.async.DefaultEventHandler=DEBUG,"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_ROOT_LOGLEVEL"), (Object)"ERROR"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value")}));
        Files.write(var2_2.resolve("log4j.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var3_3.resolve("log4j.properties"), "mounted.config=mounted value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var4_4.resolve("log4j.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareLog4jConfigs((Path)var2_2, (Path)var3_3, (Path)var4_4, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(17).append(var4_4.toString()).append("/log4j.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"mounted.config=mounted value\nlog4j.rootLogger=ERROR, stdout\nlog4j.logger.kafka=INFO\nlog4j.logger.kafka.network.RequestChannel$=WARN\nlog4j.logger.kafka.producer.async.DefaultEventHandler=DEBUG", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareLog4jConfigsWithoutMountedFile() {
        String string;
        void var3_3;
        void var4_4;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_LOGGERS"), (Object)"kafka=INFO,kafka.network.RequestChannel$=WARN,kafka.producer.async.DefaultEventHandler=DEBUG,"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_ROOT_LOGLEVEL"), (Object)"ERROR"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value")}));
        Files.write(var2_2.resolve("log4j.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var4_4.resolve("log4j.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareLog4jConfigs((Path)var2_2, (Path)var3_3, (Path)var4_4, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(17).append(var4_4.toString()).append("/log4j.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"default.config=default value\nlog4j.rootLogger=ERROR, stdout\nlog4j.logger.kafka=INFO\nlog4j.logger.kafka.network.RequestChannel$=WARN\nlog4j.logger.kafka.producer.async.DefaultEventHandler=DEBUG", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareLog4jConfigsWithoutEnvVariables() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        Map envVars = Predef$.MODULE$.Map().empty();
        Files.write(var2_2.resolve("log4j.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var3_3.resolve("log4j.properties"), "mounted.config=mounted value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var4_4.resolve("log4j.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareLog4jConfigs((Path)var2_2, (Path)var3_3, (Path)var4_4, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(17).append(var4_4.toString()).append("/log4j.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"mounted.config=mounted value", (Object)actual);
    }

    @Test
    public void testGetToolsLog4jConfigsFromEnv() {
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_TOOLS_LOG4J_LOGLEVEL"), (Object)"TRACE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value")}));
        String expected = "\nlog4j.rootLogger=TRACE, stderr";
        String actual = KafkaDockerWrapper$.MODULE$.getToolsLog4jConfigsFromEnv(envVars);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetToolsLog4jConfigsFromEnvInvalidEnvVariable() {
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value")}));
        String expected = "";
        String actual = KafkaDockerWrapper$.MODULE$.getToolsLog4jConfigsFromEnv(envVars);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetToolsLog4jConfigsFromEnvWithEmptyEnvVariable() {
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_TOOLS_LOG4J_LOGLEVEL"), (Object)"")}));
        String expected = "";
        String actual = KafkaDockerWrapper$.MODULE$.getToolsLog4jConfigsFromEnv(envVars);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareToolsLog4jConfigs() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_TOOLS_LOG4J_LOGLEVEL"), (Object)"TRACE")}));
        Files.write(var2_2.resolve("tools-log4j.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var3_3.resolve("tools-log4j.properties"), "mounted.config=mounted value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var4_4.resolve("tools-log4j.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareToolsLog4jConfigs((Path)var2_2, (Path)var3_3, (Path)var4_4, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(23).append(var4_4.toString()).append("/tools-log4j.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"mounted.config=mounted value\nlog4j.rootLogger=TRACE, stderr", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareToolsLog4jConfigsWithoutMountedFile() {
        String string;
        void var3_3;
        void var4_4;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_TOOLS_LOG4J_LOGLEVEL"), (Object)"TRACE")}));
        Files.write(var2_2.resolve("tools-log4j.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var4_4.resolve("tools-log4j.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareToolsLog4jConfigs((Path)var2_2, (Path)var3_3, (Path)var4_4, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(23).append(var4_4.toString()).append("/tools-log4j.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"default.config=default value\nlog4j.rootLogger=TRACE, stderr", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareToolsLog4jConfigsWithoutEnvVariable() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        Map envVars = Predef$.MODULE$.Map().empty();
        Files.write(var2_2.resolve("tools-log4j.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var3_3.resolve("tools-log4j.properties"), "mounted.config=mounted value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(var4_4.resolve("tools-log4j.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareToolsLog4jConfigs((Path)var2_2, (Path)var3_3, (Path)var4_4, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(23).append(var4_4.toString()).append("/tools-log4j.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"mounted.config=mounted value", (Object)actual);
    }

    private Tuple3<Path, Path, Path> createDirs() {
        Path defaultConfigsPath = Files.createTempDirectory("tmp", new FileAttribute[0]);
        Path mountedConfigsPath = Files.createTempDirectory("tmp", new FileAttribute[0]);
        Path finalConfigsPath = Files.createTempDirectory("tmp", new FileAttribute[0]);
        defaultConfigsPath.toFile().deleteOnExit();
        mountedConfigsPath.toFile().deleteOnExit();
        finalConfigsPath.toFile().deleteOnExit();
        return new Tuple3((Object)defaultConfigsPath, (Object)mountedConfigsPath, (Object)finalConfigsPath);
    }
}

