/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import kafka.log.LocalLog$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogManagerTest$;
import kafka.log.LogMetricNames$;
import kafka.log.LogTestUtils$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.log.remote.RemoteLogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.TestUtils$;
import org.apache.directory.api.util.FileUtils;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileIntRef;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0005b\u0001\u00027n\u0001IDQ!\u001f\u0001\u0005\u0002iDq! \u0001C\u0002\u0013\u0005a\u0010C\u0004\u0002\u001a\u0001\u0001\u000b\u0011B@\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005u\u0001\u0002CA\u0013\u0001\u0001\u0006I!a\b\t\u0013\u0005\u001d\u0002A1A\u0005\u0002\u0005u\u0001\u0002CA\u0015\u0001\u0001\u0006I!a\b\t\u0013\u0005-\u0002A1A\u0005\u0002\u00055\u0002\u0002CA\u001f\u0001\u0001\u0006I!a\f\t\u0013\u0005}\u0002A1A\u0005\u0002\u0005\u0005\u0003\u0002CA+\u0001\u0001\u0006I!a\u0011\t\u0017\u0005]\u0003\u00011AA\u0002\u0013\u0005\u0011\u0011\f\u0005\f\u0003O\u0002\u0001\u0019!a\u0001\n\u0003\tI\u0007C\u0006\u0002v\u0001\u0001\r\u0011!Q!\n\u0005m\u0003bCA<\u0001\u0001\u0007\t\u0019!C\u0001\u0003sB1\"!!\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0004\"Y\u0011q\u0011\u0001A\u0002\u0003\u0005\u000b\u0015BA>\u0011%\tI\t\u0001b\u0001\n\u0003\tY\t\u0003\u0005\u0002\u001a\u0002\u0001\u000b\u0011BAG\u0011%\tY\n\u0001b\u0001\n\u0003\ti\n\u0003\u0005\u0002&\u0002\u0001\u000b\u0011BAP\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!!1\u0001\t\u0003\tI\u000bC\u0004\u0002L\u0002!\t!!+\t\u000f\u0005U\u0007\u0001\"\u0001\u0002*\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005%\u0006bBAo\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003C\u0004A\u0011AAU\u0011\u001d\t)\u000f\u0001C\u0001\u0003SCq!!;\u0001\t\u0003\tI\u000bC\u0004\u0002n\u0002!\t!!+\t\u000f\u0005E\b\u0001\"\u0001\u0002*\"9\u0011Q\u001f\u0001\u0005\u0002\u0005%\u0006bBA}\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003{\u0004A\u0011AAU\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0003SCqA!\u0002\u0001\t\u0003\tI\u000bC\u0004\u0003\n\u0001!IAa\u0003\t\u000f\t\u0015\u0002\u0001\"\u0001\u0002*\"9!\u0011\u0006\u0001\u0005\u0002\u0005%\u0006b\u0002B\u0017\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0005c\u0001A\u0011AAU\u0011\u001d\u0011)\u0004\u0001C\u0001\u0003SCqA!\u000f\u0001\t\u0003\tI\u000bC\u0004\u0003>\u0001!\t!!+\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D!9!1\u000e\u0001\u0005\n\t5\u0004\"\u0003BF\u0001E\u0005I\u0011\u0002BG\u0011%\u0011\u0019\u000bAI\u0001\n\u0013\u0011)\u000bC\u0005\u0003*\u0002\t\n\u0011\"\u0003\u0003,\"9!q\u0016\u0001\u0005\u0002\u0005%\u0006b\u0002BZ\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0005o\u0003A\u0011AAU\u0011\u001d\u0011Y\f\u0001C\u0005\u0005{C\u0011B!6\u0001#\u0003%IAa+\t\u000f\t]\u0007\u0001\"\u0001\u0002*\"9!1\u001c\u0001\u0005\u0002\u0005%\u0006b\u0002Bp\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0005G\u0004A\u0011AAU\u0011\u001d\u00119\u000f\u0001C\u0001\u0003SCqAa;\u0001\t\u0013\u0011i\u000fC\u0004\u0004\n\u0001!Iaa\u0003\t\u000f\r\u0005\u0002\u0001\"\u0003\u0004$!91Q\b\u0001\u0005\n\r}\u0002bBB\"\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0007\u000f\u0002A\u0011AAU\u0011\u001d\u0019Y\u0005\u0001C\u0001\u0003SCqaa\u0014\u0001\t\u0003\tI\u000bC\u0004\u0004T\u0001!\t!!+\t\u000f\r]\u0003\u0001\"\u0001\u0002*\"911\f\u0001\u0005\u0002\ru\u0003\"CB:\u0001E\u0005I\u0011AB;\u0011%\u0019I\b\u0001b\u0001\n\u0003\u0019Y\b\u0003\u0005\u0004\u0004\u0002\u0001\u000b\u0011BB?\u0011%\u0019)\t\u0001b\u0001\n\u0003\u0019Y\b\u0003\u0005\u0004\b\u0002\u0001\u000b\u0011BB?\u0011%\u0019I\t\u0001b\u0001\n\u0003\u0019Y\b\u0003\u0005\u0004\f\u0002\u0001\u000b\u0011BB?\u0011%\u0019i\t\u0001b\u0001\n\u0003\u0019Y\b\u0003\u0005\u0004\u0010\u0002\u0001\u000b\u0011BB?\u0011%\u0019\t\n\u0001b\u0001\n\u0003\u0019Y\b\u0003\u0005\u0004\u0014\u0002\u0001\u000b\u0011BB?\u0011%\u0019)\n\u0001b\u0001\n\u0003\u0019Y\b\u0003\u0005\u0004\u0018\u0002\u0001\u000b\u0011BB?\u0011%\u0019I\n\u0001b\u0001\n\u0003\u0019Y\b\u0003\u0005\u0004\u001c\u0002\u0001\u000b\u0011BB?\u0011%\u0019i\n\u0001b\u0001\n\u0003\u0019Y\b\u0003\u0005\u0004 \u0002\u0001\u000b\u0011BB?\u0011%\u0019\t\u000b\u0001b\u0001\n\u0003\u0019Y\b\u0003\u0005\u0004$\u0002\u0001\u000b\u0011BB?\u0011%\u0019)\u000b\u0001b\u0001\n\u0003\u0019Y\b\u0003\u0005\u0004(\u0002\u0001\u000b\u0011BB?\u0011\u001d\u0019I\u000b\u0001C\u0001\u0003SCqa!,\u0001\t\u0003\tI\u000bC\u0004\u00042\u0002!\t!!+\t\u000f\rU\u0006\u0001\"\u0001\u0002*\"91\u0011\u0018\u0001\u0005\u0002\u0005%\u0006bBB_\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0007\u0003\u0004A\u0011AAU\u000f\u001d\u0019)-\u001cE\u0001\u0007\u000f4a\u0001\\7\t\u0002\r%\u0007BB=f\t\u0003\u0019Y\rC\u0004\u0004N\u0016$\taa4\t\u000f\rUW\r\"\u0001\u0004X\"91Q^3\u0005\u0002\r=\bbBB\u007fK\u0012\u00051q \u0005\n\t7)\u0017\u0013!C\u0001\t;\u0011a\u0002T8h\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002o_\u0006\u0019An\\4\u000b\u0003A\fQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001gB\u0011Ao^\u0007\u0002k*\ta/A\u0003tG\u0006d\u0017-\u0003\u0002yk\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A>\u0011\u0005q\u0004Q\"A7\u0002\tQLW.Z\u000b\u0002\u007fB!\u0011\u0011AA\u000b\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001B;uS2TA!!\u0003\u0002\f\u000511/\u001a:wKJT1\u0001]A\u0007\u0015\u0011\ty!!\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\u0019\"A\u0002pe\u001eLA!a\u0006\u0002\u0004\tAQj\\2l)&lW-A\u0003uS6,\u0007%A\bnCb\u0014v\u000e\u001c7J]R,'O^1m+\t\ty\u0002E\u0002u\u0003CI1!a\tv\u0005\rIe\u000e^\u0001\u0011[\u0006D(k\u001c7m\u0013:$XM\u001d<bY\u0002\n1\"\\1y\u0019><\u0017iZ3Ng\u0006aQ.\u0019=M_\u001e\fu-Z'tA\u0005AAn\\4Qe>\u00048/\u0006\u0002\u00020A!\u0011\u0011GA\u001d\u001b\t\t\u0019D\u0003\u0003\u0002\u0006\u0005U\"BAA\u001c\u0003\u0011Q\u0017M^1\n\t\u0005m\u00121\u0007\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u00037pOB\u0013x\u000e]:!\u0003%awnZ\"p]\u001aLw-\u0006\u0002\u0002DA!\u0011QIA)\u001b\t\t9EC\u0002o\u0003\u0013RA!a\u0013\u0002N\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0005\u0003\u001f\nY!A\u0004ti>\u0014\u0018mZ3\n\t\u0005M\u0013q\t\u0002\n\u0019><7i\u001c8gS\u001e\f!\u0002\\8h\u0007>tg-[4!\u0003\u0019awn\u001a#jeV\u0011\u00111\f\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)!\u0011\u0011MA\u001b\u0003\tIw.\u0003\u0003\u0002f\u0005}#\u0001\u0002$jY\u0016\f!\u0002\\8h\t&\u0014x\fJ3r)\u0011\tY'!\u001d\u0011\u0007Q\fi'C\u0002\u0002pU\u0014A!\u00168ji\"I\u00111O\u0007\u0002\u0002\u0003\u0007\u00111L\u0001\u0004q\u0012\n\u0014a\u00027pO\u0012K'\u000fI\u0001\u000bY><W*\u00198bO\u0016\u0014XCAA>!\ra\u0018QP\u0005\u0004\u0003\u007fj'A\u0003'pO6\u000bg.Y4fe\u0006qAn\\4NC:\fw-\u001a:`I\u0015\fH\u0003BA6\u0003\u000bC\u0011\"a\u001d\u0011\u0003\u0003\u0005\r!a\u001f\u0002\u00171|w-T1oC\u001e,'\u000fI\u0001\u0005]\u0006lW-\u0006\u0002\u0002\u000eB!\u0011qRAK\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0012\u0001\u00027b]\u001eLA!a&\u0002\u0012\n11\u000b\u001e:j]\u001e\fQA\\1nK\u0002\n\u0011D^3ss2\u000b'oZ3M_\u001e4E.^:i\u0013:$XM\u001d<bYV\u0011\u0011q\u0014\t\u0004i\u0006\u0005\u0016bAARk\n!Aj\u001c8h\u0003i1XM]=MCJ<W\rT8h\r2,8\u000f[%oi\u0016\u0014h/\u00197!\u0003\u0015\u0019X\r^+q)\t\tY\u0007K\u0002\u0017\u0003[\u0003B!a,\u0002>6\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),A\u0002ba&TA!a.\u0002:\u00069!.\u001e9ji\u0016\u0014(\u0002BA^\u0003#\tQA[;oSRLA!a0\u00022\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3aFAc!\u0011\ty+a2\n\t\u0005%\u0017\u0011\u0017\u0002\n\u0003\u001a$XM]#bG\"\fQ\u0002^3ti\u000e\u0013X-\u0019;f\u0019><\u0007f\u0001\r\u0002PB!\u0011qVAi\u0013\u0011\t\u0019.!-\u0003\tQ+7\u000f^\u0001$i\u0016\u001cHo\u0011:fCR,Gj\\4P]R\u000b'oZ3uK\u0012dun\u001a#je\u0016\u001cGo\u001c:zQ\rI\u0012qZ\u00015i\u0016\u001cHo\u0011:fCR,Gj\\4XSRDG+\u0019:hKR,G\rT8h\t&\u0014Xm\u0019;pef\u001cV\r^!t+:\f7o]5h]\u0016$\u0007f\u0001\u000e\u0002P\u0006iE/Z:u\u0007J,\u0017\r^3M_\u001e<\u0016\u000e\u001e5UCJ<W\r^3e\u0019><G)\u001b:fGR|'/_*fi\u0006\u001bXK\\6o_^tw+\u001b;i_V$\u0018I\\=PM\u001ad\u0017N\\3ESJ,7\r^8sS\u0016\u001c\bfA\u000e\u0002P\u0006!C/Z:u\u0011\u0006tG\r\\5oO\u0016C8-\u001a9uS>t7\u000fR;sS:<7\u000b[;uI><h\u000eK\u0002\u001d\u0003\u001f\fA\u0005^3ti\u000ecW-\u00198TQV$Hm\\<o\r&dWmV5uQ\n\u0013xn[3s\u000bB|7\r\u001b\u0015\u0004;\u0005=\u0017\u0001\u0010;fgR\u001cE.Z1o'\",H\u000fZ8x]\u001aKG.Z,iK:\u001c\u0006.\u001e;e_^t7)\u00197mK\u0012\u0014UMZ8sKN#\u0018M\u001d;va\u000e{W\u000e\u001d7fi\u0016D3AHAh\u0003y!Xm\u001d;De\u0016\fG/\u001a'pO^KG\u000f[%om\u0006d\u0017\u000e\u001a'pO\u0012K'\u000fK\u0002 \u0003\u001f\fq\u0004^3ti\u000e\u0013X-\u0019;f\u0019><w+\u001b;i\u0019><G)\u001b:GC2d'-Y2lQ\r\u0001\u0013qZ\u0001\u0016i\u0016\u001cHoR3u\u001d>tW\t_5ti\u0016tG\u000fT8hQ\r\t\u0013qZ\u0001\u001bi\u0016\u001cHo\u00117fC:,\b/\u0012=qSJ,GmU3h[\u0016tGo\u001d\u0015\u0004E\u0005=\u0017!\t;fgR\u001cE.Z1okB\u001cVmZ7f]R\u001cHk\\'bS:$\u0018-\u001b8TSj,\u0007fA\u0012\u0002P\u0006QC/Z:u\t>,7O\u001c;DY\u0016\fg\u000eT8hg^KG\u000f[\"p[B\f7\r\u001e#fY\u0016$X\rU8mS\u000eL\bf\u0001\u0013\u0002P\u0006!C/Z:u\t>,7O\u001c;DY\u0016\fg\u000eT8hg^KG\u000f[\"p[B\f7\r\u001e)pY&\u001c\u0017\u0010K\u0002&\u0003\u001f\f1\u0003^3ti\u0012{Wm\u001d8u\u00072,\u0017M\u001c'pON$B!a\u001b\u0003\u000e!9!q\u0002\u0014A\u0002\tE\u0011A\u00029pY&\u001c\u0017\u0010\u0005\u0003\u0003\u0014\t\u0005b\u0002\u0002B\u000b\u0005;\u00012Aa\u0006v\u001b\t\u0011IBC\u0002\u0003\u001cE\fa\u0001\u0010:p_Rt\u0014b\u0001B\u0010k\u00061\u0001K]3eK\u001aLA!a&\u0003$)\u0019!qD;\u0002%Q,7\u000f\u001e+j[\u0016\u0014\u0015m]3e\r2,8\u000f\u001b\u0015\u0004O\u0005=\u0017!\u0007;fgRdU-Y:u\u0019>\fG-\u001a3BgNLwM\\7f]RD3\u0001KAh\u0003\u0001\"Xm\u001d;M_\u0006$Gj\\4t'.L\u0007OU3n_R,\u0017J\u001c3fq\u000e\u000b7\r[3)\u0007%\ny-A\u0012uKN$Hk^8M_\u001el\u0015M\\1hKJ\u001cXk]5oON\u000bW.\u001a#je\u001a\u000b\u0017\u000e\\:)\u0007)\ny-\u0001\u000fuKN$8\t[3dWB|\u0017N\u001c;SK\u000e|g/\u001a:z!>Lg\u000e^:)\u0007-\ny-A\u0017uKN$(+Z2pm\u0016\u0014\u0018\u0010R5sK\u000e$xN]=NCB\u0004\u0018N\\4XSRDGK]1jY&twm\u00157bg\"D3\u0001LAh\u0003E\"Xm\u001d;SK\u000e|g/\u001a:z\t&\u0014Xm\u0019;pefl\u0015\r\u001d9j]\u001e<\u0016\u000e\u001e5SK2\fG/\u001b<f\t&\u0014Xm\u0019;pefD3!LAh\u0003a1XM]5gs\u000eCWmY6q_&tGOU3d_Z,'/\u001f\u000b\t\u0003W\u0012)Ea\u001a\u0003j!9!q\t\u0018A\u0002\t%\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\r\t-#Q\u000bB.\u001d\u0011\u0011iE!\u0015\u000f\t\t]!qJ\u0005\u0002m&\u0019!1K;\u0002\u000fA\f7m[1hK&!!q\u000bB-\u0005\r\u0019V-\u001d\u0006\u0004\u0005'*\b\u0003\u0002B/\u0005Gj!Aa\u0018\u000b\t\t\u0005\u00141B\u0001\u0007G>lWn\u001c8\n\t\t\u0015$q\f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t9H\fa\u0001\u0003wBq!a\u0016/\u0001\u0004\tY&\u0001\tde\u0016\fG/\u001a'pO6\u000bg.Y4feRA\u00111\u0010B8\u0005k\u00129\tC\u0005\u0003r=\u0002\n\u00111\u0001\u0003t\u00059An\\4ESJ\u001c\bC\u0002B&\u0005+\nY\u0006C\u0005\u0003x=\u0002\n\u00111\u0001\u0003z\u0005\u00012m\u001c8gS\u001e\u0014V\r]8tSR|'/\u001f\t\u0005\u0005w\u0012\u0019)\u0004\u0002\u0003~)!!q\u0010BA\u0003!iW\r^1eCR\f'bAA\u0005_&!!Q\u0011B?\u0005A\u0019uN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018\u0010C\u0005\u0003\n>\u0002\n\u00111\u0001\u0002 \u0005I\"/Z2pm\u0016\u0014\u0018\u0010\u00165sK\u0006$7\u000fU3s\t\u0006$\u0018\rR5s\u0003i\u0019'/Z1uK2{w-T1oC\u001e,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yI\u000b\u0003\u0003t\tE5F\u0001BJ!\u0011\u0011)Ja(\u000e\u0005\t]%\u0002\u0002BM\u00057\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tuU/\u0001\u0006b]:|G/\u0019;j_:LAA!)\u0003\u0018\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00025\r\u0014X-\u0019;f\u0019><W*\u00198bO\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u001d&\u0006\u0002B=\u0005#\u000b!d\u0019:fCR,Gj\\4NC:\fw-\u001a:%I\u00164\u0017-\u001e7uIM*\"A!,+\t\u0005}!\u0011S\u0001#i\u0016\u001cHOR5mKJ+g-\u001a:f]\u000e,7/\u00114uKJ\f5/\u001f8d\t\u0016dW\r^3)\u0007M\ny-\u0001\u0012uKN$8I]3bi\u0016\fe\u000e\u001a#fY\u0016$Xm\u0014<fe2LHj\u001c8h)>\u0004\u0018n\u0019\u0015\u0004i\u0005=\u0017!\t;fgR\u001c\u0005.Z2la>Lg\u000e\u001e$pe>sG._!gM\u0016\u001cG/\u001a3M_\u001e\u001c\bfA\u001b\u0002P\u00069!/Z1e\u0019><G\u0003\u0003B`\u0005\u000b\u0014iM!5\u0011\t\u0005\u0015#\u0011Y\u0005\u0005\u0005\u0007\f9EA\u0007GKR\u001c\u0007\u000eR1uC&sgm\u001c\u0005\u0007]Z\u0002\rAa2\u0011\u0007q\u0014I-C\u0002\u0003L6\u0014!\"\u00168jM&,G\rT8h\u0011\u001d\u0011yM\u000ea\u0001\u0003?\u000baa\u001c4gg\u0016$\b\"\u0003BjmA\u0005\t\u0019AA\u0010\u0003%i\u0017\r\u001f'f]\u001e$\b.A\tsK\u0006$Gj\\4%I\u00164\u0017-\u001e7uIM\nQ\u0005^3tiR{\u0007/[2D_:4\u0017nZ\"iC:<W-\u00169eCR,7\u000fT8h\u0007>tg-[4)\u0007a\ny-A\u000fuKN$8i\u001c8gS\u001e\u001c\u0005.\u00198hK\u001e+Go]\"mK\u0006tW\rZ+qQ\rI\u0014qZ\u0001)i\u0016\u001cHO\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\u0005.\u00198hK\u0012+G.\u001b<fe\u0016$Gk\\!mY2{wm\u001d\u0015\u0004u\u0005=\u0017a\r;fgR$v\u000e]5d\u0007>tg-[4DQ\u0006tw-Z*u_B\u001cE.Z1oS:<\u0017JZ\"p[B\f7\r^%t%\u0016lwN^3eQ\rY\u0014qZ\u0001-i\u0016\u001cHoQ8oM&<7\t[1oO\u0016\u001cx+\u001b;i\u001d>dunZ$fiRLgnZ%oSRL\u0017\r\\5{K\u0012D3\u0001PAh\u0003I\t\u0007\u000f]3oIJ+7m\u001c:egR{Gj\\4\u0015\u0019\u0005-$q\u001eBy\u0005k\u0014Ip!\u0002\t\u000bul\u0004\u0019A@\t\u000f\tMX\b1\u0001\u0002\\\u0005a\u0001/\u0019:f]Rdun\u001a#je\"9!q_\u001fA\u0002\u0005}\u0011a\u00039beRLG/[8o\u0013\u0012DqAa?>\u0001\u0004\u0011i0\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugB!!q`B\u0001\u001b\t\u0011\t)\u0003\u0003\u0004\u0004\t\u0005%\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u001d\u00199!\u0010a\u0001\u0003?\ta#\u001a=qK\u000e$X\rZ*fO6,g\u000e^:QKJdunZ\u0001#m\u0016\u0014\u0018NZ=SK6\f\u0017N\\5oO2{wm\u001d+p%\u0016\u001cwN^3s\u001b\u0016$(/[2\u0015\r\u0005-4QBB\t\u0011\u001d\u0019yA\u0010a\u0001\u0003w\nQb\u001d9z\u0019><W*\u00198bO\u0016\u0014\bbBB\n}\u0001\u00071QC\u0001\u000fKb\u0004Xm\u0019;fIB\u000b'/Y7t!!\u00199b!\b\u0003\u0012\u0005}QBAB\r\u0015\r\u0019Y\"^\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB\u0010\u00073\u00111!T1q\u0003\u00192XM]5gsJ+W.Y5oS:<7+Z4nK:$8\u000fV8SK\u000e|g/\u001a:NKR\u0014\u0018n\u0019\u000b\r\u0003W\u001a)ca\n\u0004*\r-21\b\u0005\b\u0007\u001fy\u0004\u0019AA>\u0011\u001d\u0011\th\u0010a\u0001\u0005gBqA!#@\u0001\u0004\ty\u0002C\u0004\u0004.}\u0002\raa\f\u0002\u000f5|7m['baBA1\u0011GB\u001c\u0005#\ty\"\u0004\u0002\u00044)!1QGA\u001a\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0007s\u0019\u0019DA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCBDqaa\u0005@\u0001\u0004\u0019)\"\u0001\u0010wKJLg-\u001f'pOJ+7m\u001c<fe6+GO]5dgJ+Wn\u001c<fIR!\u00111NB!\u0011\u001d\u0019y\u0001\u0011a\u0001\u0003w\na\u0003^3ti2{wMU3d_Z,'/_'fiJL7m\u001d\u0015\u0004\u0003\u0006=\u0017A\u000e;fgRdun\u001a*fG>4XM]=NKR\u0014\u0018nY:TQ>,H\u000e\u001a\"f%\u0016lwN^3e\u0003\u001a$XM\u001d'pOJ+7m\u001c<fe\u0016$\u0007f\u0001\"\u0002P\u0006\u0001D/Z:u\u001b\u0016$(/[2t\u000bbL7\u000f^,iK:dunZ%t%\u0016\u001c'/Z1uK\u0012\u0014UMZ8sK\u0012+G.\u001a;j_:D3aQAh\u0003E\"Xm\u001d;NKR\u0014\u0018nY:Be\u0016\u0014V-\\8wK\u0012<\u0006.\u001a8N_ZLgnZ\"veJ,g\u000e\u001e+p\rV$XO]3M_\u001eD3\u0001RAh\u0003a!Xm\u001d;XC&$hi\u001c:BY2$vnQ8na2,G/\u001a\u0015\u0004\u000b\u0006=\u0017\u0001\u0006;fgRdu.\u00193ESJ,7\r^8ss&#7\u000fK\u0002G\u0003\u001f\f1c\u001e:ji\u0016lU\r^1Qe>\u0004XM\u001d;jKN$b!a\u001b\u0004`\r\r\u0004bBB1\u000f\u0002\u0007\u00111L\u0001\u0004I&\u0014\b\"CB3\u000fB\u0005\t\u0019AB4\u0003-!\u0017N]3di>\u0014\u00180\u00133\u0011\r\u0005E2\u0011NB7\u0013\u0011\u0019Y'a\r\u0003\u0011=\u0003H/[8oC2\u0004BA!\u0018\u0004p%!1\u0011\u000fB0\u0005\u0011)V/\u001b3\u0002;]\u0014\u0018\u000e^3NKR\f\u0007K]8qKJ$\u0018.Z:%I\u00164\u0017-\u001e7uII*\"aa\u001e+\t\r\u001d$\u0011S\u0001\u0005M>|\u0007'\u0006\u0002\u0004~A!!QLB@\u0013\u0011\u0019\tIa\u0018\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017!\u00024p_B\u0002\u0013\u0001\u00024p_F\nQAZ8pc\u0001\nAAY1sa\u0005)!-\u0019:1A\u0005!!-\u0019:2\u0003\u0015\u0011\u0017M]\u0019!\u0003\u0011\u0011\u0017M\u001f\u0019\u0002\u000b\t\f'\u0010\r\u0011\u0002\t\t\f'0M\u0001\u0006E\u0006T\u0018\u0007I\u0001\u0005E\u0006T('A\u0003cCj\u0014\u0004%A\u0003rkVD\b'\u0001\u0004rkVD\b\u0007I\u0001\u000ee\u0016\u001c'/Z1uK\u00124un\u001c\u0019\u0002\u001dI,7M]3bi\u0016$gi\\81A\u0005i!/Z2sK\u0006$X\r\u001a$p_F\naB]3de\u0016\fG/\u001a3G_>\f\u0004%A\u0011uKN$h)\u001b8e'R\u0014\u0018-\u001f*fa2L7-Y:J]\u0016k\u0007\u000f^=J[\u0006<W\rK\u0002^\u0003\u001f\f\u0001\u0005^3ti\u001aKg\u000eZ*p[\u0016\u001cFO]1z%\u0016\u0004H.[2bg&s\u0017*\\1hK\"\u001aa,a4\u0002eQ,7\u000f\u001e$j]\u0012\u001cv.\\3TiJ\f\u0017PU3qY&\u001c\u0017m]%o\u00136\fw-Z,ji\"\u0014V-\\8uKJ+\u0007\u000f\\5dCND3aXAh\u0003\u0001\"Xm\u001d;GS:$7\u000b\u001e:bsJ+\u0007\u000f\\5dCNLe.R7qifd\u0015)\u0013*)\u0007\u0001\fy-A\u0011uKN$h)\u001b8e\u001d>\u001cFO]1z%\u0016\u0004H.[2bg&sg)\u001e7m\u0019\u0006K%\u000bK\u0002b\u0003\u001f\f1\u0005^3ti\u001aKg\u000eZ*p[\u0016\u001cFO]1z%\u0016\u0004H.[2bg&sg)\u001e7m\u0019\u0006K%\u000bK\u0002c\u0003\u001f\fQ\u0004^3tiR{\u0007/[2SK\u000e\u0014X-\u0019;j_:LeNR;mY2\u000b\u0015J\u0015\u0015\u0004G\u0006=\u0017A\u0004'pO6\u000bg.Y4feR+7\u000f\u001e\t\u0003y\u0016\u001c\"!Z:\u0015\u0005\r\u001d\u0017aB7pG.dun\u001a\u000b\u0005\u0005\u000f\u001c\t\u000eC\u0004\u0004T\u001e\u0004\ra! \u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0017A\u0003;pa&\u001c\u0017*\\1hKR!1\u0011\\Bs!\u0011\u0019Yn!9\u000e\u0005\ru'\u0002BBp\u0003\u0017\tQ![7bO\u0016LAaa9\u0004^\nQAk\u001c9jG&k\u0017mZ3\t\u000f\r\u001d\b\u000e1\u0001\u0004j\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u0011\r]1QDB?\u0007W\u0004bAa\u0013\u0003V\u0005}\u0011a\u0003;pa&\u001c7/S7bO\u0016$Ba!=\u0004xB!11\\Bz\u0013\u0011\u0019)p!8\u0003\u0017Q{\u0007/[2t\u00136\fw-\u001a\u0005\b\u0007sL\u0007\u0019AB~\u0003\u0019!x\u000e]5dgB1!1\nB+\u00073\f!f\u0019:fCR,G*Z1eKJ\fe\u000eZ%teJ+\u0017/^3ti\u001a{'o\u0015;sCf$U\r^3di&|g\u000e\u0006\u0004\u0005\u0002\u00115AQ\u0003\t\u0005\t\u0007!I!\u0004\u0002\u0005\u0006)!Aq\u0001B0\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002C\u0006\t\u000b\u00111\u0003T3bI\u0016\u0014\u0018I\u001c3JgJ\u0014V-];fgRDqaa:k\u0001\u0004!y\u0001\u0005\u0004\u0003L\u0011E1QP\u0005\u0005\t'\u0011IF\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011%!9B\u001bI\u0001\u0002\u0004!I\"A\u0004mK\u0006$WM]:\u0011\r\t-C\u0011CA\u0010\u0003Q\u001a'/Z1uK2+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;G_J\u001cFO]1z\t\u0016$Xm\u0019;j_:$C-\u001a4bk2$HEM\u000b\u0003\t?QC\u0001\"\u0007\u0003\u0012\u0002")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;
    private final TopicIdPartition foo0;
    private final TopicIdPartition foo1;
    private final TopicIdPartition bar0;
    private final TopicIdPartition bar1;
    private final TopicIdPartition baz0;
    private final TopicIdPartition baz1;
    private final TopicIdPartition baz2;
    private final TopicIdPartition quux0;
    private final TopicIdPartition recreatedFoo0;
    private final TopicIdPartition recreatedFoo1;

    public static Iterable<Object> createLeaderAndIsrRequestForStrayDetection$default$2() {
        return Nil$.MODULE$;
    }

    public static LeaderAndIsrRequest createLeaderAndIsrRequestForStrayDetection(Iterable<TopicIdPartition> partitions, Iterable<Object> leaders) {
        return LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection(partitions, leaders);
    }

    public static TopicsImage topicsImage(scala.collection.immutable.Seq<TopicImage> topics) {
        return LogManagerTest$.MODULE$.topicsImage(topics);
    }

    public static TopicImage topicImage(Map<TopicIdPartition, scala.collection.immutable.Seq<Object>> partitions) {
        return LogManagerTest$.MODULE$.topicImage(partitions);
    }

    public static UnifiedLog mockLog(TopicIdPartition topicIdPartition) {
        return LogManagerTest$.MODULE$.mockLog(topicIdPartition);
    }

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
    }

    @AfterEach
    public void tearDown() {
        if (this.logManager() != null) {
            LogManager qual$1 = this.logManager();
            long x$12 = qual$1.shutdown$default$1();
            qual$1.shutdown(x$12);
        }
        Utils.delete((File)this.logDir());
        if (this.logManager() != null) {
            this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
                LogManagerTest.$anonfun$tearDown$1(x$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    @Test
    public void testCreateLogOnTargetedLogDirectory() {
        Uuid targetedLogDirectoryId = DirectoryId.random();
        scala.collection.immutable.Seq dirs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().fill(5, (Function0 & Serializable)() -> TestUtils$.MODULE$.tempDir());
        this.writeMetaProperties((File)dirs.apply(0), this.writeMetaProperties$default$2());
        this.writeMetaProperties((File)dirs.apply(1), Optional.of(targetedLogDirectoryId));
        this.writeMetaProperties((File)dirs.apply(3), Optional.of(DirectoryId.random()));
        this.writeMetaProperties((File)dirs.apply(4), this.writeMetaProperties$default$2());
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        Some x$3 = new Some((Object)targetedLogDirectoryId);
        boolean x$4 = qual$1.getOrCreateLog$default$2();
        boolean x$5 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$4, x$5, (Option)x$2, (Option)x$3);
        Assertions.assertEquals((int)5, (int)this.logManager().liveLogDirs().size());
        File logFile = new File((File)dirs.apply(1), new StringBuilder(2).append(this.name()).append("-0").toString());
        Assertions.assertTrue((boolean)logFile.exists());
        Assertions.assertEquals((Object)((File)dirs.apply(1)).getAbsolutePath(), (Object)logFile.getParent());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    @Test
    public void testCreateLogWithTargetedLogDirectorySetAsUnassigned() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        Some x$3 = new Some((Object)DirectoryId.UNASSIGNED);
        boolean x$4 = qual$1.getOrCreateLog$default$2();
        boolean x$5 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$4, x$5, (Option)x$2, (Option)x$3);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        File logFile = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString());
        Assertions.assertTrue((boolean)logFile.exists());
        Assertions.assertFalse((boolean)this.logManager().directoryId(logFile.getParent()).equals((Object)DirectoryId.UNASSIGNED));
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    @Test
    public void testCreateLogWithTargetedLogDirectorySetAsUnknownWithoutAnyOfflineDirectories() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        Some x$3 = new Some((Object)DirectoryId.LOST);
        boolean x$4 = qual$1.getOrCreateLog$default$2();
        boolean x$5 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$4, x$5, (Option)x$2, (Option)x$3);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        File logFile = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString());
        Assertions.assertTrue((boolean)logFile.exists());
        Assertions.assertFalse((boolean)this.logManager().directoryId(logFile.getParent()).equals((Object)DirectoryId.random()));
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    @Test
    public void testHandlingExceptionsDuringShutdown() {
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        Option logManagerForTest = Option$.MODULE$.empty();
        try {
            logManagerForTest = new Some((Object)this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)), new MockConfigRepository(), 1));
            Assertions.assertEquals((int)2, (int)((LogManager)logManagerForTest.get()).liveLogDirs().size());
            ((LogManager)logManagerForTest.get()).startup((Set)Predef$.MODULE$.Set().empty());
            LogManager qual$1 = (LogManager)logManagerForTest.get();
            TopicPartition x$1 = new TopicPartition(this.name(), 0);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            Option x$5 = qual$1.getOrCreateLog$default$5();
            UnifiedLog log1 = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
            LogManager qual$2 = (LogManager)logManagerForTest.get();
            TopicPartition x$6 = new TopicPartition(this.name(), 1);
            None$ x$7 = None$.MODULE$;
            boolean x$8 = qual$2.getOrCreateLog$default$2();
            boolean x$9 = qual$2.getOrCreateLog$default$3();
            Option x$10 = qual$2.getOrCreateLog$default$5();
            UnifiedLog log2 = qual$2.getOrCreateLog(x$6, x$8, x$9, (Option)x$7, x$10);
            File logFile1 = new File(logDir1, new StringBuilder(2).append(this.name()).append("-0").toString());
            Assertions.assertTrue((boolean)logFile1.exists());
            Assertions.assertTrue((boolean)new File(logDir2, new StringBuilder(2).append(this.name()).append("-1").toString()).exists());
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5(), log1.appendAsLeader$default$6());
            log1.takeProducerSnapshot();
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5(), log1.appendAsLeader$default$6());
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5(), log2.appendAsLeader$default$6());
            log2.takeProducerSnapshot();
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5(), log2.appendAsLeader$default$6());
            FileUtils.deleteDirectory((File)logFile1);
            ((LogManager)logManagerForTest.get()).shutdown(3L);
            Assertions.assertFalse((boolean)Files.exists(new File(logDir1, ".kafka_cleanshutdown").toPath(), new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(new File(logDir2, ".kafka_cleanshutdown").toPath(), new LinkOption[0]));
            Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((LogManager)logManagerForTest.get()).readBrokerEpochFromCleanShutdownFiles());
        }
        finally {
            logManagerForTest.foreach((Function1 & Serializable)manager -> {
                LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$1(manager);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testCleanShutdownFileWithBrokerEpoch() {
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        Option logManagerForTest = Option$.MODULE$.empty();
        try {
            logManagerForTest = new Some((Object)this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)), new MockConfigRepository(), 1));
            Assertions.assertEquals((int)2, (int)((LogManager)logManagerForTest.get()).liveLogDirs().size());
            ((LogManager)logManagerForTest.get()).startup((Set)Predef$.MODULE$.Set().empty());
            LogManager qual$1 = (LogManager)logManagerForTest.get();
            TopicPartition x$1 = new TopicPartition(this.name(), 0);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            Option x$5 = qual$1.getOrCreateLog$default$5();
            qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
            LogManager qual$2 = (LogManager)logManagerForTest.get();
            TopicPartition x$6 = new TopicPartition(this.name(), 1);
            None$ x$7 = None$.MODULE$;
            boolean x$8 = qual$2.getOrCreateLog$default$2();
            boolean x$9 = qual$2.getOrCreateLog$default$3();
            Option x$10 = qual$2.getOrCreateLog$default$5();
            qual$2.getOrCreateLog(x$6, x$8, x$9, (Option)x$7, x$10);
            Assertions.assertTrue((boolean)new File(logDir1, new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
            Assertions.assertTrue((boolean)new File(logDir2, new StringBuilder(2).append(this.name()).append("-1").toString()).exists());
            ((LogManager)logManagerForTest.get()).shutdown(3L);
            Assertions.assertTrue((boolean)Files.exists(new File(logDir1, ".kafka_cleanshutdown").toPath(), new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(new File(logDir2, ".kafka_cleanshutdown").toPath(), new LinkOption[0]));
            Assertions.assertEquals((Object)OptionalLong.of(3L), (Object)((LogManager)logManagerForTest.get()).readBrokerEpochFromCleanShutdownFiles());
        }
        finally {
            logManagerForTest.foreach((Function1 & Serializable)manager -> {
                LogManagerTest.$anonfun$testCleanShutdownFileWithBrokerEpoch$1(manager);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete() {
        TopicPartition topicPartition0 = new TopicPartition(this.name(), 0);
        TopicPartition topicPartition1 = new TopicPartition(this.name(), 1);
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        UnifiedLog log0 = qual$1.getOrCreateLog(topicPartition0, x$3, x$4, (Option)x$2, x$5);
        LogManager qual$2 = this.logManager();
        None$ x$7 = None$.MODULE$;
        boolean x$8 = qual$2.getOrCreateLog$default$2();
        boolean x$9 = qual$2.getOrCreateLog$default$3();
        Option x$10 = qual$2.getOrCreateLog$default$5();
        UnifiedLog log1 = qual$2.getOrCreateLog(topicPartition1, x$8, x$9, (Option)x$7, x$10);
        File logFile0 = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString());
        File logFile1 = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-1").toString());
        Assertions.assertTrue((boolean)logFile0.exists());
        Assertions.assertTrue((boolean)logFile1.exists());
        log0.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log0.appendAsLeader$default$3(), log0.appendAsLeader$default$4(), log0.appendAsLeader$default$5(), log0.appendAsLeader$default$6());
        log0.takeProducerSnapshot();
        log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5(), log1.appendAsLeader$default$6());
        log1.takeProducerSnapshot();
        LogManager qual$3 = this.logManager();
        long x$11 = qual$3.shutdown$default$1();
        qual$3.shutdown(x$11);
        Assertions.assertTrue((boolean)Files.deleteIfExists(new File(this.logDir(), ".kafka_cleanshutdown").toPath()));
        VolatileIntRef loadLogCalled = VolatileIntRef.create((int)0);
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1)));
        ((LogManager)Mockito.doAnswer(invocation -> {
            LogManagerTest.$anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$1(loadLogCalled, invocation);
            return BoxedUnit.UNIT;
        }).when((Object)this.logManager())).loadLog((File)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (LogConfig)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        new Thread(this){
            private final /* synthetic */ LogManagerTest $outer;

            public void run() {
                this.$outer.logManager().startup((Set)Predef$.MODULE$.Set().empty());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }.start();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(loadLogCalled.elem == 1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for only the first log to be loaded");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$4 = this.logManager();
        long x$12 = qual$4.shutdown$default$1();
        qual$4.shutdown(x$12);
        this.logManager_$eq(null);
        Assertions.assertFalse((boolean)Files.exists(new File(this.logDir(), ".kafka_cleanshutdown").toPath(), new LinkOption[0]));
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        .colon.colon dirs = new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)new File("\u0000"), (List)Nil$.MODULE$));
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$2 = this.logManager();
        TopicPartition x$2 = new TopicPartition(this.name(), 0);
        None$ x$4 = None$.MODULE$;
        boolean x$5 = qual$2.getOrCreateLog$default$3();
        Option x$6 = qual$2.getOrCreateLog$default$5();
        UnifiedLog log = qual$2.getOrCreateLog(x$2, true, x$5, (Option)x$4, x$6);
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    @Test
    public void testCreateLogWithLogDirFallback() {
        IndexedSeq dirs = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$3 -> LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$1(BoxesRunTime.unboxToInt((Object)x$3))).map((Function1 & Serializable)x$4 -> this.logDir().toPath().resolve((String)x$4).toFile());
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1)));
        scala.collection.mutable.Set brokenDirs = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File logDir = (File)invocation.getArgument(0);
            if (brokenDirs.contains((Object)logDir) || brokenDirs.size() < dirs.length() / 2) {
                brokenDirs.add((Object)logDir);
                return new Failure(new Throwable("broken dir"));
            }
            return (Try)invocation.callRealMethod();
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$2 = this.logManager();
        TopicPartition x$2 = new TopicPartition(this.name(), 0);
        None$ x$42 = None$.MODULE$;
        boolean x$5 = qual$2.getOrCreateLog$default$3();
        Option x$6 = qual$2.getOrCreateLog$default$5();
        qual$2.getOrCreateLog(x$2, true, x$5, (Option)x$42, x$6);
        Assertions.assertEquals((int)(dirs.length() / 2), (int)brokenDirs.size());
        Function1 & Serializable containsLogFile = (Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$4(this, dir));
        Assertions.assertEquals((int)1, (int)dirs.count((Function1)containsLogFile), (String)"More than one log file created");
        Assertions.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log, (String)"No log should be found.");
        Assertions.assertFalse((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupExpiredSegments() {
        void readLog_maxLength;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$52 = qual$1.getOrCreateLog$default$5();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$52);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
            offset$1.elem = info.lastOffset();
        });
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.updateHighWatermark(log.logEndOffset());
        log.logSegments().forEach(x$6 -> x$6.log().file().setLastModified(this.time().milliseconds()));
        this.time().sleep((long)(this.maxLogAgeMs() + 1));
        Assertions.assertEquals((int)1, (int)log.numberOfSegments(), (String)"Now there should only be only one segment in the index.");
        this.time().sleep(log.config().fileDeleteDelayMs + 1L);
        log.logSegments().forEach(s -> {
            s.offsetIndex();
            s.timeIndex();
        });
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        int n = 1024;
        long readLog_offset = offset.elem + 1L;
        Assertions.assertEquals((int)0, (int)log.read((long)readLog_offset, (int)readLog_maxLength, (FetchIsolation)FetchIsolation.LOG_END, (boolean)true).records.sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> {
            void readLog_maxLength;
            int n = 1024;
            long readLog_offset = 0L;
            log.read(readLog_offset, (int)readLog_maxLength, FetchIsolation.LOG_END, true);
        }, () -> "Should get exception from fetching earlier.");
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupSegmentsToMaintainSize() {
        void readLog_maxLength;
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes();
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        int segmentBytes = 10 * setSize;
        Properties properties = new Properties();
        properties.put("segment.bytes", Integer.toString(segmentBytes));
        properties.put("retention.bytes", Long.toString(50L * (long)setSize + 10L));
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), properties);
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, configRepository, x$4));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$72 = qual$2.getOrCreateLog$default$2();
        boolean x$8 = qual$2.getOrCreateLog$default$3();
        Option x$9 = qual$2.getOrCreateLog$default$5();
        UnifiedLog log = qual$2.getOrCreateLog(x$5, x$72, x$8, (Option)x$6, x$9);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
            offset$2.elem = info.firstOffset();
        });
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((int)(numMessages * setSize / segmentBytes), (int)log.numberOfSegments(), (String)"Check we have the expected number of segments.");
        this.time().sleep((long)this.logManager().InitialTaskDelayMs());
        Assertions.assertEquals((int)6, (int)log.numberOfSegments(), (String)"Now there should be exactly 6 segments");
        this.time().sleep(log.config().fileDeleteDelayMs + 1L);
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        int n = 1024;
        long readLog_offset = offset.elem + 1L;
        Assertions.assertEquals((int)0, (int)log.read((long)readLog_offset, (int)readLog_maxLength, (FetchIsolation)FetchIsolation.LOG_END, (boolean)true).records.sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> {
            void readLog_maxLength;
            int n = 1024;
            long readLog_offset = 0L;
            log.read(readLog_offset, (int)readLog_maxLength, FetchIsolation.LOG_END, true);
        });
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs("compact,delete");
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs("compact");
    }

    private void testDoesntCleanLogs(String policy) {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), "cleanup.policy", policy);
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, configRepository, x$4));
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$2.getOrCreateLog$default$2();
        boolean x$82 = qual$2.getOrCreateLog$default$3();
        Option x$92 = qual$2.getOrCreateLog$default$5();
        UnifiedLog log = qual$2.getOrCreateLog(x$5, x$7, x$82, (Option)x$6, x$92);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
            offset$3.elem = info.lastOffset();
        });
        int numSegments = log.numberOfSegments();
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.logSegments().forEach(x$9 -> x$9.log().file().setLastModified(this.time().milliseconds()));
        this.time().sleep((long)(this.maxLogAgeMs() + 1));
        Assertions.assertEquals((int)numSegments, (int)log.numberOfSegments(), (String)"number of segments shouldn't have changed");
    }

    @Test
    public void testTimeBasedFlush() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), "flush.ms", "1000");
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, configRepository, x$4));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$2.getOrCreateLog$default$2();
        boolean x$8 = qual$2.getOrCreateLog$default$3();
        Option x$9 = qual$2.getOrCreateLog$default$5();
        UnifiedLog log = qual$2.getOrCreateLog(x$5, x$7, x$8, (Option)x$6, x$9);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1 & Serializable)x$10 -> LogManagerTest.$anonfun$testTimeBasedFlush$1(log, BoxesRunTime.unboxToInt((Object)x$10)));
        this.time().sleep((long)this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((lastFlush != log.lastFlushTime() ? 1 : 0) != 0, (String)"Time based flush should have been triggered");
    }

    @Test
    public void testLeastLoadedAssignment() {
        .colon.colon dirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$)));
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            LogManager qual$2 = this.logManager();
            TopicPartition x$2 = new TopicPartition("test", partition);
            None$ x$3 = None$.MODULE$;
            boolean x$4 = qual$2.getOrCreateLog$default$2();
            boolean x$5 = qual$2.getOrCreateLog$default$3();
            Option x$6 = qual$2.getOrCreateLog$default$5();
            qual$2.getOrCreateLog(x$2, x$4, x$5, (Option)x$3, x$6);
            Assertions.assertEquals((int)(partition + 1), (int)this.logManager().allLogs().size(), (String)"We should have created the right number of logs");
            Iterable counts = (Iterable)this.logManager().allLogs().groupBy((Function1 & Serializable)x$11 -> x$11.dir().getParent()).values().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.size()));
            Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0, (String)"Load should balance evenly");
        });
    }

    @Test
    public void testLoadLogsSkipRemoteIndexCache() {
        File logDir = TestUtils.tempDirectory(null, null);
        new File(logDir, "remote-log-index-cache").mkdir();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)logDir, (List)Nil$.MODULE$), new MockConfigRepository(), 1));
        this.logManager().loadLogs(this.logConfig(), (Map)Map$.MODULE$.empty());
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        Assertions.assertThrows(KafkaException.class, () -> this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1));
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)new File(new StringBuilder(0).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append(File.separator).toString()), (List)Nil$.MODULE$), TestUtils$.MODULE$.createLogManager$default$2(), new MockConfigRepository(), new CleanerConfig(false), new MockTime(), MetadataVersion.latestTesting(), 4, false, (Option<UnifiedLog>)None$.MODULE$, false));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)new File("data", this.logDir().getName()).getAbsoluteFile(), (List)Nil$.MODULE$), new MockConfigRepository(), 1));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(scala.collection.immutable.Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        scala.collection.immutable.Seq logs = (scala.collection.immutable.Seq)topicPartitions.map((Function1 & Serializable)x$13 -> {
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            Option x$5 = logManager.getOrCreateLog$default$5();
            return logManager.getOrCreateLog(x$13, x$3, x$4, (Option)x$2, x$5);
        });
        logs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$2(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)topicPartitions.zip((IterableOnce)logs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(scala.collection.immutable.Seq<File> logDirs, ConfigRepository configRepository, int recoveryThreadsPerDataDir) {
        LogConfig x$1 = this.logConfig();
        MockTime x$4 = this.time();
        CleanerConfig x$6 = new CleanerConfig(false);
        MetadataVersion x$7 = MetadataVersion.latestTesting();
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        boolean x$10 = false;
        return TestUtils$.MODULE$.createLogManager((Seq<File>)logDirs, x$1, configRepository, x$6, x$4, x$7, recoveryThreadsPerDataDir, x$8, (Option<UnifiedLog>)x$9, x$10);
    }

    private scala.collection.immutable.Seq<File> createLogManager$default$1() {
        return new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$);
    }

    private ConfigRepository createLogManager$default$2() {
        return new MockConfigRepository();
    }

    private int createLogManager$default$3() {
        return 1;
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        LogSegment activeSegment = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5).activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        Object[] indexFilesOnDiskBeforeDelete = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles()), (Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$1(x$15)));
        LogManager qual$2 = this.logManager();
        TopicPartition x$6 = new TopicPartition(this.name(), 0);
        boolean x$7 = qual$2.asyncDelete$default$2();
        boolean x$8 = qual$2.asyncDelete$default$3();
        boolean x$9 = qual$2.asyncDelete$default$4();
        UnifiedLog removedLog = (UnifiedLog)qual$2.asyncDelete(x$6, x$7, x$8, x$9).get();
        LogSegment removedSegment = removedLog.activeSegment();
        .colon.colon indexFilesAfterDelete = new .colon.colon((Object)removedSegment.offsetIndexFile(), (List)new .colon.colon((Object)removedSegment.timeIndexFile(), (List)new .colon.colon((Object)removedSegment.txnIndex().file(), (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.offsetIndexFile());
        Assertions.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.timeIndexFile());
        Assertions.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(indexFilesOnDiskBeforeDelete), arg_0 -> LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2$adapted((scala.collection.immutable.Seq)indexFilesAfterDelete, arg_0));
        this.time().sleep((long)this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs deleted too early");
        this.time().sleep(this.logManager().currentDefaultConfig().fileDeleteDelayMs - (long)this.logManager().InitialTaskDelayMs());
        Assertions.assertFalse((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs not deleted");
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(invalidTopicName, 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        LogManager qual$2 = this.logManager();
        TopicPartition x$6 = new TopicPartition(invalidTopicName, 0);
        boolean x$7 = qual$2.asyncDelete$default$2();
        boolean x$8 = qual$2.asyncDelete$default$3();
        boolean x$9 = qual$2.asyncDelete$default$4();
        qual$2.asyncDelete(x$6, x$7, x$8, x$9);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        .colon.colon tps = new .colon.colon((Object)new TopicPartition("test-a", 0), (List)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-a", 2), (List)new .colon.colon((Object)new TopicPartition("test-b", 0), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)))));
        scala.collection.immutable.Seq allLogs = (scala.collection.immutable.Seq)tps.map((Function1 & Serializable)x$18 -> {
            LogManager qual$1 = this.logManager();
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            Option x$5 = qual$1.getOrCreateLog$default$5();
            return qual$1.getOrCreateLog(x$18, x$3, x$4, (Option)x$2, x$5);
        });
        allLogs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$2(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsInDir(this.logDir());
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)tps.zip((IterableOnce)allLogs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(UnifiedLog log, long offset, int maxLength) {
        return log.read(offset, maxLength, FetchIsolation.LOG_END, true);
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, spyConfigRepository, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.topicConfigUpdated(testTopicOne);
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicTwo);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, spyConfigRepository, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        TopicPartition testTopicPartition = new TopicPartition("test-topic", 1);
        spyLogManager.initializingLog(testTopicPartition);
        spyLogManager.finishedInitializingLog(testTopicPartition, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicPartition.topic());
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, spyConfigRepository, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.brokerConfigUpdated();
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicTwo);
    }

    @Test
    public void testTopicConfigChangeStopCleaningIfCompactIsRemoved() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        MockConfigRepository x$2 = new MockConfigRepository();
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, x$2, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        String topic = "topic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Properties oldProperties = new Properties();
        oldProperties.put("cleanup.policy", "compact");
        LogConfig oldLogConfig = LogConfig.fromProps((java.util.Map)this.logConfig().originals(), (Properties)oldProperties);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = spyLogManager.getOrCreateLog$default$2();
        boolean x$8 = spyLogManager.getOrCreateLog$default$3();
        Option x$9 = spyLogManager.getOrCreateLog$default$5();
        UnifiedLog log0 = spyLogManager.getOrCreateLog(tp0, x$7, x$8, (Option)x$6, x$9);
        log0.updateConfig(oldLogConfig);
        None$ x$11 = None$.MODULE$;
        boolean x$12 = spyLogManager.getOrCreateLog$default$2();
        boolean x$13 = spyLogManager.getOrCreateLog$default$3();
        Option x$14 = spyLogManager.getOrCreateLog$default$5();
        UnifiedLog log1 = spyLogManager.getOrCreateLog(tp1, x$12, x$13, (Option)x$11, x$14);
        log1.updateConfig(oldLogConfig);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnifiedLog[]{log0, log1})), (Object)spyLogManager.logsByTopic(topic).toSet());
        Properties newProperties = new Properties();
        newProperties.put("cleanup.policy", "delete");
        spyLogManager.updateTopicConfig(topic, newProperties, false);
        Assertions.assertTrue((boolean)log0.config().delete);
        Assertions.assertTrue((boolean)log1.config().delete);
        Assertions.assertFalse((boolean)log0.config().compact);
        Assertions.assertFalse((boolean)log1.config().compact);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).topicConfigUpdated(topic);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp0);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp1);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    private void appendRecordsToLog(MockTime time, File parentLogDir, int partitionId, BrokerTopicStats brokerTopicStats, int expectedSegmentsPerLog) {
        File tpFile = new File(parentLogDir, new StringBuilder(1).append(this.name()).append("-").append(partitionId).toString());
        int segmentBytes = 1024;
        UnifiedLog log = LogTestUtils$.MODULE$.createLog(tpFile, this.logConfig(), brokerTopicStats, (Scheduler)time.scheduler, (Time)time, 0L, 0L, 300000, new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false), Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER);
        Assertions.assertTrue((expectedSegmentsPerLog > 0 ? 1 : 0) != 0);
        int numMessages = (int)Math.floor(segmentBytes * expectedSegmentsPerLog / LogManagerTest.createRecord$1(time).sizeInBytes());
        try {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable)x$20 -> log.appendAsLeader(LogManagerTest.createRecord$1(time), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
            Assertions.assertEquals((int)expectedSegmentsPerLog, (int)log.numberOfSegments());
        }
        finally {
            log.close();
        }
    }

    private void verifyRemainingLogsToRecoverMetric(LogManager spyLogManager, Map<String, Object> expectedParams) {
        String logManagerClassName = LogManager.class.getSimpleName();
        ArrayBuffer logMetrics = (ArrayBuffer)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$1(logManagerClassName, x0$1)))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (Metric)x0$2._2();
            }
            throw new MatchError(null);
        });
        Assertions.assertEquals((int)expectedParams.size(), (int)logMetrics.size());
        ArgumentCaptor capturedPath = ArgumentCaptor.forClass(String.class);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)expectedParams.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)expectedCallTimes))).decNumRemainingLogs((ConcurrentMap)ArgumentMatchers.any(), (String)capturedPath.capture());
        java.util.List paths = capturedPath.getAllValues();
        expectedParams.foreach((Function1 & Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$3(paths, x0$3);
            return BoxedUnit.UNIT;
        });
        logMetrics.foreach((Function1 & Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyRemainingSegmentsToRecoverMetric(LogManager spyLogManager, scala.collection.immutable.Seq<File> logDirs, int recoveryThreadsPerDataDir, ConcurrentHashMap<String, Object> mockMap, Map<String, Object> expectedParams) {
        String logManagerClassName = LogManager.class.getSimpleName();
        ArrayBuffer logSegmentMetrics = (ArrayBuffer)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$1(logManagerClassName, x0$1)))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (Metric)x0$2._2();
            }
            throw new MatchError(null);
        });
        Assertions.assertEquals((int)(recoveryThreadsPerDataDir * logDirs.size()), (int)logSegmentMetrics.size());
        ArgumentCaptor capturedThreadName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor capturedNumRemainingSegments = ArgumentCaptor.forClass(Integer.TYPE);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)expectedParams.values().map((Function1)(JFunction1.mcII.sp & Serializable)num -> num + 1)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((ConcurrentHashMap)Mockito.verify(mockMap, (VerificationMode)Mockito.times((int)expectedCallTimes))).put(capturedThreadName.capture(), capturedNumRemainingSegments.capture());
        logSegmentMetrics.foreach((Function1 & Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
        java.util.List threadNames = capturedThreadName.getAllValues();
        java.util.List numRemainingSegments = capturedNumRemainingSegments.getAllValues();
        expectedParams.foreach((Function1 & Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$5(threadNames, numRemainingSegments, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyLogRecoverMetricsRemoved(LogManager spyLogManager) {
        String spyLogManagerClassName = spyLogManager.getClass().getSimpleName();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$1(spyLogManagerClassName).isEmpty());
        Assertions.assertTrue((boolean)((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$2(spyLogManagerClassName, metric)))).isEmpty());
    }

    @Test
    public void testLogRecoveryMetrics() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        .colon.colon logDirs = new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$));
        int recoveryThreadsPerDataDir = 2;
        MockConfigRepository x$4 = new MockConfigRepository();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)logDirs, x$4, recoveryThreadsPerDataDir));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        MockTime mockTime = new MockTime();
        ConcurrentHashMap mockMap = (ConcurrentHashMap)Mockito.mock(ConcurrentHashMap.class);
        BrokerTopicStats mockBrokerTopicStats = (BrokerTopicStats)Mockito.mock(BrokerTopicStats.class);
        int expectedSegmentsPerLog = 2;
        this.appendRecordsToLog(mockTime, logDir1, 0, mockBrokerTopicStats, expectedSegmentsPerLog);
        this.appendRecordsToLog(mockTime, logDir2, 1, mockBrokerTopicStats, expectedSegmentsPerLog);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File dir = (File)invocation.getArgument(0);
            scala.collection.mutable.Map topicConfigOverrides = (scala.collection.mutable.Map)invocation.getArgument(5);
            TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
            LogConfig config = (LogConfig)topicConfigOverrides.getOrElse((Object)topicPartition.topic(), (Function0 & Serializable)() -> this.logConfig());
            ProducerStateManagerConfig x$10 = new ProducerStateManagerConfig(300000, false);
            int x$11 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
            MockScheduler x$12 = mockTime$1.scheduler;
            LogDirFailureChannel x$15 = (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class);
            None$ x$17 = None$.MODULE$;
            boolean x$20 = false;
            LogOffsetsListener x$21 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
            return UnifiedLog$.MODULE$.apply(dir, config, 0L, 0L, (Scheduler)x$12, mockBrokerTopicStats, (Time)mockTime, 300000, x$10, x$11, x$15, false, (Option)x$17, false, (ConcurrentMap)mockMap, x$20, x$21);
        }).when((Object)spyLogManager)).loadLog((File)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (LogConfig)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.doNothing().when((Object)spyLogManager)).removeLogRecoveryMetrics();
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        Map expectedRemainingLogsParams = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1))}));
        this.verifyRemainingLogsToRecoverMetric(spyLogManager, (Map<String, Object>)expectedRemainingLogsParams);
        Map expectedRemainingSegmentsParams = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog))}));
        this.verifyRemainingSegmentsToRecoverMetric(spyLogManager, (scala.collection.immutable.Seq<File>)logDirs, recoveryThreadsPerDataDir, mockMap, (Map<String, Object>)expectedRemainingSegmentsParams);
    }

    @Test
    public void testLogRecoveryMetricsShouldBeRemovedAfterLogRecovered() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        .colon.colon logDirs = new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$));
        int recoveryThreadsPerDataDir = 2;
        MockConfigRepository x$4 = new MockConfigRepository();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)logDirs, x$4, recoveryThreadsPerDataDir));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        this.verifyLogRecoverMetricsRemoved(spyLogManager);
    }

    @Test
    public void testMetricsExistWhenLogIsRecreatedBeforeDeletion() {
        String topicName = "metric-test";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2, x$5);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        LogManager qual$2 = this.logManager();
        boolean x$7 = qual$2.asyncDelete$default$2();
        boolean x$8 = qual$2.asyncDelete$default$3();
        boolean x$9 = qual$2.asyncDelete$default$4();
        UnifiedLog removedLog = (UnifiedLog)qual$2.asyncDelete(tp, x$7, x$8, x$9).get();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$2(topicName).isEmpty());
        LogManager qual$3 = this.logManager();
        None$ x$11 = None$.MODULE$;
        boolean x$12 = qual$3.getOrCreateLog$default$2();
        boolean x$13 = qual$3.getOrCreateLog$default$3();
        Option x$14 = qual$3.getOrCreateLog$default$5();
        qual$3.getOrCreateLog(tp, x$12, x$13, (Option)x$11, x$14);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        this.time().sleep(this.logConfig().fileDeleteDelayMs + 1L);
        Assertions.assertTrue((boolean)removedLog.logSegments().isEmpty());
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
    }

    @Test
    public void testMetricsAreRemovedWhenMovingCurrentToFutureLog() {
        File dir1 = TestUtils.tempDirectory(null, null);
        File dir2 = TestUtils.tempDirectory(null, null);
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)dir1, (List)new .colon.colon((Object)dir2, (List)Nil$.MODULE$)), new MockConfigRepository(), 1));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        String topicName = "future-log";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        this.logManager().maybeUpdatePreferredLogDir(tp, dir1.getAbsolutePath());
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2, x$5);
        this.logManager().maybeUpdatePreferredLogDir(tp, dir2.getAbsolutePath());
        LogManager qual$2 = this.logManager();
        None$ x$8 = None$.MODULE$;
        boolean x$9 = qual$2.getOrCreateLog$default$2();
        Option x$10 = qual$2.getOrCreateLog$default$5();
        qual$2.getOrCreateLog(tp, x$9, true, (Option)x$8, x$10);
        LogManagerTest.verifyMetrics$2(2, metricTag, topicName);
        this.logManager().replaceCurrentWithFutureLog(tp);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
        Assertions.assertEquals((int)0, (int)LogManagerTest.logMetrics$3(topicName).count((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$3(m))));
        this.time().sleep(this.logConfig().fileDeleteDelayMs + 1L);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
    }

    @Test
    public void testWaitForAllToComplete() {
        IntRef invokedCount = IntRef.create((int)0);
        Future success = (Future)Mockito.mock(Future.class);
        Mockito.when(success.get()).thenAnswer(x$21 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testWaitForAllToComplete$1(invokedCount, x$21)));
        Future failure = (Future)Mockito.mock(Future.class);
        Mockito.when(failure.get()).thenAnswer(x$22 -> {
            ++invokedCount$1.elem;
            throw new RuntimeException();
        });
        IntRef failureCount = IntRef.create((int)0);
        Assertions.assertFalse((new .colon.colon((Object)success, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$23 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$3(failureCount, x$23);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)invokedCount.elem);
        Assertions.assertEquals((int)1, (int)failureCount.elem);
        Assertions.assertFalse((new .colon.colon((Object)failure, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$24 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$4(failureCount, x$24);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)4, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Assertions.assertTrue((new .colon.colon((Object)success, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$25 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$5(failureCount, x$25);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)6, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Assertions.assertFalse((new .colon.colon((Object)failure, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$26 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$6(failureCount, x$26);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)8, (int)invokedCount.elem);
        Assertions.assertEquals((int)4, (int)failureCount.elem);
    }

    @Test
    public void testLoadDirectoryIds() {
        scala.collection.immutable.Seq dirs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().fill(5, (Function0 & Serializable)() -> TestUtils$.MODULE$.tempDir());
        this.writeMetaProperties((File)dirs.apply(0), this.writeMetaProperties$default$2());
        this.writeMetaProperties((File)dirs.apply(1), Optional.of(Uuid.fromString((String)"ZwkGXjB0TvSF6mjVh6gO7Q")));
        this.writeMetaProperties((File)dirs.apply(3), Optional.of(Uuid.fromString((String)"kQfNPJ2FTHq_6Qlyyv6Jqg")));
        this.writeMetaProperties((File)dirs.apply(4), this.writeMetaProperties$default$2());
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1));
        Assertions.assertFalse((boolean)this.logManager().directoryId(((File)dirs.apply(0)).getAbsolutePath()).isDefined());
        Assertions.assertTrue((boolean)this.logManager().directoryId(((File)dirs.apply(1)).getAbsolutePath()).isDefined());
        Assertions.assertEquals((Object)new Some((Object)Uuid.fromString((String)"ZwkGXjB0TvSF6mjVh6gO7Q")), (Object)this.logManager().directoryId(((File)dirs.apply(1)).getAbsolutePath()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.logManager().directoryId(((File)dirs.apply(2)).getAbsolutePath()));
        Assertions.assertEquals((Object)new Some((Object)Uuid.fromString((String)"kQfNPJ2FTHq_6Qlyyv6Jqg")), (Object)this.logManager().directoryId(((File)dirs.apply(3)).getAbsolutePath()));
        Assertions.assertTrue((boolean)this.logManager().directoryId(((File)dirs.apply(3)).getAbsolutePath()).isDefined());
        Assertions.assertEquals((int)2, (int)this.logManager().directoryIdsSet().size());
    }

    public void writeMetaProperties(File dir, Optional<Uuid> directoryId) {
        PropertiesUtils.writePropertiesFile((Properties)new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V0).setClusterId("IVT1Seu3QjacxS7oBTKhDQ").setNodeId(1).setDirectoryId(directoryId).build().toProperties(), (String)new File(dir, "meta.properties").getAbsolutePath(), (boolean)false);
    }

    public Optional<Uuid> writeMetaProperties$default$2() {
        return Optional.empty();
    }

    public TopicIdPartition foo0() {
        return this.foo0;
    }

    public TopicIdPartition foo1() {
        return this.foo1;
    }

    public TopicIdPartition bar0() {
        return this.bar0;
    }

    public TopicIdPartition bar1() {
        return this.bar1;
    }

    public TopicIdPartition baz0() {
        return this.baz0;
    }

    public TopicIdPartition baz1() {
        return this.baz1;
    }

    public TopicIdPartition baz2() {
        return this.baz2;
    }

    public TopicIdPartition quux0() {
        return this.quux0;
    }

    public TopicIdPartition recreatedFoo0() {
        return this.recreatedFoo0;
    }

    public TopicIdPartition recreatedFoo1() {
        return this.recreatedFoo1;
    }

    @Test
    public void testFindStrayReplicasInEmptyImage() {
        TopicsImage image = LogManagerTest$.MODULE$.topicsImage((scala.collection.immutable.Seq<TopicImage>)Nil$.MODULE$);
        .colon.colon onDisk = new .colon.colon((Object)this.foo0(), (List)new .colon.colon((Object)this.foo1(), (List)new .colon.colon((Object)this.bar0(), (List)new .colon.colon((Object)this.bar1(), (List)new .colon.colon((Object)this.quux0(), (List)Nil$.MODULE$)))));
        Assertions.assertEquals((Object)((IterableOnceOps)onDisk.map((Function1 & Serializable)x$27 -> x$27.topicPartition())).toSet(), (Object)LogManager$.MODULE$.findStrayReplicas(0, image, (Iterable)((IterableOnceOps)onDisk.map((Function1 & Serializable)x$28 -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)x$28))).toSet()));
    }

    @Test
    public void testFindSomeStrayReplicasInImage() {
        TopicsImage image = LogManagerTest$.MODULE$.topicsImage((scala.collection.immutable.Seq<TopicImage>)new .colon.colon((Object)LogManagerTest$.MODULE$.topicImage((Map<TopicIdPartition, scala.collection.immutable.Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.foo0()), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})))), (List)new .colon.colon((Object)LogManagerTest$.MODULE$.topicImage((Map<TopicIdPartition, scala.collection.immutable.Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.bar0()), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.bar1()), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})))), (List)Nil$.MODULE$)));
        scala.collection.immutable.Seq onDisk = (scala.collection.immutable.Seq)new .colon.colon((Object)this.foo0(), (List)new .colon.colon((Object)this.foo1(), (List)new .colon.colon((Object)this.bar0(), (List)new .colon.colon((Object)this.bar1(), (List)new .colon.colon((Object)this.quux0(), (List)Nil$.MODULE$))))).map((Function1 & Serializable)x$29 -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)x$29));
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.foo1(), this.quux0()}))).map((Function1 & Serializable)x$30 -> x$30.topicPartition())), (Object)LogManager$.MODULE$.findStrayReplicas(0, image, (Iterable)onDisk).toSet());
    }

    @Test
    public void testFindSomeStrayReplicasInImageWithRemoteReplicas() {
        TopicsImage image = LogManagerTest$.MODULE$.topicsImage((scala.collection.immutable.Seq<TopicImage>)new .colon.colon((Object)LogManagerTest$.MODULE$.topicImage((Map<TopicIdPartition, scala.collection.immutable.Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.foo0()), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})))), (List)new .colon.colon((Object)LogManagerTest$.MODULE$.topicImage((Map<TopicIdPartition, scala.collection.immutable.Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.bar0()), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.bar1()), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0})))})))), (List)Nil$.MODULE$)));
        scala.collection.immutable.Seq onDisk = (scala.collection.immutable.Seq)new .colon.colon((Object)this.foo0(), (List)new .colon.colon((Object)this.bar0(), (List)new .colon.colon((Object)this.bar1(), (List)Nil$.MODULE$))).map((Function1 & Serializable)x$31 -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)x$31));
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.bar0()}))).map((Function1 & Serializable)x$32 -> x$32.topicPartition())), (Object)LogManager$.MODULE$.findStrayReplicas(0, image, (Iterable)onDisk).toSet());
    }

    @Test
    public void testFindStrayReplicasInEmptyLAIR() {
        scala.collection.immutable.Seq onDisk = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.foo0(), this.foo1(), this.bar0(), this.bar1(), this.baz0(), this.baz1(), this.baz2(), this.quux0()}));
        Assertions.assertEquals((Object)((IterableOnceOps)onDisk.map((Function1 & Serializable)x$33 -> x$33.topicPartition())).toSet(), (Object)LogManager$.MODULE$.findStrayReplicas(0, LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection((Iterable<TopicIdPartition>)Nil$.MODULE$, (Iterable<Object>)Nil$.MODULE$), (Iterable)onDisk.map((Function1 & Serializable)x$34 -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)x$34))).toSet());
    }

    @Test
    public void testFindNoStrayReplicasInFullLAIR() {
        scala.collection.immutable.Seq onDisk = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.foo0(), this.foo1(), this.bar0(), this.bar1(), this.baz0(), this.baz1(), this.baz2(), this.quux0()}));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)LogManager$.MODULE$.findStrayReplicas(0, LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection((Iterable<TopicIdPartition>)onDisk, (Iterable<Object>)Nil$.MODULE$), (Iterable)onDisk.map((Function1 & Serializable)x$35 -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)x$35))).toSet());
    }

    @Test
    public void testFindSomeStrayReplicasInFullLAIR() {
        scala.collection.immutable.Seq onDisk = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.foo0(), this.foo1(), this.bar0(), this.bar1(), this.baz0(), this.baz1(), this.baz2(), this.quux0()}));
        .colon.colon present = new .colon.colon((Object)this.foo0(), (List)new .colon.colon((Object)this.bar0(), (List)new .colon.colon((Object)this.bar1(), (List)new .colon.colon((Object)this.quux0(), (List)Nil$.MODULE$))));
        Assertions.assertEquals((Object)((IterableOnceOps)new .colon.colon((Object)this.foo1(), (List)new .colon.colon((Object)this.baz0(), (List)new .colon.colon((Object)this.baz1(), (List)new .colon.colon((Object)this.baz2(), (List)Nil$.MODULE$)))).map((Function1 & Serializable)x$36 -> x$36.topicPartition())).toSet(), (Object)LogManager$.MODULE$.findStrayReplicas(0, LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection((Iterable<TopicIdPartition>)present, (Iterable<Object>)Nil$.MODULE$), (Iterable)onDisk.map((Function1 & Serializable)x$37 -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)x$37))).toSet());
    }

    @Test
    public void testTopicRecreationInFullLAIR() {
        scala.collection.immutable.Seq onDisk = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.foo0(), this.foo1(), this.bar0(), this.bar1(), this.baz0(), this.baz1(), this.baz2(), this.quux0()}));
        .colon.colon present = new .colon.colon((Object)this.recreatedFoo0(), (List)new .colon.colon((Object)this.recreatedFoo1(), (List)new .colon.colon((Object)this.bar0(), (List)new .colon.colon((Object)this.baz0(), (List)new .colon.colon((Object)this.baz1(), (List)new .colon.colon((Object)this.baz2(), (List)new .colon.colon((Object)this.quux0(), (List)Nil$.MODULE$)))))));
        Assertions.assertEquals((Object)((IterableOnceOps)new .colon.colon((Object)this.foo0(), (List)new .colon.colon((Object)this.foo1(), (List)new .colon.colon((Object)this.bar1(), (List)Nil$.MODULE$))).map((Function1 & Serializable)x$38 -> x$38.topicPartition())).toSet(), (Object)LogManager$.MODULE$.findStrayReplicas(0, LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection((Iterable<TopicIdPartition>)present, (Iterable<Object>)Nil$.MODULE$), (Iterable)onDisk.map((Function1 & Serializable)x$39 -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)x$39))).toSet());
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownFileWithBrokerEpoch$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownFileWithBrokerEpoch$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            LogManagerTest.$anonfun$testCleanShutdownFileWithBrokerEpoch$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$1(VolatileIntRef loadLogCalled$1, InvocationOnMock invocation) {
        Thread.sleep(5000L);
        UnifiedLog cfr_ignored_0 = (UnifiedLog)invocation.callRealMethod();
        ++loadLogCalled$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$2(VolatileIntRef loadLogCalled$1) {
        return loadLogCalled$1.elem == 1;
    }

    public static final /* synthetic */ String $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$3() {
        return "Timed out waiting for only the first log to be loaded";
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1(int x$3) {
        return Integer.toString(x$3);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateLogWithLogDirFallback$4(LogManagerTest $this, File dir) {
        return new File(dir, new StringBuilder(2).append($this.name()).append("-0").toString()).exists();
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$1(UnifiedLog log$4, int x$10) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        return log$4.appendAsLeader(set, 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4(), log$4.appendAsLeader$default$5(), log$4.appendAsLeader$default$6());
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$2(UnifiedLog log) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)x$14 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$4(Map checkpoints$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$1(File x$15) {
        return x$15.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$3(File fileBeforeDelete$1, File x$16) {
        String string = x$16.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$2(scala.collection.immutable.Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(fileBeforeDelete, x$16)));
        Assertions.assertEquals((Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1 & Serializable)x$17 -> x$17.getName()), (String)new StringBuilder(51).append("Could not find index file ").append(fileBeforeDelete.getName()).append(" in indexFilesAfterDelete").toString());
        Assertions.assertNotEquals((Object)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (String)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$2(UnifiedLog log) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)x$19 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$4(Map checkpoints$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$2.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    private static final MemoryRecords createRecord$1(MockTime time$1) {
        byte[] x$1 = "test".getBytes();
        long x$2 = time$1.milliseconds();
        CompressionType x$4 = CompressionType.NONE;
        byte x$5 = 2;
        return TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, x$5);
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemainingLogsToRecoverMetric$1(String logManagerClassName$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metric = (MetricName)x0$1._1();
            String string = metric.getType();
            String string2 = String.valueOf(logManagerClassName$1);
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = metric.getName();
                String string4 = "remainingLogsToRecover";
                if (string3 != null && string3.equals(string4)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$3(java.util.List paths$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String path = (String)x0$3._1();
            Assertions.assertEquals((int)x0$3._2$mcI$sp(), (int)Collections.frequency(paths$1, path));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemainingSegmentsToRecoverMetric$1(String logManagerClassName$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metric = (MetricName)x0$1._1();
            String string = metric.getType();
            String string2 = String.valueOf(logManagerClassName$2);
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = metric.getName();
                String string4 = "remainingSegmentsToRecover";
                if (string3 != null && string3.equals(string4)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$5(java.util.List threadNames$1, java.util.List numRemainingSegments$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String threadName = (String)x0$3._1();
            IntRef expectedCurRemainingSegments = IntRef.create((int)(x0$3._2$mcI$sp() + 1));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), threadNames$1.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (((String)threadNames$1.get(i)).contains(threadName)) {
                    --expectedCurRemainingSegments$1.elem;
                    Assertions.assertEquals((int)expectedCurRemainingSegments$1.elem, (int)BoxesRunTime.unboxToInt(numRemainingSegments$1.get(i)));
                    return;
                }
            });
            Assertions.assertEquals((int)0, (int)expectedCurRemainingSegments.elem);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$1(String spyLogManagerClassName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$1);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingLogsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    private static final scala.collection.mutable.Set logMetrics$1(String spyLogManagerClassName$1) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$1(spyLogManagerClassName$1, metric)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$2(String spyLogManagerClassName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$1);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingSegmentsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(String topicName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$1);
    }

    private static final scala.collection.mutable.Set logMetrics$2(String topicName$1) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(topicName$1, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(String metricTag$1, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$1));
    }

    private static final void verifyMetrics$1(String metricTag$1, String topicName$1) {
        Assertions.assertEquals((int)LogMetricNames$.MODULE$.allMetricNames().size(), (int)LogManagerTest.logMetrics$2(topicName$1).size());
        LogManagerTest.logMetrics$2(topicName$1).foreach((Function1 & Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(metricTag$1, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(String topicName$2, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$2);
    }

    private static final scala.collection.mutable.Set logMetrics$3(String topicName$2) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(topicName$2, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(String metricTag$2, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$2));
    }

    private static final void verifyMetrics$2(int logCount, String metricTag$2, String topicName$2) {
        Assertions.assertEquals((int)(LogMetricNames$.MODULE$.allMetricNames().size() * logCount), (int)LogManagerTest.logMetrics$3(topicName$2).size());
        LogManagerTest.logMetrics$3(topicName$2).foreach((Function1 & Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(metricTag$2, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$3(MetricName m) {
        return m.getMBeanName().contains("is-future");
    }

    public static final /* synthetic */ boolean $anonfun$testWaitForAllToComplete$1(IntRef invokedCount$1, InvocationOnMock x$21) {
        ++invokedCount$1.elem;
        return true;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$3(IntRef failureCount$1, Throwable x$23) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$4(IntRef failureCount$1, Throwable x$24) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$5(IntRef failureCount$1, Throwable x$25) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$6(IntRef failureCount$1, Throwable x$26) {
        ++failureCount$1.elem;
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("segment.index.bytes", Predef$.MODULE$.int2Integer(4096));
        this.logProps().put("retention.ms", Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logConfig = new LogConfig((java.util.Map)this.logProps());
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
        this.foo0 = new TopicIdPartition(Uuid.fromString((String)"Sl08ZXU2QW6uF5hIoSzc8w"), new TopicPartition("foo", 0));
        this.foo1 = new TopicIdPartition(Uuid.fromString((String)"Sl08ZXU2QW6uF5hIoSzc8w"), new TopicPartition("foo", 1));
        this.bar0 = new TopicIdPartition(Uuid.fromString((String)"69O438ZkTSeqqclTtZO2KA"), new TopicPartition("bar", 0));
        this.bar1 = new TopicIdPartition(Uuid.fromString((String)"69O438ZkTSeqqclTtZO2KA"), new TopicPartition("bar", 1));
        this.baz0 = new TopicIdPartition(Uuid.fromString((String)"2Ik9_5-oRDOKpSXd2SuG5w"), new TopicPartition("baz", 0));
        this.baz1 = new TopicIdPartition(Uuid.fromString((String)"2Ik9_5-oRDOKpSXd2SuG5w"), new TopicPartition("baz", 1));
        this.baz2 = new TopicIdPartition(Uuid.fromString((String)"2Ik9_5-oRDOKpSXd2SuG5w"), new TopicPartition("baz", 2));
        this.quux0 = new TopicIdPartition(Uuid.fromString((String)"YS9owjv5TG2OlsvBM0Qw6g"), new TopicPartition("quux", 0));
        this.recreatedFoo0 = new TopicIdPartition(Uuid.fromString((String)"_dOOzPe3TfiWV21Lh7Vmqg"), new TopicPartition("foo", 0));
        this.recreatedFoo1 = new TopicIdPartition(Uuid.fromString((String)"_dOOzPe3TfiWV21Lh7Vmqg"), new TopicPartition("foo", 1));
    }

    public static final /* synthetic */ Object $anonfun$testFileReferencesAfterAsyncDelete$2$adapted(scala.collection.immutable.Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(indexFilesAfterDelete$1, fileBeforeDelete);
        return BoxedUnit.UNIT;
    }
}

