/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.UnifiedLog$;
import kafka.server.Defaults$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CompletedTxn;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.ProducerAppendInfo;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.SnapshotFile;
import org.apache.kafka.storage.internals.log.TxnMetadata;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.storage.internals.log.VerificationStateEntry;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\u001de\u0001\u0002,X\u0001qCQa\u0019\u0001\u0005\u0002\u0011D\u0011b\u001a\u0001A\u0002\u0003\u0007I\u0011\u00025\t\u0013E\u0004\u0001\u0019!a\u0001\n\u0013\u0011\b\"\u0003=\u0001\u0001\u0004\u0005\t\u0015)\u0003j\u0011%I\b\u00011AA\u0002\u0013%!\u0010C\u0006\u0002\u0014\u0001\u0001\r\u00111A\u0005\n\u0005U\u0001BCA\r\u0001\u0001\u0007\t\u0011)Q\u0005w\"I\u00111\u0004\u0001C\u0002\u0013%\u0011Q\u0004\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002 !I\u0011Q\u0006\u0001C\u0002\u0013%\u0011q\u0006\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u00022!I\u0011\u0011\b\u0001C\u0002\u0013%\u00111\b\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u0002>!I\u0011Q\t\u0001C\u0002\u0013%\u0011q\t\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002J!I\u0011\u0011\u000b\u0001C\u0002\u0013%\u0011q\u0006\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u00022!I\u0011Q\u000b\u0001C\u0002\u0013%\u0011q\u000b\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002Z!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBAA\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003\u0017\u0003A\u0011AA5\u0011\u001d\t)\n\u0001C\u0001\u0003SBq!!'\u0001\t\u0003\tI\u0007C\u0004\u0002\u001e\u0002!\t!!\u001b\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002j!9\u0011Q\u0015\u0001\u0005\u0002\u0005%\u0004bBAU\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003[\u0003A\u0011AA5\u0011\u001d\t\t\f\u0001C\u0001\u0003SBq!!.\u0001\t\u0003\t9\fC\u0004\u00026\u0002!\t!a5\t\u000f\u0005e\u0007\u0001\"\u0001\u0002j!9\u0011Q\u001c\u0001\u0005\u0002\u0005%\u0004bBAq\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003K\u0004A\u0011AA5\u0011\u001d\tI\u000f\u0001C\u0001\u0003SBq!!<\u0001\t\u0003\tI\u0007C\u0004\u0002r\u0002!\t!!\u001b\t\u000f\u0005U\b\u0001\"\u0001\u0002j!9\u0011\u0011 \u0001\u0005\u0002\u0005%\u0004bBA\u007f\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0005\u0003\u0001A\u0011AA5\u0011\u001d\u0011)\u0001\u0001C\u0001\u0003SBqA!\u0003\u0001\t\u0003\tI\u0007C\u0004\u0003\u000e\u0001!\t!!\u001b\t\u000f\tE\u0001\u0001\"\u0001\u0002j!9!Q\u0003\u0001\u0005\u0002\u0005%\u0004b\u0002B\r\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0005;\u0001A\u0011AA5\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0003SBqA!\n\u0001\t\u0003\tI\u0007C\u0004\u0003*\u0001!\t!!\u001b\t\u000f\t5\u0002\u0001\"\u0001\u0002j!9!\u0011\u0007\u0001\u0005\u0002\u0005%\u0004b\u0002B\u001b\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0005s\u0001A\u0011AA5\u0011\u001d\u0011i\u0004\u0001C\u0001\u0003SBqA!\u0011\u0001\t\u0003\tI\u0007C\u0004\u0003F\u0001!\t!!\u001b\t\u000f\t%\u0003\u0001\"\u0001\u0002j!9!Q\n\u0001\u0005\u0002\u0005%\u0004b\u0002B)\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0005+\u0002A\u0011AA5\u0011\u001d\u0011I\u0006\u0001C\u0001\u0003SBqA!\u0018\u0001\t\u0003\tI\u0007C\u0004\u0003b\u0001!\t!!\u001b\t\u000f\t\u0015\u0004\u0001\"\u0001\u0002j!9!\u0011\u000e\u0001\u0005\u0002\u0005%\u0004b\u0002B7\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0005c\u0002A\u0011AA5\u0011\u001d\u0011)\b\u0001C\u0001\u0003SBqA!\u001f\u0001\t\u0003\tI\u0007C\u0004\u0003~\u0001!\tAa \t\u000f\t=\u0006\u0001\"\u0001\u0002j!9!1\u0017\u0001\u0005\n\tU\u0006b\u0002Bi\u0001\u0011%!1\u001b\u0005\n\u0007\u001b\u0001\u0011\u0013!C\u0005\u0007\u001fA\u0011b!\n\u0001#\u0003%Iaa\n\t\u000f\r-\u0002\u0001\"\u0003\u0004.!I11\n\u0001\u0012\u0002\u0013%1q\u0005\u0005\n\u0007\u001b\u0002\u0011\u0013!C\u0005\u0007\u001fB\u0011ba\u0015\u0001#\u0003%Ia!\u0016\t\u000f\r-\u0002\u0001\"\u0003\u0004Z!91Q\u000e\u0001\u0005\n\r=$\u0001\u0007)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'\u000fV3ti*\u0011\u0001,W\u0001\u0004Y><'\"\u0001.\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0002A\u0006)1oY1mC&\u0011!m\u0018\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)\u0007C\u00014\u0001\u001b\u00059\u0016A\u00027pO\u0012K'/F\u0001j!\tQw.D\u0001l\u0015\taW.\u0001\u0002j_*\ta.\u0001\u0003kCZ\f\u0017B\u00019l\u0005\u00111\u0015\u000e\\3\u0002\u00151|w\rR5s?\u0012*\u0017\u000f\u0006\u0002tmB\u0011a\f^\u0005\u0003k~\u0013A!\u00168ji\"9qoAA\u0001\u0002\u0004I\u0017a\u0001=%c\u00059An\\4ESJ\u0004\u0013\u0001D:uCR,W*\u00198bO\u0016\u0014X#A>\u0011\u0007q\fy!D\u0001~\u0015\tAfPC\u0002\u0000\u0003\u0003\t\u0011\"\u001b8uKJt\u0017\r\\:\u000b\t\u0005\r\u0011QA\u0001\bgR|'/Y4f\u0015\rQ\u0016q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u001b\t1a\u001c:h\u0013\r\t\t\" \u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\u0002!M$\u0018\r^3NC:\fw-\u001a:`I\u0015\fHcA:\u0002\u0018!9qOBA\u0001\u0002\u0004Y\u0018!D:uCR,W*\u00198bO\u0016\u0014\b%A\u0005qCJ$\u0018\u000e^5p]V\u0011\u0011q\u0004\t\u0005\u0003C\t9#\u0004\u0002\u0002$)!\u0011QEA\u0003\u0003\u0019\u0019w.\\7p]&!\u0011\u0011FA\u0012\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f!\u0002]1si&$\u0018n\u001c8!\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\nZ\u000b\u0003\u0003c\u00012AXA\u001a\u0013\r\t)d\u0018\u0002\u0005\u0019>tw-A\u0006qe>$WoY3s\u0013\u0012\u0004\u0013aF7bqR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'t+\t\ti\u0004E\u0002_\u0003\u007fI1!!\u0011`\u0005\rIe\u000e^\u0001\u0019[\u0006DHK]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN\u0004\u0013A\u00079s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'oQ8oM&<WCAA%!\ra\u00181J\u0005\u0004\u0003\u001bj(A\u0007)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'oQ8oM&<\u0017a\u00079s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'oQ8oM&<\u0007%\u0001\rmCR,GK]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN\f\u0011\u0004\\1uKR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'tA\u0005!A/[7f+\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\u0011\ty&a\t\u0002\u000bU$\u0018\u000e\\:\n\t\u0005\r\u0014Q\f\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005)1/\u001a;VaR\t1\u000fK\u0002\u0015\u0003[\u0002B!a\u001c\u0002~5\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\n)(A\u0002ba&TA!a\u001e\u0002z\u00059!.\u001e9ji\u0016\u0014(\u0002BA>\u0003\u0017\tQA[;oSRLA!a \u0002r\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3!FAC!\u0011\ty'a\"\n\t\u0005%\u0015\u0011\u000f\u0002\n\u0003\u001a$XM]#bG\"\f!\u0003^3ti\n\u000b7/[2JI6\u000b\u0007\u000f]5oO\"\u001aa#a$\u0011\t\u0005=\u0014\u0011S\u0005\u0005\u0003'\u000b\tH\u0001\u0003UKN$\u0018A\n;fgR\f\u0005\u000f]3oIRCh.T1sW\u0016\u0014x+\u001b;i\u001d>\u0004&o\u001c3vG\u0016\u00148\u000b^1uK\"\u001aq#a$\u0002=Q,7\u000f\u001e)s_\u0012,8-\u001a:TKF,XM\\2f/J\f\u0007/\u0011:pk:$\u0007f\u0001\r\u0002\u0010\u0006iC/Z:u!J|G-^2feN+\u0017/^3oG\u0016<\u0016\u000e\u001e5Xe\u0006\u0004\u0018I]8v]\u0012\u0014\u0015\r^2i%\u0016\u001cwN\u001d3)\u0007e\ty)A\u0013uKN$\bK]8ek\u000e,'oU3rk\u0016t7-Z%om\u0006d\u0017\u000eZ,sCB\f%o\\;oI\"\u001a!$a$\u0002UQ,7\u000f\u001e(p-\u0006d\u0017\u000eZ1uS>twJ\u001c$jeN$XI\u001c;ss^CWM\u001c'pC\u0012Lgn\u001a'pO\"\u001a1$a$\u0002GQ,7\u000f^\"p]R\u0014x\u000e\u001c*fG>\u0014HMQ;naN\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\"\u001aA$a$\u0002AQ,7\u000f\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1DC\u000eDW\r\u001a\u0015\u0004;\u0005=\u0015!\u0007;fgR\u001c6.\u001b9F[B$\u0018\u0010\u0016:b]N\f7\r^5p]ND3AHAH\u0003]\t7o]3siRCh.T3uC\u0012\fG/Y#rk\u0006d7\u000fF\u0003t\u0003s\u000by\rC\u0004\u0002<~\u0001\r!!0\u0002\u0011\u0015D\b/Z2uK\u0012\u0004b!a0\u0002F\u0006%WBAAa\u0015\r\t\u0019-\\\u0001\u0005kRLG.\u0003\u0003\u0002H\u0006\u0005'\u0001\u0002'jgR\u00042\u0001`Af\u0013\r\ti- \u0002\f)btW*\u001a;bI\u0006$\u0018\rC\u0004\u0002R~\u0001\r!!0\u0002\r\u0005\u001cG/^1m)\u0015\u0019\u0018Q[Al\u0011\u001d\tY\f\ta\u0001\u0003\u0013Dq!!5!\u0001\u0004\tI-\u0001\fuKN$\b*Y:MCR,GK]1og\u0006\u001cG/[8oQ\r\t\u0013qR\u0001-i\u0016\u001cH\u000fS1t\u0019\u0006$X\r\u0016:b]N\f7\r^5p]&s\u0017\u000e^5bY&TX\rZ!gi\u0016\u0014(+\u001a7pC\u0012D3AIAH\u0003M\"Xm\u001d;ICNd\u0015\r^3Ue\u0006t7/Y2uS>tW\u000b\u001d3bi\u0016$\u0017I\u001a;feB\u000b'\u000f^5bYR\u0013XO\\2bi&|g\u000eK\u0002$\u0003\u001f\u000b\u0001\u0007^3ti\"\u000b7\u000fT1uKR\u0013\u0018M\\:bGRLwN\\+qI\u0006$X\rZ!gi\u0016\u0014h)\u001e7m)J,hnY1uS>t\u0007f\u0001\u0013\u0002\u0010\u0006\u0001C/Z:u\u0019\u0006\u001cHo\u0015;bE2,wJ\u001a4tKR\u001cu.\u001c9mKR,G\r\u0016=oQ\r)\u0013qR\u0001\u001fi\u0016\u001cH\u000f\u0015:fa\u0006\u0014X-\u00169eCR,Gi\\3t\u001d>$X*\u001e;bi\u0016D3AJAH\u0003y)\b\u000fZ1uKB\u0013x\u000eZ;dKJ$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\rK\u0002(\u0003\u001f\u000bA\u0006^3ti>+Ho\u00144TKF,XM\\2f\u0003\u001a$XM]\"p]R\u0014x\u000e\u001c*fG>\u0014H-\u00129pG\"\u0014U/\u001c9)\u0007!\ny)\u0001\u0019uKN$hj\u001c8Ue\u0006t7/Y2uS>t\u0017\r\\!qa\u0016tGmV5uQ>swm\\5oOR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004S\u0005=\u0015a\f;fgR$&/\u001e8dCR,\u0017I\u001c3SK2|\u0017\r\u001a*f[>4Xm](vi>3'+\u00198hKNs\u0017\r]:i_R\u001c\bf\u0001\u0016\u0002\u0010\u0006\u0001B/Z:u)\u0006\\Wm\u00158baNDw\u000e\u001e\u0015\u0004W\u0005=\u0015\u0001\f;fgR\u0014VmY8wKJ4%o\\7T]\u0006\u00048\u000f[8u+:4\u0017N\\5tQ\u0016$GK]1og\u0006\u001cG/[8oQ\ra\u0013qR\u0001+i\u0016\u001cHOU3d_Z,'O\u0012:p[Ns\u0017\r]:i_R4\u0015N\\5tQ\u0016$GK]1og\u0006\u001cG/[8oQ\ri\u0013qR\u0001(i\u0016\u001cHOU3d_Z,'O\u0012:p[Ns\u0017\r]:i_R,U\u000e\u001d;z)J\fgn]1di&|g\u000eK\u0002/\u0003\u001f\u000b\u0001\u0006^3tiB\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u0003\u001a$XM\u001d$f]\u000eLgnZ!c_J$X*\u0019:lKJD3aLAH\u0003u!Xm\u001d;SK6|g/Z#ya&\u0014X\r\u001a)jIN|eNU3m_\u0006$\u0007f\u0001\u0019\u0002\u0010\u0006iC/Z:u\u0003\u000e\u001cW\r\u001d;BaB,g\u000eZ,ji\"|W\u000f\u001e)s_\u0012,8-\u001a:Ti\u0006$Xm\u00148SKBd\u0017nY1)\u0007E\ny)A\u0015uKN$\u0018iY2faR\f\u0005\u000f]3oI^KG\u000f[*fcV,gnY3HCB\u001cxJ\u001c*fa2L7-\u0019\u0015\u0004e\u0005=\u0015!\u0007;fgR$U\r\\3uKNs\u0017\r]:i_R\u001c()\u001a4pe\u0016D3aMAH\u0003m!Xm\u001d;UeVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;Bi\"\u001aA'a$\u0002'Q,7\u000f\u001e*fY>\fGm\u00158baNDw\u000e^:)\u0007U\ny)\u0001\u0014uKN$h)\u001b:tiVs7\u000f^1cY\u0016|eMZ:fi\u00063G/\u001a:UeVt7-\u0019;j_:D3ANAH\u00039\"Xm\u001d;M_\u0006$gI]8n':\f\u0007o\u001d5piJ+G/Y5og:{g.\u0012=qSJ,G\r\u0015:pIV\u001cWM]:)\u0007]\ny)A\u0011uKN$8k[5q':\f\u0007o\u001d5pi&3wJ\u001a4tKR,fn\u00195b]\u001e,G\rK\u00029\u0003\u001f\u000b\u0001\u0004^3tiBKG-\u0012=qSJ\fG/[8o)&lWm\\;uQ\rI\u0014qR\u0001\u0018i\u0016\u001cHOR5sgR,fn\u001d;bE2,wJ\u001a4tKRD3AOAH\u00039\"Xm\u001d;Qe>$WoY3sg^KG\u000f[(oO>Lgn\u001a+sC:\u001c\u0018m\u0019;j_:\u001cHi\u001c8u\u000bb\u0004\u0018N]3)\u0007m\ny)A\u0017uKN$8+Z9vK:\u001cWMT8u-\u0006d\u0017\u000eZ1uK\u00124uN]$s_V\u0004X*\u001a;bI\u0006$\u0018\rV8qS\u000eD3\u0001PAH\u0003q!Xm\u001d;PY\u0012,\u0005o\\2i\r>\u00148i\u001c8ue>d'+Z2pe\u0012D3!PAH\u0003Y!Xm\u001d;D_>\u0014H-\u001b8bi>\u0014h)\u001a8dS:<\u0007f\u0001 \u0002\u0010\u0006\u0001C/Z:u\u0007>|'\u000fZ5oCR|'OR3oG\u0016$\u0017I\u001a;feJ+Gn\\1eQ\ry\u0014qR\u0001\u001ei\u0016\u001cH\u000fT8bI\u001a\u0013x.\\#naRL8K\\1qg\"|GOR5mK\"\u001a\u0001)a$\u0002CQ,7\u000f\u001e'pC\u00124%o\\7UeVt7-\u0019;fINs\u0017\r]:i_R4\u0015\u000e\\3)\u0007\u0005\u000by)A\u0010uKN$Hj\\1e\rJ|WnQ8seV\u0004Ho\u00158baNDw\u000e\u001e$jY\u0016D3AQAH\u0003m!Xm\u001d;BaB,g\u000eZ#naRL8i\u001c8ue>d')\u0019;dQ\"\u001a1)a$\u0002cQ,7\u000f\u001e*f[>4Xm\u0015;sCf\u001cf.\u00199tQ>$8oS3fa\u000ecW-\u00198TQV$Hm\\<o':\f\u0007o\u001d5pi\"\u001aA)a$\u00027Q,7\u000f\u001e*f[>4X-\u00117m'R\u0014\u0018-_*oCB\u001c\bn\u001c;tQ\r)\u0015qR\u0001%i\u0016\u001cHOU3n_Z,\u0017I\u001c3NCJ\\7K\\1qg\"|GOR8s\t\u0016dW\r^5p]\"\u001aa)a$\u0002eQ,7\u000f\u001e*f[>4X-\u00118e\u001b\u0006\u00148n\u00158baNDw\u000e\u001e$pe\u0012+G.\u001a;j_:\fEN]3bIf$U\r\\3uK\u0012D3aRAH\u0003a!Xm\u001d;F]R\u0014\u0018PR8s-\u0016\u0014\u0018NZ5dCRLwN\u001c\u0015\u0004\u0011\u0006=\u0015a\n;fgR\u001cV-];f]\u000e,\u0017I\u001c3Fa>\u001c\u0007.\u00138WKJLg-[2bi&|g.\u00128uefD3!SAH\u0003a\"Xm\u001d;UQJ|woT;u\u001f\u001a|%\u000fZ3s'\u0016\fX/\u001a8dK^KG\u000f\u001b,fe&4\u0017nY1uS>t7+Z9vK:\u001cWm\u00115fG.$2a\u001dBA\u0011\u001d\u0011\u0019I\u0013a\u0001\u0005\u000b\u000b!\u0003Z=oC6L7-\u00197ms\u0012K7/\u00192mKB\u0019aLa\"\n\u0007\t%uLA\u0004C_>dW-\u00198)\u0007)\u0013i\t\u0005\u0003\u0003\u0010\nUUB\u0001BI\u0015\u0011\u0011\u0019*!\u001e\u0002\rA\f'/Y7t\u0013\u0011\u00119J!%\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000fK\u0004K\u00057\u00139K!+\u0011\t\tu%1U\u0007\u0003\u0005?SAA!)\u0003\u0012\u0006A\u0001O]8wS\u0012,'/\u0003\u0003\u0003&\n}%a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0005W\u0013i+G\u0001\u00023\u0005\u0001\u0011\u0001\n;fgR4VM]5gS\u000e\fG/[8o'R\fG/Z#oiJLX\t\u001f9je\u0006$\u0018n\u001c8)\u0007-\u000by)A\u000euKN$Hj\\1e\rJ|WnQ8seV\u0004Ho\u00158baNDw\u000e\u001e\u000b\u0004g\n]\u0006b\u0002B]\u0019\u0002\u0007!1X\u0001\u0010[\u0006\\WMR5mK\u000e{'O];qiB1aL!0\u0003BNL1Aa0`\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0003D\n5WB\u0001Bc\u0015\u0011\u00119M!3\u0002\u0011\rD\u0017M\u001c8fYNT1Aa3n\u0003\rq\u0017n\\\u0005\u0005\u0005\u001f\u0014)MA\u0006GS2,7\t[1o]\u0016d\u0017AE1qa\u0016tG-\u00128e)btW*\u0019:lKJ$\u0002C!6\u0003b\n\u0015(q\u001dBy\u0007\u0003\u0019)a!\u0003\u0011\u000by\u00139Na7\n\u0007\tewL\u0001\u0004PaRLwN\u001c\t\u0004y\nu\u0017b\u0001Bp{\na1i\\7qY\u0016$X\r\u001a+y]\"1!1]'A\u0002m\fq!\\1qa&tw\rC\u0004\u0002.5\u0003\r!!\r\t\u000f\t%X\n1\u0001\u0003l\u0006i\u0001O]8ek\u000e,'/\u00129pG\"\u00042A\u0018Bw\u0013\r\u0011yo\u0018\u0002\u0006'\"|'\u000f\u001e\u0005\b\u0005gl\u0005\u0019\u0001B{\u0003-\u0019wN\u001c;s_2$\u0016\u0010]3\u0011\t\t](Q`\u0007\u0003\u0005sTAAa?\u0002$\u00051!/Z2pe\u0012LAAa@\u0003z\n\t2i\u001c8ue>d'+Z2pe\u0012$\u0016\u0010]3\t\u000f\r\rQ\n1\u0001\u00022\u00051qN\u001a4tKRD\u0011ba\u0002N!\u0003\u0005\r!!\u0010\u0002!\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007\"CB\u0006\u001bB\u0005\t\u0019AA\u0019\u0003%!\u0018.\\3ti\u0006l\u0007/\u0001\u000fbaB,g\u000eZ#oIRCh.T1sW\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\rE!\u0006BA\u001f\u0007'Y#a!\u0006\u0011\t\r]1\u0011E\u0007\u0003\u00073QAaa\u0007\u0004\u001e\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007?y\u0016AC1o]>$\u0018\r^5p]&!11EB\r\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001dCB\u0004XM\u001c3F]\u0012$\u0006P\\'be.,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\u0019IC\u000b\u0003\u00022\rM\u0011AB1qa\u0016tG\rF\tt\u0007_\u0019\tda\r\u00046\re21HB\u001f\u0007\u0003BQ!\u001f)A\u0002mDq!!\fQ\u0001\u0004\t\t\u0004C\u0004\u0003jB\u0003\rAa;\t\u000f\r]\u0002\u000b1\u0001\u0002>\u0005\u00191/Z9\t\u000f\r\r\u0001\u000b1\u0001\u00022!I11\u0002)\u0011\u0002\u0003\u0007\u0011\u0011\u0007\u0005\n\u0007\u007f\u0001\u0006\u0013!a\u0001\u0005\u000b\u000bq\"[:Ue\u0006t7/Y2uS>t\u0017\r\u001c\u0005\n\u0007\u0007\u0002\u0006\u0013!a\u0001\u0007\u000b\naa\u001c:jO&t\u0007c\u0001?\u0004H%\u00191\u0011J?\u0003\u0019\u0005\u0003\b/\u001a8e\u001fJLw-\u001b8\u0002!\u0005\u0004\b/\u001a8eI\u0011,g-Y;mi\u00122\u0014\u0001E1qa\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00138+\t\u0019\tF\u000b\u0003\u0003\u0006\u000eM\u0011\u0001E1qa\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00139+\t\u00199F\u000b\u0003\u0004F\rMAcC:\u0004\\\ru3qLB1\u0007WBQ!\u001f+A\u0002mDq!!\fU\u0001\u0004\t\t\u0004C\u0004\u0004\u0004Q\u0003\r!!\r\t\u000f\r\rD\u000b1\u0001\u0004f\u0005)!-\u0019;dQB!!q_B4\u0013\u0011\u0019IG!?\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r\u001b\u0005\b\u0007\u0007\"\u0006\u0019AB#\u0003Y\u0019WO\u001d:f]R\u001cf.\u00199tQ>$xJ\u001a4tKR\u001cXCAB9!\u0019\u0019\u0019h!!\u000229!1QOB?!\r\u00199hX\u0007\u0003\u0007sR1aa\u001f\\\u0003\u0019a$o\\8u}%\u00191qP0\u0002\rA\u0013X\rZ3g\u0013\u0011\u0019\u0019i!\"\u0003\u0007M+GOC\u0002\u0004\u0000}\u0003")
public class ProducerStateManagerTest {
    private File logDir;
    private ProducerStateManager stateManager;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxTransactionTimeoutMs;
    private final ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), true);
    private final long lateTransactionTimeoutMs = (long)this.maxTransactionTimeoutMs() + 300000L;
    private final MockTime time = new MockTime();

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private ProducerStateManager stateManager() {
        return this.stateManager;
    }

    private void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private long producerId() {
        return this.producerId;
    }

    private int maxTransactionTimeoutMs() {
        return this.maxTransactionTimeoutMs;
    }

    private ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    private long lateTransactionTimeoutMs() {
        return this.lateTransactionTimeoutMs;
    }

    private MockTime time() {
        return this.time;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time()));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, false, AppendOrigin.CLIENT);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, false, AppendOrigin.CLIENT));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, false, AppendOrigin.CLIENT));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, false, AppendOrigin.CLIENT);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, false, AppendOrigin.CLIENT));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, 0, this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).orElseThrow(() -> new RuntimeException("Expected last entry to be defined"));
        Assertions.assertEquals((short)producerEpoch, (short)firstEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assertions.assertEquals((int)-1, (int)firstEntry.lastSeq());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, false, AppendOrigin.CLIENT));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, false, AppendOrigin.CLIENT));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, false, AppendOrigin.CLIENT);
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).orElseThrow(() -> new RuntimeException("Expected last entry to be defined"));
        Assertions.assertEquals((short)producerEpoch, (short)secondEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assertions.assertEquals((int)0, (int)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)0, (int)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.REPLICATION);
        appendInfo.appendDataBatch(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L), 2020L, false);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0x7FFFFFF5, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)9, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)2000L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), false, AppendOrigin.CLIENT));
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)offset, (long)lastEntry.firstDataOffset());
    }

    @Test
    public void testControlRecordBumpsProducerEpoch() {
        short producerEpoch = (short)0;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        short bumpedProducerEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedProducerEpoch, ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)bumpedProducerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((int)-1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)-1, (int)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedProducerEpoch, 0, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)0L)), this.stateManager().lastEntry(this.producerId()).map(x$3 -> BoxesRunTime.boxToLong((long)x$3.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry.empty((long)this.producerId()), AppendOrigin.CLIENT, this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), seq, producerEpoch));
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assertions.assertEquals(Optional.of(firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testSkipEmptyTransactions() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 27;
        AtomicInteger seq = new AtomicInteger(0);
        ProducerAppendInfo firstAppend = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        this.appendData$1(16L, 20L, firstAppend, producerEpoch, seq);
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), 16L), (TxnMetadata)firstAppend.startedTransactions().get(0));
        this.stateManager().update(firstAppend);
        this.stateManager().onHighWatermarkUpdated(21L);
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(16L)), (Object)this.stateManager().firstUnstableOffset());
        ProducerAppendInfo secondAppend = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        Option firstCompletedTxn = this.appendEndTxn$1(ControlRecordType.COMMIT, 21L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertEquals((Object)new Some((Object)new CompletedTxn(this.producerId(), 16L, 21L, false)), (Object)firstCompletedTxn);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.COMMIT, 22L, secondAppend, coordinatorEpoch, producerEpoch));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 23L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(24L, 27L, secondAppend, producerEpoch, seq);
        Option secondCompletedTxn = this.appendEndTxn$1(ControlRecordType.ABORT, 28L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertTrue((boolean)secondCompletedTxn.isDefined());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 29L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(30L, 31L, secondAppend, producerEpoch, seq);
        int size = secondAppend.startedTransactions().size();
        Assertions.assertEquals((int)2, (int)size);
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), new LogOffsetMetadata(24L)), (TxnMetadata)secondAppend.startedTransactions().get(0));
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), new LogOffsetMetadata(30L)), (TxnMetadata)secondAppend.startedTransactions().get(size - 1));
        this.stateManager().update(secondAppend);
        this.stateManager().completeTxn((CompletedTxn)firstCompletedTxn.get());
        this.stateManager().completeTxn((CompletedTxn)secondCompletedTxn.get());
        this.stateManager().onHighWatermarkUpdated(32L);
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(30L)), (Object)this.stateManager().firstUnstableOffset());
    }

    public void assertTxnMetadataEquals(List<TxnMetadata> expected, List<TxnMetadata> actual) {
        Iterator<TxnMetadata> expectedIter = expected.iterator();
        Iterator<TxnMetadata> actualIter = actual.iterator();
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        while (expectedIter.hasNext() && actualIter.hasNext()) {
            this.assertTxnMetadataEquals(expectedIter.next(), actualIter.next());
        }
    }

    public void assertTxnMetadataEquals(TxnMetadata expected, TxnMetadata actual) {
        Assertions.assertEquals((long)expected.producerId, (long)actual.producerId);
        Assertions.assertEquals((Object)expected.firstOffset, (Object)actual.firstOffset);
        Assertions.assertEquals((Object)expected.lastOffset, (Object)actual.lastOffset);
    }

    @Test
    public void testHasLateTransaction() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId1, epoch1, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, producerId2, epoch2, 0, 150L, x$15, true, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() - 500L + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId1, epoch1, ControlRecordType.COMMIT, 200L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId2, epoch2, ControlRecordType.COMMIT, 250L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionInitializedAfterReload() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId1, epoch1, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, producerId2, epoch2, 0, 150L, x$15, true, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().takeSnapshot();
        this.time().sleep(this.lateTransactionTimeoutMs() - 500L + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        reloadedStateManager.truncateAndReload(0L, this.stateManager().mapEndOffset(), this.time().milliseconds());
        Assertions.assertTrue((boolean)reloadedStateManager.hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterPartialTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId, epoch, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateAndReload(0L, 80L, this.time().milliseconds());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterFullTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId, epoch, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateFullyAndStartAt(150L);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)startOffset2)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)startOffset2)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assertions.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        appendInfo.appendDataBatch(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L), 20L, false);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        nextAppendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L), 30L, false);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), false, AppendOrigin.CLIENT);
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        appendInfo.appendDataBatch(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)OptionalLong.of(16L), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L)), appendInfo.startedTransactions());
        appendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)OptionalLong.of(16L), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L)), appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        Optional completedTxnOpt = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assertions.assertTrue((boolean)completedTxnOpt.isPresent());
        CompletedTxn completedTxn = (CompletedTxn)completedTxnOpt.get();
        Assertions.assertEquals((long)this.producerId(), (long)completedTxn.producerId);
        Assertions.assertEquals((long)16L, (long)completedTxn.firstOffset);
        Assertions.assertEquals((long)40L, (long)completedTxn.lastOffset);
        Assertions.assertFalse((boolean)completedTxn.isAborted);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((int)coordinatorEpoch, (int)lastEntry.coordinatorEpoch());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L)), appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            long x$23 = this.append$default$6();
            AppendOrigin x$24 = AppendOrigin.CLIENT;
            this.append(x$17, x$18, bumpedEpoch, 2, 2L, x$23, true, x$24);
        });
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            long x$31 = this.append$default$6();
            AppendOrigin x$32 = AppendOrigin.CLIENT;
            this.append(x$25, x$26, x$27, 2, 2L, x$31, true, x$32);
        });
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        long x$39 = this.append$default$6();
        AppendOrigin x$40 = AppendOrigin.CLIENT;
        this.append(x$33, x$34, bumpedEpoch, 0, 0L, x$39, true, x$40);
        Assertions.assertEquals((short)bumpedEpoch, (short)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        Assertions.assertThrows(InvalidTxnStateException.class, () -> {
            ProducerStateManager x$9 = this.stateManager();
            long x$10 = this.producerId();
            long x$15 = this.append$default$6();
            AppendOrigin x$16 = AppendOrigin.CLIENT;
            this.append(x$9, x$10, epoch, 1, 1L, x$15, false, x$16);
        });
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)OptionalLong.of(3L), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().list().length, (String)"Directory doesn't contain a single file as expected");
        Assertions.assertTrue((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())))), (String)"Snapshot file is empty");
    }

    @Test
    public void testRecoverFromSnapshotUnfinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Optional loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)OptionalLong.of(0L), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
        long x$18 = this.producerId();
        long x$23 = this.append$default$6();
        AppendOrigin x$24 = AppendOrigin.CLIENT;
        this.append(recoveredMapping, x$18, epoch, 2, 2L, x$23, true, x$24);
    }

    @Test
    public void testRecoverFromSnapshotFinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.ABORT, 2L, 0, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Optional loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testRecoverFromSnapshotEmptyTransaction() {
        short epoch = (short)0;
        long appendTimestamp = this.time().milliseconds();
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$7 = 0;
        this.appendEndTxnMarker(x$1, x$2, epoch, ControlRecordType.ABORT, 0L, x$7, appendTimestamp);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
        Optional lastEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertTrue((boolean)lastEntry.isPresent());
        Assertions.assertEquals((long)appendTimestamp, (long)((ProducerStateEntry)lastEntry.get()).lastTimestamp());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)lastEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testProducerStateAfterFencingAbortMarker() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)(epoch + 1), ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.firstDataOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
    }

    @Test
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, false, AppendOrigin.CLIENT);
        Assertions.assertEquals((int)1, (int)recoveredMapping.activeProducers().size());
        Assertions.assertEquals((int)2, (int)((ProducerStateEntry)recoveredMapping.activeProducers().values().iterator().next()).lastSeq());
        Assertions.assertEquals((long)3L, (long)recoveredMapping.mapEndOffset());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assertions.assertFalse((boolean)recoveredMapping.activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        long x$2 = this.producerId();
        boolean x$8 = false;
        this.append(recoveredMapping, x$2, epoch, sequence, 2L, 70001L, x$8, AppendOrigin.REPLICATION);
        Assertions.assertTrue((boolean)recoveredMapping.activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)recoveredMapping.activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertEquals((short)epoch, (short)producerStateEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        int outOfOrderSequence = 3;
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            boolean x$8 = false;
            this.append(x$1, x$2, epoch, outOfOrderSequence, 1L, 1L, x$8, AppendOrigin.CLIENT);
        });
        Assertions.assertTrue((boolean)this.stateManager().activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)this.stateManager().activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertNotNull((Object)producerStateEntry);
        Assertions.assertEquals((long)0L, (long)producerStateEntry.lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        boolean x$16 = false;
        this.append(x$9, x$10, epoch, outOfOrderSequence, 1L, 1L, x$16, AppendOrigin.REPLICATION);
        ProducerStateEntry producerStateEntryForReplication = (ProducerStateEntry)this.stateManager().activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertNotNull((Object)producerStateEntryForReplication);
        Assertions.assertEquals((int)outOfOrderSequence, (int)producerStateEntryForReplication.lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncateFullyAndStartAt(0L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testReloadSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Object[] pathAndDataList = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> new Tuple2((Object)file.toPath(), (Object)Files.readAllBytes(file.toPath())), ClassTag$.MODULE$.apply(Tuple2.class));
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 5})), this.currentSnapshotOffsets());
        this.stateManager().truncateAndReload(3L, 5L, this.time().milliseconds());
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5})), this.currentSnapshotOffsets());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(pathAndDataList), (Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Path path = (Path)x0$1._1();
                byte[] data = (byte[])x0$1._2();
                return Files.write(path, data, new OpenOption[0]);
            }
            throw new MatchError(null);
        });
        this.stateManager().truncateFullyAndReloadSnapshots();
        Assertions.assertEquals((Object)OptionalLong.of(3L), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, 0, this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        Optional entry1 = this.stateManager().lastEntry(pid1);
        Assertions.assertTrue((boolean)entry1.isPresent());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry1.get()).lastSeq());
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Optional entry2 = this.stateManager().lastEntry(pid2);
        Assertions.assertTrue((boolean)entry2.isPresent());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry2.get()).lastSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Assertions.assertEquals((int)1, (int)this.stateManager().activeProducers().size());
        Assertions.assertEquals((int)(sequence + 1), (int)((ProducerStateEntry)this.stateManager().activeProducers().values().iterator().next()).lastSeq());
        Assertions.assertEquals((long)3L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long anotherPid = 2L;
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, anotherPid, epoch, sequence, 105L, x$15, true, x$16);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)OptionalLong.of(105L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)105L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)105L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        short epoch = (short)0;
        long x$2 = this.producerId();
        long x$8 = this.append$default$6();
        this.append(stateManager, x$2, epoch, -1, 99L, x$8, true, AppendOrigin.COORDINATOR);
        long x$10 = this.producerId();
        long x$16 = this.append$default$6();
        this.append(stateManager, x$10, epoch, -1, 100L, x$16, true, AppendOrigin.COORDINATOR);
    }

    @Test
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Optional lastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), lastEntry.map(x -> BoxesRunTime.boxToInteger((int)x.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, producerEpoch, 0, 99L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time()).truncateAndReload(0L, 2L, 70000L);
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            testLoadFromCorruptSnapshot_channel.truncate(0L);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)Mockito.mock(RecordBatch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)batch.iterator()).thenReturn(Collections.emptyIterator());
        this.append(this.stateManager(), producerId, baseOffset, batch, AppendOrigin.CLIENT);
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    @Test
    public void testRemoveStraySnapshotsKeepCleanShutdownSnapshot() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)2L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)42L).toPath(), new FileAttribute[0]);
        this.stateManager().removeStraySnapshots(Collections.singletonList(Predef$.MODULE$.long2Long(5L)));
        Assertions.assertEquals((Object)OptionalLong.of(42L), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)OptionalLong.of(5L), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{5L, 42L})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(ProducerStateManager.listSnapshotFiles((File)this.logDir())).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.offset))).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAllStraySnapshots() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)2L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)42L).toPath(), new FileAttribute[0]);
        this.stateManager().removeStraySnapshots(Collections.singletonList(Predef$.MODULE$.long2Long(42L)));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{42L})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(ProducerStateManager.listSnapshotFiles((File)this.logDir())).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.offset))).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletion() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isPresent());
        Assertions.assertTrue((boolean)((Object)((SnapshotFile)manager.removeAndMarkSnapshotForDeletion(5L).get()).file().toPath()).toString().endsWith(".deleted"));
        Assertions.assertTrue((!manager.latestSnapshotOffset().isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletionAlreadyDeleted() {
        File file = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L);
        Files.createFile(file.toPath(), new FileAttribute[0]);
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isPresent());
        Files.delete(file.toPath());
        Assertions.assertTrue((!manager.removeAndMarkSnapshotForDeletion(5L).isPresent() ? 1 : 0) != 0);
        Assertions.assertTrue((!manager.latestSnapshotOffset().isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testEntryForVerification() {
        VerificationGuard originalEntryVerificationGuard = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0).verificationGuard();
        VerificationStateEntry updatedEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        this.verifyEntry$1(this.producerId(), updatedEntry, originalEntryVerificationGuard);
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, (short)0, 0, 0L, x$7, true, x$8);
        this.stateManager().clearVerificationStateEntry(this.producerId());
        Assertions.assertNull((Object)this.stateManager().verificationStateEntry(this.producerId()));
    }

    @Test
    public void testSequenceAndEpochInVerificationEntry() {
        VerificationStateEntry originalEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 1, (short)0);
        VerificationGuard originalEntryVerificationGuard = originalEntry.verificationGuard();
        this.verifyEntry$2(this.producerId(), originalEntry, 1, (short)0, originalEntryVerificationGuard);
        VerificationStateEntry updatedEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        this.verifyEntry$2(this.producerId(), updatedEntry, 0, (short)0, originalEntryVerificationGuard);
        VerificationStateEntry updatedEntryNewEpoch = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 2, (short)1);
        this.verifyEntry$2(this.producerId(), updatedEntryNewEpoch, 2, (short)1, originalEntryVerificationGuard);
        VerificationStateEntry updatedEntryOldEpoch = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        this.verifyEntry$2(this.producerId(), updatedEntryOldEpoch, 2, (short)1, originalEntryVerificationGuard);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testThrowOutOfOrderSequenceWithVerificationSequenceCheck(boolean dynamicallyDisable) {
        VerificationStateEntry originalEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        if (dynamicallyDisable) {
            this.producerStateManagerConfig().setTransactionVerificationEnabled(false);
        }
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            long x$7 = this.append$default$6();
            AppendOrigin x$8 = AppendOrigin.CLIENT;
            this.append(x$1, x$2, (short)0, 4, 0L, x$7, true, x$8);
        });
        Assertions.assertEquals((Object)originalEntry, (Object)this.stateManager().verificationStateEntry(this.producerId()));
    }

    @Test
    public void testVerificationStateEntryExpiration() {
        VerificationStateEntry originalEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() / 2));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertEquals((Object)originalEntry, (Object)this.stateManager().verificationStateEntry(this.producerId()));
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() / 2 + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertNull((Object)this.stateManager().verificationStateEntry(this.producerId()));
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)latestSnapshotOffset);
        File snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)latestSnapshotOffset.getAsLong());
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertNotNull((Object)loadedProducerState);
        Assertions.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Option<CompletedTxn> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, AppendOrigin.COORDINATOR);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        Option completedTxnOpt = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp)));
        mapping.update(producerAppendInfo);
        completedTxnOpt.foreach((Function1 & Serializable)x$1 -> {
            mapping.completeTxn(x$1);
            return BoxedUnit.UNIT;
        });
        mapping.updateMapEndOffset(offset + 1L);
        return completedTxnOpt;
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, long offset, RecordBatch batch, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.append(batch, Optional.empty());
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private AppendOrigin append$default$8() {
        return AppendOrigin.CLIENT;
    }

    private Set<Object> currentSnapshotOffsets() {
        return Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToLong((long)UnifiedLog$.MODULE$.offsetFromFile(file)), (ClassTag)ClassTag$.MODULE$.Long())).toSet();
    }

    private final Option appendEndTxn$1(ControlRecordType recordType, long offset, ProducerAppendInfo appendInfo, int coordinatorEpoch$1, short producerEpoch$2) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(appendInfo.appendEndTxnMarker(new EndTransactionMarker(recordType, coordinatorEpoch$1), producerEpoch$2, offset, this.time().milliseconds())));
    }

    private final void appendData$1(long startOffset, long endOffset, ProducerAppendInfo appendInfo, short producerEpoch$2, AtomicInteger seq$1) {
        int count = (int)(endOffset - startOffset);
        appendInfo.appendDataBatch(producerEpoch$2, seq$1.get(), seq$1.addAndGet(count), this.time().milliseconds(), new LogOffsetMetadata(startOffset), endOffset, true);
        seq$1.incrementAndGet();
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$3) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry.empty((long)producerId), AppendOrigin.CLIENT, this.stateManager().maybeCreateVerificationStateEntry(producerId, 0, producerEpoch$3));
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.appendDataBatch(producerEpoch$3, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap(new byte[]{37}), file.size() / 2L);
    }

    private final void verifyEntry$1(long producerId, VerificationStateEntry newEntry, VerificationGuard originalEntryVerificationGuard$1) {
        VerificationStateEntry entry = this.stateManager().verificationStateEntry(producerId);
        Assertions.assertEquals((Object)originalEntryVerificationGuard$1, (Object)entry.verificationGuard());
        Assertions.assertEquals((Object)entry.verificationGuard(), (Object)newEntry.verificationGuard());
    }

    private final void verifyEntry$2(long producerId, VerificationStateEntry newEntry, int expectedSequence, short expectedEpoch, VerificationGuard originalEntryVerificationGuard$2) {
        VerificationStateEntry entry = this.stateManager().verificationStateEntry(producerId);
        Assertions.assertEquals((Object)originalEntryVerificationGuard$2, (Object)entry.verificationGuard());
        Assertions.assertEquals((Object)entry.verificationGuard(), (Object)newEntry.verificationGuard());
        Assertions.assertEquals((int)expectedSequence, (int)entry.lowestSequence());
        Assertions.assertEquals((short)expectedEpoch, (short)entry.epoch());
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxTransactionTimeoutMs = 300000;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromEmptySnapshotFile$1$adapted(FileChannel file) {
        file.truncate(0L);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromTruncatedSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromCorruptSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }
}

