/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kafka.server.BaseRequestTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafka.clients.admin.RenewDelegationTokenResult;
import org.apache.kafka.common.errors.UnsupportedByAuthenticationException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001\u0002\u0006\f\u0001AAQ!\u0006\u0001\u0005\u0002YA\u0011\u0002\u0007\u0001A\u0002\u0003\u0007I\u0011A\r\t\u0013\u001d\u0002\u0001\u0019!a\u0001\n\u0003A\u0003\"C\u0019\u0001\u0001\u0004\u0005\t\u0015)\u0003\u001b\u0011\u0015\u0011\u0004\u0001\"\u00114\u0011\u00159\u0004\u0001\"\u00119\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0019y\b\u0001\"\u0011\u0002\u0002\t1C)\u001a7fO\u0006$\u0018n\u001c8U_.,gNU3rk\u0016\u001cHo](o!2\f\u0017N\u001c+fqR$Vm\u001d;\u000b\u00051i\u0011AB:feZ,'OC\u0001\u000f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I\u0019R\"A\u0006\n\u0005QY!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\n\u0001\u0003-\tG-\\5o\u00072LWM\u001c;\u0016\u0003i\u0001\"aG\u0013\u000e\u0003qQ!!\b\u0010\u0002\u000b\u0005$W.\u001b8\u000b\u0005}\u0001\u0013aB2mS\u0016tGo\u001d\u0006\u0003\u001d\u0005R!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO&\u0011a\u0005\b\u0002\u0006\u0003\u0012l\u0017N\\\u0001\u0010C\u0012l\u0017N\\\"mS\u0016tGo\u0018\u0013fcR\u0011\u0011f\f\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0005+:LG\u000fC\u00041\u0007\u0005\u0005\t\u0019\u0001\u000e\u0002\u0007a$\u0013'\u0001\u0007bI6Lgn\u00117jK:$\b%A\u0006ce>\\WM]\"pk:$X#\u0001\u001b\u0011\u0005)*\u0014B\u0001\u001c,\u0005\rIe\u000e^\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003SeBQA\u000f\u0004A\u0002m\n\u0001\u0002^3ti&sgm\u001c\t\u0003y\rk\u0011!\u0010\u0006\u0003}}\n1!\u00199j\u0015\t\u0001\u0015)A\u0004kkBLG/\u001a:\u000b\u0005\t\u001b\u0013!\u00026v]&$\u0018B\u0001#>\u0005!!Vm\u001d;J]\u001a|\u0007F\u0001\u0004G!\tat)\u0003\u0002I{\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002#\r\u0014X-\u0019;f\u0003\u0012l\u0017N\\\"p]\u001aLw-F\u0001L!\u0011a\u0015k\u00150\u000e\u00035S!AT(\u0002\tU$\u0018\u000e\u001c\u0006\u0002!\u0006!!.\u0019<b\u0013\t\u0011VJA\u0002NCB\u0004\"\u0001V.\u000f\u0005UK\u0006C\u0001,,\u001b\u00059&B\u0001-\u0010\u0003\u0019a$o\\8u}%\u0011!lK\u0001\u0007!J,G-\u001a4\n\u0005qk&AB*ue&twM\u0003\u0002[WA\u0011qLY\u0007\u0002A*\u0011\u0011mT\u0001\u0005Y\u0006tw-\u0003\u0002dA\n1qJ\u00196fGR\f1\u0004^3ti\u0012+G.Z4bi&|g\u000eV8lK:\u0014V-];fgR\u001cHCA\u0015g\u0011\u00159\u0007\u00021\u0001T\u0003\u0019\tXo\u001c:v[\"\"\u0001\"[8q!\tQW.D\u0001l\u0015\taw(\u0001\u0004qCJ\fWn]\u0005\u0003].\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003E\f!e\u001f3jgBd\u0017-\u001f(b[\u0016lhf_1sOVlWM\u001c;t/&$\bNT1nKNl\b\u0006\u0002\u0005tsj\u0004\"\u0001^<\u000e\u0003UT!A^6\u0002\u0011A\u0014xN^5eKJL!\u0001_;\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\tYX0I\u0001}\u0003\u0015Y'/\u00194uC\u0005q\u0018A\u0001>l\u0003!!X-\u0019:E_^tG#A\u0015)\u0007%\t)\u0001E\u0002=\u0003\u000fI1!!\u0003>\u0005%\te\r^3s\u000b\u0006\u001c\u0007\u000e")
public class DelegationTokenRequestsOnPlainTextTest
extends BaseRequestTest {
    private Admin adminClient;

    public Admin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
    }

    public Map<String, Object> createAdminConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties()).forEach((key, value) -> config.put((String)key, value));
        return config;
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testDelegationTokenRequests(String quorum) {
        this.adminClient_$eq(Admin.create(this.createAdminConfig()));
        CreateDelegationTokenResult createResult = this.adminClient().createDelegationToken();
        boolean cfr_ignored_0 = Assertions.assertThrows(ExecutionException.class, () -> createResult.delegationToken().get()).getCause() instanceof UnsupportedByAuthenticationException;
        DescribeDelegationTokenResult describeResult = this.adminClient().describeDelegationToken();
        boolean cfr_ignored_1 = Assertions.assertThrows(ExecutionException.class, () -> describeResult.delegationTokens().get()).getCause() instanceof UnsupportedByAuthenticationException;
        RenewDelegationTokenResult renewResult = this.adminClient().renewDelegationToken("".getBytes());
        boolean cfr_ignored_2 = Assertions.assertThrows(ExecutionException.class, () -> renewResult.expiryTimestamp().get()).getCause() instanceof UnsupportedByAuthenticationException;
        ExpireDelegationTokenResult expireResult = this.adminClient().expireDelegationToken("".getBytes());
        boolean cfr_ignored_3 = Assertions.assertThrows(ExecutionException.class, () -> expireResult.expiryTimestamp().get()).getCause() instanceof UnsupportedByAuthenticationException;
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.adminClient() != null) {
            this.adminClient().close();
        }
        super.tearDown();
    }
}

