/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.ControllerServer;
import kafka.server.KafkaConfig$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Timeout(value=120L)
@Tag(value="integration")
@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001B\u0003\u0007\u0001-AQA\u0005\u0001\u0005\u0002MAQA\u0006\u0001\u0005\u0002]AQ!\u0017\u0001\u0005\u0002iCQ\u0001\u0019\u0001\u0005\u0002\u0005\u0014\u0001eS1gW\u0006\u001cVM\u001d<fe.\u0013\u0016M\u001a;SK\u001eL7\u000f\u001e:bi&|g\u000eV3ti*\u0011q\u0001C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003%\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u000b\u0011\u0005U\u0001Q\"\u0001\u0004\u00027Q,7\u000f\u001e*fO&\u001cH/\u001a:[W\n\u0013xn[3s\u0013:\\%/\u00194u)\tA2\u0004\u0005\u0002\u000e3%\u0011!D\u0004\u0002\u0005+:LG\u000fC\u0003\u001d\u0005\u0001\u0007Q$A\u0005{W\u000ecWo\u001d;feB\u0011a$I\u0007\u0002?)\u0011\u0001\u0005C\u0001\u0005i\u0016\u001cH/\u0003\u0002#?\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW\r\u000b\u0006\u0003I)Z\u0003'\r\u001a4\u0001\u0006\u0003\"!\n\u0015\u000e\u0003\u0019R!aJ\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002*M\tY1\t\\;ti\u0016\u0014H+Z:u\u0003-\u0019G.^:uKJ$\u0016\u0010]3%\u00031J!!\f\u0018\u0002\u0005i[%BA\u0018'\u0003\u0011!\u0016\u0010]3\u0002\u000f\t\u0014xn[3sgv\t1!A\bnKR\fG-\u0019;b-\u0016\u00148/[8oI\u0005!\u0014BA\u001b7\u0003-I%\tU04?Rz\u0016J\u0016\u0019\u000b\u0005]B\u0014aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u000b\u0005eR\u0014AB2p[6|gN\u0003\u0002\bw)\u0011\u0011\u0002\u0010\u0006\u0003{y\na!\u00199bG\",'\"A \u0002\u0007=\u0014x-\u0001\ttKJ4XM\u001d)s_B,'\u000f^5fg2\"!\tT)UW\u0015\u0019eiR%K!\t)C)\u0003\u0002FM\t)2\t\\;ti\u0016\u00148i\u001c8gS\u001e\u0004&o\u001c9feRL\u0018aA6fs\u0006\n\u0001*\u0001\u000ej]R,'O\f2s_.,'O\f7jgR,g.\u001a:/]\u0006lW-A\u0003wC2,X-I\u0001L\u0003!)\u0005\fV#S\u001d\u0006c5&B\"G\u001b&{\u0015%\u0001(\u0002\u00131L7\u000f^3oKJ\u001c\u0018%\u0001)\u0002]Ac\u0015)\u0013(U\u000bb#&hL\u0018m_\u000e\fG\u000e[8tij\u0002D&\u0012-U\u000bJs\u0015\t\u0014\u001e0_1|7-\u00197i_N$(\bM\u0016\u0006\u0007\u001a\u0013\u0016jT\u0011\u0002'\u0006!\u0012\r\u001a<feRL7/\u001a3/Y&\u001cH/\u001a8feN\\Sa\u0011$V\u0013^\u000b\u0013AV\u0001\u001fY&\u001cH/\u001a8fe:\u001aXmY;sSRLh\u0006\u001d:pi>\u001cw\u000e\u001c\u0018nCB\f\u0013\u0001W\u0001'\u000bb#VI\u0015(B\u0019j\u0002F*Q%O)\u0016CF\u000b\f)M\u0003&sE+\u0012-UuAc\u0015)\u0013(U\u000bb#\u0016\u0001\u000b;fgR\u0014Vm\u001d;beR|E\u000eZ%caj['I]8lKJLe.T5he\u0006$\u0018n\u001c8N_\u0012,GC\u0001\r\\\u0011\u0015a2\u00011\u0001\u001eQ!\u0019AEK\u00161cIjF%\u00010\n\u0005}3\u0014aC%C!~\u001btlM0J-B\n!c\u001d5vi\u0012|wO\\%o'\u0016\fX/\u001a8dKR\u0019\u0001DY2\t\u000bq!\u0001\u0019A\u000f\t\u000b\u0011$\u0001\u0019A3\u0002\u0019-\u0014\u0018M\u001a;DYV\u001cH/\u001a:\u0011\u0005\u0019LW\"A4\u000b\u0005!D\u0011a\u0002;fgR\\\u0017\u000e^\u0005\u0003U\u001e\u00141cS1gW\u0006\u001cE.^:uKJ$Vm\u001d;LSRDC\u0001\u00017JmB\u0011Q\u000e^\u0007\u0002]*\u0011q\u000e]\u0001\u0004CBL'BA9s\u0003\u001dQW\u000f]5uKJT!a\u001d \u0002\u000b),h.\u001b;\n\u0005Ut'a\u0002+j[\u0016|W\u000f\u001e\u0010\u0002q\"\"\u0001\u0001_%|!\ti\u00170\u0003\u0002{]\n\u0019A+Y4\"\u0003q\f1\"\u001b8uK\u001e\u0014\u0018\r^5p]\"*\u0001A`%\u0002\nA\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002]\u0006IQ\r\u001f;f]NLwN\\\u0005\u0005\u0003\u000f\t\tA\u0001\u0006FqR,g\u000eZ,ji\"d#!a\u0003$\u0005\u00055\u0001\u0003BA\b\u0003'i!!!\u0005\u000b\u0005M|\u0012\u0002BA\u000b\u0003#\u0011Qc\u00117vgR,'\u000fV3ti\u0016CH/\u001a8tS>t7\u000f")
public class KafkaServerKRaftRegistrationTest {
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testRegisterZkBrokerInKraft(ClusterInstance zkCluster) {
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            try {
                readyFuture.get(30L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                Assertions.fail((String)"Did not see 3 brokers within 30 seconds");
            }
            catch (Throwable t) {
                Assertions.fail((String)"Had some other error waiting for brokers", (Throwable)t);
            }
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_3_IV0)
    public void testRestartOldIbpZkBrokerInMigrationMode(ClusterInstance zkCluster) {
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            Assertions.assertThrows(IllegalArgumentException.class, () -> zkCluster.rollingBrokerRestart());
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    public void shutdownInSequence(ClusterInstance zkCluster, KafkaClusterTestKit kraftCluster) {
        zkCluster.brokerIds().forEach(x$1 -> zkCluster.shutdownBroker(Predef$.MODULE$.Integer2int(x$1)));
        kraftCluster.close();
        zkCluster.stop();
    }
}

