/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.log.LogTestUtils$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.log.remote.RemoteLogManager;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.KafkaRaftServer$;
import kafka.server.RequestLocal;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\u0015+\u0001=BQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001C\u0002\u0013\u00051\b\u0003\u0004E\u0001\u0001\u0006I\u0001\u0010\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001<\u0011\u00191\u0005\u0001)A\u0005y!9q\t\u0001b\u0001\n\u0003A\u0005BB(\u0001A\u0003%\u0011\nC\u0004Q\u0001\t\u0007I\u0011\u0001%\t\rE\u0003\u0001\u0015!\u0003J\u0011\u001d\u0011\u0006A1A\u0005\u0002!Caa\u0015\u0001!\u0002\u0013I\u0005b\u0002+\u0001\u0005\u0004%\t\u0001\u0013\u0005\u0007+\u0002\u0001\u000b\u0011B%\t\u000fY\u0003!\u0019!C\u0001\u0011\"1q\u000b\u0001Q\u0001\n%Cq\u0001\u0017\u0001C\u0002\u0013\u0005\u0011\f\u0003\u0004h\u0001\u0001\u0006IA\u0017\u0005\bQ\u0002\u0011\r\u0011\"\u0001j\u0011\u0019)\b\u0001)A\u0005U\"Ia\u000f\u0001a\u0001\u0002\u0004%\ta\u001e\u0005\n{\u0002\u0001\r\u00111A\u0005\u0002yD!\"!\u0003\u0001\u0001\u0004\u0005\t\u0015)\u0003y\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bAq!!\n\u0001\t\u0003\ti\u0001C\u0004\u0002(\u0001!\t!!\u0004\t\u000f\u0005E\u0002\u0001\"\u0001\u0002\u000e!9\u00111\b\u0001\u0005\u0002\u00055\u0001bBA \u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003\u0007\u0002A\u0011AA\u0007\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u001bAq!a\u0013\u0001\t\u0003\ti\u0001C\u0004\u0002P\u0001!\t!!\u0004\t\u000f\u0005M\u0003\u0001\"\u0003\u0002V!9\u0011Q\u000f\u0001\u0005\u0002\u00055\u0001bBA=\u0001\u0011%\u00111\u0010\u0005\b\u0003#\u0003A\u0011BAJ\u0011\u001d\t\t\u000b\u0001C\u0005\u0003GCq!a*\u0001\t\u0013\tI\u000bC\u0004\u0002@\u0002!I!!1\t\u000f\u00055\u0007\u0001\"\u0003\u0002\u000e\t\u0019B)^7q\u0019><7+Z4nK:$8\u000fV3ti*\u00111\u0006L\u0001\u0006i>|Gn\u001d\u0006\u0002[\u0005)1.\u00194lC\u000e\u00011C\u0001\u00011!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u000f\t\u0003s\u0001i\u0011AK\u0001\u0007i6\u0004H)\u001b:\u0016\u0003q\u0002\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\u0005%|'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u0012AAR5mK\u00069A/\u001c9ESJ\u0004\u0013A\u00027pO\u0012K'/A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u0017M,w-\\3oi:\u000bW.Z\u000b\u0002\u0013B\u0011!*T\u0007\u0002\u0017*\u0011A\nQ\u0001\u0005Y\u0006tw-\u0003\u0002O\u0017\n11\u000b\u001e:j]\u001e\fAb]3h[\u0016tGOT1nK\u0002\n1\u0002\\8h\r&dW\rU1uQ\u0006aAn\\4GS2,\u0007+\u0019;iA\u0005a1O\\1qg\"|G\u000fU1uQ\u0006i1O\\1qg\"|G\u000fU1uQ\u0002\nQ\"\u001b8eKb4\u0015\u000e\\3QCRD\u0017AD5oI\u0016Dh)\u001b7f!\u0006$\b\u000eI\u0001\u0012i&lW-\u00138eKb4\u0015\u000e\\3QCRD\u0017A\u0005;j[\u0016Le\u000eZ3y\r&dW\rU1uQ\u0002\nA\u0001^5nKV\t!\f\u0005\u0002\\K6\tAL\u0003\u0002^=\u0006!Q\u000f^5m\u0015\ty\u0006-\u0001\u0004tKJ4XM\u001d\u0006\u0003[\u0005T!AY2\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0017aA8sO&\u0011a\r\u0018\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059!-\u0019;dQ\u0016\u001cX#\u00016\u0011\u0007-\u0004(/D\u0001m\u0015\tig.A\u0004nkR\f'\r\\3\u000b\u0005=\u0014\u0014AC2pY2,7\r^5p]&\u0011\u0011\u000f\u001c\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0002:g&\u0011AO\u000b\u0002\n\u0005\u0006$8\r[%oM>\f\u0001BY1uG\",7\u000fI\u0001\u0004Y><W#\u0001=\u0011\u0005e\\X\"\u0001>\u000b\u0005Yd\u0013B\u0001?{\u0005))f.\u001b4jK\u0012dunZ\u0001\bY><w\fJ3r)\ry\u0018Q\u0001\t\u0004c\u0005\u0005\u0011bAA\u0002e\t!QK\\5u\u0011!\t9!FA\u0001\u0002\u0004A\u0018a\u0001=%c\u0005!An\\4!\u0003\u0015\u0019X\r^+q)\u0005y\bfA\f\u0002\u0012A!\u00111CA\u0011\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011aA1qS*!\u00111DA\u000f\u0003\u001dQW\u000f]5uKJT1!a\bd\u0003\u0015QWO\\5u\u0013\u0011\t\u0019#!\u0006\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\tbI\u0012\u001c\u0016.\u001c9mKJ+7m\u001c:eg\u0006AA/Z1s\t><h\u000eK\u0002\u001a\u0003W\u0001B!a\u0005\u0002.%!\u0011qFA\u000b\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0011uKN$()\u0019;dQ\u0006sGMU3d_J$W*\u001a;bI\u0006$\u0018mT;uaV$\bf\u0001\u000e\u00026A!\u00111CA\u001c\u0013\u0011\tI$!\u0006\u0003\tQ+7\u000f^\u0001\u0011i\u0016\u001cH\u000f\u0015:j]R$\u0015\r^1M_\u001eD3aGA\u001b\u0003]!Xm\u001d;Ek6\u0004\u0018J\u001c3fq6K7/\\1uG\",7\u000fK\u0002\u001d\u0003k\tq\u0003^3ti\u0012+X\u000e\u001d+j[\u0016Le\u000eZ3y\u000bJ\u0014xN]:)\u0007u\t)$A\fuKN$H)^7q\u001b\u0016$\u0018\rZ1uCJ+7m\u001c:eg\"\u001aa$!\u000e\u00021Q,7\u000f\u001e#v[BlU\r^1eCR\f7K\\1qg\"|G\u000fK\u0002 \u0003k\t!\u0003^3ti\u0012+X\u000e]#naRL\u0018J\u001c3fq\"\u001a\u0001%!\u000e\u0002%I,h\u000eR;na2{wmU3h[\u0016tGo\u001d\u000b\u0005\u0003/\nY\u0007\u0005\u0003\u0002Z\u0005\u001dd\u0002BA.\u0003G\u00022!!\u00183\u001b\t\tyFC\u0002\u0002b9\na\u0001\u0010:p_Rt\u0014bAA3e\u00051\u0001K]3eK\u001aL1ATA5\u0015\r\t)G\r\u0005\b\u0003[\n\u0003\u0019AA8\u0003\u0011\t'oZ:\u0011\u000bE\n\t(a\u0016\n\u0007\u0005M$GA\u0003BeJ\f\u00170\u0001\u0010uKN$\bK]5oi\u0012\u000bG/\u0019'pOB\u000b'\u000f^5bY\n\u000bGo\u00195fg\"\u001a!%!\u000e\u0002#I,\u0017\r\u001a\"bi\u000eDW*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0002~\u0005\r\u0005#B\u0019\u0002\u0000\u0005]\u0013bAAAe\t1q\n\u001d;j_:Dq!!\"$\u0001\u0004\t9)A\u0003mS:,7\u000f\u0005\u0004\u0002\n\u00065\u0015qK\u0007\u0003\u0003\u0017S!!\u0018!\n\t\u0005=\u00151\u0012\u0002\r\u0019&\u001cH/\u0013;fe\u0006$xN]\u0001\u0018e\u0016\fG\rU1si&\fGNQ1uG\",7OQ=uKN$b!!&\u0002\u001c\u0006u\u0005cA\u0019\u0002\u0018&\u0019\u0011\u0011\u0014\u001a\u0003\u0007%sG\u000fC\u0004\u0002\u0006\u0012\u0002\r!a\"\t\u000f\u0005}E\u00051\u0001\u0002\u0016\u0006)A.[7ji\u0006a1m\\;oi\n\u000bGo\u00195fgR!\u0011QSAS\u0011\u001d\t))\na\u0001\u0003\u000f\u000b\u0001C]3bI\n\u000bGo\u00195SK\u000e|'\u000fZ:\u0015\t\u0005-\u0016Q\u0018\t\u0007\u0003[\u000b9,a\u0016\u000f\t\u0005=\u00161\u0017\b\u0005\u0003;\n\t,C\u00014\u0013\r\t)LM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI,a/\u0003\u0007M+\u0017OC\u0002\u00026JBq!!\"'\u0001\u0004\t9)A\nqCJ\u001cX-T3uC\u0012\fG/\u0019$jK2$7\u000f\u0006\u0003\u0002D\u0006%\u0007\u0003CA-\u0003\u000b\f9&a\u0016\n\t\u0005\u001d\u0017\u0011\u000e\u0002\u0004\u001b\u0006\u0004\bbBAfO\u0001\u0007\u0011qK\u0001\u0005Y&tW-A\u000ebgN,'\u000f\u001e#v[Bdun\u001a*fG>\u0014H-T3uC\u0012\fG/\u0019")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String snapshotPath = new StringBuilder(43).append(this.logDir()).append("/00000000000000000000-0000000000.checkpoint").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private final ArrayBuffer<BatchInfo> batches = new ArrayBuffer();
    private UnifiedLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String snapshotPath() {
        return this.snapshotPath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public ArrayBuffer<BatchInfo> batches() {
        return this.batches;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public void log_$eq(UnifiedLog x$1) {
        this.log = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.setProperty("index.interval.bytes", "128");
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props);
        MockScheduler x$5 = this.time().scheduler;
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats(Optional.empty());
        ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false);
        int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$14 = true;
        ConcurrentHashMap x$15 = new ConcurrentHashMap();
        boolean x$16 = false;
        LogOffsetsListener x$17 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        this.log_$eq(UnifiedLog$.MODULE$.apply(x$1, x$2, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, x$9, x$10, x$11, x$14, (Option)x$12, true, x$15, x$16, x$17));
    }

    public void addSimpleRecords() {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)fourthBatchRecords, false, false));
        this.batches().foreach((Function1 & Serializable)batchInfo -> {
            void withRecords_records;
            void withRecords_partitionLeaderEpoch;
            UnifiedLog qual$1 = this.log();
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])batchInfo.records().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            boolean bl = false;
            CompressionType withRecords_compressionType = CompressionType.NONE;
            Object var8_5 = null;
            simpleRecordArray = null;
            MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
            AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
            MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
            RequestLocal x$5 = qual$1.appendAsLeader$default$5();
            VerificationGuard x$6 = qual$1.appendAsLeader$default$6();
            return qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5, x$6);
        });
        this.log().flush(false);
    }

    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.log(), (String)"UnifiedLog");
        Utils.delete((File)this.tmpDir());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBatchAndRecordMetadataOutput() {
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_producerEpoch;
        void withTransactionalRecords_producerId;
        void withIdempotentRecords_records;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        UnifiedLog qual$1 = this.log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl = false;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var36_4 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3);
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$6 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5, x$6);
        UnifiedLog qual$2 = this.log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "c".getBytes(), "1".getBytes()), new SimpleRecord("d".getBytes())};
        boolean bl2 = false;
        CompressionType withRecords_compressionType2 = CompressionType.GZIP;
        Object var39_13 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$7 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2);
        AppendOrigin x$9 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$10 = qual$2.appendAsLeader$default$4();
        RequestLocal x$11 = qual$2.appendAsLeader$default$5();
        VerificationGuard x$12 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$7, 3, x$9, x$10, x$11, x$12);
        UnifiedLog qual$3 = this.log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("e".getBytes(), null), new SimpleRecord(null, "f".getBytes()), new SimpleRecord("g".getBytes())};
        boolean bl3 = false;
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        Object var42_22 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$13 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        AppendOrigin x$15 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$16 = qual$3.appendAsLeader$default$4();
        RequestLocal x$17 = qual$3.appendAsLeader$default$5();
        VerificationGuard x$18 = qual$3.appendAsLeader$default$6();
        qual$3.appendAsLeader(x$13, 3, x$15, x$16, x$17, x$18);
        UnifiedLog qual$4 = this.log();
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord("h".getBytes())};
        int n = 234123;
        short s = (short)15;
        long l = 29342342L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var45_33 = null;
        simpleRecordArray4 = null;
        MemoryRecords x$19 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        AppendOrigin x$21 = qual$4.appendAsLeader$default$3();
        MetadataVersion x$22 = qual$4.appendAsLeader$default$4();
        RequestLocal x$23 = qual$4.appendAsLeader$default$5();
        VerificationGuard x$24 = qual$4.appendAsLeader$default$6();
        qual$4.appendAsLeader(x$19, 3, x$21, x$22, x$23, x$24);
        UnifiedLog qual$5 = this.log();
        SimpleRecord[] simpleRecordArray5 = new SimpleRecord[]{new SimpleRecord("i".getBytes()), new SimpleRecord("j".getBytes())};
        int n2 = 266;
        short s2 = (short)99;
        long l2 = 98323L;
        CompressionType withTransactionalRecords_compressionType = CompressionType.GZIP;
        Object var51_44 = null;
        simpleRecordArray5 = null;
        MemoryRecords x$25 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId, (short)withTransactionalRecords_producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        AppendOrigin x$27 = qual$5.appendAsLeader$default$3();
        MetadataVersion x$28 = qual$5.appendAsLeader$default$4();
        RequestLocal x$29 = qual$5.appendAsLeader$default$5();
        VerificationGuard x$30 = qual$5.appendAsLeader$default$6();
        qual$5.appendAsLeader(x$25, 5, x$27, x$28, x$29, x$30);
        UnifiedLog qual$6 = this.log();
        MemoryRecords x$31 = MemoryRecords.withEndTransactionMarker((long)98323L, (short)((short)99), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100));
        MetadataVersion x$34 = qual$6.appendAsLeader$default$4();
        RequestLocal x$35 = qual$6.appendAsLeader$default$5();
        VerificationGuard x$36 = qual$6.appendAsLeader$default$6();
        qual$6.appendAsLeader(x$31, 7, AppendOrigin.COORDINATOR, x$34, x$35, x$36);
        this.assertDumpLogRecordMetadata();
    }

    @Test
    public void testPrintDataLog() {
        this.addSimpleRecords();
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(false, new String[]{"--deep-iteration", "--files", this.logFilePath()});
        this.verifyNoRecordsInOutput$1(new String[]{"--files", this.logFilePath()});
    }

    @Test
    public void testDumpIndexMismatches() {
        this.addSimpleRecords();
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.addSimpleRecords();
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpMetadataRecords() {
        void withRecords_timestampType;
        void withRecords_records;
        void withRecords_timestampType2;
        void withRecords_timestampType3;
        MockTime mockTime = new MockTime();
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(Optional.empty()), (Scheduler)mockTime.scheduler, (Time)mockTime, 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        SimpleRecord[] records = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0), (List)Nil$.MODULE$)))).map((Function1 & Serializable)message -> {
            MetadataRecordSerde serde = MetadataRecordSerde.INSTANCE;
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        })).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        UnifiedLog qual$1 = this.log();
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var44_17 = null;
        MemoryRecords x$14 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType3, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records);
        AppendOrigin x$16 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$17 = qual$1.appendAsLeader$default$4();
        RequestLocal x$18 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$19 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$14, 1, x$16, x$17, x$18, x$19);
        this.log().flush(false);
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        UnifiedLog qual$2 = this.log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(null, buf.array())};
        CompressionType withRecords_compressionType2 = CompressionType.NONE;
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var45_31 = null;
        simpleRecordArray = null;
        MemoryRecords x$20 = MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType2, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        AppendOrigin x$22 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$23 = qual$2.appendAsLeader$default$4();
        RequestLocal x$24 = qual$2.appendAsLeader$default$5();
        VerificationGuard x$25 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$20, 2, x$22, x$23, x$24, x$25);
        UnifiedLog qual$3 = this.log();
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        byte withRecords_magic3 = 2;
        TimestampType timestampType3 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset3 = 0L;
        timestampType3 = null;
        Object var47_41 = null;
        MemoryRecords x$26 = MemoryRecords.withRecords((byte)withRecords_magic3, (long)withRecords_initialOffset3, (CompressionType)withRecords_compressionType3, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records);
        AppendOrigin x$28 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$29 = qual$3.appendAsLeader$default$4();
        RequestLocal x$30 = qual$3.appendAsLeader$default$5();
        VerificationGuard x$31 = qual$3.appendAsLeader$default$6();
        qual$3.appendAsLeader(x$26, 2, x$28, x$29, x$30, x$31);
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("skipping"));
    }

    @Test
    public void testDumpMetadataSnapshot() {
        .colon.colon metadataRecords = new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0), (List)Nil$.MODULE$))));
        KafkaMetadataLog metadataLog = KafkaMetadataLog$.MODULE$.apply(KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.logDir(), (Time)this.time(), (Scheduler)this.time().scheduler, new MetadataLogConfig(102400, 102400, 10000L, 102400L, 60000L, 0x800000, 0x800000, 60000L, 1));
        int lastContainedLogTimestamp = 10000;
        try (AutoCloseable resource_resource = (AutoCloseable)RecordsSnapshotWriter.createWithHeader(() -> metadataLog.createNewSnapshot(new OffsetAndEpoch(0L, 0)), (int)1024, (MemoryPool)MemoryPool.NONE, (Time)new MockTime(), (long)lastContainedLogTimestamp, (CompressionType)CompressionType.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE).get();){
            SnapshotWriter snapshotWriter = (SnapshotWriter)resource_resource;
            DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2((scala.collection.immutable.Seq)metadataRecords, snapshotWriter);
        }
        Object var5_4 = null;
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.snapshotPath()});
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("SnapshotHeader"));
        Assertions.assertTrue((boolean)output.contains("SnapshotFooter"));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(28).append("\"lastContainedLogTimestamp\":").append(lastContainedLogTimestamp).toString()));
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.snapshotPath()});
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertFalse((boolean)output.contains("SnapshotHeader"));
        Assertions.assertFalse((boolean)output.contains("SnapshotFooter"));
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(29).append("\"lastContainedLogTimestamp\": ").append(lastContainedLogTimestamp).toString()));
    }

    @Test
    public void testDumpEmptyIndex() {
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = new StringBuilder(11).append(indexFile).append(" is empty.\n").toString();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        return outContent.toString();
    }

    @Test
    public void testPrintDataLogPartialBatches() {
        this.addSimpleRecords();
        int partialBatches = this.batches().size() / 2;
        ListIterator<String> lines = Arrays.asList(this.runDumpLogSegments(new String[]{"--files", this.logFilePath()}).split("\n")).listIterator();
        int partialBatchesBytes = this.readPartialBatchesBytes(lines, partialBatches);
        ListIterator<String> partialLines = Arrays.asList(this.runDumpLogSegments(new String[]{"--max-bytes", Integer.toString(partialBatchesBytes), "--files", this.logFilePath()}).split("\n")).listIterator();
        int partialBatchesCount = this.countBatches(partialLines);
        Assertions.assertEquals((int)partialBatches, (int)partialBatchesCount);
    }

    private Option<String> readBatchMetadata(ListIterator<String> lines) {
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                throw new IllegalStateException("Read unexpected record entry");
            }
            if (!line.startsWith("baseOffset")) continue;
            return new Some((Object)line);
        }
        return None$.MODULE$;
    }

    private int readPartialBatchesBytes(ListIterator<String> lines, int limit) {
        Regex sizePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".+?size:\\s(\\d+).+"));
        int batchesBytes = 0;
        int batchesCounter = 0;
        while (lines.hasNext()) {
            if (batchesCounter >= limit) {
                return batchesBytes;
            }
            String line = lines.next();
            if (!line.startsWith("baseOffset")) continue;
            Option option = sizePattern.unapplySeq((CharSequence)line);
            if (!option.isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String size = (String)((LinearSeqOps)option.get()).apply(0);
                batchesBytes += StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(size));
            } else {
                throw new IllegalStateException(new StringBuilder(52).append("Failed to parse and find size value for batch line: ").append(line).toString());
            }
            ++batchesCounter;
        }
        return batchesBytes;
    }

    private int countBatches(ListIterator<String> lines) {
        int countBatches = 0;
        while (lines.hasNext()) {
            if (!lines.next().startsWith("baseOffset")) continue;
            ++countBatches;
        }
        return countBatches;
    }

    private scala.collection.immutable.Seq<String> readBatchRecords(ListIterator<String> lines) {
        ArrayBuffer records = ArrayBuffer$.MODULE$.empty();
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                records.$plus$eq((Object)line.substring(1));
                continue;
            }
            lines.previous();
            return records.toSeq();
        }
        return records.toSeq();
    }

    private scala.collection.immutable.Map<String, String> parseMetadataFields(String line) {
        scala.collection.mutable.Map fields = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Iterator tokens = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+")), (Function1 & Serializable)x$4 -> x$4.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$5))))));
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            if (!token.endsWith(":")) {
                throw new IllegalStateException(new StringBuilder(27).append("Unexpected non-field token ").append(token).toString());
            }
            String field = token.substring(0, token.length() - 1);
            if (!tokens.hasNext()) {
                throw new IllegalStateException(new StringBuilder(26).append("Failed to parse value for ").append(field).toString());
            }
            String value = (String)tokens.next();
            fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)value));
        }
        return fields.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void assertDumpLogRecordMetadata() {
        FetchDataInfo logReadInfo = this.log().read(0L, Integer.MAX_VALUE, FetchIsolation.LOG_END, true);
        ListIterator<String> lines = Arrays.asList(this.runDumpLogSegments(new String[]{"--deep-iteration", "--files", this.logFilePath()}).split("\n")).listIterator();
        CollectionConverters$.MODULE$.IterableHasAsScala(logReadInfo.records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$1(this, lines, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private final boolean isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((IterableOnceOps)this.batches().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)new StringBuilder(19).append("No match for index ").append(index).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$3) {
        return x$3.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)new StringBuilder(18).append("Data not printed: ").append(output).toString());
        int totalRecords = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.batches().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$3)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = this.batches().iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            String line = lines[lines.length - totalRecords - this.batches().size() + index];
            if (this.isBatch$1(index)) {
                Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()), (String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString());
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()), (String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString());
            if (checkKeysAndValues) {
                String suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = new StringBuilder(18).append(suffix).append(" key: message key ").append(offset$1.elem).toString();
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = new StringBuilder(24).append(suffix).append(" payload: message value ").append(offset$1.elem).toString();
                }
                Assertions.assertTrue((boolean)line.endsWith(suffix), (String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString());
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString());
    }

    public static final /* synthetic */ long $anonfun$testDumpMetadataSnapshot$2(scala.collection.immutable.Seq metadataRecords$1, SnapshotWriter snapshotWriter) {
        snapshotWriter.append(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)metadataRecords$1).asJava());
        return snapshotWriter.freeze();
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$11(DumpLogSegmentsTest $this, Iterator parsedRecordIter$1, RecordBatch batch$2, Record record) {
        Assertions.assertTrue((boolean)parsedRecordIter$1.hasNext());
        scala.collection.immutable.Map<String, String> parsedRecord = $this.parseMetadataFields((String)parsedRecordIter$1.next());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.offset())), (Object)parsedRecord.get((Object)"offset").map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$15)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.keySize())), (Object)parsedRecord.get((Object)"keySize").map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$16)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.valueSize())), (Object)parsedRecord.get((Object)"valueSize").map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$17)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.timestamp())), (Object)parsedRecord.get((Object)batch$2.timestampType().name).map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$18)))));
        if (batch$2.magic() >= RecordVersion.V2.value) {
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.sequence())), (Object)parsedRecord.get((Object)"sequence").map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$19)))));
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"lastOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"partitionLeaderEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerId"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseSequence"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isTransactional"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isControl"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"compresscodec"));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$1(DumpLogSegmentsTest $this, ListIterator lines$2, RecordBatch batch) {
        Option<String> parsedBatchOpt = $this.readBatchMetadata(lines$2);
        Assertions.assertTrue((boolean)parsedBatchOpt.isDefined());
        scala.collection.immutable.Map<String, String> parsedBatch = $this.parseMetadataFields((String)parsedBatchOpt.get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())), (Object)parsedBatch.get((Object)"baseOffset").map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$6)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())), (Object)parsedBatch.get((Object)"lastOffset").map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$7)))));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)batch.countOrNull()), (Object)parsedBatch.get((Object)"count").map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$8)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())), (Object)parsedBatch.get((Object)"partitionLeaderEpoch").map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$9)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())), (Object)parsedBatch.get((Object)"isTransactional").map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$10)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())), (Object)parsedBatch.get((Object)"isControl").map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$11)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)parsedBatch.get((Object)"producerId").map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$12)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())), (Object)parsedBatch.get((Object)"producerEpoch").map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$13)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())), (Object)parsedBatch.get((Object)"baseSequence").map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$14)))));
        Assertions.assertEquals((Object)new Some((Object)batch.compressionType().name), (Object)parsedBatch.get((Object)"compresscodec"));
        Iterator parsedRecordIter = $this.readBatchRecords(lines$2).iterator();
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$11($this, parsedRecordIter, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }

    public static final /* synthetic */ Object $anonfun$testDumpMetadataSnapshot$2$adapted(scala.collection.immutable.Seq metadataRecords$1, SnapshotWriter snapshotWriter) {
        return BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2(metadataRecords$1, snapshotWriter));
    }
}

