/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.log.LocalLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.utils.CoreUtils$;
import kafka.utils.FileLock;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileBasedStateStore;
import org.apache.kafka.raft.KafkaNetworkChannel;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.Timer;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rMr!\u0002 @\u0011\u0003!e!\u0002$@\u0011\u00039\u0005\"\u0002(\u0002\t\u0003ye\u0001\u0002)\u0002\u0001EC\u0001\"Z\u0002\u0003\u0002\u0003\u0006IA\u001a\u0005\to\u000e\u0011\t\u0011)A\u0005q\"Q\u0011qA\u0002\u0003\u0002\u0003\u0006I!!\u0003\t\r9\u001bA\u0011AA\u000b\u0011\u001d\tIc\u0001C!\u0003WAq!a\r\u0004\t\u0003\n)\u0004C\u0004\u0002>\r!\t%!\u000e\t\u000f\u0005}\u0012\u0001\"\u0003\u0002B!9\u00111L\u0001\u0005\n\u0005uc!\u0002$@\u0001\u0005%\u0004\"CA=\u001b\t\u0005\t\u0015!\u0003y\u0011)\tY(\u0004B\u0001B\u0003%\u0011Q\u0010\u0005\u000b\u0003\u000fk!\u0011!Q\u0001\n\u0005%\u0005BCAM\u001b\t\u0005\t\u0015!\u0003\u0002\u001c\"Q\u0011QU\u0007\u0003\u0002\u0003\u0006I!a*\t\u0015\u00055VB!A!\u0002\u0013\ty\u000b\u0003\u0006\u0002:6\u0011\t\u0011)A\u0005\u0003wC!\"!2\u000e\u0005\u0003\u0005\u000b\u0011BAd\u0011)\ti-\u0004BC\u0002\u0013\u0005\u0011q\u001a\u0005\u000b\u0005#i!\u0011!Q\u0001\n\u0005E\u0007BCA\u0004\u001b\t\u0005\t\u0015!\u0003\u0002\n!1a*\u0004C\u0001\u0005'A\u0011Ba\u000b\u000e\u0005\u0004%\tA!\f\t\u0011\tmR\u0002)A\u0005\u0005_A\u0011B!\u0010\u000e\u0005\u0004%IAa\u0010\t\u0011\t\u001dS\u0002)A\u0005\u0005\u0003B\u0001b^\u0007C\u0002\u0013%!\u0011\n\u0005\b\u0005\u0017j\u0001\u0015!\u0003y\u0011%\u0011i%\u0004b\u0001\n\u0013\u0011y\u0005\u0003\u0005\u0003X5\u0001\u000b\u0011\u0002B)\u0011%\u0011I&\u0004b\u0001\n\u0013\u0011Y\u0006\u0003\u0005\u0003d5\u0001\u000b\u0011\u0002B/\u0011%\t9'\u0004b\u0001\n\u0013\u0011)\u0007\u0003\u0005\u0003h5\u0001\u000b\u0011BA\"\u0011%\u0011I'\u0004b\u0001\n\u0013\u0011Y\u0007\u0003\u0005\u0003p5\u0001\u000b\u0011\u0002B7\u0011%\u0011\t(\u0004b\u0001\n\u0003\u0012\u0019\b\u0003\u0005\u0003|5\u0001\u000b\u0011\u0002B;\u0011%\u0011i(\u0004b\u0001\n\u0013\u0011y\b\u0003\u0005\u0003\b6\u0001\u000b\u0011\u0002BA\u0011%\u0011I)\u0004b\u0001\n\u0013\u0011Y\t\u0003\u0005\u0003\u001a6\u0001\u000b\u0011\u0002BG\u0011%\u0011Y*\u0004b\u0001\n\u0013\u0011i\n\u0003\u0005\u0003&6\u0001\u000b\u0011\u0002BP\u0011!)WB1A\u0005B\t\u001d\u0006\u0002\u0003BV\u001b\u0001\u0006IA!+\t\u0013\t5VB1A\u0005\n\t=\u0006\u0002\u0003B_\u001b\u0001\u0006IA!-\t\u000f\t}V\u0002\"\u0001\u0002,!9!\u0011Y\u0007\u0005\u0002\u0005-\u0002b\u0002Bb\u001b\u0011\u0005#Q\u0019\u0005\b\u00053lA\u0011\tBn\u0011\u001d\u0019I!\u0004C\u0005\u0007\u0017Aqa!\u0004\u000e\t\u0013\u0019y\u0001C\u0004\u0004\u00125!Iaa\u0005\t\u000f\rUQ\u0002\"\u0003\u0004\u0018!91qD\u0007\u0005\n\r\u0005\u0002bBB\u0015\u001b\u0011\u000531F\u0001\u0011\u0017\u000647.\u0019*bMRl\u0015M\\1hKJT!\u0001Q!\u0002\tI\fg\r\u001e\u0006\u0002\u0005\u0006)1.\u00194lC\u000e\u0001\u0001CA#\u0002\u001b\u0005y$\u0001E&bM.\f'+\u00194u\u001b\u0006t\u0017mZ3s'\t\t\u0001\n\u0005\u0002J\u00196\t!JC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0013ABU1gi&{G\u000b\u001b:fC\u0012\u001c2a\u0001*`!\t\u0019V,D\u0001U\u0015\t)f+\u0001\u0003vi&d'BA,Y\u0003\u0019\u0019XM\u001d<fe*\u0011!)\u0017\u0006\u00035n\u000ba!\u00199bG\",'\"\u0001/\u0002\u0007=\u0014x-\u0003\u0002_)\n\u00112\u000b[;uI><h.\u00192mKRC'/Z1e!\t\u00017-D\u0001b\u0015\t\u0011\u0017)A\u0003vi&d7/\u0003\u0002eC\n9Aj\\4hS:<\u0017AB2mS\u0016tG\u000f\r\u0002h]B\u0019\u0001N\u001b7\u000e\u0003%T!\u0001\u0011-\n\u0005-L'aD&bM.\f'+\u00194u\u00072LWM\u001c;\u0011\u00055tG\u0002\u0001\u0003\n_\u0012\t\t\u0011!A\u0003\u0002A\u00141a\u0018\u00132#\t\tH\u000f\u0005\u0002Je&\u00111O\u0013\u0002\b\u001d>$\b.\u001b8h!\tIU/\u0003\u0002w\u0015\n\u0019\u0011I\\=\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\bcA=\u0002\u00029\u0011!P \t\u0003w*k\u0011\u0001 \u0006\u0003{\u000e\u000ba\u0001\u0010:p_Rt\u0014BA@K\u0003\u0019\u0001&/\u001a3fM&!\u00111AA\u0003\u0005\u0019\u0019FO]5oO*\u0011qPS\u0001\u0012M\u0006$\u0018\r\u001c$bk2$\b*\u00198eY\u0016\u0014\b\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=a+A\u0003gCVdG/\u0003\u0003\u0002\u0014\u00055!\u0001\u0004$bk2$\b*\u00198eY\u0016\u0014H\u0003CA\f\u00037\t)#a\n\u0011\u0007\u0005e1!D\u0001\u0002\u0011\u0019)w\u00011\u0001\u0002\u001eA\"\u0011qDA\u0012!\u0011A'.!\t\u0011\u00075\f\u0019\u0003\u0002\u0006p\u00037\t\t\u0011!A\u0003\u0002ADQa^\u0004A\u0002aDq!a\u0002\b\u0001\u0004\tI!\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003[\u00012!SA\u0018\u0013\r\t\tD\u0013\u0002\u0005+:LG/\u0001\tj]&$\u0018.\u0019;f'\",H\u000fZ8x]R\u0011\u0011q\u0007\t\u0004\u0013\u0006e\u0012bAA\u001e\u0015\n9!i\\8mK\u0006t\u0017!C5t%Vtg.\u001b8h\u0003I\u0019'/Z1uK2{w\rR5sK\u000e$xN]=\u0015\r\u0005\r\u00131KA,!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\n!![8\u000b\u0005\u00055\u0013\u0001\u00026bm\u0006LA!!\u0015\u0002H\t!a)\u001b7f\u0011\u001d\t)f\u0003a\u0001\u0003\u0007\na\u0001\\8h\t&\u0014\bBBA-\u0017\u0001\u0007\u00010\u0001\u0006m_\u001e$\u0015N\u001d(b[\u0016\f1\u0002\\8dW\u0012\u000bG/\u0019#jeR!\u0011qLA3!\r\u0001\u0017\u0011M\u0005\u0004\u0003G\n'\u0001\u0003$jY\u0016dunY6\t\u000f\u0005\u001dD\u00021\u0001\u0002D\u00059A-\u0019;b\t&\u0014X\u0003BA6\u0003k\u001aR!\u0004%\u0002n}\u0003R!RA8\u0003gJ1!!\u001d@\u0005-\u0011\u0016M\u001a;NC:\fw-\u001a:\u0011\u00075\f)\b\u0002\u0004\u0002x5\u0011\r\u0001\u001d\u0002\u0002)\u0006I1\r\\;ti\u0016\u0014\u0018\nZ\u0001\u0007G>tg-[4\u0011\t\u0005}\u00141Q\u0007\u0003\u0003\u0003S!aV!\n\t\u0005\u0015\u0015\u0011\u0011\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006sK\u000e|'\u000fZ*fe\u0012,\u0007CBAF\u0003+\u000b\u0019(\u0004\u0002\u0002\u000e*!\u0011qRAI\u00035\u0019XM]5bY&T\u0018\r^5p]*\u0019\u00111\u0013,\u0002\r\r|W.\\8o\u0013\u0011\t9*!$\u0003\u0017I+7m\u001c:e'\u0016\u0014H-Z\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\ti*!)\u000e\u0005\u0005}%bAAJ1&!\u00111UAP\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0001^8qS\u000eLE\r\u0005\u0003\u0002\u001e\u0006%\u0016\u0002BAV\u0003?\u0013A!V;jI\u0006!A/[7f!\u0011\t\t,!.\u000e\u0005\u0005M&b\u00012\u0002 &!\u0011qWAZ\u0005\u0011!\u0016.\\3\u0002\u000f5,GO]5dgB!\u0011QXAa\u001b\t\tyL\u0003\u0003\u0002:\u0006}\u0015\u0002BAb\u0003\u007f\u0013q!T3ue&\u001c7/A\nuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jq>\u0003H\u000f\u0005\u0003J\u0003\u0013D\u0018bAAf\u0015\n1q\n\u001d;j_:\fAdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X-\u0006\u0002\u0002RB1\u00111[An\u0003?l!!!6\u000b\t\u0005]\u0017\u0011\\\u0001\u000bG>t7-\u001e:sK:$(bA+\u0002L%!\u0011Q\\Ak\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\t\u0003C\f\u0019/a:\u0002t6\u0011\u0011\u0011\\\u0005\u0005\u0003K\fINA\u0002NCB\u0004B!!;\u0002p6\u0011\u00111\u001e\u0006\u0005\u0003[\fY%\u0001\u0003mC:<\u0017\u0002BAy\u0003W\u0014q!\u00138uK\u001e,'\u000f\u0005\u0003\u0002v\n-a\u0002BA|\u0005\u000fqA!!?\u0003\u00069!\u00111 B\u0002\u001d\u0011\tiP!\u0001\u000f\u0007m\fy0C\u0001]\u0013\tQ6,\u0003\u0002C3&\u0011\u0001\tW\u0005\u0004\u0005\u0013I\u0017A\u0003*bMR\u001cuN\u001c4jO&!!Q\u0002B\b\u0005-\tE\r\u001a:fgN\u001c\u0006/Z2\u000b\u0007\t%\u0011.A\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3!)Y\u0011)Ba\u0006\u0003\u001a\tm!Q\u0004B\u0010\u0005C\u0011\u0019C!\n\u0003(\t%\u0002\u0003B#\u000e\u0003gBa!!\u001f\u001a\u0001\u0004A\bbBA>3\u0001\u0007\u0011Q\u0010\u0005\b\u0003\u000fK\u0002\u0019AAE\u0011\u001d\tI*\u0007a\u0001\u00037Cq!!*\u001a\u0001\u0004\t9\u000bC\u0004\u0002.f\u0001\r!a,\t\u000f\u0005e\u0016\u00041\u0001\u0002<\"9\u0011QY\rA\u0002\u0005\u001d\u0007bBAg3\u0001\u0007\u0011\u0011\u001b\u0005\b\u0003\u000fI\u0002\u0019AA\u0005\u0003-\t\u0007/\u001b,feNLwN\\:\u0016\u0005\t=\u0002\u0003\u0002B\u0019\u0005oi!Aa\r\u000b\u0007\tU\u0002,A\u0004dY&,g\u000e^:\n\t\te\"1\u0007\u0002\f\u0003BLg+\u001a:tS>t7/\u0001\u0007ba&4VM]:j_:\u001c\b%\u0001\u0006sC\u001a$8i\u001c8gS\u001e,\"A!\u0011\u0011\u0007!\u0014\u0019%C\u0002\u0003F%\u0014!BU1gi\u000e{gNZ5h\u0003-\u0011\u0018M\u001a;D_:4\u0017n\u001a\u0011\u0016\u0003a\f\u0011\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=!\u0003)awnZ\"p]R,\u0007\u0010^\u000b\u0003\u0005#\u0002B!!-\u0003T%!!QKAZ\u0005)aunZ\"p]R,\u0007\u0010^\u0001\fY><7i\u001c8uKb$\b%A\u0005tG\",G-\u001e7feV\u0011!Q\f\t\u0004'\n}\u0013b\u0001B1)\nq1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sAU\u0011\u00111I\u0001\tI\u0006$\u0018\rR5sA\u0005YA-\u0019;b\t&\u0014Hj\\2l+\t\u0011i\u0007E\u0003J\u0003\u0013\fy&\u0001\u0007eCR\fG)\u001b:M_\u000e\\\u0007%A\u0007sKBd\u0017nY1uK\u0012dunZ\u000b\u0003\u0005k\u00022\u0001\u001bB<\u0013\r\u0011I(\u001b\u0002\u000e%\u0016\u0004H.[2bi\u0016$Gj\\4\u0002\u001dI,\u0007\u000f\\5dCR,G\rT8hA\u0005Qa.\u001a;DQ\u0006tg.\u001a7\u0016\u0005\t\u0005\u0005c\u00015\u0003\u0004&\u0019!QQ5\u0003'-\u000bgm[1OKR<xN]6DQ\u0006tg.\u001a7\u0002\u00179,Go\u00115b]:,G\u000eI\u0001\u0010Kb\u0004\u0018N]1uS>tG+[7feV\u0011!Q\u0012\t\u0005\u0005\u001f\u0013)*\u0004\u0002\u0003\u0012*\u0019!1\u0013+\u0002\u000bQLW.\u001a:\n\t\t]%\u0011\u0013\u0002\f'f\u001cH/Z7US6,'/\u0001\tfqBL'/\u0019;j_:$\u0016.\\3sA\u0005\tR\r\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0016\u0005\t}\u0005cA#\u0003\"&\u0019!1U \u00039QKW.\u001b8h/\",W\r\\#ya&\u0014\u0018\r^5p]N+'O^5dK\u0006\u0011R\r\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3!+\t\u0011I\u000b\u0005\u0003iU\u0006M\u0014aB2mS\u0016tG\u000fI\u0001\re\u00064G/S8UQJ,\u0017\rZ\u000b\u0003\u0005c\u00032Aa-\u0004\u001d\r\u0011)\f\u0001\b\u0005\u0005o\u0013YLD\u0002|\u0005sK\u0011AQ\u0005\u0003\u0001\u0006\u000bQB]1gi&{G\u000b\u001b:fC\u0012\u0004\u0013aB:uCJ$X\u000f]\u0001\tg\",H\u000fZ8x]\u0006A!/Z4jgR,'\u000f\u0006\u0003\u0002.\t\u001d\u0007b\u0002Bem\u0001\u0007!1Z\u0001\tY&\u001cH/\u001a8feB1!Q\u001aBj\u0003gr1\u0001\u001bBh\u0013\r\u0011\t.[\u0001\u000b%\u00064Go\u00117jK:$\u0018\u0002\u0002Bk\u0005/\u0014\u0001\u0002T5ti\u0016tWM\u001d\u0006\u0004\u0005#L\u0017!\u00045b]\u0012dWMU3rk\u0016\u001cH\u000f\u0006\u0005\u0003^\n-(1 B\u0000!\u0019\t\u0019.a7\u0003`B!!\u0011\u001dBt\u001b\t\u0011\u0019O\u0003\u0003\u0003f\u0006}\u0015\u0001\u00039s_R|7m\u001c7\n\t\t%(1\u001d\u0002\u000b\u0003BLW*Z:tC\u001e,\u0007b\u0002Bwo\u0001\u0007!q^\u0001\u0007Q\u0016\fG-\u001a:\u0011\t\tE(q_\u0007\u0003\u0005gTAA!>\u0002 \u0006A!/Z9vKN$8/\u0003\u0003\u0003z\nM(!\u0004*fcV,7\u000f\u001e%fC\u0012,'\u000fC\u0004\u0003~^\u0002\rAa8\u0002\u000fI,\u0017/^3ti\"91\u0011A\u001cA\u0002\r\r\u0011!D2sK\u0006$X\r\u001a+j[\u0016l5\u000fE\u0002J\u0007\u000bI1aa\u0002K\u0005\u0011auN\\4\u0002\u001f\t,\u0018\u000e\u001c3SC\u001a$8\t\\5f]R$\"A!+\u0002'\t,\u0018\u000e\u001c3OKR<xN]6DQ\u0006tg.\u001a7\u0015\u0005\t\u0005\u0015!D2sK\u0006$X\rR1uC\u0012K'\u000f\u0006\u0002\u0002D\u0005\u0001\"-^5mI6+G/\u00193bi\u0006dun\u001a\u000b\u0003\u00073\u00012!RB\u000e\u0013\r\u0019ib\u0010\u0002\u0011\u0017\u000647.Y'fi\u0006$\u0017\r^1M_\u001e\f!CY;jY\u0012tU\r^<pe.\u001cE.[3oiR\u001111\u0005\t\u0005\u0005c\u0019)#\u0003\u0003\u0004(\tM\"!\u0004(fi^|'o[\"mS\u0016tG/\u0001\bmK\u0006$WM]!oI\u0016\u0003xn\u00195\u0016\u0005\r5\u0002c\u00015\u00040%\u00191\u0011G5\u0003\u001d1+\u0017\rZ3s\u0003:$W\t]8dQ\u0002")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final String clusterId;
    private final KafkaConfig config;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final ApiVersions apiVersions;
    private final RaftConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final RaftIoThread raftIoThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private RaftConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private RaftIoThread raftIoThread() {
        return this.raftIoThread;
    }

    public void startup() {
        java.util.Map<Integer, RaftConfig.AddressSpec> voterAddresses = this.controllerQuorumVotersFuture().get();
        CollectionConverters$.MODULE$.SetHasAsScala(voterAddresses.entrySet()).asScala().foreach((Function1 & Serializable)voterAddressEntry -> {
            KafkaRaftManager.$anonfun$startup$1(this, voterAddressEntry);
            return BoxedUnit.UNIT;
        });
        this.netChannel().start();
        this.raftIoThread().start();
    }

    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationService().shutdown(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationTimer().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.raftIoThread().shutdown(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.client().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.scheduler().shutdown(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.netChannel().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.replicatedLog().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable)x$3 -> {
            x$3.destroy();
            return BoxedUnit.UNIT;
        }), this, Level.WARN);
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestHeader header, ApiMessage request, long createdTimeMs) {
        RaftRequest.Inbound inboundRequest = new RaftRequest.Inbound(header.correlationId(), request, createdTimeMs);
        this.client().handle(inboundRequest);
        return inboundRequest.completion.thenApply(response -> response.data());
    }

    private KafkaRaftClient<T> buildRaftClient() {
        FileBasedStateStore quorumStateStore = new FileBasedStateStore(new File(this.dataDir(), "quorum-state"));
        OptionalInt nodeId = OptionalInt.of(this.config.nodeId());
        KafkaRaftClient client = new KafkaRaftClient(this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), (QuorumStateStore)quorumStateStore, this.time, this.metrics, (ExpirationService)this.expirationService(), this.logContext(), this.clusterId, nodeId, this.raftConfig());
        client.initialize();
        return client;
    }

    private KafkaNetworkChannel buildNetworkChannel() {
        NetworkClient netClient = this.buildNetworkClient();
        return new KafkaNetworkChannel(this.time, (KafkaClient)netClient, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        TopicPartition logDirName_topicPartition = this.topicPartition;
        Object var2_1 = null;
        String logDirName = LocalLog$.MODULE$.logDirName(logDirName_topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, (Scheduler)this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000));
    }

    private NetworkClient buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()))), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerListenerName, (String)this.config.saslMechanismControllerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, Int$.MODULE$.int2long(reconnectBackoffMs), Int$.MODULE$.int2long(reconnectBackoffMsMs), -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext());
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    public static final /* synthetic */ void $anonfun$startup$1(KafkaRaftManager $this, Map.Entry voterAddressEntry) {
        RaftConfig.AddressSpec addressSpec = (RaftConfig.AddressSpec)voterAddressEntry.getValue();
        if (addressSpec instanceof RaftConfig.InetAddressSpec) {
            RaftConfig.InetAddressSpec inetAddressSpec = (RaftConfig.InetAddressSpec)addressSpec;
            $this.netChannel().updateEndpoint(Predef$.MODULE$.Integer2int((Integer)voterAddressEntry.getKey()), inetAddressSpec);
            return;
        }
        if (addressSpec instanceof RaftConfig.UnknownAddressSpec) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(79).append("Skipping channel update for destination ID: ").append(voterAddressEntry.getKey()).append(" ").append("because of non-routable endpoint: ").append(RaftConfig.NON_ROUTABLE_ADDRESS.toString()).toString());
            return;
        }
        if (addressSpec != null) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Unexpected address spec (type: ").append(addressSpec.getClass()).append(") for channel update for ").append("destination ID: ").append(voterAddressEntry.getKey()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public KafkaRaftManager(String clusterId, KafkaConfig config, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandler fatalFaultHandler) {
        this.clusterId = clusterId;
        this.config = config;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.apiVersions = new ApiVersions();
        this.raftConfig = new RaftConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(18).append("[RaftManager id=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString());
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = !((SeqOps)config.logDirs().map((Function1 & Serializable)x$2 -> Paths.get(x$2, new String[0]).toAbsolutePath())).contains((Object)Paths.get(config.metadataLogDir(), new String[0]).toAbsolutePath());
        Set<KafkaRaftServer.ProcessRole> set = config.processRoles();
        Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer$ControllerRole$[]{KafkaRaftServer$ControllerRole$.MODULE$}));
        boolean isOnlyController = !(set != null ? !set.equals(object) : object != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor");
        this.expirationService = new TimingWheelExpirationService((Timer)this.expirationTimer());
        this.client = this.buildRaftClient();
        this.raftIoThread = new RaftIoThread(this.client(), this.threadNamePrefix(), fatalFaultHandler);
    }

    public static class RaftIoThread
    extends ShutdownableThread
    implements Logging {
        private final KafkaRaftClient<?> client;
        private final FaultHandler fatalFaultHandler;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        public void doWork() {
            try {
                this.client.poll();
                return;
            }
            catch (Throwable t) {
                throw this.fatalFaultHandler.handleFault("Unexpected error in raft IO thread", t);
            }
        }

        public boolean initiateShutdown() {
            if (super.initiateShutdown()) {
                this.client.shutdown(5000).whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> "Graceful shutdown of RaftClient failed", (Function0<Throwable>)(Function0 & Serializable)() -> exception);
                        return;
                    }
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Completed graceful shutdown of RaftClient");
                });
                return true;
            }
            return false;
        }

        public boolean isRunning() {
            return this.client.isRunning() && !this.isThreadFailed();
        }

        public RaftIoThread(KafkaRaftClient<?> client, String threadNamePrefix, FaultHandler fatalFaultHandler) {
            this.client = client;
            this.fatalFaultHandler = fatalFaultHandler;
            super(new StringBuilder(10).append(threadNamePrefix).append("-io-thread").toString(), false);
            this.logIdent_$eq(this.logPrefix);
        }
    }
}

