/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\re\u0001B\u000b\u0017\u0001mAQA\t\u0001\u0005\u0002\rBqA\n\u0001C\u0002\u0013\u0005q\u0005\u0003\u0004/\u0001\u0001\u0006I\u0001\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0011\u0019I\u0004\u0001)A\u0005c!9!\b\u0001b\u0001\n\u0003\u0001\u0004BB\u001e\u0001A\u0003%\u0011\u0007C\u0004=\u0001\t\u0007I\u0011A\u0014\t\ru\u0002\u0001\u0015!\u0003)\u0011\u001dq\u0004A1A\u0005\u0002}Baa\u0017\u0001!\u0002\u0013\u0001\u0005b\u0002/\u0001\u0005\u0004%\t!\u0018\u0005\u0007K\u0002\u0001\u000b\u0011\u00020\t\u000b\u0019\u0004A\u0011I4\t\u000bI\u0004A\u0011I:\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA2\u0001\u0011%\u0011Q\r\u0005\b\u0003g\u0002A\u0011BA;\u0011\u001d\tY\b\u0001C\u0005\u0003{\u0012!\u0005\u0016:b]N\f7\r^5p]N<\u0016\u000e\u001e5NCbLeN\u00127jO\"$xJ\\3UKN$(BA\f\u0019\u0003\r\t\u0007/\u001b\u0006\u00023\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\ty\u0002$A\u0006j]R,wM]1uS>t\u0017BA\u0011\u001f\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001%!\t)\u0003!D\u0001\u0017\u0003)qW/\u001c\"s_.,'o]\u000b\u0002QA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t\u0019\u0011J\u001c;\u0002\u00179,XN\u0011:pW\u0016\u00148\u000fI\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0003E\u0002\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\t1\fgn\u001a\u0006\u0002m\u0005!!.\u0019<b\u0013\tA4G\u0001\u0004TiJLgnZ\u0001\bi>\u0004\u0018nY\u0019!\u0003\u0019!x\u000e]5de\u00059Ao\u001c9jGJ\u0002\u0013!\u00048v[B\u000b'\u000f^5uS>t7/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002-Q\u0014\u0018M\\:bGRLwN\\1m!J|G-^2feN,\u0012\u0001\u0011\t\u0004\u0003\u001aCU\"\u0001\"\u000b\u0005\r#\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u000b*\n!bY8mY\u0016\u001cG/[8o\u0013\t9%I\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0013N+V+D\u0001K\u0015\tYE*\u0001\u0005qe>$WoY3s\u0015\tie*A\u0004dY&,g\u000e^:\u000b\u0005ey%B\u0001)R\u0003\u0019\t\u0007/Y2iK*\t!+A\u0002pe\u001eL!\u0001\u0016&\u0003\u001b-\u000bgm[1Qe>$WoY3s!\rIc\u000bW\u0005\u0003/*\u0012Q!\u0011:sCf\u0004\"!K-\n\u0005iS#\u0001\u0002\"zi\u0016\fq\u0003\u001e:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'o\u001d\u0011\u0002-Q\u0014\u0018M\\:bGRLwN\\1m\u0007>t7/^7feN,\u0012A\u0018\t\u0004\u0003\u001a{\u0006\u0003\u00021d+Vk\u0011!\u0019\u0006\u0003E2\u000b\u0001bY8ogVlWM]\u0005\u0003I\u0006\u0014\u0001bQ8ogVlWM]\u0001\u0018iJ\fgn]1di&|g.\u00197D_:\u001cX/\\3sg\u0002\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002QB\u0019\u0011N\u001b7\u000e\u0003\u0011K!a\u001b#\u0003\u0007M+\u0017\u000f\u0005\u0002na6\taN\u0003\u0002p1\u000511/\u001a:wKJL!!\u001d8\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003i^\u0004\"!K;\n\u0005YT#\u0001B+oSRDQ\u0001_\bA\u0002e\f\u0001\u0002^3ti&sgm\u001c\t\u0004u\u0006\u0005Q\"A>\u000b\u0005]a(BA?\u007f\u0003\u001dQW\u000f]5uKJT!a`)\u0002\u000b),h.\u001b;\n\u0007\u0005\r1P\u0001\u0005UKN$\u0018J\u001c4pQ\ry\u0011q\u0001\t\u0004u\u0006%\u0011bAA\u0006w\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:$\u0012\u0001\u001e\u0015\u0004!\u0005M\u0001c\u0001>\u0002\u0016%\u0019\u0011qC>\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017a\r;fgR$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001c\u0016N\\4mK\n\u0013xn[3s\u001b\u0006D\u0018J\u001c$mS\u001eDGo\u00148f)\r!\u0018Q\u0004\u0005\b\u0003?\t\u0002\u0019AA\u0011\u0003\u0019\tXo\u001c:v[B!\u00111EA\u0019\u001d\u0011\t)#!\f\u0011\u0007\u0005\u001d\"&\u0004\u0002\u0002*)\u0019\u00111\u0006\u000e\u0002\rq\u0012xn\u001c;?\u0013\r\tyCK\u0001\u0007!J,G-\u001a4\n\u0007a\n\u0019DC\u0002\u00020)Bs!EA\u001c\u0003\u0007\n)\u0005\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\ti\u0004`\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005\u0005\u00131\b\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f#!a\u0012\u0002Em$\u0017n\u001d9mCft\u0015-\\3~]m\f'oZ;nK:$8oV5uQ:\u000bW.Z:~Q\u001d\t\u00121JA,\u00033\u0002B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0005\u0003#\nY$\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\t)&a\u0014\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\tY&a\u0018\"\u0005\u0005u\u0013A\u0001>lC\t\t\t'A\u0003le\u00064G/A\u0006tKJ4XM\u001d)s_B\u001cHCAA4!\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA7k\u0005!Q\u000f^5m\u0013\u0011\t\t(a\u001b\u0003\u0015A\u0013x\u000e]3si&,7/A\u000ede\u0016\fG/\u001a*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM\u001d\u000b\u0004?\u0006]\u0004bBA='\u0001\u0007\u0011\u0011E\u0001\u0006OJ|W\u000f]\u0001\u001cGJ,\u0017\r^3Ue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:\u0015\u0007!\u000by\bC\u0004\u0002\u0002R\u0001\r!!\t\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0004")
public class TransactionsWithMaxInFlightOneTest
extends KafkaServerTestHarness {
    private final int numBrokers;
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<Consumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);

    public int numBrokers() {
        return this.numBrokers;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<Consumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numBrokers(), this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.serverProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(1));
        this.createTopic(this.topic1(), this.numPartitions(), this.numBrokers(), topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.topic2(), this.numPartitions(), this.numBrokers(), topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        this.createTransactionalProducer("transactional-producer");
        this.createReadCommittedConsumer("transactional-group");
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTransactionalProducerSingleBrokerMaxInFlightOne(String quorum) {
        Assertions.assertEquals((int)1, (int)this.brokers().size());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", false));
        producer.flush();
        producer.abortTransaction();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", true));
        producer.commitTransaction();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    private Properties serverProps() {
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        return serverProps;
    }

    private Consumer<byte[], byte[]> createReadCommittedConsumer(String group) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        String x$5 = "earliest";
        int x$6 = 500;
        SecurityProtocol x$7 = SecurityProtocol.PLAINTEXT;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        ByteArrayDeserializer x$10 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        Consumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$5, false, true, x$6, x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11);
        this.transactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId) {
        Buffer<KafkaBroker> x$2 = this.brokers();
        int x$4 = 16384;
        long x$5 = 60000L;
        long x$6 = 60000L;
        int x$7 = 120000;
        int x$8 = 30000;
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(transactionalId, x$2, x$4, x$5, x$6, x$7, x$8, 1);
        this.transactionalProducers().$plus$eq(producer);
        return producer;
    }

    public TransactionsWithMaxInFlightOneTest() {
        this.numBrokers = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
    }
}

