/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.log.UnifiedLog;
import kafka.server.ControllerServer;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.storage.internals.checkpoint.PartitionMetadataFile;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;

@ExtendWith(value={ClusterTestExtensions.class})
@Tag(value="integration")
public class LogManagerIntegrationTest {
    private final ClusterInstance cluster;

    public LogManagerIntegrationTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.KRAFT, brokers=3), @ClusterTest(clusterType=Type.CO_KRAFT, brokers=3)})
    public void testRestartBrokerNoErrorIfMissingPartitionMetadata() throws IOException, ExecutionException, InterruptedException {
        RaftClusterInvocationContext.RaftClusterInstance raftInstance = (RaftClusterInvocationContext.RaftClusterInstance)this.cluster;
        try (Admin admin = this.cluster.createAdminClient();){
            kafka.utils.TestUtils.createTopicWithAdmin(admin, "foo", CollectionConverters.asScala(raftInstance.brokers().iterator()).toSeq(), (Seq<ControllerServer>)CollectionConverters.asScala(raftInstance.controllers().iterator()).toSeq(), 1, 3, (Map<Object, Seq<Object>>)CollectionConverters.asScala(Collections.emptyMap()), new Properties());
        }
        Optional<Object> partitionMetadataFile = Optional.ofNullable(((UnifiedLog)raftInstance.getUnderlying().brokers().get(0).logManager().getLog(new TopicPartition("foo", 0), false).get()).partitionMetadataFile().getOrElse(null));
        Assertions.assertTrue((boolean)partitionMetadataFile.isPresent());
        raftInstance.getUnderlying().brokers().get(0).shutdown();
        try (Admin admin = this.cluster.createAdminClient();){
            TestUtils.waitForCondition(() -> {
                List partitionInfos = ((TopicDescription)((KafkaFuture)admin.describeTopics(Collections.singletonList("foo")).topicNameValues().get("foo")).get()).partitions();
                return ((TopicPartitionInfo)partitionInfos.get(0)).isr().size() == 2;
            }, (String)"isr size is not shrink to 2");
        }
        ((PartitionMetadataFile)partitionMetadataFile.get()).delete();
        Assertions.assertFalse((boolean)((PartitionMetadataFile)partitionMetadataFile.get()).exists());
        raftInstance.getUnderlying().brokers().get(0).startup();
        Assertions.assertDoesNotThrow(() -> raftInstance.getUnderlying().fatalFaultHandler().maybeRethrowFirstException());
        admin = this.cluster.createAdminClient();
        var4_6 = null;
        try {
            TestUtils.waitForCondition(() -> {
                List partitionInfos = ((TopicDescription)((KafkaFuture)admin.describeTopics(Collections.singletonList("foo")).topicNameValues().get("foo")).get()).partitions();
                return ((TopicPartitionInfo)partitionInfos.get(0)).isr().size() == 3;
            }, (String)"isr size is not expand to 3");
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
        finally {
            if (admin != null) {
                if (var4_6 != null) {
                    try {
                        admin.close();
                    }
                    catch (Throwable throwable) {
                        var4_6.addSuppressed(throwable);
                    }
                } else {
                    admin.close();
                }
            }
        }
        HashMap<String, String> producerConfigs = new HashMap<String, String>();
        producerConfigs.put("bootstrap.servers", this.cluster.bootstrapServers());
        producerConfigs.put("key.serializer", StringSerializer.class.getName());
        producerConfigs.put("value.serializer", StringSerializer.class.getName());
        try (KafkaProducer producer = new KafkaProducer(producerConfigs);){
            producer.send(new ProducerRecord("foo", Integer.valueOf(0), null, (Object)"bar")).get();
            producer.flush();
        }
        HashMap<String, String> consumerConfigs = new HashMap<String, String>();
        consumerConfigs.put("bootstrap.servers", this.cluster.bootstrapServers());
        consumerConfigs.put("group.id", UUID.randomUUID().toString());
        consumerConfigs.put("key.deserializer", StringDeserializer.class.getName());
        consumerConfigs.put("value.deserializer", StringDeserializer.class.getName());
        try (KafkaConsumer consumer = new KafkaConsumer(consumerConfigs);){
            consumer.assign(Collections.singletonList(new TopicPartition("foo", 0)));
            consumer.seekToBeginning(Collections.singletonList(new TopicPartition("foo", 0)));
            ArrayList<Object> values = new ArrayList<Object>();
            ConsumerRecords records = consumer.poll(Duration.ofMinutes(1L));
            for (ConsumerRecord record : records) {
                values.add(record.value());
            }
            Assertions.assertEquals((int)1, (int)values.size());
            Assertions.assertEquals((Object)"bar", values.get(0));
        }
    }
}

