/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.server.BrokerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaFetcherThread;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$Checkpoint$;
import kafka.utils.TestUtils$Roll$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005ee\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00043\u0001\u0001\u0006I\u0001\f\u0005\bg\u0001\u0011\r\u0011\"\u0001,\u0011\u0019!\u0004\u0001)A\u0005Y!9Q\u0007\u0001b\u0001\n\u0003Y\u0003B\u0002\u001c\u0001A\u0003%A\u0006C\u00048\u0001\t\u0007I\u0011\u0002\u001d\t\r\u0005\u0003\u0001\u0015!\u0003:\u0011\u001d\u0011\u0005A1A\u0005\n-Baa\u0011\u0001!\u0002\u0013a\u0003b\u0002#\u0001\u0005\u0004%\te\u000b\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002\u0017\t\u000b\u0019\u0003A\u0011I$\t\u000bq\u0003A\u0011A/\t\u000by\u0004A\u0011A@\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001bBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r\t\tBj\\4ESJ4\u0015-\u001b7ve\u0016$Vm\u001d;\u000b\u0005ma\u0012AB:feZ,'OC\u0001\u001e\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rb\u0012aA1qS&\u0011QE\t\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011AG\u0001\u000eaJ|G-^2fe\u000e{WO\u001c;\u0016\u00031\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u00121!\u00138u\u00039\u0001(o\u001c3vG\u0016\u00148i\\;oi\u0002\nQbY8ogVlWM]\"pk:$\u0018AD2p]N,X.\u001a:D_VtG\u000fI\u0001\fEJ|7.\u001a:D_VtG/\u0001\u0007ce>\\WM]\"pk:$\b%A\u0003u_BL7-F\u0001:!\tQt(D\u0001<\u0015\taT(\u0001\u0003mC:<'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u0012aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0007qCJ$\u0018\u000e^5p]:+X.A\u0007qCJ$\u0018\u000e^5p]:+X\u000eI\u0001\fY><G)\u001b:D_VtG/\u0001\u0007m_\u001e$\u0015N]\"pk:$\b%A\u0003tKR,\u0006\u000f\u0006\u0002I\u0017B\u0011Q&S\u0005\u0003\u0015:\u0012A!\u00168ji\")AJ\u0004a\u0001\u001b\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002O-6\tqJ\u0003\u0002$!*\u0011\u0011KU\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0019F+A\u0003kk:LGOC\u0001V\u0003\ry'oZ\u0005\u0003/>\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u0003\u001de\u0003\"A\u0014.\n\u0005m{%A\u0003\"fM>\u0014X-R1dQ\u0006!C/Z:u!J|G-^2f\u000bJ\u0014xN\u001d$s_64\u0015-\u001b7ve\u0016|e\u000eT8h%>dG\u000e\u0006\u0002I=\")ql\u0004a\u0001A\u00061\u0011/^8sk6\u0004\"!\u00195\u000f\u0005\t4\u0007CA2/\u001b\u0005!'BA3\u001f\u0003\u0019a$o\\8u}%\u0011qML\u0001\u0007!J,G-\u001a4\n\u0005\u0001K'BA4/Q\ty1\u000e\u0005\u0002m_6\tQN\u0003\u0002o!\u00061\u0001/\u0019:b[NL!\u0001]7\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000f\u000b\u0003\u0010ebL\bCA:w\u001b\u0005!(BA;n\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018BA<u\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012!\u0010`\u0011\u0002w\u0006\u0011!p[\u0011\u0002{\u0006)1N]1gi\u0006iB/Z:u\u0019><G)\u001b:O_RLg-[2bi&|g\u000eV5nK>,H\u000fF\u0002I\u0003\u0003AQa\u0018\tA\u0002\u0001D#\u0001E6)\u000bA\u0011\b0a\u0002-\u0003q\fA\u0004^3ti&{U\t_2faRLwN\u001c#ve&tw\rT8h%>dG\u000eF\u0002I\u0003\u001bAQaX\tA\u0002\u0001D#!E6)\u000bE\u0011\b0a\u0005-\u0005id\u0018a\u0010;fgRT6N\u0011:pW\u0016\u0014x+\u001b;i\u001f2$\u0017J\u001c;fe\n\u0013xn[3s!J|Go\\2pYNCw.\u001e7e\u0011\u0006dGo\u00148M_\u001e$\u0015N\u001d$bS2,(/\u001a\u000b\u0002\u0011\"\u001a!#a\u0007\u0011\u00079\u000bi\"C\u0002\u0002 =\u0013A\u0001V3ti\u00069C/Z:u!J|G-^2f\u000bJ\u0014xN\u001d$s_64\u0015-\u001b7ve\u0016|en\u00115fG.\u0004x.\u001b8u)\rA\u0015Q\u0005\u0005\u0006?N\u0001\r\u0001\u0019\u0015\u0003'-DSa\u0005:y\u0003Wa#A\u001f?\u0002?Q,7\u000f^%P\u000bb\u001cW\r\u001d;j_:$UO]5oO\u000eCWmY6q_&tG\u000fF\u0002I\u0003cAQa\u0018\u000bA\u0002\u0001D#\u0001F6)\u000bQ\u0011\b0a\u000e-\u0005id\u0018\u0001\u000e;fgR\u0014V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bI\u00063G/\u001a:M_\u001e$\u0015N\u001d$bS2,(/Z(o\r>dGn\\<feR\u0019\u0001*!\u0010\t\u000b}+\u0002\u0019\u00011)\u0005UY\u0007&B\u000bsq\u0006\rCF\u0001>}\u0003)\"Xm\u001d;Qe>$WoY3FeJ|'o\u001d$s_6dun\u001a#je\u001a\u000b\u0017\u000e\\;sK>sG*Z1eKJ$2\u0001SA%\u0011\u001d\tYE\u0006a\u0001\u0003\u001b\n1BZ1jYV\u0014X\rV=qKB!\u0011qJA1\u001d\u0011\t\t&a\u0017\u000f\t\u0005M\u0013q\u000b\b\u0004G\u0006U\u0013\"A\u000f\n\u0007\u0005eC$A\u0003vi&d7/\u0003\u0003\u0002^\u0005}\u0013!\u0003+fgR,F/\u001b7t\u0015\r\tI\u0006H\u0005\u0005\u0003G\n)GA\tM_\u001e$\u0015N\u001d$bS2,(/\u001a+za\u0016TA!!\u0018\u0002`\u0005)C/Z:u!J|G-^2f\u0003\u001a$XM\u001d'pO\u0012K'OR1jYV\u0014Xm\u00148MK\u0006$WM\u001d\u000b\u0006\u0011\u0006-\u0014Q\u000e\u0005\b\u0003\u0017:\u0002\u0019AA'\u0011\u0015yv\u00031\u0001a\u0003u\u0019XOY:de&\u0014W-\u00118e/\u0006LGOR8s\u0003N\u001c\u0018n\u001a8nK:$H#\u0002%\u0002t\u0005U\u0004\"B\u001c\u0019\u0001\u0004\u0001\u0007bBA<1\u0001\u0007\u0011\u0011P\u0001\tG>t7/^7feBA\u00111PAE\u0003\u001b\u000bi)\u0004\u0002\u0002~)!\u0011qOA@\u0015\u0011\t\t)a!\u0002\u000f\rd\u0017.\u001a8ug*\u0019Q$!\"\u000b\u0007\u0005\u001dE+\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003\u0017\u000biH\u0001\u0005D_:\u001cX/\\3s!\u0015i\u0013qRAJ\u0013\r\t\tJ\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004[\u0005U\u0015bAAL]\t!!)\u001f;f\u0001")
public class LogDirFailureTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int brokerCount;
    private final String topic;
    private final int partitionNum;
    private final int logDirCount;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    private String topic() {
        return this.topic;
    }

    private int partitionNum() {
        return this.partitionNum;
    }

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic(), this.partitionNum(), this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.ensureConsistentKRaftMetadata();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testProduceErrorFromFailureOnLogRoll(String quorum) {
        this.testProduceErrorsFromLogDirFailureOnLeader(TestUtils$Roll$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testLogDirNotificationTimeout(String quorum) {
        this.producerConfig().setProperty("retries", "0");
        this.producerConfig().setProperty("enable.idempotence", "false");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        int leaderServerId = ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testLogDirNotificationTimeout$1(x$1))).get()).leader().id();
        KafkaBroker leaderServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testLogDirNotificationTimeout$2(leaderServerId, x$2))).get();
        this.controllerServer().shutdown();
        this.controllerServer().awaitShutdown();
        TestUtils$.MODULE$.causeLogDirFailure(TestUtils$Checkpoint$.MODULE$, leaderServer, partition);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$testLogDirNotificationTimeout$3(leaderServer)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogDirFailureTest.$anonfun$testLogDirNotificationTimeout$4(leaderServer));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        leaderServer.awaitShutdown();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testIOExceptionDuringLogRoll(String quorum) {
        this.testProduceAfterLogDirFailureOnLeader(TestUtils$Roll$.MODULE$, quorum);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkBrokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure() {
        VolatileObjectRef statusCodeOption = VolatileObjectRef.create((Object)None$.MODULE$);
        Function2 & Serializable setHaltProcedure_haltProcedure = (Function2 & Serializable)(statusCode, x$3) -> LogDirFailureTest.$anonfun$testZkBrokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(statusCodeOption, BoxesRunTime.unboxToInt((Object)statusCode), x$3);
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var27_2 = null;
        KafkaServer server = null;
        try {
            void createServer_time;
            int x$1 = this.brokerCount();
            String x$2 = this.zkConnect();
            boolean x$4 = true;
            boolean x$5 = true;
            TestUtils$ createBrokerConfig$default$5_this = TestUtils$.MODULE$;
            Object var34_8 = null;
            int x$6 = createBrokerConfig$default$5_this.RandomPort();
            None$ x$7 = None$.MODULE$;
            None$ x$8 = None$.MODULE$;
            None$ x$9 = None$.MODULE$;
            boolean x$10 = true;
            boolean x$11 = false;
            TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
            Object var35_15 = null;
            int x$12 = createBrokerConfig$default$11_this.RandomPort();
            boolean x$13 = false;
            TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
            Object var36_18 = null;
            int x$14 = createBrokerConfig$default$13_this.RandomPort();
            boolean x$15 = false;
            TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
            Object var37_21 = null;
            int x$16 = createBrokerConfig$default$15_this.RandomPort();
            None$ x$17 = None$.MODULE$;
            boolean x$18 = false;
            int x$19 = 1;
            short x$20 = 1;
            boolean x$21 = false;
            Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$6, (Option<SecurityProtocol>)x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, (Option<String>)x$17, 3, x$18, x$19, x$20, x$21);
            props.put("inter.broker.protocol.version", "0.11.0");
            props.put(ServerLogConfigs.LOG_MESSAGE_FORMAT_VERSION_CONFIG, "0.11.0");
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            File logDir = new File((String)kafkaConfig.logDirs().head());
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> Utils.delete((File)logDir), (Logging)this, Level.WARN);
            Files.createFile(logDir.toPath(), new FileAttribute[0]);
            Assertions.assertTrue((boolean)logDir.isFile());
            Time time = Time.SYSTEM;
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            boolean createServer_createServer_createServer_startup = true;
            Object var40_33 = null;
            Object var38_32 = null;
            time = null;
            server = createServer_this.createServer(kafkaConfig, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((Option)statusCodeOption.elem).contains((Object)BoxesRunTime.boxToInteger((int)1))) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"timed out waiting for broker to halt");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        catch (Throwable throwable) {
            Exit.resetHaltProcedure();
            if (server != null) {
                TestUtils$.MODULE$.shutdownServers(new .colon.colon(server, (List)Nil$.MODULE$), true);
            }
            throw throwable;
        }
        Exit.resetHaltProcedure();
        if (server != null) {
            TestUtils$.MODULE$.shutdownServers(new .colon.colon((Object)server, (List)Nil$.MODULE$), true);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testProduceErrorFromFailureOnCheckpoint(String quorum) {
        this.testProduceErrorsFromLogDirFailureOnLeader(TestUtils$Checkpoint$.MODULE$);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testIOExceptionDuringCheckpoint(String quorum) {
        this.testProduceAfterLogDirFailureOnLeader(TestUtils$Checkpoint$.MODULE$, quorum);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testReplicaFetcherThreadAfterLogDirFailureOnFollower(String quorum) {
        this.producerConfig().setProperty("retries", "0");
        this.producerConfig().setProperty("enable.idempotence", "false");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        PartitionInfo partitionInfo = (PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(x$4))).get();
        int leaderServerId = partitionInfo.leader().id();
        KafkaBroker leaderServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(leaderServerId, x$5))).get();
        int followerServerId = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas()), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), (ClassTag)ClassTag$.MODULE$.Int())), (Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> x$7 != leaderServerId).get());
        KafkaBroker followerServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(followerServerId, x$8))).get();
        followerServer.replicaManager().markPartitionOffline(partition);
        int anotherPartitionWithTheSameLeader = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.partitionNum()).find((Function1)(JFunction1.mcZI.sp & Serializable)i -> leaderServer.replicaManager().onlinePartition(new TopicPartition(this.topic(), i)).flatMap((Function1 & Serializable)x$9 -> x$9.leaderLogIfLocal()).isDefined()).get());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(anotherPartitionWithTheSameLeader), (Object)this.topic().getBytes(), (Object)"message".getBytes());
        producer.send(record).get();
        Assertions.assertEquals((int)this.brokerCount(), (int)((Partition)leaderServer.replicaManager().onlinePartition(new TopicPartition(this.topic(), anotherPartitionWithTheSameLeader)).get()).inSyncReplicaIds().size());
        followerServer.replicaManager().replicaFetcherManager().fetcherThreadMap().values().foreach((Function1 & Serializable)thread -> {
            LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(thread);
            return BoxedUnit.UNIT;
        });
    }

    public void testProduceErrorsFromLogDirFailureOnLeader(TestUtils.LogDirFailureType failureType) {
        this.producerConfig().setProperty("retries", "0");
        this.producerConfig().setProperty("enable.idempotence", "false");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int leaderServerId = ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceErrorsFromLogDirFailureOnLeader$1(x$10))).get()).leader().id();
        KafkaBroker leaderServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceErrorsFromLogDirFailureOnLeader$2(leaderServerId, x$11))).get();
        TestUtils$.MODULE$.causeLogDirFailure(failureType, leaderServer, partition);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> producer.send(record).get(6000L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((e.getCause() instanceof KafkaStorageException || e.getCause() instanceof NotLeaderOrFollowerException ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    public void testProduceAfterLogDirFailureOnLeader(TestUtils.LogDirFailureType failureType, String quorum) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int originalLeaderServerId = ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$1(x$12))).get()).leader().id();
        KafkaBroker originalLeaderServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$2(originalLeaderServerId, x$13))).get();
        producer.send(record).get();
        TestUtils$.MODULE$.consumeRecords(consumer, 1, 15000L);
        File failedLogDir = TestUtils$.MODULE$.causeLogDirFailure(failureType, originalLeaderServer, partition);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$3(this, producer, record, originalLeaderServerId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected new leader for the partition");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
        String string = quorum;
        String string2 = "kraft";
        if (string != null && string.equals(string2)) {
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$6(this, originalLeaderServerId, failedLogDir)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Expected to find an offline log dir");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            return;
        }
        Assertions.assertTrue((boolean)this.zkClient().getAllLogDirEventNotifications().isEmpty());
        Assertions.assertTrue((boolean)((KafkaServer)this.servers().find((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$13(x$19))).get()).kafkaController().controllerContext().replicasInState(this.topic(), (ReplicaState)OfflineReplica$.MODULE$).contains((Object)new PartitionAndReplica(new TopicPartition(this.topic(), 0), originalLeaderServerId)));
    }

    private void subscribeAndWaitForAssignment(String topic, Consumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        long pollUntilTrue_waitTimeMs = 15000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (LogDirFailureTest.$anonfun$subscribeAndWaitForAssignment$1(consumer)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected non-empty assignment");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollUntilTrue_waitTimeMs), pollUntilTrue_waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testLogDirNotificationTimeout$1(PartitionInfo x$1) {
        return x$1.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testLogDirNotificationTimeout$2(int leaderServerId$1, KafkaBroker x$2) {
        return x$2.config().brokerId() == leaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testLogDirNotificationTimeout$3(KafkaBroker leaderServer$1) {
        BrokerState brokerState = leaderServer$1.brokerState();
        BrokerState brokerState2 = BrokerState.SHUTTING_DOWN;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testLogDirNotificationTimeout$4(KafkaBroker leaderServer$1) {
        return new StringBuilder(51).append("Expected broker to be in NOT_RUNNING state but was ").append(leaderServer$1.brokerState()).toString();
    }

    public static final /* synthetic */ Nothing$ $anonfun$testZkBrokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(VolatileObjectRef statusCodeOption$1, int statusCode, Option x$3) {
        statusCodeOption$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        throw new IllegalArgumentException();
    }

    public static final /* synthetic */ boolean $anonfun$testZkBrokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$3(VolatileObjectRef statusCodeOption$1) {
        return ((Option)statusCodeOption$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)1));
    }

    public static final /* synthetic */ String $anonfun$testZkBrokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$4() {
        return "timed out waiting for broker to halt";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(PartitionInfo x$4) {
        return x$4.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(int leaderServerId$2, KafkaBroker x$5) {
        return x$5.config().brokerId() == leaderServerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(int followerServerId$1, KafkaBroker x$8) {
        return x$8.config().brokerId() == followerServerId$1;
    }

    public static final /* synthetic */ void $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(ReplicaFetcherThread thread) {
        Assertions.assertFalse((boolean)thread.isShutdownComplete(), (String)"ReplicaFetcherThread should still be working if its partition count > 0");
    }

    public static final /* synthetic */ boolean $anonfun$testProduceErrorsFromLogDirFailureOnLeader$1(PartitionInfo x$10) {
        return x$10.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceErrorsFromLogDirFailureOnLeader$2(int leaderServerId$3, KafkaBroker x$11) {
        return x$11.config().brokerId() == leaderServerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$1(PartitionInfo x$12) {
        return x$12.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$2(int originalLeaderServerId$1, KafkaBroker x$13) {
        return x$13.config().brokerId() == originalLeaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$4(PartitionInfo x$14) {
        return x$14.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$3(LogDirFailureTest $this, KafkaProducer producer$2, ProducerRecord record$2, int originalLeaderServerId$1) {
        producer$2.send(record$2);
        return ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer$2.partitionsFor($this.topic())).asScala().find((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$4(x$14))).get()).leader().id() != originalLeaderServerId$1;
    }

    public static final /* synthetic */ String $anonfun$testProduceAfterLogDirFailureOnLeader$5() {
        return "Expected new leader for the partition";
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$7(int originalLeaderServerId$1, KafkaBroker x$15) {
        return x$15.config().nodeId() == originalLeaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$9(File failedLogDir$1, BrokerServer x$17) {
        return x$17.logDirFailureChannel().hasOfflineLogDir(((Object)failedLogDir$1.toPath()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$6(LogDirFailureTest $this, int originalLeaderServerId$1, File failedLogDir$1) {
        Option brokerWithDirFail = $this.brokers().find((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$7(originalLeaderServerId$1, x$15))).map((Function1 & Serializable)x$16 -> (BrokerServer)x$16);
        return brokerWithDirFail.exists((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$9(failedLogDir$1, x$17))) && brokerWithDirFail.exists((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])broker.replicaManager().metadataCache().getClusterMetadata(broker.clusterId(), broker.config().interBrokerListenerName()).partition(new TopicPartition($this.topic(), 0)).offlineReplicas()), (Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.id()), (ClassTag)ClassTag$.MODULE$.Int())), (Object)BoxesRunTime.boxToInteger((int)originalLeaderServerId$1))));
    }

    public static final /* synthetic */ String $anonfun$testProduceAfterLogDirFailureOnLeader$12() {
        return "Expected to find an offline log dir";
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$13(KafkaServer x$19) {
        return x$19.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$subscribeAndWaitForAssignment$1(Consumer consumer$1) {
        return !consumer$1.assignment().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$subscribeAndWaitForAssignment$2() {
        return "Expected non-empty assignment";
    }

    public LogDirFailureTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.brokerCount = 2;
        this.topic = "topic";
        this.partitionNum = 12;
        this.logDirCount = 3;
        this.serverConfig().setProperty("replica.high.watermark.checkpoint.interval.ms", "60000");
        this.serverConfig().setProperty("num.replica.fetchers", "1");
        this.serverConfig().setProperty("log.dir.failure.timeout.ms", "5000");
        this.serverConfig().setProperty("controlled.shutdown.enable", "false");
    }
}

