/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FelixCommandAdaptor {
    public static final String FELIX_COMMAND = "org.apache.felix.shell.Command";
    private final Object felixCommand;
    private Method execute;
    private String help;
    private String name;
    private String usage;

    public FelixCommandAdaptor(Object felixCommand) throws Exception {
        this.felixCommand = felixCommand;
        Class<?> c = felixCommand.getClass();
        Class[] parms = new Class[]{String.class, PrintStream.class, PrintStream.class};
        this.execute = c.getMethod("execute", parms);
        Method name = c.getMethod("getName", null);
        this.name = (String)name.invoke(felixCommand, (Object[])null);
        Method help = c.getMethod("getShortDescription", null);
        this.help = (String)help.invoke(felixCommand, (Object[])null);
        Method usage = c.getMethod("getUsage", null);
        this.usage = (String)usage.invoke(felixCommand, (Object[])null);
    }

    public void _main(String[] argv) throws Exception {
        StringBuilder buf = new StringBuilder();
        for (String arg : argv) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(arg);
        }
        try {
            Object[] args = new Object[]{buf.toString(), System.out, System.err};
            this.execute.invoke(this.felixCommand, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
    }

    public Dictionary<String, Object> getAttributes() {
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        ((Dictionary)dict).put("osgi.command.scope", "felix");
        ((Dictionary)dict).put("osgi.command.function", this.name);
        return dict;
    }
}

