/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.commands.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CommandException;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.gogo.commands.basic.ActionPreparator;
import org.apache.felix.gogo.commands.converter.DefaultConverter;
import org.apache.felix.gogo.commands.converter.GenericType;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.ansi.SimpleAnsi;
import org.apache.karaf.shell.console.NameScoping;

@Deprecated
public class DefaultActionPreparator
implements ActionPreparator {
    public static final Option HELP = new Option(){

        @Override
        public String name() {
            return "--help";
        }

        @Override
        public String[] aliases() {
            return new String[0];
        }

        @Override
        public String description() {
            return "Display this help message";
        }

        @Override
        public boolean required() {
            return false;
        }

        @Override
        public boolean multiValued() {
            return false;
        }

        @Override
        public String valueToShowInHelp() {
            return "DEFAULT";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Option.class;
        }
    };

    @Override
    public boolean prepare(Action action, CommandSession session, List<Object> params) throws Exception {
        Command command;
        HashMap<Option, Field> options = new HashMap<Option, Field>();
        HashMap<Argument, Field> arguments = new HashMap<Argument, Field>();
        ArrayList<Argument> orderedArguments = new ArrayList<Argument>();
        for (Class<?> type = action.getClass(); type != null; type = type.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                Argument argument;
                Option option = field.getAnnotation(Option.class);
                if (option != null) {
                    options.put(option, field);
                }
                if ((argument = field.getAnnotation(Argument.class)) == null) continue;
                if ("##default".equals(argument.name())) {
                    final Argument delegate = argument;
                    final String name = field.getName();
                    argument = new Argument(){

                        @Override
                        public String name() {
                            return name;
                        }

                        @Override
                        public String description() {
                            return delegate.description();
                        }

                        @Override
                        public boolean required() {
                            return delegate.required();
                        }

                        @Override
                        public int index() {
                            return delegate.index();
                        }

                        @Override
                        public boolean multiValued() {
                            return delegate.multiValued();
                        }

                        @Override
                        public String valueToShowInHelp() {
                            return delegate.valueToShowInHelp();
                        }

                        @Override
                        public Class<? extends Annotation> annotationType() {
                            return delegate.annotationType();
                        }
                    };
                }
                arguments.put(argument, field);
                int index = argument.index();
                while (orderedArguments.size() <= index) {
                    orderedArguments.add(null);
                }
                if (orderedArguments.get(index) != null) {
                    throw new IllegalArgumentException("Duplicate argument index: " + index);
                }
                orderedArguments.set(index, argument);
            }
        }
        for (int i = 0; i < orderedArguments.size(); ++i) {
            if (orderedArguments.get(i) != null) continue;
            throw new IllegalArgumentException("Missing argument for index: " + i);
        }
        HashMap<Option, Object> optionValues = new HashMap<Option, Object>();
        HashMap<Argument, Object> argumentValues = new HashMap<Argument, Object>();
        boolean processOptions = true;
        int argIndex = 0;
        Iterator<Object> it = params.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (HELP.name().equals(object) || Arrays.asList(HELP.aliases()).contains(object)) {
                this.printUsage(session, action, options, arguments, System.out);
                return false;
            }
            if (processOptions && object instanceof String && ((String)object).startsWith("-")) {
                String name;
                boolean isKeyValuePair = ((String)object).indexOf(61) != -1;
                Object value = null;
                if (isKeyValuePair) {
                    name = ((String)object).substring(0, ((String)object).indexOf(61));
                    value = ((String)object).substring(((String)object).indexOf(61) + 1);
                } else {
                    name = (String)object;
                }
                Option option = null;
                for (Option opt : options.keySet()) {
                    if (!name.equals(opt.name()) && !Arrays.asList(opt.aliases()).contains(name)) continue;
                    option = opt;
                    break;
                }
                if (option == null) {
                    Command command2 = action.getClass().getAnnotation(Command.class);
                    if (command2 != null) {
                        throw new CommandException(SimpleAnsi.COLOR_RED + "Error executing command " + command2.scope() + ":" + SimpleAnsi.INTENSITY_BOLD + command2.name() + SimpleAnsi.INTENSITY_NORMAL + " undefined option " + SimpleAnsi.INTENSITY_BOLD + object + SimpleAnsi.INTENSITY_NORMAL + SimpleAnsi.COLOR_DEFAULT, "Undefined option: " + object);
                    }
                    throw new CommandException("Undefined option: " + object);
                }
                Field field = (Field)options.get(option);
                if (value == null && (field.getType() == Boolean.TYPE || field.getType() == Boolean.class)) {
                    value = Boolean.TRUE;
                }
                if (value == null && it.hasNext()) {
                    value = it.next();
                }
                if (value == null) {
                    Command command3 = action.getClass().getAnnotation(Command.class);
                    if (command3 != null) {
                        throw new CommandException(SimpleAnsi.COLOR_RED + "Error executing command " + command3.scope() + ":" + SimpleAnsi.INTENSITY_BOLD + command3.name() + SimpleAnsi.INTENSITY_NORMAL + " missing value for option " + SimpleAnsi.INTENSITY_BOLD + object + SimpleAnsi.INTENSITY_NORMAL + SimpleAnsi.COLOR_DEFAULT, "Missing value for option: " + object);
                    }
                    throw new CommandException("Missing value for option: " + object);
                }
                if (option.multiValued()) {
                    ArrayList<Object> l = (ArrayList<Object>)optionValues.get(option);
                    if (l == null) {
                        l = new ArrayList<Object>();
                        optionValues.put(option, l);
                    }
                    l.add(value);
                    continue;
                }
                optionValues.put(option, value);
                continue;
            }
            processOptions = false;
            if (argIndex >= orderedArguments.size()) {
                Command command4 = action.getClass().getAnnotation(Command.class);
                if (command4 != null) {
                    throw new CommandException(SimpleAnsi.COLOR_RED + "Error executing command " + command4.scope() + ":" + SimpleAnsi.INTENSITY_BOLD + command4.name() + SimpleAnsi.INTENSITY_NORMAL + ": too many arguments specified" + SimpleAnsi.INTENSITY_BOLD + object + SimpleAnsi.INTENSITY_NORMAL + SimpleAnsi.COLOR_DEFAULT, "Too many arguments specified");
                }
                throw new CommandException("Too many arguments specified");
            }
            Argument argument = (Argument)orderedArguments.get(argIndex);
            if (!argument.multiValued()) {
                ++argIndex;
            }
            if (argument.multiValued()) {
                ArrayList<Object> l = (ArrayList<Object>)argumentValues.get(argument);
                if (l == null) {
                    l = new ArrayList<Object>();
                    argumentValues.put(argument, l);
                }
                l.add(object);
                continue;
            }
            argumentValues.put(argument, object);
        }
        for (Option option : options.keySet()) {
            if (!option.required() || optionValues.get(option) != null) continue;
            Command command5 = action.getClass().getAnnotation(Command.class);
            if (command5 != null) {
                throw new CommandException(SimpleAnsi.COLOR_RED + "Error executing command " + command5.scope() + ":" + SimpleAnsi.INTENSITY_BOLD + command5.name() + SimpleAnsi.INTENSITY_NORMAL + ": option " + SimpleAnsi.INTENSITY_BOLD + option.name() + SimpleAnsi.INTENSITY_NORMAL + " is required" + SimpleAnsi.COLOR_DEFAULT, "Option " + option.name() + " is required");
            }
            throw new CommandException("Option " + option.name() + " is required");
        }
        for (Argument argument : orderedArguments) {
            if (!argument.required() || argumentValues.get(argument) != null) continue;
            Command command6 = action.getClass().getAnnotation(Command.class);
            if (command6 != null) {
                throw new CommandException(SimpleAnsi.COLOR_RED + "Error executing command " + command6.scope() + ":" + SimpleAnsi.INTENSITY_BOLD + command6.name() + SimpleAnsi.INTENSITY_NORMAL + ": argument " + SimpleAnsi.INTENSITY_BOLD + argument.name() + SimpleAnsi.INTENSITY_NORMAL + " is required" + SimpleAnsi.COLOR_DEFAULT, "Argument " + argument.name() + " is required");
            }
            throw new CommandException("Argument " + argument.name() + " is required");
        }
        for (Map.Entry entry : optionValues.entrySet()) {
            Object value;
            Field field = (Field)options.get(entry.getKey());
            try {
                value = this.convert(action, session, entry.getValue(), field.getGenericType());
            }
            catch (Exception e) {
                command = action.getClass().getAnnotation(Command.class);
                if (command != null) {
                    throw new CommandException(SimpleAnsi.COLOR_RED + "Error executing command " + command.scope() + ":" + SimpleAnsi.INTENSITY_BOLD + command.name() + SimpleAnsi.INTENSITY_NORMAL + ": unable to convert option " + SimpleAnsi.INTENSITY_BOLD + ((Option)entry.getKey()).name() + SimpleAnsi.INTENSITY_NORMAL + " with value '" + entry.getValue() + "' to type " + new GenericType(field.getGenericType()).toString() + SimpleAnsi.COLOR_DEFAULT, "Unable to convert option " + ((Option)entry.getKey()).name() + " with value '" + entry.getValue() + "' to type " + new GenericType(field.getGenericType()).toString(), e);
                }
                throw new CommandException("Unable to convert option " + ((Option)entry.getKey()).name() + " with value '" + entry.getValue() + "' to type " + new GenericType(field.getGenericType()).toString(), e);
            }
            field.setAccessible(true);
            field.set(action, value);
        }
        for (Map.Entry entry : argumentValues.entrySet()) {
            Object value;
            Field field = (Field)arguments.get(entry.getKey());
            try {
                value = this.convert(action, session, entry.getValue(), field.getGenericType());
            }
            catch (Exception e) {
                command = action.getClass().getAnnotation(Command.class);
                if (command != null) {
                    throw new CommandException(SimpleAnsi.COLOR_RED + "Error executing command " + command.scope() + ":" + SimpleAnsi.INTENSITY_BOLD + command.name() + SimpleAnsi.INTENSITY_NORMAL + ": unable to convert argument " + SimpleAnsi.INTENSITY_BOLD + ((Argument)entry.getKey()).name() + SimpleAnsi.INTENSITY_NORMAL + " with value '" + entry.getValue() + "' to type " + new GenericType(field.getGenericType()).toString() + SimpleAnsi.COLOR_DEFAULT, "Unable to convert argument " + ((Argument)entry.getKey()).name() + " with value '" + entry.getValue() + "' to type " + new GenericType(field.getGenericType()).toString(), e);
                }
                throw new CommandException("Unable to convert argument " + ((Argument)entry.getKey()).name() + " with value '" + entry.getValue() + "' to type " + new GenericType(field.getGenericType()).toString(), e);
            }
            field.setAccessible(true);
            field.set(action, value);
        }
        return true;
    }

    protected void printUsage(CommandSession session, Action action, Map<Option, Field> optionsMap, Map<Argument, Field> argsMap, PrintStream out) {
        Command command = action.getClass().getAnnotation(Command.class);
        if (command != null) {
            ArrayList<Argument> arguments = new ArrayList<Argument>(argsMap.keySet());
            Collections.sort(arguments, new Comparator<Argument>(){

                @Override
                public int compare(Argument o1, Argument o2) {
                    return Integer.valueOf(o1.index()).compareTo(o2.index());
                }
            });
            HashSet<Option> options = new HashSet<Option>(optionsMap.keySet());
            options.add(HELP);
            boolean globalScope = NameScoping.isGlobalScope(session, command.scope());
            if (command != null && (command.description() != null || command.name() != null)) {
                out.println(SimpleAnsi.INTENSITY_BOLD + "DESCRIPTION" + SimpleAnsi.INTENSITY_NORMAL);
                out.print("        ");
                if (command.name() != null) {
                    if (globalScope) {
                        out.println(SimpleAnsi.INTENSITY_BOLD + command.name() + SimpleAnsi.INTENSITY_NORMAL);
                    } else {
                        out.println(command.scope() + ":" + SimpleAnsi.INTENSITY_BOLD + command.name() + SimpleAnsi.INTENSITY_NORMAL);
                    }
                    out.println();
                }
                out.print("\t");
                out.println(command.description());
                out.println();
            }
            StringBuffer syntax = new StringBuffer();
            if (command != null) {
                if (globalScope) {
                    syntax.append(command.name());
                } else {
                    syntax.append(String.format("%s:%s", command.scope(), command.name()));
                }
            }
            if (options.size() > 0) {
                syntax.append(" [options]");
            }
            if (arguments.size() > 0) {
                syntax.append(' ');
                for (Argument argument : arguments) {
                    if (!argument.required()) {
                        syntax.append(String.format("[%s] ", argument.name()));
                        continue;
                    }
                    syntax.append(String.format("%s ", argument.name()));
                }
            }
            int width = this.getWidth(session);
            out.println(SimpleAnsi.INTENSITY_BOLD + "SYNTAX" + SimpleAnsi.INTENSITY_NORMAL);
            out.print("        ");
            out.println(syntax.toString());
            out.println();
            if (arguments.size() > 0) {
                out.println(SimpleAnsi.INTENSITY_BOLD + "ARGUMENTS" + SimpleAnsi.INTENSITY_NORMAL);
                for (Argument argument : arguments) {
                    out.print("        ");
                    out.println(SimpleAnsi.INTENSITY_BOLD + argument.name() + SimpleAnsi.INTENSITY_NORMAL);
                    DefaultActionPreparator.printFormatted("                ", argument.description(), width, out);
                    if (argument.required() || argument.valueToShowInHelp() == null || argument.valueToShowInHelp().length() == 0) continue;
                    try {
                        if ("DEFAULT".equals(argument.valueToShowInHelp())) {
                            argsMap.get(argument).setAccessible(true);
                            Object o = argsMap.get(argument).get(action);
                            this.printObjectDefaultsTo(out, o);
                            continue;
                        }
                        this.printDefaultsTo(out, argument.valueToShowInHelp());
                    }
                    catch (Throwable t) {}
                }
                out.println();
            }
            if (options.size() > 0) {
                out.println(SimpleAnsi.INTENSITY_BOLD + "OPTIONS" + SimpleAnsi.INTENSITY_NORMAL);
                for (Option option : options) {
                    String opt = option.name();
                    for (String alias : option.aliases()) {
                        opt = opt + ", " + alias;
                    }
                    out.print("        ");
                    out.println(SimpleAnsi.INTENSITY_BOLD + opt + SimpleAnsi.INTENSITY_NORMAL);
                    DefaultActionPreparator.printFormatted("                ", option.description(), width, out);
                    if (option.valueToShowInHelp() == null || option.valueToShowInHelp().length() == 0) continue;
                    try {
                        if ("DEFAULT".equals(option.valueToShowInHelp())) {
                            optionsMap.get(option).setAccessible(true);
                            Object o = optionsMap.get(option).get(action);
                            this.printObjectDefaultsTo(out, o);
                            continue;
                        }
                        this.printDefaultsTo(out, option.valueToShowInHelp());
                    }
                    catch (Throwable t) {}
                }
                out.println();
            }
            if (command.detailedDescription().length() > 0) {
                out.println(SimpleAnsi.INTENSITY_BOLD + "DETAILS" + SimpleAnsi.INTENSITY_NORMAL);
                String desc = this.loadDescription(action.getClass(), command.detailedDescription());
                DefaultActionPreparator.printFormatted("        ", desc, width, out);
            }
        }
    }

    private void printObjectDefaultsTo(PrintStream out, Object o) {
        if (!(o == null || o instanceof Boolean && !((Boolean)o).booleanValue() || o instanceof Number && ((Number)o).doubleValue() == 0.0)) {
            this.printDefaultsTo(out, o.toString());
        }
    }

    private void printDefaultsTo(PrintStream out, String value) {
        out.print("                (defaults to ");
        out.print(value);
        out.println(")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadDescription(Class clazz, String desc) {
        if (desc.startsWith("classpath:")) {
            InputStream is = clazz.getResourceAsStream(desc.substring("classpath:".length()));
            if (is == null) {
                is = clazz.getClassLoader().getResourceAsStream(desc.substring("classpath:".length()));
            }
            if (is == null) {
                desc = "Unable to load description from " + desc;
            } else {
                try {
                    int c;
                    InputStreamReader r = new InputStreamReader(is);
                    StringWriter sw = new StringWriter();
                    while ((c = ((Reader)r).read()) != -1) {
                        sw.append((char)c);
                    }
                    desc = sw.toString();
                }
                catch (IOException e) {
                    desc = "Unable to load description from " + desc;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return desc;
    }

    public static void printFormatted(String prefix, String str, int termWidth, PrintStream out) {
        DefaultActionPreparator.printFormatted(prefix, str, termWidth, out, true);
    }

    public static void printFormatted(String prefix, String str, int termWidth, PrintStream out, boolean prefixFirstLine) {
        int pfxLen = DefaultActionPreparator.length(prefix);
        int maxwidth = termWidth - pfxLen;
        Pattern wrap = Pattern.compile("(\\S\\S{" + maxwidth + ",}|.{1," + maxwidth + "})(\\s+|$)");
        int cur = 0;
        while (cur >= 0) {
            String s;
            int lst = str.indexOf(10, cur);
            String string = s = lst >= 0 ? str.substring(cur, lst) : str.substring(cur);
            if (s.length() == 0) {
                out.println();
            } else {
                Matcher m = wrap.matcher(s);
                while (m.find()) {
                    if (cur > 0 || prefixFirstLine) {
                        out.print(prefix);
                    }
                    out.println(m.group());
                }
            }
            if (lst < 0) break;
            cur = lst + 1;
        }
    }

    public static int length(String str) {
        return str.length();
    }

    protected Object convert(Action action, CommandSession session, Object value, Type toType) throws Exception {
        if (toType == String.class) {
            return value != null ? value.toString() : null;
        }
        return new DefaultConverter(action.getClass().getClassLoader()).convert(value, toType);
    }

    private int getWidth(CommandSession session) {
        Object cols = session.get("COLUMNS");
        return cols != null && cols instanceof Integer ? (Integer)cols : 80;
    }
}

