/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.compat;

import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Parser;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.CommandWithAction;
import org.apache.karaf.shell.compat.ArgumentCompleter;
import org.apache.karaf.shell.compat.OldArgumentCompleter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class CommandTracker
implements ServiceTrackerCustomizer<Object, Object> {
    SessionFactory sessionFactory;
    BundleContext context;
    ServiceTracker<?, ?> tracker;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setContext(BundleContext context) {
        this.context = context;
    }

    public void init() throws Exception {
        Filter filter = this.context.createFilter(String.format("(&(%s=*)(%s=*))", "osgi.command.scope", "osgi.command.function"));
        this.tracker = new ServiceTracker(this.context, filter, (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    public void destroy() {
        this.tracker.close();
    }

    public Object addingService(final ServiceReference reference) {
        Object service = this.context.getService(reference);
        if (service instanceof CommandWithAction) {
            final CommandWithAction oldCommand = (CommandWithAction)service;
            org.apache.karaf.shell.api.console.Command command = new org.apache.karaf.shell.api.console.Command(){

                public String getScope() {
                    return reference.getProperty("osgi.command.scope").toString();
                }

                public String getName() {
                    return reference.getProperty("osgi.command.function").toString();
                }

                public String getDescription() {
                    Command cmd = oldCommand.getActionClass().getAnnotation(Command.class);
                    if (cmd != null) {
                        return cmd.description();
                    }
                    return this.getName();
                }

                public Completer getCompleter(boolean scoped) {
                    final ArgumentCompleter completer = new ArgumentCompleter(oldCommand, this.getScope(), this.getName(), scoped);
                    return new Completer(){

                        public int complete(Session session, CommandLine commandLine, List<String> candidates) {
                            return completer.complete(session, commandLine, candidates);
                        }
                    };
                }

                public Parser getParser() {
                    return null;
                }

                public Object execute(Session session, List<Object> arguments) throws Exception {
                    CommandSession commandSession = (CommandSession)session.get(".commandSession");
                    return oldCommand.execute(commandSession, arguments);
                }
            };
            this.sessionFactory.getRegistry().register((Object)command);
            return command;
        }
        if (service instanceof org.apache.felix.gogo.commands.CommandWithAction) {
            final org.apache.felix.gogo.commands.CommandWithAction oldCommand = (org.apache.felix.gogo.commands.CommandWithAction)service;
            org.apache.karaf.shell.api.console.Command command = new org.apache.karaf.shell.api.console.Command(){

                public String getScope() {
                    return reference.getProperty("osgi.command.scope").toString();
                }

                public String getName() {
                    return reference.getProperty("osgi.command.function").toString();
                }

                public String getDescription() {
                    org.apache.felix.gogo.commands.Command cmd = oldCommand.getActionClass().getAnnotation(org.apache.felix.gogo.commands.Command.class);
                    if (cmd != null) {
                        return cmd.description();
                    }
                    return this.getName();
                }

                public Completer getCompleter(boolean scoped) {
                    final OldArgumentCompleter completer = new OldArgumentCompleter(oldCommand, this.getScope(), this.getName(), scoped);
                    return new Completer(){

                        public int complete(Session session, CommandLine commandLine, List<String> candidates) {
                            return completer.complete(session, commandLine, candidates);
                        }
                    };
                }

                public Parser getParser() {
                    return null;
                }

                public Object execute(Session session, List<Object> arguments) throws Exception {
                    CommandSession commandSession = (CommandSession)session.get(".commandSession");
                    return oldCommand.execute(commandSession, arguments);
                }
            };
            this.sessionFactory.getRegistry().register((Object)command);
            return command;
        }
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        if (service instanceof org.apache.karaf.shell.api.console.Command) {
            this.sessionFactory.getRegistry().unregister(service);
        }
        this.context.ungetService(reference);
    }
}

