/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.completer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.gogo.runtime.CommandProxy;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.commands.CommandWithAction;
import org.apache.karaf.shell.console.CommandSessionHolder;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.AggregateCompleter;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.karaf.shell.console.completer.OldArgumentCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CommandsCompleter
implements Completer {
    public static final String COMMANDS = ".commands";
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandsCompleter.class);
    private CommandSession session;
    private final Map<String, Completer> globalCompleters = new HashMap<String, Completer>();
    private final Map<String, Completer> localCompleters = new HashMap<String, Completer>();
    private final Set<String> commands = new HashSet<String>();

    public CommandsCompleter() {
        this(CommandSessionHolder.getSession());
    }

    public CommandsCompleter(CommandSession session) {
        this.session = session;
        try {
            new CommandTracker();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int complete(String buffer, int cursor, List<String> candidates) {
        if (this.session == null) {
            this.session = CommandSessionHolder.getSession();
        }
        List<String> scopes = this.getCurrentScopes();
        Map<String, Completer>[] allCompleters = this.checkData();
        this.sort(allCompleters, scopes);
        String subShell = this.getCurrentSubShell();
        String completion = this.getCompletionType();
        if ("SUBSHELL".equalsIgnoreCase(completion)) {
            if (subShell.isEmpty()) {
                subShell = "*";
            }
            ArrayList<Completer> completers = new ArrayList<Completer>();
            for (String name : allCompleters[1].keySet()) {
                if (!name.startsWith(subShell + ":")) continue;
                completers.add(allCompleters[1].get(name));
            }
            if (!subShell.equals("*")) {
                completers.add(new StringsCompleter(new String[]{"exit"}));
            }
            int res = new AggregateCompleter(completers).complete(buffer, cursor, (List)candidates);
            Collections.sort(candidates);
            return res;
        }
        if ("FIRST".equalsIgnoreCase(completion)) {
            int res;
            if (!subShell.isEmpty()) {
                ArrayList<Completer> completers = new ArrayList<Completer>();
                for (String name : allCompleters[1].keySet()) {
                    if (!name.startsWith(subShell + ":")) continue;
                    completers.add(allCompleters[1].get(name));
                }
                res = new AggregateCompleter(completers).complete(buffer, cursor, (List)candidates);
                if (!candidates.isEmpty()) {
                    Collections.sort(candidates);
                    return res;
                }
            }
            ArrayList<Completer> compl = new ArrayList<Completer>();
            compl.add(new StringsCompleter(this.getAliases()));
            compl.addAll(allCompleters[0].values());
            res = new AggregateCompleter(compl).complete(buffer, cursor, (List)candidates);
            Collections.sort(candidates);
            return res;
        }
        ArrayList<Completer> compl = new ArrayList<Completer>();
        compl.add(new StringsCompleter(this.getAliases()));
        compl.addAll(allCompleters[0].values());
        int res = new AggregateCompleter(compl).complete(buffer, cursor, (List)candidates);
        Collections.sort(candidates);
        return res;
    }

    protected void sort(Map<String, Completer>[] completers, List<String> scopes) {
        ScopeComparator comparator = new ScopeComparator(scopes);
        for (int i = 0; i < completers.length; ++i) {
            TreeMap<String, Completer> map = new TreeMap<String, Completer>(comparator);
            map.putAll(completers[i]);
            completers[i] = map;
        }
    }

    protected List<String> getCurrentScopes() {
        String scopes = (String)this.session.get("SCOPE");
        return Arrays.asList(scopes.split(":"));
    }

    protected String getCurrentSubShell() {
        String s = (String)this.session.get("SUBSHELL");
        if (s == null) {
            s = "";
        }
        return s;
    }

    protected String getCompletionType() {
        String completion = (String)this.session.get("karaf.completionMode");
        if (completion == null) {
            completion = "GLOBAL";
        }
        return completion;
    }

    protected String stripScope(String name) {
        int index = name.indexOf(":");
        return index > 0 ? name.substring(index + 1) : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Completer>[] checkData() {
        boolean update;
        HashSet names;
        CommandsCompleter commandsCompleter = this;
        synchronized (commandsCompleter) {
            names = new HashSet((Set)this.session.get(COMMANDS));
            update = !names.equals(this.commands);
        }
        if (update) {
            HashSet<String> commands = new HashSet<String>();
            HashMap<String, Completer> global = new HashMap<String, Completer>();
            HashMap<String, Completer> local = new HashMap<String, Completer>();
            for (String command : names) {
                String rawCommand = this.stripScope(command);
                Function function = (Function)this.session.get(command);
                if ((function = CommandsCompleter.unProxy(function)) instanceof CommandWithAction) {
                    try {
                        global.put(command, new ArgumentCompleter(this.session, (CommandWithAction)function, command));
                        local.put(command, new ArgumentCompleter(this.session, (CommandWithAction)function, rawCommand));
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Unable to create completers for command '" + command + "'", t);
                    }
                } else if (function instanceof org.apache.felix.gogo.commands.CommandWithAction) {
                    try {
                        global.put(command, new OldArgumentCompleter(this.session, (org.apache.felix.gogo.commands.CommandWithAction)function, command));
                        local.put(command, new OldArgumentCompleter(this.session, (org.apache.felix.gogo.commands.CommandWithAction)function, rawCommand));
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Unable to create completers for command '" + command + "'", t);
                    }
                }
                commands.add(command);
            }
            CommandsCompleter commandsCompleter2 = this;
            synchronized (commandsCompleter2) {
                this.commands.clear();
                this.globalCompleters.clear();
                this.localCompleters.clear();
                this.commands.addAll(commands);
                this.globalCompleters.putAll(global);
                this.localCompleters.putAll(local);
            }
        }
        commandsCompleter = this;
        synchronized (commandsCompleter) {
            return new Map[]{new HashMap<String, Completer>(this.globalCompleters), new HashMap<String, Completer>(this.localCompleters)};
        }
    }

    private Set<String> getAliases() {
        Set vars = (Set)this.session.get(null);
        HashSet<String> aliases = new HashSet<String>();
        for (String var : vars) {
            Object content = this.session.get(var);
            if (content == null || !"org.apache.felix.gogo.runtime.Closure".equals(content.getClass().getName())) continue;
            aliases.add(var);
        }
        return aliases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Function unProxy(Function function) {
        if (function == null || function.getClass() != CommandProxy.class) {
            return function;
        }
        CommandProxy proxy = (CommandProxy)function;
        Object target = proxy.getTarget();
        try {
            Function function2 = target instanceof Function ? (Function)target : function;
            return function2;
        }
        finally {
            proxy.ungetTarget();
        }
    }

    private class CommandTracker {
        public CommandTracker() throws Exception {
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            if (context == null) {
                throw new IllegalStateException("Bundle is stopped");
            }
            ServiceListener listener = new ServiceListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void serviceChanged(ServiceEvent event) {
                    CommandsCompleter commandsCompleter = CommandsCompleter.this;
                    synchronized (commandsCompleter) {
                        CommandsCompleter.this.commands.clear();
                    }
                }
            };
            context.addServiceListener(listener, String.format("(&(%s=*)(%s=*))", "osgi.command.scope", "osgi.command.function"));
        }
    }

    protected static class ScopeComparator
    implements Comparator<String> {
        private final List<String> scopes;

        public ScopeComparator(List<String> scopes) {
            this.scopes = scopes;
        }

        @Override
        public int compare(String o1, String o2) {
            String[] p1 = o1.split(":");
            String[] p2 = o2.split(":");
            int p = 0;
            while (p < p1.length && p < p2.length) {
                int i1 = this.scopes.indexOf(p1[p]);
                int i2 = this.scopes.indexOf(p2[p]);
                if (i1 < 0) {
                    if (i2 < 0) {
                        int c = p1[p].compareTo(p2[p]);
                        if (c != 0) {
                            return c;
                        }
                        ++p;
                        continue;
                    }
                    return 1;
                }
                if (i2 < 0) {
                    return -1;
                }
                if (i1 < i2) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                ++p;
            }
            return 0;
        }
    }
}

