/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tools.utils.model.io.stax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.karaf.tools.utils.model.KarafPropertyEdit;
import org.apache.karaf.tools.utils.model.KarafPropertyEdits;
import org.apache.karaf.tools.utils.model.Operation;
import org.apache.karaf.tools.utils.model.io.stax.IndentingXMLStreamWriter;

public class KarafPropertyInstructionsModelStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, KarafPropertyEdits karafPropertyEdits) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(karafPropertyEdits.getModelEncoding(), "1.0");
        this.writeKarafPropertyEdits(karafPropertyEdits, "property-edits", serializer);
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, KarafPropertyEdits karafPropertyEdits) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, karafPropertyEdits.getModelEncoding()));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(karafPropertyEdits.getModelEncoding(), "1.0");
        this.writeKarafPropertyEdits(karafPropertyEdits, "property-edits", serializer);
        serializer.writeEndDocument();
    }

    private void writeKarafPropertyEdit(KarafPropertyEdit karafPropertyEdit, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (karafPropertyEdit != null) {
            serializer.writeStartElement(tagName);
            if (karafPropertyEdit.getOperation() != null) {
                this.writeOperation(karafPropertyEdit.getOperation(), "operation", serializer);
            }
            if (karafPropertyEdit.getFile() != null) {
                serializer.writeStartElement("file");
                serializer.writeCharacters(karafPropertyEdit.getFile());
                serializer.writeEndElement();
            }
            if (karafPropertyEdit.getKey() != null) {
                serializer.writeStartElement("key");
                serializer.writeCharacters(karafPropertyEdit.getKey());
                serializer.writeEndElement();
            }
            if (karafPropertyEdit.getValue() != null) {
                serializer.writeStartElement("value");
                serializer.writeCharacters(karafPropertyEdit.getValue());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeKarafPropertyEdits(KarafPropertyEdits karafPropertyEdits, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (karafPropertyEdits != null) {
            serializer.setDefaultNamespace("http://karaf.apache.org/tools/property-edits/1.0.0");
            serializer.writeStartElement(tagName);
            serializer.writeDefaultNamespace("http://karaf.apache.org/tools/property-edits/1.0.0");
            serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://karaf.apache.org/tools/property-edits/1.0.0 http://karaf.apache.org/xsd/property-edits-1.0.0.xsd");
            if (karafPropertyEdits.getEdits() != null && karafPropertyEdits.getEdits().size() > 0) {
                serializer.writeStartElement("edits");
                for (KarafPropertyEdit o : karafPropertyEdits.getEdits()) {
                    this.writeKarafPropertyEdit(o, "edit", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeOperation(Operation operation, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (operation != null) {
            serializer.writeStartElement(tagName);
            if (operation.isPrepend()) {
                serializer.writeAttribute("prepend", String.valueOf(operation.isPrepend()));
            }
            serializer.writeCharacters(operation.getOperation());
            serializer.writeEndElement();
        }
    }
}

