/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client.request;

import java.io.File;
import java.io.IOException;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.KrbContext;
import org.apache.kerby.kerberos.kerb.client.KrbOption;
import org.apache.kerby.kerberos.kerb.client.request.AsRequest;
import org.apache.kerby.kerberos.kerb.keytab.Keytab;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataType;

public class AsRequestWithKeytab
extends AsRequest {
    public AsRequestWithKeytab(KrbContext context) {
        super(context);
        this.setAllowedPreauth(PaDataType.ENC_TIMESTAMP);
    }

    private Keytab getKeytab() {
        File keytabFile = null;
        KOptions kOptions = this.getRequestOptions();
        if (kOptions.contains((KOption)KrbOption.KEYTAB_FILE)) {
            keytabFile = kOptions.getFileOption((KOption)KrbOption.KEYTAB_FILE);
        }
        Keytab keytab = null;
        try {
            keytab = Keytab.loadKeytab((File)keytabFile);
        }
        catch (IOException e) {
            System.err.println("Can not load keytab from file" + keytabFile.getAbsolutePath());
        }
        return keytab;
    }

    @Override
    public EncryptionKey getClientKey() throws KrbException {
        if (super.getClientKey() == null) {
            EncryptionKey tmpKey = this.getKeytab().getKey(this.getClientPrincipal(), this.getChosenEncryptionType());
            this.setClientKey(tmpKey);
        }
        return super.getClientKey();
    }
}

