/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.type.kdc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.ExplicitField;
import org.apache.kerby.asn1.type.Asn1Integer;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.type.KerberosString;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.KrbIntegers;
import org.apache.kerby.kerberos.kerb.type.KrbSequenceType;
import org.apache.kerby.kerberos.kerb.type.ad.AuthorizationData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.HostAddresses;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcOptions;
import org.apache.kerby.kerberos.kerb.type.ticket.Tickets;

public class KdcReqBody
extends KrbSequenceType {
    static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField((EnumType)KdcReqBodyField.KDC_OPTIONS, KdcOptions.class), new ExplicitField((EnumType)KdcReqBodyField.CNAME, PrincipalName.class), new ExplicitField((EnumType)KdcReqBodyField.REALM, KerberosString.class), new ExplicitField((EnumType)KdcReqBodyField.SNAME, PrincipalName.class), new ExplicitField((EnumType)KdcReqBodyField.FROM, KerberosTime.class), new ExplicitField((EnumType)KdcReqBodyField.TILL, KerberosTime.class), new ExplicitField((EnumType)KdcReqBodyField.RTIME, KerberosTime.class), new ExplicitField((EnumType)KdcReqBodyField.NONCE, Asn1Integer.class), new ExplicitField((EnumType)KdcReqBodyField.ETYPE, KrbIntegers.class), new ExplicitField((EnumType)KdcReqBodyField.ADDRESSES, HostAddresses.class), new ExplicitField((EnumType)KdcReqBodyField.ENC_AUTHORIZATION_DATA, EncryptedData.class), new ExplicitField((EnumType)KdcReqBodyField.ADDITIONAL_TICKETS, Tickets.class)};
    private AuthorizationData authorizationData;

    public KdcReqBody() {
        super(fieldInfos);
    }

    public KerberosTime getFrom() {
        return (KerberosTime)this.getFieldAs(KdcReqBodyField.FROM, KerberosTime.class);
    }

    public void setFrom(KerberosTime from) {
        this.setFieldAs(KdcReqBodyField.FROM, (Asn1Type)from);
    }

    public KerberosTime getTill() {
        return (KerberosTime)this.getFieldAs(KdcReqBodyField.TILL, KerberosTime.class);
    }

    public void setTill(KerberosTime till) {
        this.setFieldAs(KdcReqBodyField.TILL, (Asn1Type)till);
    }

    public KerberosTime getRtime() {
        return (KerberosTime)this.getFieldAs(KdcReqBodyField.RTIME, KerberosTime.class);
    }

    public void setRtime(KerberosTime rtime) {
        this.setFieldAs(KdcReqBodyField.RTIME, (Asn1Type)rtime);
    }

    public int getNonce() {
        return this.getFieldAsInt(KdcReqBodyField.NONCE);
    }

    public void setNonce(int nonce) {
        this.setFieldAsInt(KdcReqBodyField.NONCE, nonce);
    }

    public List<EncryptionType> getEtypes() {
        KrbIntegers values = (KrbIntegers)this.getFieldAs(KdcReqBodyField.ETYPE, KrbIntegers.class);
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<EncryptionType> results = new ArrayList<EncryptionType>();
        for (Integer value : values.getValues()) {
            results.add(EncryptionType.fromValue(value));
        }
        return results;
    }

    public void setEtypes(List<EncryptionType> etypes) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (EncryptionType etype : etypes) {
            values.add(etype.getValue());
        }
        KrbIntegers value = new KrbIntegers(values);
        this.setFieldAs(KdcReqBodyField.ETYPE, (Asn1Type)value);
    }

    public HostAddresses getAddresses() {
        return (HostAddresses)this.getFieldAs(KdcReqBodyField.ADDRESSES, HostAddresses.class);
    }

    public void setAddresses(HostAddresses addresses) {
        this.setFieldAs(KdcReqBodyField.ADDRESSES, (Asn1Type)addresses);
    }

    public EncryptedData getEncryptedAuthorizationData() {
        return (EncryptedData)this.getFieldAs(KdcReqBodyField.ENC_AUTHORIZATION_DATA, EncryptedData.class);
    }

    public void setEncryptedAuthorizationData(EncryptedData encAuthorizationData) {
        this.setFieldAs(KdcReqBodyField.ENC_AUTHORIZATION_DATA, (Asn1Type)encAuthorizationData);
    }

    public AuthorizationData getAuthorizationData() {
        return this.authorizationData;
    }

    public void setAuthorizationData(AuthorizationData authorizationData) {
        this.authorizationData = authorizationData;
    }

    public Tickets getAdditionalTickets() {
        return (Tickets)this.getFieldAs(KdcReqBodyField.ADDITIONAL_TICKETS, Tickets.class);
    }

    public void setAdditionalTickets(Tickets additionalTickets) {
        this.setFieldAs(KdcReqBodyField.ADDITIONAL_TICKETS, (Asn1Type)additionalTickets);
    }

    public KdcOptions getKdcOptions() {
        return (KdcOptions)this.getFieldAs(KdcReqBodyField.KDC_OPTIONS, KdcOptions.class);
    }

    public void setKdcOptions(KdcOptions kdcOptions) {
        this.setFieldAs(KdcReqBodyField.KDC_OPTIONS, (Asn1Type)kdcOptions);
    }

    public PrincipalName getSname() {
        return (PrincipalName)this.getFieldAs(KdcReqBodyField.SNAME, PrincipalName.class);
    }

    public void setSname(PrincipalName sname) {
        this.setFieldAs(KdcReqBodyField.SNAME, (Asn1Type)sname);
    }

    public PrincipalName getCname() {
        return (PrincipalName)this.getFieldAs(KdcReqBodyField.CNAME, PrincipalName.class);
    }

    public void setCname(PrincipalName cname) {
        this.setFieldAs(KdcReqBodyField.CNAME, (Asn1Type)cname);
    }

    public String getRealm() {
        return this.getFieldAsString(KdcReqBodyField.REALM);
    }

    public void setRealm(String realm) {
        this.setFieldAs(KdcReqBodyField.REALM, (Asn1Type)new KerberosString(realm));
    }

    protected static enum KdcReqBodyField implements EnumType
    {
        KDC_OPTIONS,
        CNAME,
        REALM,
        SNAME,
        FROM,
        TILL,
        RTIME,
        NONCE,
        ETYPE,
        ADDRESSES,
        ENC_AUTHORIZATION_DATA,
        ADDITIONAL_TICKETS;


        public int getValue() {
            return this.ordinal();
        }

        public String getName() {
            return this.name();
        }
    }
}

