/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.Schema;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.GetTableSchemaResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.master.Master;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.protobuf.ByteString;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class GetTableSchemaRequest
extends KuduRpc<GetTableSchemaResponse> {
    private final String id;
    private final String name;

    GetTableSchemaRequest(KuduTable masterTable, String id, String name) {
        super(masterTable);
        Preconditions.checkArgument(id != null ^ name != null, "Only one of table ID or the table name should be provided");
        this.id = id;
        this.name = name;
    }

    @Override
    Message createRequestPB() {
        Master.GetTableSchemaRequestPB.Builder builder = Master.GetTableSchemaRequestPB.newBuilder();
        Master.TableIdentifierPB.Builder identifierBuilder = Master.TableIdentifierPB.newBuilder();
        if (this.id != null) {
            identifierBuilder.setTableId(ByteString.copyFromUtf8(this.id));
        } else {
            Preconditions.checkNotNull(this.name);
            identifierBuilder.setTableName(this.name);
        }
        builder.setTable(identifierBuilder.build());
        return builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return "GetTableSchema";
    }

    @Override
    Pair<GetTableSchemaResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.GetTableSchemaResponsePB.Builder respBuilder = Master.GetTableSchemaResponsePB.newBuilder();
        GetTableSchemaRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        Schema schema = ProtobufHelper.pbToSchema(respBuilder.getSchema());
        GetTableSchemaResponse response = new GetTableSchemaResponse(this.deadlineTracker.getElapsedMillis(), tsUUID, schema, respBuilder.getTableId().toStringUtf8(), ProtobufHelper.pbToPartitionSchema(respBuilder.getPartitionSchema(), schema));
        return new Pair<GetTableSchemaResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

