/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.io.ByteStreamLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class LoggerInputStream
extends FilterInputStream {
    private static final String FQCN = LoggerInputStream.class.getName();
    private final String fqcn;
    private final ByteStreamLogger logger;

    protected LoggerInputStream(InputStream in, Charset charset, ExtendedLogger logger, String fqcn, Level level, Marker marker) {
        super(in);
        this.logger = new ByteStreamLogger(logger, level, marker, charset);
        this.fqcn = fqcn == null ? FQCN : fqcn;
    }

    @Override
    public void close() throws IOException {
        this.logger.close(this.fqcn);
        super.close();
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        this.logger.put(this.fqcn, b);
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        this.logger.put(this.fqcn, b, off, bytesRead);
        return bytesRead;
    }

    public String toString() {
        return LoggerInputStream.class.getSimpleName() + "{stream=" + this.in + '}';
    }
}

