/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.nosql.appender.couchdb;

import java.lang.reflect.Method;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.NameUtil;
import org.apache.logging.log4j.nosql.appender.NoSqlProvider;
import org.apache.logging.log4j.nosql.appender.couchdb.CouchDbConnection;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;
import org.lightcouch.CouchDbClient;
import org.lightcouch.CouchDbProperties;

@Plugin(name="CouchDB", category="Core", printObject=true)
public final class CouchDbProvider
implements NoSqlProvider<CouchDbConnection> {
    private static final int HTTP = 80;
    private static final int HTTPS = 443;
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final CouchDbClient client;
    private final String description;

    private CouchDbProvider(CouchDbClient client, String description) {
        this.client = client;
        this.description = "couchDb{ " + description + " }";
    }

    @Override
    public CouchDbConnection getConnection() {
        return new CouchDbConnection(this.client);
    }

    @Override
    public String toString() {
        return this.description;
    }

    @PluginFactory
    public static CouchDbProvider createNoSqlProvider(@PluginAttribute(value="databaseName") String databaseName, @PluginAttribute(value="protocol") String protocol, @PluginAttribute(value="server") String server, @PluginAttribute(value="port") String port, @PluginAttribute(value="username") String username, @PluginAttribute(value="password", sensitive=true) String password, @PluginAttribute(value="factoryClassName") String factoryClassName, @PluginAttribute(value="factoryMethodName") String factoryMethodName) {
        String description;
        CouchDbClient client;
        block15: {
            if (factoryClassName != null && factoryClassName.length() > 0 && factoryMethodName != null && factoryMethodName.length() > 0) {
                Object object;
                block16: {
                    Class factoryClass = Loader.loadClass((String)factoryClassName);
                    Method method = factoryClass.getMethod(factoryMethodName, new Class[0]);
                    object = method.invoke(null, new Object[0]);
                    if (object instanceof CouchDbClient) {
                        client = (CouchDbClient)object;
                        description = "uri=" + client.getDBUri();
                        break block15;
                    }
                    if (object instanceof CouchDbProperties) {
                        CouchDbProperties properties = (CouchDbProperties)object;
                        client = new CouchDbClient(properties);
                        description = "uri=" + client.getDBUri() + ", username=" + properties.getUsername() + ", passwordHash=" + NameUtil.md5((String)(String.valueOf(password) + CouchDbProvider.class.getName())) + ", maxConnections=" + properties.getMaxConnections() + ", connectionTimeout=" + properties.getConnectionTimeout() + ", socketTimeout=" + properties.getSocketTimeout();
                        break block15;
                    }
                    if (object != null) break block16;
                    LOGGER.error("The factory method [{}.{}()] returned null.", new Object[]{factoryClassName, factoryMethodName});
                    return null;
                }
                try {
                    LOGGER.error("The factory method [{}.{}()] returned an unsupported type [{}].", new Object[]{factoryClassName, factoryMethodName, object.getClass().getName()});
                    return null;
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("The factory class [{}] could not be loaded.", new Object[]{factoryClassName, e});
                    return null;
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error("The factory class [{}] does not have a no-arg method named [{}].", new Object[]{factoryClassName, factoryMethodName, e});
                    return null;
                }
                catch (Exception e) {
                    LOGGER.error("The factory method [{}.{}()] could not be invoked.", new Object[]{factoryClassName, factoryMethodName, e});
                    return null;
                }
            }
            if (databaseName != null && databaseName.length() > 0) {
                if (protocol != null && protocol.length() > 0) {
                    if (!(protocol = protocol.toLowerCase()).equals("http") && !protocol.equals("https")) {
                        LOGGER.error("Only protocols [http] and [https] are supported, [{}] specified.", new Object[]{protocol});
                        return null;
                    }
                } else {
                    protocol = "http";
                    LOGGER.warn("No protocol specified, using default port [http].");
                }
                int portInt = AbstractAppender.parseInt((String)port, (int)(protocol.equals("https") ? 443 : 80));
                if (Strings.isEmpty((CharSequence)server)) {
                    server = "localhost";
                    LOGGER.warn("No server specified, using default server localhost.");
                }
                if (Strings.isEmpty((CharSequence)username) || Strings.isEmpty((CharSequence)password)) {
                    LOGGER.error("You must provide a username and password for the CouchDB provider.");
                    return null;
                }
                client = new CouchDbClient(databaseName, false, protocol, server, portInt, username, password);
                description = "uri=" + client.getDBUri() + ", username=" + username + ", passwordHash=" + NameUtil.md5((String)(String.valueOf(password) + CouchDbProvider.class.getName()));
            } else {
                LOGGER.error("No factory method was provided so the database name is required.");
                return null;
            }
        }
        return new CouchDbProvider(client, description);
    }
}

