/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.nosql.appender.mongodb;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.NameUtil;
import org.apache.logging.log4j.nosql.appender.NoSqlProvider;
import org.apache.logging.log4j.nosql.appender.mongodb.MongoDbConnection;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="MongoDb", category="Core", printObject=true)
public final class MongoDbProvider
implements NoSqlProvider<MongoDbConnection> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String collectionName;
    private final DB database;
    private final String description;
    private final WriteConcern writeConcern;

    private MongoDbProvider(DB database, WriteConcern writeConcern, String collectionName, String description) {
        this.database = database;
        this.writeConcern = writeConcern;
        this.collectionName = collectionName;
        this.description = "mongoDb{ " + description + " }";
    }

    @Override
    public MongoDbConnection getConnection() {
        return new MongoDbConnection(this.database, this.writeConcern, this.collectionName);
    }

    @Override
    public String toString() {
        return this.description;
    }

    @PluginFactory
    public static MongoDbProvider createNoSqlProvider(@PluginAttribute(value="collectionName") String collectionName, @PluginAttribute(value="writeConcernConstant") String writeConcernConstant, @PluginAttribute(value="writeConcernConstantClass") String writeConcernConstantClassName, @PluginAttribute(value="databaseName") String databaseName, @PluginAttribute(value="server") String server, @PluginAttribute(value="port") String port, @PluginAttribute(value="username") String username, @PluginAttribute(value="password", sensitive=true) String password, @PluginAttribute(value="factoryClassName") String factoryClassName, @PluginAttribute(value="factoryMethodName") String factoryMethodName) {
        WriteConcern writeConcern;
        String description;
        DB database;
        if (factoryClassName != null && factoryClassName.length() > 0 && factoryMethodName != null && factoryMethodName.length() > 0) {
            block29: {
                Object object;
                block31: {
                    block30: {
                        Class factoryClass = Loader.loadClass((String)factoryClassName);
                        Method method = factoryClass.getMethod(factoryMethodName, new Class[0]);
                        object = method.invoke(null, new Object[0]);
                        if (object instanceof DB) {
                            database = (DB)object;
                            break block29;
                        }
                        if (!(object instanceof MongoClient)) break block30;
                        if (databaseName != null && databaseName.length() > 0) {
                            database = ((MongoClient)object).getDB(databaseName);
                            break block29;
                        }
                        LOGGER.error("The factory method [{}.{}()] returned a MongoClient so the database name is required.", new Object[]{factoryClassName, factoryMethodName});
                        return null;
                    }
                    if (object != null) break block31;
                    LOGGER.error("The factory method [{}.{}()] returned null.", new Object[]{factoryClassName, factoryMethodName});
                    return null;
                }
                LOGGER.error("The factory method [{}.{}()] returned an unsupported type [{}].", new Object[]{factoryClassName, factoryMethodName, object.getClass().getName()});
                return null;
            }
            try {
                description = "database=" + database.getName();
                List addresses = database.getMongo().getAllAddress();
                if (addresses.size() == 1) {
                    description = String.valueOf(description) + ", server=" + ((ServerAddress)addresses.get(0)).getHost() + ", port=" + ((ServerAddress)addresses.get(0)).getPort();
                }
                description = String.valueOf(description) + ", servers=[";
                for (ServerAddress address : addresses) {
                    description = String.valueOf(description) + " { " + address.getHost() + ", " + address.getPort() + " } ";
                }
                description = String.valueOf(description) + "]";
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("The factory class [{}] could not be loaded.", new Object[]{factoryClassName, e});
                return null;
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("The factory class [{}] does not have a no-arg method named [{}].", new Object[]{factoryClassName, factoryMethodName, e});
                return null;
            }
            catch (Exception e) {
                LOGGER.error("The factory method [{}.{}()] could not be invoked.", new Object[]{factoryClassName, factoryMethodName, e});
                return null;
            }
        } else if (databaseName != null && databaseName.length() > 0) {
            description = "database=" + databaseName;
            try {
                if (server != null && server.length() > 0) {
                    int portInt = AbstractAppender.parseInt((String)port, (int)0);
                    description = String.valueOf(description) + ", server=" + server;
                    if (portInt > 0) {
                        description = String.valueOf(description) + ", port=" + portInt;
                        database = new MongoClient(server, portInt).getDB(databaseName);
                    }
                    database = new MongoClient(server).getDB(databaseName);
                }
                database = new MongoClient().getDB(databaseName);
            }
            catch (Exception e) {
                LOGGER.error("Failed to obtain a database instance from the MongoClient at server [{}] and port [{}].", new Object[]{server, port});
                return null;
            }
        } else {
            LOGGER.error("No factory method was provided so the database name is required.");
            return null;
        }
        if (!database.isAuthenticated()) {
            if (username != null && username.length() > 0 && password != null && password.length() > 0) {
                description = String.valueOf(description) + ", username=" + username + ", passwordHash=" + NameUtil.md5((String)(String.valueOf(password) + MongoDbProvider.class.getName()));
                MongoDbConnection.authenticate(database, username, password);
            } else {
                LOGGER.error("The database is not already authenticated so you must supply a username and password for the MongoDB provider.");
                return null;
            }
        }
        if (writeConcernConstant != null && writeConcernConstant.length() > 0) {
            if (writeConcernConstantClassName != null && writeConcernConstantClassName.length() > 0) {
                try {
                    Class writeConcernConstantClass = Loader.loadClass((String)writeConcernConstantClassName);
                    Field field = writeConcernConstantClass.getField(writeConcernConstant);
                    writeConcern = (WriteConcern)field.get(null);
                }
                catch (Exception e) {
                    LOGGER.error("Write concern constant [{}.{}] not found, using default.", new Object[]{writeConcernConstantClassName, writeConcernConstant});
                    writeConcern = WriteConcern.ACKNOWLEDGED;
                }
            } else {
                writeConcern = WriteConcern.valueOf((String)writeConcernConstant);
                if (writeConcern == null) {
                    LOGGER.warn("Write concern constant [{}] not found, using default.", new Object[]{writeConcernConstant});
                    writeConcern = WriteConcern.ACKNOWLEDGED;
                }
            }
        } else {
            writeConcern = WriteConcern.ACKNOWLEDGED;
        }
        return new MongoDbProvider(database, writeConcern, collectionName, description);
    }
}

