/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.bind;

import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.logging.log4j.plugins.bind.AbstractConfigurationBinder;
import org.apache.logging.log4j.plugins.bind.ConfigurationBindingException;

public class FieldConfigurationBinder
extends AbstractConfigurationBinder<Field> {
    public FieldConfigurationBinder(Field field) {
        super(field, Field::getGenericType);
    }

    @Override
    public void bindObject(Object factory, Object value) {
        Objects.requireNonNull(factory);
        if (value == null) {
            try {
                Object defaultValue = ((Field)this.element).get(factory);
                this.validate(defaultValue);
                LOGGER.trace("Using default value {} for option {}", defaultValue, (Object)this.name);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationBindingException("Unable to validate option " + this.name, e);
            }
        }
        this.validate(value);
        try {
            ((Field)this.element).set(factory, value);
            LOGGER.trace("Using value {} for option {}", value, (Object)this.name);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationBindingException(this.name, value, e);
        }
    }
}

