/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompoundWordTokenFilterBase
extends TokenFilter {
    public static final int DEFAULT_MIN_WORD_SIZE = 5;
    public static final int DEFAULT_MIN_SUBWORD_SIZE = 2;
    public static final int DEFAULT_MAX_SUBWORD_SIZE = 15;
    protected final CharArraySet dictionary;
    protected final LinkedList<CompoundToken> tokens;
    protected final int minWordSize;
    protected final int minSubwordSize;
    protected final int maxSubwordSize;
    protected final boolean onlyLongestMatch;
    protected final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    protected final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private AttributeSource.State current;

    @Deprecated
    protected CompoundWordTokenFilterBase(TokenStream input, String[] dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        this(Version.LUCENE_30, input, (Set<?>)CompoundWordTokenFilterBase.makeDictionary(Version.LUCENE_30, dictionary), minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    @Deprecated
    protected CompoundWordTokenFilterBase(TokenStream input, String[] dictionary, boolean onlyLongestMatch) {
        this(Version.LUCENE_30, input, (Set<?>)CompoundWordTokenFilterBase.makeDictionary(Version.LUCENE_30, dictionary), 5, 2, 15, onlyLongestMatch);
    }

    @Deprecated
    protected CompoundWordTokenFilterBase(TokenStream input, Set<?> dictionary, boolean onlyLongestMatch) {
        this(Version.LUCENE_30, input, dictionary, 5, 2, 15, onlyLongestMatch);
    }

    @Deprecated
    protected CompoundWordTokenFilterBase(TokenStream input, String[] dictionary) {
        this(Version.LUCENE_30, input, (Set<?>)CompoundWordTokenFilterBase.makeDictionary(Version.LUCENE_30, dictionary), 5, 2, 15, false);
    }

    @Deprecated
    protected CompoundWordTokenFilterBase(TokenStream input, Set<?> dictionary) {
        this(Version.LUCENE_30, input, dictionary, 5, 2, 15, false);
    }

    @Deprecated
    protected CompoundWordTokenFilterBase(TokenStream input, Set<?> dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        this(Version.LUCENE_30, input, dictionary, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    protected CompoundWordTokenFilterBase(Version matchVersion, TokenStream input, String[] dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        this(matchVersion, input, (Set<?>)CompoundWordTokenFilterBase.makeDictionary(matchVersion, dictionary), minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    protected CompoundWordTokenFilterBase(Version matchVersion, TokenStream input, String[] dictionary, boolean onlyLongestMatch) {
        this(matchVersion, input, (Set<?>)CompoundWordTokenFilterBase.makeDictionary(matchVersion, dictionary), 5, 2, 15, onlyLongestMatch);
    }

    protected CompoundWordTokenFilterBase(Version matchVersion, TokenStream input, Set<?> dictionary, boolean onlyLongestMatch) {
        this(matchVersion, input, dictionary, 5, 2, 15, onlyLongestMatch);
    }

    protected CompoundWordTokenFilterBase(Version matchVersion, TokenStream input, String[] dictionary) {
        this(matchVersion, input, (Set<?>)CompoundWordTokenFilterBase.makeDictionary(matchVersion, dictionary), 5, 2, 15, false);
    }

    protected CompoundWordTokenFilterBase(Version matchVersion, TokenStream input, Set<?> dictionary) {
        this(matchVersion, input, dictionary, 5, 2, 15, false);
    }

    protected CompoundWordTokenFilterBase(Version matchVersion, TokenStream input, Set<?> dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        super(input);
        this.tokens = new LinkedList();
        this.minWordSize = minWordSize;
        this.minSubwordSize = minSubwordSize;
        this.maxSubwordSize = maxSubwordSize;
        this.onlyLongestMatch = onlyLongestMatch;
        this.dictionary = dictionary == null || dictionary instanceof CharArraySet ? (CharArraySet)dictionary : new CharArraySet(matchVersion, dictionary, true);
    }

    @Deprecated
    public static CharArraySet makeDictionary(Version matchVersion, String[] dictionary) {
        if (dictionary == null) {
            return null;
        }
        return new CharArraySet(matchVersion, Arrays.asList(dictionary), true);
    }

    public final boolean incrementToken() throws IOException {
        if (!this.tokens.isEmpty()) {
            assert (this.current != null);
            CompoundToken token = this.tokens.removeFirst();
            this.restoreState(this.current);
            this.termAtt.setEmpty().append(token.txt);
            this.offsetAtt.setOffset(token.startOffset, token.endOffset);
            this.posIncAtt.setPositionIncrement(0);
            return true;
        }
        this.current = null;
        if (this.input.incrementToken()) {
            if (this.termAtt.length() >= this.minWordSize) {
                this.decompose();
                if (!this.tokens.isEmpty()) {
                    this.current = this.captureState();
                }
            }
            return true;
        }
        return false;
    }

    protected abstract void decompose();

    public void reset() throws IOException {
        super.reset();
        this.tokens.clear();
        this.current = null;
    }

    protected class CompoundToken {
        public final CharSequence txt;
        public final int startOffset;
        public final int endOffset;

        public CompoundToken(int offset, int length) {
            this.txt = CompoundWordTokenFilterBase.this.termAtt.subSequence(offset, offset + length);
            int startOff = CompoundWordTokenFilterBase.this.offsetAtt.startOffset();
            int endOff = CompoundWordTokenFilterBase.this.offsetAtt.endOffset();
            if (endOff - startOff != CompoundWordTokenFilterBase.this.termAtt.length()) {
                this.startOffset = startOff;
                this.endOffset = endOff;
            } else {
                int newStart;
                this.startOffset = newStart = startOff + offset;
                this.endOffset = newStart + length;
            }
        }
    }
}

