/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.VirtualMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Analyzer
implements Closeable {
    private CloseableThreadLocal<Object> tokenStreams = new CloseableThreadLocal();
    private static final VirtualMethod<Analyzer> tokenStreamMethod = new VirtualMethod<Analyzer>(Analyzer.class, "tokenStream", String.class, Reader.class);
    private static final VirtualMethod<Analyzer> reusableTokenStreamMethod = new VirtualMethod<Analyzer>(Analyzer.class, "reusableTokenStream", String.class, Reader.class);
    @Deprecated
    protected final boolean overridesTokenStreamMethod = VirtualMethod.compareImplementationDistance(this.getClass(), tokenStreamMethod, reusableTokenStreamMethod) > 0;

    public abstract TokenStream tokenStream(String var1, Reader var2);

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        return this.tokenStream(fieldName, reader);
    }

    protected Object getPreviousTokenStream() {
        try {
            return this.tokenStreams.get();
        }
        catch (NullPointerException npe) {
            if (this.tokenStreams == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            throw npe;
        }
    }

    protected void setPreviousTokenStream(Object obj) {
        try {
            this.tokenStreams.set(obj);
        }
        catch (NullPointerException npe) {
            if (this.tokenStreams == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            throw npe;
        }
    }

    @Deprecated
    protected void setOverridesTokenStreamMethod(Class<? extends Analyzer> baseClass) {
    }

    public int getPositionIncrementGap(String fieldName) {
        return 0;
    }

    public int getOffsetGap(Fieldable field) {
        if (field.isTokenized()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void close() {
        this.tokenStreams.close();
        this.tokenStreams = null;
    }
}

