/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeywordMarkerTokenFilter
extends TokenFilter {
    private final KeywordAttribute keywordAttr;
    private final TermAttribute termAtt = this.addAttribute(TermAttribute.class);
    private final CharArraySet keywordSet;

    public KeywordMarkerTokenFilter(TokenStream in, CharArraySet keywordSet) {
        super(in);
        this.keywordAttr = this.addAttribute(KeywordAttribute.class);
        this.keywordSet = keywordSet;
    }

    public KeywordMarkerTokenFilter(TokenStream in, Set<?> keywordSet) {
        this(in, keywordSet instanceof CharArraySet ? (CharArraySet)keywordSet : CharArraySet.copy(Version.LUCENE_31, keywordSet));
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            this.keywordAttr.setKeyword(this.keywordSet.contains(this.termAtt.termBuffer(), 0, this.termAtt.termLength()));
            return true;
        }
        return false;
    }
}

